/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.sfcalc;

import io.github.seggan.sfcalc.Calculator;
import io.github.seggan.sfcalc.SFCalc;
import io.github.seggan.sfcalc.Util;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.PatternUtils;
import java.util.HashMap;
import java.util.Map;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class CalcExecutor
implements CommandExecutor {
    private final SFCalc plugin;
    private final Map<String, SlimefunItem[]> exceptions = new HashMap<String, SlimefunItem[]>();

    public CalcExecutor(SFCalc plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String s, String[] args) {
        int amount;
        if (!(sender instanceof Player) && s.equals("sfneeded")) {
            sender.sendMessage(this.plugin.notAPlayerString);
            return true;
        }
        if (args.length > 2) {
            return false;
        }
        if (args.length == 0) {
            if (sender instanceof Player) {
                this.openGUI((Player)sender);
                return true;
            }
            return false;
        }
        String reqItem = args[0];
        if (args.length == 1) {
            amount = 1;
        } else if (PatternUtils.NUMERIC.matcher(args[1]).matches()) {
            amount = Integer.parseInt(args[1]);
        } else {
            sender.sendMessage(this.plugin.noNumberString);
            return true;
        }
        reqItem = reqItem.toUpperCase();
        SlimefunItem item = SlimefunItem.getByID((String)reqItem);
        if (item == null) {
            sender.sendMessage(this.plugin.noItemString);
            return true;
        }
        SFCalc.itemsSearched.add(Util.capitalize(ChatColor.stripColor((String)item.getItemName())));
        Calculator.printResults(Calculator.calculate(item, this.plugin), sender, s, item, amount, this.plugin);
        return true;
    }

    private void openGUI(Player player) {
        int size = Util.getSlots(SlimefunPlugin.getRegistry().getCategories().size());
        if (size > 54) {
            player.sendMessage(this.plugin.tooManyCategoriesString);
            return;
        }
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)"Choose a Category");
        for (Category category : SlimefunPlugin.getRegistry().getCategories()) {
            inv.addItem(new ItemStack[]{category.getItem(player)});
        }
        player.openInventory(inv);
    }
}

