/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.sfcalc;

import io.github.seggan.sfcalc.CalcCompleter;
import io.github.seggan.sfcalc.CalcExecutor;
import io.github.seggan.sfcalc.CalcHandler;
import io.github.seggan.sfcalc.bukkit.Metrics;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.cscorelib2.updater.GitHubBuildsUpdater;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SFCalc
extends JavaPlugin
implements SlimefunAddon {
    FileConfiguration config = this.getConfig();
    private static SFCalc instance;
    final Set<RecipeType> blacklistedRecipes = new HashSet<RecipeType>();
    final Set<String> blacklistedIds = new HashSet<String>();
    String headerString;
    String amountString;
    String neededString;
    String noItemString;
    String noNumberString;
    String tooManyCategoriesString;
    String tooManyItemsString;
    String notAPlayerString;
    static List<String> itemsSearched;
    private boolean sent = false;

    public void onEnable() {
        this.getLogger().info("SFCalc enabled.");
        this.saveDefaultConfig();
        Metrics metrics = new Metrics((Plugin)this, 8812);
        metrics.addCustomChart(new Metrics.AdvancedPie("items_searched", () -> {
            HashMap<String, Integer> result = new HashMap<String, Integer>();
            HashSet<String> itemSet = new HashSet<String>(itemsSearched);
            for (String item : itemSet) {
                result.put(item, Collections.frequency(itemsSearched, item));
            }
            if (this.sent) {
                this.sent = false;
                itemsSearched.clear();
            } else {
                this.sent = true;
            }
            return result;
        }));
        metrics.addCustomChart(new Metrics.SingleLineChart("searches", () -> {
            int searches = itemsSearched.size();
            if (this.sent) {
                this.sent = false;
                itemsSearched.clear();
            } else {
                this.sent = true;
            }
            return searches;
        }));
        if (this.getConfig().getBoolean("options.auto-update") && this.getDescription().getVersion().startsWith("DEV - ")) {
            new GitHubBuildsUpdater((Plugin)this, this.getFile(), "Seggan/SFCalc/master").start();
        }
        Objects.requireNonNull(this.getCommand("sfcalc")).setExecutor((CommandExecutor)new CalcExecutor(this));
        Objects.requireNonNull(this.getCommand("sfcalc")).setTabCompleter((TabCompleter)new CalcCompleter());
        Objects.requireNonNull(this.getCommand("sfneeded")).setExecutor((CommandExecutor)new CalcExecutor(this));
        Objects.requireNonNull(this.getCommand("sfneeded")).setTabCompleter((TabCompleter)new CalcCompleter());
        this.getServer().getPluginManager().registerEvents((Listener)new CalcHandler(), (Plugin)this);
        this.blacklistedRecipes.add(RecipeType.ORE_WASHER);
        this.blacklistedRecipes.add(RecipeType.GEO_MINER);
        this.blacklistedRecipes.add(RecipeType.GOLD_PAN);
        this.blacklistedRecipes.add(RecipeType.MOB_DROP);
        this.blacklistedRecipes.add(RecipeType.ORE_CRUSHER);
        this.blacklistedRecipes.add(RecipeType.NULL);
        this.blacklistedIds.add("uu_matter");
        this.blacklistedIds.add("silicon");
        instance = this;
        this.loadStrings();
    }

    public void onDisable() {
        this.getLogger().info("SFCalc disabled.");
    }

    public JavaPlugin getJavaPlugin() {
        return this;
    }

    public String getBugTrackerURL() {
        return "https://github.com/Seggan/SFCalc/issues";
    }

    static SFCalc getInstance() {
        return instance;
    }

    private void loadStrings() {
        this.headerString = ChatColor.translateAlternateColorCodes((char)'&', (String)(this.config.getString("header-string") != null ? this.config.getString("header-string") : "&e&nRecipe for %s:"));
        this.amountString = ChatColor.translateAlternateColorCodes((char)'&', (String)(this.config.getString("amount-string") != null ? this.config.getString("amount-string") : "&e%d of %s"));
        this.neededString = ChatColor.translateAlternateColorCodes((char)'&', (String)(this.config.getString("needed-string") != null ? this.config.getString("needed-string") : "&e%d more %s needed"));
        this.noItemString = ChatColor.translateAlternateColorCodes((char)'&', (String)(this.config.getString("no-item-string") != null ? this.config.getString("no-item-string") : "&cThat item was not found."));
        this.noNumberString = ChatColor.translateAlternateColorCodes((char)'&', (String)(this.config.getString("no-number-string") != null ? this.config.getString("no-number-string") : "&cThat's not a number!"));
        this.tooManyCategoriesString = ChatColor.translateAlternateColorCodes((char)'&', (String)(this.config.getString("category-error-string") != null ? this.config.getString("category-error-string") : "&cThat many categories is not supported yet. Please use the command form of the calculator."));
        this.tooManyItemsString = ChatColor.translateAlternateColorCodes((char)'&', (String)(this.config.getString("item-error-string") != null ? this.config.getString("item-error-string") : "&cThat many items is not supported yet. Please use the command form of the calculator."));
        this.notAPlayerString = ChatColor.translateAlternateColorCodes((char)'&', (String)(this.config.getString("not-a-player-string") != null ? this.config.getString("not-a-player-string") : "&cYou must be a player to send this message!"));
    }

    static {
        itemsSearched = new ArrayList<String>();
    }
}

