/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.sfcalc;

import io.github.seggan.sfcalc.SFCalc;
import io.github.seggan.sfcalc.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class Calculator {
    static List<String> calculate(SlimefunItem item, SFCalc plugin) {
        ArrayList<String> result = new ArrayList<String>();
        switch (item.getID().toLowerCase()) {
            case "carbon": {
                for (int n = 0; n < 8; ++n) {
                    result.add("coal");
                }
                break;
            }
            case "compressed_carbon": {
                for (int n = 0; n < 4; ++n) {
                    result.addAll(Calculator.calculate(SlimefunItem.getByID((String)"CARBON"), plugin));
                }
                break;
            }
            case "reinforced_plate": {
                for (int n = 0; n < 8; ++n) {
                    result.addAll(Calculator.calculate(SlimefunItem.getByID((String)"REINFORCED_ALLOY_INGOT"), plugin));
                }
                break;
            }
            case "steel_plate": {
                for (int n = 0; n < 8; ++n) {
                    result.addAll(Calculator.calculate(SlimefunItem.getByID((String)"STEEL_INGOT"), plugin));
                }
                break;
            }
            default: {
                for (ItemStack i : item.getRecipe()) {
                    if (i == null) continue;
                    SlimefunItem ingredient = SlimefunItem.getByItem((ItemStack)i);
                    if (ingredient == null) {
                        result.add(i.getType().toString());
                        continue;
                    }
                    if (plugin.blacklistedIds.contains(ingredient.getID().toLowerCase())) {
                        result.add(ChatColor.stripColor((String)ingredient.getItemName()));
                        continue;
                    }
                    if (!plugin.blacklistedRecipes.contains(ingredient.getRecipeType())) {
                        result.addAll(Calculator.calculate(ingredient, plugin));
                        continue;
                    }
                    result.add(ChatColor.stripColor((String)ingredient.getItemName()));
                }
            }
        }
        return result;
    }

    static void printResults(List<String> results, CommandSender sender, String s, SlimefunItem item, int amount, SFCalc plugin) {
        HashSet<String> resultSet = new HashSet<String>(results);
        sender.sendMessage(String.format(plugin.headerString, Util.capitalize(ChatColor.stripColor((String)item.getItemName()))));
        if (s.equals("sfneeded")) {
            ArrayList<String> sfInv = new ArrayList<String>();
            for (ItemStack i : ((Player)sender).getInventory().getContents()) {
                SlimefunItem sfItem;
                if (i == null || (sfItem = SlimefunItem.getByItem((ItemStack)i)) == null) continue;
                for (int n = 0; n < i.getAmount(); ++n) {
                    sfInv.add(ChatColor.stripColor((String)sfItem.getItemName()));
                }
            }
            for (String name : resultSet) {
                sender.sendMessage(Util.format(plugin.neededString, Collections.frequency(results, name) * amount - Collections.frequency(sfInv, name), Util.capitalize(name)));
            }
        } else {
            for (String name : resultSet) {
                sender.sendMessage(Util.format(plugin.amountString, Collections.frequency(results, name) * amount, Util.capitalize(name)));
            }
        }
    }
}

