/*
 * Decompiled with CFR 0.152.
 */
package org.lins.mmmjjkx.rykenslimefuncustomizer.objects.yaml.item;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.PiglinBarterDrop;
import io.github.thebusybiscuit.slimefun4.core.attributes.Radioactivity;
import io.github.thebusybiscuit.slimefun4.core.attributes.Soulbound;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.Pair;
import io.github.thebusybiscuit.slimefun4.utils.ColoredMaterial;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.bytebuddy.implementation.FixedValue;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.lins.mmmjjkx.rykenslimefuncustomizer.RykenSlimefunCustomizer;
import org.lins.mmmjjkx.rykenslimefuncustomizer.bulit_in.JavaScriptEval;
import org.lins.mmmjjkx.rykenslimefuncustomizer.libraries.colors.CMIChatColor;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.ProjectAddon;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.item.CustomDefaultItem;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.item.CustomUnplaceableItem;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.item.exts.CustomDefaultRadiationItem;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.item.exts.CustomEnergyItem;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.item.exts.CustomEnergyRadiationItem;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.item.exts.CustomRadiationItem;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.item.exts.CustomRainbowBlock;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.parent.BaseRadiationItem;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.parent.CustomItem;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.global.DropFromBlock;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.slimefun.WitherProofBlockImpl;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.yaml.YamlReader;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.ClassUtils;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.CommonUtils;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.ExceptionHandler;

public class ItemReader
extends YamlReader<SlimefunItem> {
    public ItemReader(YamlConfiguration config, ProjectAddon addon) {
        super(config, addon);
    }

    @Override
    public SlimefunItem readEach(String s) {
        Class<?> clazz;
        CustomItem instance;
        RecipeType rt;
        ConfigurationSection section = this.configuration.getConfigurationSection(s);
        if (section == null) {
            return null;
        }
        String id = this.addon.getId(s, section.getString("id_alias"));
        ExceptionHandler.HandleResult result = ExceptionHandler.handleIdConflict(id);
        if (result == ExceptionHandler.HandleResult.FAILED) {
            return null;
        }
        String igId = section.getString("item_group");
        Pair<ExceptionHandler.HandleResult, ItemGroup> group = ExceptionHandler.handleItemGroupGet(this.addon, igId);
        if (group.getFirstValue() == ExceptionHandler.HandleResult.FAILED) {
            return null;
        }
        SlimefunItemStack sfis = this.getPreloadItem(id);
        if (sfis == null) {
            return null;
        }
        ItemStack[] itemStacks = CommonUtils.readRecipe(section.getConfigurationSection("recipe"), this.addon);
        String recipeType = section.getString("recipe_type", "NULL");
        boolean piglin = section.getBoolean("piglin_trade_chance", false);
        if (piglin) {
            rt = RecipeType.BARTER_DROP;
        } else {
            Pair<ExceptionHandler.HandleResult, RecipeType> rt1 = ExceptionHandler.getRecipeType("Found an error while loading the item " + s + " in addon " + this.addon.getAddonId() + ": Invalid recipe type '" + recipeType + "'!", recipeType);
            if (rt1.getFirstValue() == ExceptionHandler.HandleResult.FAILED) {
                return null;
            }
            rt = (RecipeType)rt1.getSecondValue();
        }
        JavaScriptEval eval = null;
        if (section.contains("script")) {
            String script = section.getString("script", "");
            File file = new File(this.addon.getScriptsFolder(), script + ".js");
            if (!file.exists()) {
                ExceptionHandler.handleWarning("There was an error while loading item" + s + " in addon " + this.addon.getAddonId() + ": Could not find script file " + file.getName());
            } else {
                ExceptionHandler.debugLog("\u52a0\u8f7d\u4e86\u9644\u5c5e" + this.addon.getAddonId() + "\u4e2d\u7269\u54c1" + s + "\u7684\u811a\u672c\u6587\u4ef6" + file.getName());
                eval = new JavaScriptEval(file, this.addon);
            }
        }
        boolean energy = section.contains("energy_capacity");
        boolean hasRadiation = section.contains("radiation");
        if (hasRadiation) {
            return this.setupRadiationItem(section, sfis, (ItemGroup)group.getSecondValue(), s, rt, itemStacks, eval, this.addon);
        }
        if (energy) {
            double energyCapacity = section.getDouble("energy_capacity");
            if (energyCapacity < 1.0) {
                ExceptionHandler.handleError("Found an error while loading item" + s + " in addon " + this.addon.getAddonId() + ": Energy capacity must be at least 1");
                return null;
            }
            CommonUtils.addLore((ItemStack)sfis, true, CMIChatColor.translate("&8\u21e8 &e\u26a1 &70 / " + energyCapacity + " J"));
            instance = new CustomEnergyItem((ItemGroup)group.getSecondValue(), sfis, rt, itemStacks, (float)energyCapacity, eval);
        } else if (section.getBoolean("placeable", false)) {
            instance = new CustomDefaultItem((ItemGroup)group.getSecondValue(), sfis, rt, itemStacks);
        } else if (section.contains("rainbow")) {
            String materialType = section.getString("rainbow", "");
            if (!sfis.getType().isBlock()) {
                ExceptionHandler.handleError("Found an error while loading item " + s + " in addon " + this.addon.getAddonId() + ": Rainbow attribute can only be applied to blocks");
                return null;
            }
            if (materialType.equalsIgnoreCase("CUSTOM")) {
                List materials = section.getStringList("rainbow_materials");
                if (materials.isEmpty()) {
                    ExceptionHandler.handleError("Found an error while loading item " + s + " in addon " + this.addon.getAddonId() + ": Rainbow attribute CUSTOM requires a list of materials");
                    return null;
                }
                ArrayList<Material> colorMaterials = new ArrayList<Material>();
                for (String material : materials) {
                    Pair<ExceptionHandler.HandleResult, Material> materialPair = ExceptionHandler.handleEnumValueOf("Found an error while loading item " + s + " in addon " + this.addon.getAddonId() + ": Invalid material: " + material, Material.class, material);
                    Material material1 = (Material)materialPair.getSecondValue();
                    if (materialPair.getFirstValue() == ExceptionHandler.HandleResult.FAILED || material1 == null) {
                        return null;
                    }
                    colorMaterials.add(material1);
                }
                instance = new CustomRainbowBlock((ItemGroup)group.getSecondValue(), sfis, rt, itemStacks, colorMaterials);
            } else {
                Pair<ExceptionHandler.HandleResult, ColoredMaterial> coloredMaterialPair = ExceptionHandler.handleEnumValueOf("Found an error while loading item " + s + " in addon " + this.addon.getAddonId() + ": Invalid colored material type: " + materialType, ColoredMaterial.class, materialType);
                ColoredMaterial coloredMaterial = (ColoredMaterial)coloredMaterialPair.getSecondValue();
                if (coloredMaterialPair.getFirstValue() == ExceptionHandler.HandleResult.FAILED || coloredMaterial == null) {
                    return null;
                }
                instance = new CustomRainbowBlock((ItemGroup)group.getSecondValue(), sfis, rt, itemStacks, coloredMaterial);
            }
        } else {
            instance = new CustomUnplaceableItem((ItemGroup)group.getSecondValue(), sfis, rt, itemStacks, eval);
        }
        Object[] constructorArgs = instance.constructorArgs();
        if (section.getBoolean("anti_wither", false)) {
            if (!sfis.getType().isBlock()) {
                ExceptionHandler.handleError("Found an error while loading item " + s + " in addon " + this.addon.getAddonId() + ": Wither proof attribute can only be applied to blocks");
                return null;
            }
            clazz = ClassUtils.generateClass(((Object)((Object)instance)).getClass(), "WitherProof", "Item", new Class[]{WitherProofBlockImpl.class}, null);
            instance = (CustomItem)((Object)clazz.getDeclaredConstructors()[0].newInstance(constructorArgs));
        }
        if (section.getBoolean("soulbound", false)) {
            clazz = ClassUtils.generateClass(((Object)((Object)instance)).getClass(), "Soulbound", "Item", new Class[]{Soulbound.class}, null);
            instance = (CustomItem)((Object)clazz.getDeclaredConstructors()[0].newInstance(constructorArgs));
        }
        if (section.contains("piglin_trade_chance")) {
            int chance = section.getInt("piglin_trade_chance", 100);
            if (chance < 0 || chance > 100) {
                ExceptionHandler.handleError("Found an error while loading item " + s + "in addon " + this.addon.getAddonId() + ": Piglin trade chance must be between 0 and 100. Using 100 instead.");
                chance = 100;
            }
            int finalChance = chance;
            Class<?> clazz2 = ClassUtils.generateClass(((Object)((Object)instance)).getClass(), "PiglinTradeAble", "Item", new Class[]{PiglinBarterDrop.class}, builder -> builder.method((ElementMatcher)ElementMatchers.isDeclaredBy(PiglinBarterDrop.class)).intercept((Implementation)FixedValue.value((Object)finalChance)));
            instance = (CustomItem)((Object)clazz2.getDeclaredConstructors()[0].newInstance(constructorArgs));
        }
        instance.setHidden(section.getBoolean("hidden", false));
        instance.setUseableInWorkbench(section.getBoolean("vanilla", false));
        if (section.contains("drop_from")) {
            String dropMaterial;
            Optional<Material> xm;
            int amount;
            int chance = section.getInt("drop_chance", 100);
            int n = amount = section.isInt("drop_amount") ? section.getInt("drop_amount", 1) : -1;
            if (chance < 0 || chance > 100) {
                ExceptionHandler.handleError("Found an error while loading item " + s + " in addon " + this.addon.getAddonId() + ": Drop chance must be between 0 and 100. Using 100 instead.");
                chance = 100;
            }
            if ((xm = Optional.ofNullable(Material.matchMaterial((String)(dropMaterial = section.getString("drop_from", ""))))).isPresent()) {
                Material material = xm.get();
                if (amount == -1) {
                    String between = section.getString("drop_amount", "1");
                    if (between.contains("-")) {
                        String[] split = between.split("-");
                        if (split.length == 2) {
                            int min = Integer.parseInt(split[0]);
                            int max = Integer.parseInt(split[1]);
                            DropFromBlock.addDrop(material, new DropFromBlock.Drop((ItemStack)sfis, chance, this.addon, min, max));
                        } else {
                            ExceptionHandler.handleError("Found an error while loading item " + s + " in addon " + this.addon.getAddonId() + ": Invalid drop amount range '" + between + "' The drop amount will use 1 instead.");
                            DropFromBlock.addDrop(material, new DropFromBlock.Drop((ItemStack)sfis, chance, this.addon));
                        }
                    }
                } else {
                    DropFromBlock.addDrop(material, new DropFromBlock.Drop((ItemStack)sfis, chance, this.addon, amount, amount));
                }
            } else {
                ExceptionHandler.handleError("Found an error while loading item " + s + " in addon " + this.addon.getAddonId() + ": Invalid drop material: " + dropMaterial);
            }
        }
        instance.register(RykenSlimefunCustomizer.INSTANCE);
        return instance;
    }

    @Override
    public List<SlimefunItemStack> preloadItems(String key) {
        ConfigurationSection section = this.configuration.getConfigurationSection(key);
        if (section == null) {
            return null;
        }
        ConfigurationSection item = section.getConfigurationSection("item");
        ItemStack stack = CommonUtils.readItem(item, false, this.addon);
        if (stack == null) {
            ExceptionHandler.handleError("Found an error while loading item " + key + " in addon " + this.addon.getAddonId() + ": The item is null or has an invalid format");
            return null;
        }
        return List.of(new SlimefunItemStack(this.addon.getId(key, section.getString("id_alias")), stack));
    }

    @Deprecated(forRemoval=true, since="RSC 1.4")
    private SlimefunItem setupRadiationItem(ConfigurationSection section, SlimefunItemStack original, ItemGroup itemGroup, String id, RecipeType recipeType, ItemStack[] recipe, JavaScriptEval eval, ProjectAddon addon) {
        int chance;
        boolean piglin;
        Class<?> clazz;
        BaseRadiationItem instance;
        String radio = section.getString("radiation");
        Pair<ExceptionHandler.HandleResult, Radioactivity> radioactivityPair = ExceptionHandler.handleEnumValueOf("Found an error while loading item " + id + " in addon " + addon.getAddonId() + ": Invalid radioactivity level: " + radio, Radioactivity.class, radio);
        Radioactivity radioactivity = (Radioactivity)radioactivityPair.getSecondValue();
        if (radioactivityPair.getFirstValue() == ExceptionHandler.HandleResult.FAILED || radioactivity == null) {
            return null;
        }
        boolean energy = section.contains("energy_capacity");
        CommonUtils.addLore((ItemStack)original, true, CMIChatColor.translate(radioactivity.getLore()));
        if (energy) {
            double energyCapacity = section.getDouble("energy_capacity");
            instance = new CustomEnergyRadiationItem(itemGroup, original, recipeType, recipe, radioactivity, (float)energyCapacity, eval);
        } else {
            instance = section.getBoolean("placeable", false) ? new CustomDefaultRadiationItem(itemGroup, original, recipeType, recipe, radioactivity) : new CustomRadiationItem(itemGroup, original, recipeType, recipe, eval, radioactivity);
        }
        Object[] constructorArgs = instance.constructArgs();
        if (section.getBoolean("anti_wither", false)) {
            if (!original.getType().isBlock()) {
                ExceptionHandler.handleError("Found an error while loading item " + id + " in addon " + addon.getAddonId() + ": Wither proof attribute can only be applied to blocks");
                return null;
            }
            clazz = ClassUtils.generateClass(((Object)((Object)instance)).getClass(), "WitherProof", "Item", new Class[]{WitherProofBlockImpl.class}, null);
            instance = (BaseRadiationItem)((Object)clazz.getDeclaredConstructors()[0].newInstance(constructorArgs));
        }
        if (section.getBoolean("soulbound", false)) {
            clazz = ClassUtils.generateClass(((Object)((Object)instance)).getClass(), "Soulbound", "Item", new Class[]{Soulbound.class}, null);
            instance = (BaseRadiationItem)((Object)clazz.getDeclaredConstructors()[0].newInstance(constructorArgs));
        }
        if (piglin = section.contains("piglin_trade_chance")) {
            chance = section.getInt("piglin_trade_chance", 100);
            if (chance < 0 || chance > 100) {
                ExceptionHandler.handleError("Found an error while loading item " + id + "in addon " + addon.getAddonId() + ": Piglin trade chance must be between 0 and 100. Using 100 instead.");
                chance = 100;
            }
            int finalChance = chance;
            Class<?> clazz2 = ClassUtils.generateClass(((Object)((Object)instance)).getClass(), "PiglinTradeAble", "Item", new Class[]{PiglinBarterDrop.class}, builder -> builder.method((ElementMatcher)ElementMatchers.isDeclaredBy(PiglinBarterDrop.class)).intercept((Implementation)FixedValue.value((Object)finalChance)));
            instance = (BaseRadiationItem)((Object)clazz2.getDeclaredConstructors()[0].newInstance(constructorArgs));
        }
        instance.setHidden(section.getBoolean("hidden", false));
        instance.setUseableInWorkbench(section.getBoolean("vanilla", false));
        if (section.contains("drop_from")) {
            String dropMaterial;
            Optional<Material> xm;
            int amount;
            chance = section.getInt("drop_chance", 100);
            int n = amount = section.isInt("drop_amount") ? section.getInt("drop_amount", 1) : -1;
            if (chance < 0 || chance > 100) {
                ExceptionHandler.handleError("Found an error while loading item " + id + " in addon " + addon.getAddonId() + ": Drop chance must be between 0 and 100. Using 100 instead.");
                chance = 100;
            }
            if ((xm = Optional.ofNullable(Material.matchMaterial((String)(dropMaterial = section.getString("drop_from", ""))))).isPresent()) {
                Material material = xm.get();
                if (amount == -1) {
                    String between = section.getString("drop_amount", "1");
                    if (between.contains("-")) {
                        String[] split = between.split("-");
                        if (split.length == 2) {
                            int min = Integer.parseInt(split[0]);
                            int max = Integer.parseInt(split[1]);
                            DropFromBlock.addDrop(material, new DropFromBlock.Drop((ItemStack)original, chance, addon, min, max));
                        } else {
                            ExceptionHandler.handleError("Found an error while loading item " + id + " in addon " + addon.getAddonId() + ": Invalid drop amount range '" + between + "' The drop amount will use 1 instead.");
                            DropFromBlock.addDrop(material, new DropFromBlock.Drop((ItemStack)original, chance, addon));
                        }
                    }
                } else {
                    DropFromBlock.addDrop(material, new DropFromBlock.Drop((ItemStack)original, chance, addon, amount, amount));
                }
            } else {
                ExceptionHandler.handleError("Found an error while loading item " + id + " in addon " + addon.getAddonId() + ": Invalid drop material: " + dropMaterial);
            }
        }
        instance.register(RykenSlimefunCustomizer.INSTANCE);
        return instance;
    }
}

