/*
 * Decompiled with CFR 0.152.
 */
package org.lins.mmmjjkx.rykenslimefuncustomizer.objects;

import io.github.thebusybiscuit.slimefun4.api.geo.GEOResource;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.api.researches.Research;
import io.github.thebusybiscuit.slimefun4.core.attributes.Radioactive;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.electric.Capacitor;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lins.mmmjjkx.rykenslimefuncustomizer.bulit_in.JavaScriptEval;
import org.lins.mmmjjkx.rykenslimefuncustomizer.listeners.ScriptableEventListener;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.CustomAddonConfig;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.CustomMenu;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.item.CustomArmorPiece;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.item.CustomFood;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.item.CustomGeoResource;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.item.exts.CustomMobDrop;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.machine.CustomGenerator;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.machine.CustomLinkedRecipeMachine;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.machine.CustomMaterialGenerator;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.machine.CustomMultiBlockMachine;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.machine.CustomRecipeMachine;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.machine.CustomSolarGenerator;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.machine.CustomTemplateMachine;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.machine.CustomWorkbench;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.parent.AbstractEmptyMachine;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.global.DropFromBlock;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.global.RecipeTypeMap;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.ExceptionHandler;

public final class ProjectAddon {
    private boolean markAsDepend = false;
    @NotNull
    private final String addonId;
    @NotNull
    private final String addonName;
    @NotNull
    private final String addonVersion;
    @NotNull
    private final List<String> pluginDepends;
    @NotNull
    private final List<String> depends;
    @NotNull
    private final String description;
    @NotNull
    private final List<String> authors;
    @NotNull
    private final File folder;
    @NotNull
    private final Map<String, SlimefunItemStack> preloadItems = new HashMap<String, SlimefunItemStack>();
    @Nullable
    private String githubRepo;
    @Nullable
    private String downloadZipName;
    @Nullable
    private String idPattern;
    @Nullable
    private CustomAddonConfig config;
    @Nullable
    private ScriptableEventListener eventListener;
    private List<JavaScriptEval> scriptEvals = new ArrayList<JavaScriptEval>();
    private List<ItemGroup> itemGroups = new ArrayList<ItemGroup>();
    private List<CustomMenu> menus = new ArrayList<CustomMenu>();
    private List<GEOResource> geoResources = new ArrayList<GEOResource>();
    private List<SlimefunItem> items = new ArrayList<SlimefunItem>();
    private List<AbstractEmptyMachine<?>> machines = new ArrayList();
    private List<Research> researches = new ArrayList<Research>();
    private List<CustomGenerator> generators = new ArrayList<CustomGenerator>();
    private List<CustomMaterialGenerator> materialGenerators = new ArrayList<CustomMaterialGenerator>();
    private List<CustomRecipeMachine> recipeMachines = new ArrayList<CustomRecipeMachine>();
    private List<CustomMultiBlockMachine> multiBlockMachines = new ArrayList<CustomMultiBlockMachine>();
    private List<CustomSolarGenerator> solarGenerators = new ArrayList<CustomSolarGenerator>();
    private List<CustomMobDrop> mobDrops = new ArrayList<CustomMobDrop>();
    private List<Capacitor> capacitors = new ArrayList<Capacitor>();
    private List<RecipeType> recipeTypes = new ArrayList<RecipeType>();
    private List<SlimefunItem> simpleMachines = new ArrayList<SlimefunItem>();
    private List<CustomFood> foods = new ArrayList<CustomFood>();
    private List<List<CustomArmorPiece>> armors = new ArrayList<List<CustomArmorPiece>>();
    private List<SlimefunItem> supers = new ArrayList<SlimefunItem>();
    private List<CustomTemplateMachine> templateMachines = new ArrayList<CustomTemplateMachine>();
    private List<CustomLinkedRecipeMachine> linkedRecipeMachines = new ArrayList<CustomLinkedRecipeMachine>();
    private List<CustomWorkbench> workbenches = new ArrayList<CustomWorkbench>();

    public File getScriptsFolder() {
        File scripts = new File(this.folder, "scripts");
        if (!scripts.exists()) {
            scripts.mkdirs();
        }
        return scripts;
    }

    public File getSavedItemsFolder() {
        File savedItems = new File(this.folder, "saveditems");
        if (!savedItems.exists()) {
            savedItems.mkdirs();
        }
        return savedItems;
    }

    public void unregister() {
        this.scriptEvals.forEach(JavaScriptEval::close);
        this.itemGroups.forEach(ig -> Slimefun.getRegistry().getAllItemGroups().remove(ig));
        this.menus.forEach(m -> Slimefun.getRegistry().getMenuPresets().remove(m.getID()));
        this.items.forEach(this::unregisterItem);
        this.mobDrops.forEach(md -> {
            this.unregisterItem((SlimefunItem)md);
            ((Set)Slimefun.getRegistry().getMobDrops().get(md.getEntityType())).removeAll(md.getDrops());
        });
        this.capacitors.forEach(this::unregisterItem);
        this.foods.forEach(this::unregisterItem);
        this.machines.forEach(this::unregisterItem);
        this.solarGenerators.forEach(this::unregisterItem);
        this.generators.forEach(this::unregisterItem);
        this.geoResources.forEach(g -> {
            if (g instanceof CustomGeoResource) {
                CustomGeoResource cgr = (CustomGeoResource)((Object)g);
                this.unregisterItem((SlimefunItem)cgr);
            }
            this.unregisterGeo((GEOResource)g);
        });
        this.materialGenerators.forEach(this::unregisterItem);
        this.recipeMachines.forEach(this::unregisterItem);
        this.multiBlockMachines.forEach(this::unregisterItem);
        this.simpleMachines.forEach(this::unregisterItem);
        this.armors.forEach(l -> l.forEach(this::unregisterItem));
        this.supers.forEach(this::unregisterItem);
        this.templateMachines.forEach(this::unregisterItem);
        this.linkedRecipeMachines.forEach(this::unregisterItem);
        this.workbenches.forEach(this::unregisterItem);
        this.recipeTypes.forEach(r -> RecipeTypeMap.removeRecipeTypes(r.getKey().getKey()));
        this.scriptEvals.clear();
        this.items.clear();
        this.machines.clear();
        this.itemGroups.clear();
        this.menus.clear();
        this.geoResources.clear();
        this.generators.clear();
        this.materialGenerators.clear();
        this.recipeMachines.clear();
        this.multiBlockMachines.clear();
        this.capacitors.clear();
        this.solarGenerators.clear();
        this.mobDrops.clear();
        this.recipeTypes.clear();
        this.simpleMachines.clear();
        this.foods.clear();
        this.armors.clear();
        this.supers.clear();
        this.templateMachines.clear();
        this.linkedRecipeMachines.clear();
        this.workbenches.clear();
        this.preloadItems.clear();
        DropFromBlock.unregisterAddonDrops(this);
        if (this.config != null && this.config.onReloadHandler() != null) {
            this.config.onReloadHandler().close();
        }
    }

    private void unregisterItem(SlimefunItem item) {
        if (item instanceof Radioactive) {
            Slimefun.getRegistry().getRadioactiveItems().remove(item);
        }
        Slimefun.getRegistry().getTickerBlocks().remove(item.getId());
        Slimefun.getRegistry().getEnabledSlimefunItems().remove(item);
        Slimefun.getRegistry().getSlimefunItemIds().remove(item.getId());
        Slimefun.getRegistry().getAllSlimefunItems().remove(item);
    }

    private void unregisterGeo(GEOResource resource) {
        Slimefun.getRegistry().getGEOResources().remove((Object)resource.getKey());
    }

    public String getId(@Nullable String configuredId, @Nullable String id_alias) {
        String id = configuredId;
        if (id_alias != null) {
            id = id_alias;
        }
        if (id != null) {
            SlimefunItem item;
            if (this.idPattern != null && (item = SlimefunItem.getById((String)id)) == null) {
                id = this.idPattern.replaceAll("%0", id);
            }
            return id.toUpperCase();
        }
        ExceptionHandler.handleError("\u65e0\u6cd5\u83b7\u53d6id");
        ExceptionHandler.handleError("configuredId: " + configuredId == null ? "null" : configuredId);
        ExceptionHandler.handleError("id_alias: " + id_alias == null ? "null" : id_alias);
        ExceptionHandler.handleError("idPattern: " + this.idPattern == null ? "null" : this.idPattern);
        String randomId = "RSC_UNKNOWN_ID_" + (int)(Math.random() * 1000000.0);
        ExceptionHandler.handleError("\u5206\u914d\u968f\u673aid");
        ExceptionHandler.handleError("randomId: " + randomId);
        return randomId;
    }

    @Generated
    ProjectAddon(@NotNull String addonId, @NotNull String addonName, @NotNull String addonVersion, @NotNull List<String> pluginDepends, @NotNull List<String> depends, @NotNull String description, @NotNull List<String> authors, @NotNull File folder) {
        if (addonId == null) {
            throw new NullPointerException("addonId is marked non-null but is null");
        }
        if (addonName == null) {
            throw new NullPointerException("addonName is marked non-null but is null");
        }
        if (addonVersion == null) {
            throw new NullPointerException("addonVersion is marked non-null but is null");
        }
        if (pluginDepends == null) {
            throw new NullPointerException("pluginDepends is marked non-null but is null");
        }
        if (depends == null) {
            throw new NullPointerException("depends is marked non-null but is null");
        }
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (authors == null) {
            throw new NullPointerException("authors is marked non-null but is null");
        }
        if (folder == null) {
            throw new NullPointerException("folder is marked non-null but is null");
        }
        this.addonId = addonId;
        this.addonName = addonName;
        this.addonVersion = addonVersion;
        this.pluginDepends = pluginDepends;
        this.depends = depends;
        this.description = description;
        this.authors = authors;
        this.folder = folder;
    }

    @Generated
    public boolean isMarkAsDepend() {
        return this.markAsDepend;
    }

    @NotNull
    @Generated
    public String getAddonId() {
        return this.addonId;
    }

    @NotNull
    @Generated
    public String getAddonName() {
        return this.addonName;
    }

    @NotNull
    @Generated
    public String getAddonVersion() {
        return this.addonVersion;
    }

    @NotNull
    @Generated
    public List<String> getPluginDepends() {
        return this.pluginDepends;
    }

    @NotNull
    @Generated
    public List<String> getDepends() {
        return this.depends;
    }

    @NotNull
    @Generated
    public String getDescription() {
        return this.description;
    }

    @NotNull
    @Generated
    public List<String> getAuthors() {
        return this.authors;
    }

    @NotNull
    @Generated
    public File getFolder() {
        return this.folder;
    }

    @NotNull
    @Generated
    public Map<String, SlimefunItemStack> getPreloadItems() {
        return this.preloadItems;
    }

    @Nullable
    @Generated
    public String getGithubRepo() {
        return this.githubRepo;
    }

    @Nullable
    @Generated
    public String getDownloadZipName() {
        return this.downloadZipName;
    }

    @Nullable
    @Generated
    public String getIdPattern() {
        return this.idPattern;
    }

    @Nullable
    @Generated
    public CustomAddonConfig getConfig() {
        return this.config;
    }

    @Nullable
    @Generated
    public ScriptableEventListener getEventListener() {
        return this.eventListener;
    }

    @Generated
    public List<JavaScriptEval> getScriptEvals() {
        return this.scriptEvals;
    }

    @Generated
    public List<ItemGroup> getItemGroups() {
        return this.itemGroups;
    }

    @Generated
    public List<CustomMenu> getMenus() {
        return this.menus;
    }

    @Generated
    public List<GEOResource> getGeoResources() {
        return this.geoResources;
    }

    @Generated
    public List<SlimefunItem> getItems() {
        return this.items;
    }

    @Generated
    public List<AbstractEmptyMachine<?>> getMachines() {
        return this.machines;
    }

    @Generated
    public List<Research> getResearches() {
        return this.researches;
    }

    @Generated
    public List<CustomGenerator> getGenerators() {
        return this.generators;
    }

    @Generated
    public List<CustomMaterialGenerator> getMaterialGenerators() {
        return this.materialGenerators;
    }

    @Generated
    public List<CustomRecipeMachine> getRecipeMachines() {
        return this.recipeMachines;
    }

    @Generated
    public List<CustomMultiBlockMachine> getMultiBlockMachines() {
        return this.multiBlockMachines;
    }

    @Generated
    public List<CustomSolarGenerator> getSolarGenerators() {
        return this.solarGenerators;
    }

    @Generated
    public List<CustomMobDrop> getMobDrops() {
        return this.mobDrops;
    }

    @Generated
    public List<Capacitor> getCapacitors() {
        return this.capacitors;
    }

    @Generated
    public List<RecipeType> getRecipeTypes() {
        return this.recipeTypes;
    }

    @Generated
    public List<SlimefunItem> getSimpleMachines() {
        return this.simpleMachines;
    }

    @Generated
    public List<CustomFood> getFoods() {
        return this.foods;
    }

    @Generated
    public List<List<CustomArmorPiece>> getArmors() {
        return this.armors;
    }

    @Generated
    public List<SlimefunItem> getSupers() {
        return this.supers;
    }

    @Generated
    public List<CustomTemplateMachine> getTemplateMachines() {
        return this.templateMachines;
    }

    @Generated
    public List<CustomLinkedRecipeMachine> getLinkedRecipeMachines() {
        return this.linkedRecipeMachines;
    }

    @Generated
    public List<CustomWorkbench> getWorkbenches() {
        return this.workbenches;
    }

    @Generated
    void setMarkAsDepend(boolean markAsDepend) {
        this.markAsDepend = markAsDepend;
    }

    @Generated
    void setGithubRepo(@Nullable String githubRepo) {
        this.githubRepo = githubRepo;
    }

    @Generated
    void setDownloadZipName(@Nullable String downloadZipName) {
        this.downloadZipName = downloadZipName;
    }

    @Generated
    void setIdPattern(@Nullable String idPattern) {
        this.idPattern = idPattern;
    }

    @Generated
    void setConfig(@Nullable CustomAddonConfig config) {
        this.config = config;
    }

    @Generated
    void setEventListener(@Nullable ScriptableEventListener eventListener) {
        this.eventListener = eventListener;
    }

    @Generated
    void setScriptEvals(List<JavaScriptEval> scriptEvals) {
        this.scriptEvals = scriptEvals;
    }

    @Generated
    void setItemGroups(List<ItemGroup> itemGroups) {
        this.itemGroups = itemGroups;
    }

    @Generated
    void setMenus(List<CustomMenu> menus) {
        this.menus = menus;
    }

    @Generated
    void setGeoResources(List<GEOResource> geoResources) {
        this.geoResources = geoResources;
    }

    @Generated
    void setItems(List<SlimefunItem> items) {
        this.items = items;
    }

    @Generated
    void setMachines(List<AbstractEmptyMachine<?>> machines) {
        this.machines = machines;
    }

    @Generated
    void setResearches(List<Research> researches) {
        this.researches = researches;
    }

    @Generated
    void setGenerators(List<CustomGenerator> generators) {
        this.generators = generators;
    }

    @Generated
    void setMaterialGenerators(List<CustomMaterialGenerator> materialGenerators) {
        this.materialGenerators = materialGenerators;
    }

    @Generated
    void setRecipeMachines(List<CustomRecipeMachine> recipeMachines) {
        this.recipeMachines = recipeMachines;
    }

    @Generated
    void setMultiBlockMachines(List<CustomMultiBlockMachine> multiBlockMachines) {
        this.multiBlockMachines = multiBlockMachines;
    }

    @Generated
    void setSolarGenerators(List<CustomSolarGenerator> solarGenerators) {
        this.solarGenerators = solarGenerators;
    }

    @Generated
    void setMobDrops(List<CustomMobDrop> mobDrops) {
        this.mobDrops = mobDrops;
    }

    @Generated
    void setCapacitors(List<Capacitor> capacitors) {
        this.capacitors = capacitors;
    }

    @Generated
    void setRecipeTypes(List<RecipeType> recipeTypes) {
        this.recipeTypes = recipeTypes;
    }

    @Generated
    void setSimpleMachines(List<SlimefunItem> simpleMachines) {
        this.simpleMachines = simpleMachines;
    }

    @Generated
    void setFoods(List<CustomFood> foods) {
        this.foods = foods;
    }

    @Generated
    void setArmors(List<List<CustomArmorPiece>> armors) {
        this.armors = armors;
    }

    @Generated
    void setSupers(List<SlimefunItem> supers) {
        this.supers = supers;
    }

    @Generated
    void setTemplateMachines(List<CustomTemplateMachine> templateMachines) {
        this.templateMachines = templateMachines;
    }

    @Generated
    void setLinkedRecipeMachines(List<CustomLinkedRecipeMachine> linkedRecipeMachines) {
        this.linkedRecipeMachines = linkedRecipeMachines;
    }

    @Generated
    void setWorkbenches(List<CustomWorkbench> workbenches) {
        this.workbenches = workbenches;
    }
}

