/*
 * Decompiled with CFR 0.152.
 */
package org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lins.mmmjjkx.rykenslimefuncustomizer.bulit_in.JavaScriptEval;
import org.lins.mmmjjkx.rykenslimefuncustomizer.libraries.colors.CMIChatColor;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.machine.CustomMachine;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.machine.CustomNoEnergyMachine;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.machine.CustomRecipeMachine;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.script.lambda.RSCClickHandler;

public class CustomMenu {
    private final JavaScriptEval eval;
    private final String title;
    private final String id;
    private int progressSlot;
    private int size;
    private ItemStack progress;
    private boolean playerInvClickable;
    private ChestMenu.MenuOpeningHandler menuOpeningHandler;
    private ChestMenu.MenuCloseHandler menuCloseHandler;
    private final Map<Integer, ItemStack> items;
    private final Map<Integer, ChestMenu.MenuClickHandler> clickHandlers;

    public CustomMenu(String id, String title, CustomMenu menu) {
        this.menuOpeningHandler = p -> {};
        this.menuCloseHandler = p -> {};
        this.eval = menu.eval;
        this.title = CMIChatColor.translate(title);
        this.id = id;
        this.items = menu.items;
        this.progressSlot = menu.progressSlot;
        this.clickHandlers = menu.clickHandlers;
        this.size = menu.size;
        if (this.eval != null) {
            this.menuOpeningHandler = menu.menuOpeningHandler;
            this.menuCloseHandler = menu.menuCloseHandler;
        }
    }

    public CustomMenu(String id, String title, @Nullable BlockMenuPreset preset, @Nullable ItemStack progressBar, @Nullable JavaScriptEval eval) {
        this(id, title, new HashMap<Integer, ItemStack>(), preset == null || preset.isPlayerInventoryClickable(), 22, progressBar, eval);
        if (preset != null) {
            this.cloneFromPresetInventory(preset);
            SlimefunItem item = (SlimefunItem)Slimefun.getRegistry().getSlimefunItemIds().get(preset.getID());
            if (item instanceof CustomMachine) {
                CustomMachine cm = (CustomMachine)item;
                this.progressSlot = cm.getMenu().getProgressSlot();
                this.progress = cm.getMenu().getProgressBarItem();
            } else if (item instanceof CustomNoEnergyMachine) {
                CustomNoEnergyMachine cnem = (CustomNoEnergyMachine)item;
                this.progressSlot = cnem.getMenu().getProgressSlot();
                this.progress = cnem.getMenu().getProgressBarItem();
            } else if (item instanceof CustomRecipeMachine) {
                CustomRecipeMachine crm = (CustomRecipeMachine)item;
                this.progressSlot = crm.getMenu() != null ? crm.getMenu().getProgressSlot() : 22;
                this.progress = crm.getProgressBar();
            } else if (item instanceof AContainer) {
                AContainer container = (AContainer)item;
                this.progressSlot = 22;
                this.progress = container.getProgressBar();
            }
            this.size = preset.getSize();
        }
    }

    public CustomMenu(String id, String title, @NotNull Map<Integer, ItemStack> mi, boolean playerInvClickable, int progress, @Nullable ItemStack progressBar, @Nullable JavaScriptEval eval) {
        this.menuOpeningHandler = p -> {};
        this.menuCloseHandler = p -> {};
        this.id = id;
        this.title = CMIChatColor.translate(title);
        this.eval = eval;
        this.progress = progressBar != null ? progressBar.clone() : mi.get(progress);
        this.progressSlot = progress;
        this.playerInvClickable = playerInvClickable;
        this.items = mi;
        this.clickHandlers = new HashMap<Integer, ChestMenu.MenuClickHandler>();
        if (eval != null) {
            eval.doInit();
        }
        for (int i = 0; i < 54; ++i) {
            ItemStack item = this.items.get(i);
            if (item == null) continue;
            this.addItem(i, item, (p, slot, is, ca) -> {
                if (eval != null) {
                    eval.evalFunction("onClick", p, slot, is, ca);
                }
            });
        }
        if (eval != null) {
            this.menuOpeningHandler = p -> eval.evalFunction("onOpen", p);
            this.menuCloseHandler = p -> eval.evalFunction("onClose", p);
        }
    }

    public String getId() {
        return this.id;
    }

    public CustomMenu setSize(int size) {
        if (size == -1) {
            this.size = -1;
            return this;
        }
        if (size > 54 || size < 0) {
            throw new IllegalArgumentException("Size must be between 0 and 54");
        }
        if (size % 9 != 0) {
            throw new IllegalArgumentException("Size must be a multiple of 9");
        }
        this.size = size;
        return this;
    }

    public void addItem(int i, ItemStack item, ChestMenu.MenuClickHandler onClick) {
        this.items.put(i, item);
        this.clickHandlers.put(i, onClick);
    }

    public void addItem(int i, ItemStack item) {
        this.items.put(i, item);
    }

    private ChestMenu.MenuClickHandler getClickHandler(int slot) {
        return this.clickHandlers.getOrDefault(slot, (player, i, itemStack, clickAction) -> true);
    }

    @Nullable
    public ItemStack getProgressBarItem() {
        return this.progress;
    }

    public String getID() {
        return this.id;
    }

    private void cloneFromPresetInventory(BlockMenuPreset preset) {
        preset.getContents();
        Inventory inventory = Bukkit.createInventory(null, (int)preset.toInventory().getSize(), (String)CMIChatColor.translate(this.title));
        for (int i = 0; i < preset.toInventory().getSize(); ++i) {
            ChestMenu.MenuClickHandler handler;
            ItemStack item = preset.getItemInSlot(i);
            if (item != null) {
                this.addItem(i, item.clone());
                inventory.setItem(i, item.clone());
            }
            if ((handler = preset.getMenuClickHandler(i)) == null) continue;
            this.addMenuClickHandler(i, new RSCClickHandler(){

                @Override
                public void mainFunction(Player player, int slot, ItemStack itemStack, ClickAction action) {
                    handler.onClick(player, slot, itemStack, action);
                }

                @Override
                public void andThen(Player player, int slot, ItemStack itemStack, ClickAction action) {
                    if (CustomMenu.this.eval != null) {
                        CustomMenu.this.eval.evalFunction("onClick", player, slot, itemStack, action);
                    }
                }
            });
        }
    }

    public void addMenuClickHandler(int i, ChestMenu.MenuClickHandler onClick) {
        this.clickHandlers.put(i, onClick);
    }

    public void apply(BlockMenuPreset preset) {
        preset.setPlayerInventoryClickable(this.playerInvClickable);
        if (this.size != -1) {
            preset.setSize(this.size);
        }
        for (int slot : this.items.keySet()) {
            preset.addItem(slot, this.items.get(slot), this.getClickHandler(slot));
        }
        preset.addMenuOpeningHandler(this.menuOpeningHandler);
        preset.addMenuCloseHandler(this.menuCloseHandler);
    }

    @Nullable
    public ChestMenu.MenuClickHandler getMenuClickHandler(int workSlot) {
        return this.clickHandlers.get(workSlot);
    }

    @Generated
    public JavaScriptEval getEval() {
        return this.eval;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public int getProgressSlot() {
        return this.progressSlot;
    }

    @Generated
    public int getSize() {
        return this.size;
    }

    @Generated
    public ItemStack getProgress() {
        return this.progress;
    }

    @Generated
    public void setPlayerInvClickable(boolean playerInvClickable) {
        this.playerInvClickable = playerInvClickable;
    }

    @Generated
    public void setMenuOpeningHandler(ChestMenu.MenuOpeningHandler menuOpeningHandler) {
        this.menuOpeningHandler = menuOpeningHandler;
    }

    @Generated
    public void setMenuCloseHandler(ChestMenu.MenuCloseHandler menuCloseHandler) {
        this.menuCloseHandler = menuCloseHandler;
    }

    @Generated
    public Map<Integer, ItemStack> getItems() {
        return this.items;
    }
}

