/*
 * Decompiled with CFR 0.152.
 */
package org.lins.mmmjjkx.rykenslimefuncustomizer.objects.yaml.machine;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.ProjectAddon;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.CustomMenu;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.LinkedOutput;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.machine.CustomLinkedRecipeMachine;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.machine.CustomLinkedMachineRecipe;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.yaml.YamlReader;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.CommonUtils;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.ExceptionHandler;

public class LinkedRecipeMachineReader
extends YamlReader<CustomLinkedRecipeMachine> {
    public LinkedRecipeMachineReader(YamlConfiguration config, ProjectAddon addon) {
        super(config, addon);
    }

    @Override
    public CustomLinkedRecipeMachine readEach(String s) {
        ConfigurationSection section = this.configuration.getConfigurationSection(s);
        if (section == null) {
            return null;
        }
        String id = this.addon.getId(s, section.getString("id_alias"));
        ExceptionHandler.HandleResult result = ExceptionHandler.handleIdConflict(id);
        if (result == ExceptionHandler.HandleResult.FAILED) {
            return null;
        }
        String igId = section.getString("item_group");
        Pair<ExceptionHandler.HandleResult, ItemGroup> group = ExceptionHandler.handleItemGroupGet(this.addon, igId);
        if (group.getFirstValue() == ExceptionHandler.HandleResult.FAILED) {
            return null;
        }
        SlimefunItemStack slimefunItemStack = this.getPreloadItem(id);
        if (slimefunItemStack == null) {
            return null;
        }
        ItemStack[] recipe = CommonUtils.readRecipe(section.getConfigurationSection("recipe"), this.addon);
        String recipeType = section.getString("recipe_type", "NULL");
        Pair<ExceptionHandler.HandleResult, RecipeType> rt = ExceptionHandler.getRecipeType("\u5728\u9644\u5c5e" + this.addon.getAddonId() + "\u4e2d\u52a0\u8f7d\u5f3a\u914d\u65b9\u673a\u5668" + s + "\u65f6\u9047\u5230\u4e86\u95ee\u9898: \u9519\u8bef\u7684\u914d\u65b9\u7c7b\u578b" + recipeType + "!", recipeType);
        if (rt.getFirstValue() == ExceptionHandler.HandleResult.FAILED) {
            return null;
        }
        CustomMenu menu = CommonUtils.getIf(this.addon.getMenus(), m -> m.getID().equalsIgnoreCase(id));
        if (menu == null) {
            ExceptionHandler.handleWarning("\u672a\u627e\u5230\u83dc\u5355 " + id + " \u4f7f\u7528\u9ed8\u8ba4\u83dc\u5355");
        }
        List input = section.getIntegerList("input");
        List output = section.getIntegerList("output");
        if (input.isEmpty()) {
            ExceptionHandler.handleError("\u5728\u9644\u5c5e" + this.addon.getAddonId() + "\u4e2d\u52a0\u8f7d\u5f3a\u914d\u65b9\u673a\u5668" + s + "\u65f6\u9047\u5230\u4e86\u95ee\u9898: \u8f93\u5165\u69fd\u4e3a\u7a7a");
            return null;
        }
        if (output.isEmpty()) {
            ExceptionHandler.handleError("\u5728\u9644\u5c5e" + this.addon.getAddonId() + "\u4e2d\u52a0\u8f7d\u5f3a\u914d\u65b9\u673a\u5668" + s + "\u65f6\u9047\u5230\u4e86\u95ee\u9898: \u8f93\u51fa\u69fd\u4e3a\u7a7a");
            return null;
        }
        ConfigurationSection recipes = section.getConfigurationSection("recipes");
        int capacity = section.getInt("capacity");
        if (capacity < 0) {
            ExceptionHandler.handleError("\u5728\u9644\u5c5e" + this.addon.getAddonId() + "\u4e2d\u52a0\u8f7d\u5f3a\u914d\u65b9\u673a\u5668" + s + "\u65f6\u9047\u5230\u4e86\u95ee\u9898: \u80fd\u6e90\u5bb9\u91cf\u5c0f\u4e8e0");
            return null;
        }
        int energy = section.getInt("energyPerCraft");
        if (energy <= 0) {
            ExceptionHandler.handleError("\u5728\u9644\u5c5e" + this.addon.getAddonId() + "\u4e2d\u52a0\u8f7d\u5f3a\u914d\u65b9\u673a\u5668" + s + "\u65f6\u9047\u5230\u4e86\u95ee\u9898: \u5408\u6210\u4e00\u6b21\u7684\u6d88\u8017\u80fd\u91cf\u672a\u8bbe\u7f6e\u6216\u5c0f\u4e8e\u7b49\u4e8e0");
            return null;
        }
        int speed = section.getInt("speed");
        if (speed <= 0) {
            ExceptionHandler.handleError("\u5728\u9644\u5c5e" + this.addon.getAddonId() + "\u4e2d\u52a0\u8f7d\u5f3a\u914d\u65b9\u673a\u5668" + s + "\u65f6\u9047\u5230\u4e86\u95ee\u9898: \u5408\u6210\u901f\u5ea6\u672a\u8bbe\u7f6e\u6216\u5c0f\u4e8e\u7b49\u4e8e0");
            return null;
        }
        boolean hideAllRecipes = section.getBoolean("hideAllRecipes", false);
        int saveAmount = section.getInt("saveAmount", 0);
        List<CustomLinkedMachineRecipe> mr = this.readRecipes(s, input.size(), output.size(), recipes, this.addon);
        return new CustomLinkedRecipeMachine((ItemGroup)group.getSecondValue(), slimefunItemStack, (RecipeType)rt.getSecondValue(), recipe, input.stream().mapToInt(x -> x).toArray(), output.stream().mapToInt(x -> x).toArray(), mr, energy, capacity, menu, speed, hideAllRecipes, saveAmount);
    }

    @Override
    public List<SlimefunItemStack> preloadItems(String s) {
        ConfigurationSection section = this.configuration.getConfigurationSection(s);
        if (section == null) {
            return null;
        }
        ConfigurationSection item = section.getConfigurationSection("item");
        ItemStack stack = CommonUtils.readItem(item, false, this.addon);
        if (stack == null) {
            ExceptionHandler.handleError("\u5728\u9644\u5c5e" + this.addon.getAddonId() + "\u4e2d\u52a0\u8f7d\u5f3a\u914d\u65b9\u673a\u5668" + s + "\u65f6\u9047\u5230\u4e86\u95ee\u9898: \u7269\u54c1\u4e3a\u7a7a\u6216\u683c\u5f0f\u9519\u8bef");
            return null;
        }
        return List.of(new SlimefunItemStack(this.addon.getId(s, section.getString("id_alias")), stack));
    }

    private List<CustomLinkedMachineRecipe> readRecipes(String s, int inputSize, int outputSize, ConfigurationSection section, ProjectAddon addon) {
        ArrayList<CustomLinkedMachineRecipe> list = new ArrayList<CustomLinkedMachineRecipe>();
        if (section == null) {
            return list;
        }
        for (String key : section.getKeys(false)) {
            ConfigurationSection recipes = section.getConfigurationSection(key);
            if (recipes == null) continue;
            int seconds = recipes.getInt("seconds");
            if (seconds < 0) {
                ExceptionHandler.handleError("\u5728\u9644\u5c5e" + addon.getAddonId() + "\u4e2d\u52a0\u8f7d\u5f3a\u914d\u65b9\u673a\u5668" + s + "\u7684\u5de5\u4f5c\u914d\u65b9" + key + "\u65f6\u9047\u5230\u4e86\u95ee\u9898: \u95f4\u9694\u65f6\u95f4\u672a\u8bbe\u7f6e\u6216\u4e0d\u80fd\u5c0f\u4e8e0");
                continue;
            }
            ConfigurationSection inputs = recipes.getConfigurationSection("input");
            if (inputs == null) {
                ExceptionHandler.handleError("\u5728\u9644\u5c5e" + addon.getAddonId() + "\u4e2d\u52a0\u8f7d\u5f3a\u914d\u65b9\u673a\u5668" + s + "\u7684\u5de5\u4f5c\u914d\u65b9" + key + "\u65f6\u9047\u5230\u4e86\u95ee\u9898: \u6ca1\u6709\u8f93\u5165\u7269\u54c1");
                continue;
            }
            ConfigurationSection outputs = recipes.getConfigurationSection("output");
            if (outputs == null) {
                ExceptionHandler.handleError("\u5728\u9644\u5c5e" + addon.getAddonId() + "\u4e2d\u52a0\u8f7d\u5f3a\u914d\u65b9\u673a\u5668" + s + "\u7684\u5de5\u4f5c\u914d\u65b9" + key + "\u65f6\u9047\u5230\u4e86\u95ee\u9898: \u6ca1\u6709\u8f93\u51fa\u7269\u54c1");
                continue;
            }
            ArrayList<ItemStack> freeOutput = new ArrayList<ItemStack>();
            ArrayList<Integer> freeChances = new ArrayList<Integer>();
            HashMap<Integer, ItemStack> linkedOutput = new HashMap<Integer, ItemStack>();
            HashMap<Integer, Integer> linkedChances = new HashMap<Integer, Integer>();
            for (int i = 0; i < outputSize; ++i) {
                int slot;
                ConfigurationSection section1 = outputs.getConfigurationSection(String.valueOf(i + 1));
                ItemStack item = CommonUtils.readItem(section1, true, addon);
                if (item == null) continue;
                int chance = section1.getInt("chance", 100);
                if (chance < 1) {
                    ExceptionHandler.handleError("\u5728\u9644\u5c5e" + addon.getAddonId() + "\u4e2d\u52a0\u8f7d\u5f3a\u914d\u65b9\u673a\u5668" + s + "\u7684\u5de5\u4f5c\u914d\u65b9" + key + "\u65f6\u9047\u5230\u4e86\u95ee\u9898: \u6982\u7387\u4e0d\u5e94\u8be5\u5c0f\u4e8e1\uff0c\u5df2\u8f6c\u4e3a1");
                    chance = 1;
                }
                if ((slot = section1.getInt("slot", -1)) == -1) {
                    freeOutput.add(item);
                    freeChances.add(chance);
                    continue;
                }
                linkedOutput.put(slot, item);
                linkedChances.put(slot, chance);
            }
            boolean chooseOne = recipes.getBoolean("chooseOne", false);
            boolean forDisplay = recipes.getBoolean("forDisplay", false);
            boolean hide = recipes.getBoolean("hide", false);
            HashMap<Integer, ItemStack> finalInput = new HashMap<Integer, ItemStack>();
            for (int i = 0; i < inputSize; ++i) {
                ItemStack itemStack;
                ConfigurationSection section1 = inputs.getConfigurationSection(String.valueOf(i + 1));
                if (section1 == null || (itemStack = CommonUtils.readItem(section1, true, addon)) == null) continue;
                int slot = section1.getInt("slot", -1);
                if (slot == -1) {
                    ExceptionHandler.handleError("\u5728\u9644\u5c5e" + addon.getAddonId() + "\u4e2d\u52a0\u8f7d\u5f3a\u914d\u65b9\u673a\u5668" + s + "\u7684\u5de5\u4f5c\u914d\u65b9" + key + "\u65f6\u9047\u5230\u4e86\u95ee\u9898: \u8f93\u5165\u69fd\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                    continue;
                }
                if (slot < 0 || slot > 53) {
                    ExceptionHandler.handleError("\u5728\u9644\u5c5e" + addon.getAddonId() + "\u4e2d\u52a0\u8f7d\u5f3a\u914d\u65b9\u673a\u5668" + s + "\u7684\u5de5\u4f5c\u914d\u65b9" + key + "\u65f6\u9047\u5230\u4e86\u95ee\u9898: \u8f93\u5165\u69fd\u4f4d\u8d85\u51fa\u8303\u56f4");
                    continue;
                }
                finalInput.put(slot, itemStack);
            }
            int[] array = new int[freeChances.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = i;
            }
            list.add(new CustomLinkedMachineRecipe(seconds, finalInput, new LinkedOutput(freeOutput.toArray(new ItemStack[0]), linkedOutput, array, linkedChances), chooseOne, forDisplay, hide));
        }
        return list;
    }
}

