/*
 * Decompiled with CFR 0.152.
 */
package org.lins.mmmjjkx.rykenslimefuncustomizer.objects.slimefun;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.groups.NestedItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.groups.SubItemGroup;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.guide.GuideHistory;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuide;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundEffect;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.guide.SurvivalSlimefunGuide;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.slimefun.ItemGroupButton;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.ExceptionHandler;

public class AdvancedNestedItemGroup
extends NestedItemGroup {
    private final List<SubItemGroup> subGroups;

    public AdvancedNestedItemGroup(NamespacedKey key, ItemStack item, int tier) {
        super(key, item, tier);
        ExceptionHandler.debugLog("\u521b\u5efa\u7269\u54c1\u7ec4: " + String.valueOf(key));
        this.subGroups = new ArrayList<SubItemGroup>();
    }

    public void open(@NotNull Player p, @NotNull PlayerProfile profile, @NotNull SlimefunGuideMode mode) {
        this.setup(p, profile, mode, 1);
    }

    public void addSubGroup(@Nonnull SubItemGroup group) {
        super.addSubGroup(group);
        this.subGroups.add(group);
    }

    public void removeSubGroup(@Nonnull SubItemGroup group) {
        super.removeSubGroup(group);
        this.subGroups.remove(group);
    }

    private void setup(Player p, PlayerProfile profile, SlimefunGuideMode mode, int page) {
        GuideHistory history = profile.getGuideHistory();
        if (mode == SlimefunGuideMode.SURVIVAL_MODE) {
            history.add((ItemGroup)this, page);
        }
        ChestMenu menu = new ChestMenu(Slimefun.getLocalization().getMessage(p, "guide.title.main"));
        SurvivalSlimefunGuide guide = (SurvivalSlimefunGuide)Slimefun.getRegistry().getSlimefunGuide(mode);
        menu.setEmptySlotsClickable(false);
        SoundEffect var10001 = SoundEffect.GUIDE_BUTTON_CLICK_SOUND;
        Objects.requireNonNull(var10001);
        menu.addMenuOpeningHandler(arg_0 -> ((SoundEffect)var10001).playFor(arg_0));
        guide.createHeader(p, profile, menu);
        menu.addItem(1, (ItemStack)new CustomItemStack(ChestMenuUtils.getBackButton((Player)p, (String[])new String[]{"", String.valueOf(ChatColor.GRAY) + Slimefun.getLocalization().getMessage(p, "guide.back.guide")})));
        menu.addMenuClickHandler(1, (pl, s, is, action) -> {
            SlimefunGuide.openMainMenu((PlayerProfile)profile, (SlimefunGuideMode)mode, (int)history.getMainMenuPage());
            return false;
        });
        int index = 9;
        int target = 36 * (page - 1) - 1;
        while (target < this.subGroups.size() - 1 && index < 45) {
            SubItemGroup itemGroup;
            if (!(itemGroup = this.subGroups.get(++target)).isVisibleInNested(p)) continue;
            menu.addItem(index, itemGroup.getItem(p));
            menu.addMenuClickHandler(index, (pl, slot, item, action) -> {
                if (itemGroup instanceof ItemGroupButton) {
                    ItemGroupButton button = (ItemGroupButton)itemGroup;
                    button.run(p, slot, item, action, mode);
                    return false;
                }
                SlimefunGuide.openItemGroup((PlayerProfile)profile, (ItemGroup)itemGroup, (SlimefunGuideMode)mode, (int)1);
                return false;
            });
            ++index;
        }
        int pages = target == this.subGroups.size() - 1 ? page : (this.subGroups.size() - 1) / 36 + 1;
        menu.addItem(46, ChestMenuUtils.getPreviousButton((Player)p, (int)page, (int)pages));
        menu.addMenuClickHandler(46, (pl, slot, item, action) -> {
            int next = page - 1;
            if (next > 0) {
                this.setup(p, profile, mode, next);
            }
            return false;
        });
        menu.addItem(52, ChestMenuUtils.getNextButton((Player)p, (int)page, (int)pages));
        menu.addMenuClickHandler(52, (pl, slot, item, action) -> {
            int next = page + 1;
            if (next <= pages) {
                this.setup(p, profile, mode, next);
            }
            return false;
        });
        menu.open(new Player[]{p});
    }
}

