/*
 * Decompiled with CFR 0.152.
 */
package org.lins.mmmjjkx.rykenslimefuncustomizer.utils;

import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.LinkedOutput;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.StackUtils;

public final class BlockMenuUtil {
    @Nullable
    public static ItemStack pushItem(@Nonnull BlockMenu blockMenu, @Nonnull ItemStack item, int ... slots) {
        if (item == null || item.getType() == Material.AIR) {
            throw new IllegalArgumentException("Cannot push null or AIR");
        }
        int leftAmount = item.getAmount();
        for (int slot : slots) {
            if (leftAmount <= 0) break;
            ItemStack existing = blockMenu.getItemInSlot(slot);
            if (existing == null || existing.getType() == Material.AIR) {
                int received = Math.min(leftAmount, item.getMaxStackSize());
                ItemStack clone = item.clone();
                clone.setAmount(received);
                blockMenu.replaceExistingItem(slot, clone);
                item.setAmount(Math.max(0, leftAmount -= received));
                continue;
            }
            int existingAmount = existing.getAmount();
            if (existingAmount >= item.getMaxStackSize() || !StackUtils.itemsMatch(item, existing, true, false)) continue;
            int received = Math.max(0, Math.min(item.getMaxStackSize() - existingAmount, leftAmount));
            existing.setAmount(existingAmount + received);
            item.setAmount(leftAmount -= received);
        }
        if (leftAmount > 0) {
            return new CustomItemStack(item, leftAmount);
        }
        return null;
    }

    @Nonnull
    public static Map<ItemStack, Integer> pushItem(@Nonnull BlockMenu blockMenu, @Nonnull ItemStack[] items, int ... slots) {
        if (items == null || items.length == 0) {
            throw new IllegalArgumentException("Cannot push null or empty array");
        }
        ArrayList<ItemStack> listItems = new ArrayList<ItemStack>();
        for (ItemStack item : items) {
            if (item == null || item.getType() == Material.AIR) continue;
            listItems.add(item);
        }
        return BlockMenuUtil.pushItem(blockMenu, listItems, slots);
    }

    @Nonnull
    public static Map<ItemStack, Integer> pushItem(@Nonnull BlockMenu blockMenu, @Nonnull List<ItemStack> items, int ... slots) {
        if (items == null || items.isEmpty()) {
            throw new IllegalArgumentException("Cannot push null or empty list");
        }
        HashMap<ItemStack, Integer> itemMap = new HashMap<ItemStack, Integer>();
        for (ItemStack item : items) {
            ItemStack leftOver;
            if (item == null || item.getType() == Material.AIR || (leftOver = BlockMenuUtil.pushItem(blockMenu, item, slots)) == null) continue;
            itemMap.put(leftOver, itemMap.getOrDefault(leftOver, 0) + leftOver.getAmount());
        }
        return itemMap;
    }

    public static boolean fits(@Nonnull BlockMenu blockMenu, @Nonnull ItemStack item, int ... slots) {
        if (item == null || item.getType() == Material.AIR) {
            return true;
        }
        int incoming = item.getAmount();
        for (int slot : slots) {
            ItemStack stack = blockMenu.getItemInSlot(slot);
            if (stack == null || stack.getType() == Material.AIR) {
                incoming -= item.getMaxStackSize();
            } else if (stack.getMaxStackSize() > stack.getAmount() && StackUtils.itemsMatch(item, stack, true, false)) {
                incoming -= stack.getMaxStackSize() - stack.getAmount();
            }
            if (incoming > 0) continue;
            return true;
        }
        return false;
    }

    public static boolean fits(@Nonnull BlockMenu blockMenu, @Nonnull ItemStack[] items, int ... slots) {
        if (items == null || items.length == 0) {
            return false;
        }
        ArrayList<ItemStack> listItems = new ArrayList<ItemStack>();
        for (ItemStack item : items) {
            if (item == null || item.getType() == Material.AIR) continue;
            listItems.add(item.clone());
        }
        return BlockMenuUtil.fits(blockMenu, listItems, slots);
    }

    public static boolean fits(@Nonnull BlockMenu blockMenu, @Nonnull List<ItemStack> items, int ... slots) {
        if (items == null || items.isEmpty()) {
            return false;
        }
        ArrayList<ItemStack> cloneMenu = new ArrayList<ItemStack>();
        for (int i = 0; i < 54; ++i) {
            cloneMenu.add(null);
        }
        for (int slot : slots) {
            ItemStack stack = blockMenu.getItemInSlot(slot);
            if (stack != null && stack.getType() != Material.AIR) {
                cloneMenu.set(slot, stack.clone());
                continue;
            }
            cloneMenu.set(slot, null);
        }
        Object object = items.iterator();
        while (object.hasNext()) {
            ItemStack rawItem = (ItemStack)object.next();
            ItemStack item = rawItem.clone();
            int leftAmount = item.getAmount();
            for (int slot : slots) {
                if (leftAmount <= 0) break;
                ItemStack existing = (ItemStack)cloneMenu.get(slot);
                if (existing == null || existing.getType() == Material.AIR) {
                    int received = Math.min(leftAmount, item.getMaxStackSize());
                    ItemStack clone = item.clone();
                    clone.setAmount(leftAmount);
                    cloneMenu.set(slot, clone);
                    item.setAmount(Math.max(0, leftAmount -= received));
                    continue;
                }
                int existingAmount = existing.getAmount();
                if (existingAmount >= item.getMaxStackSize() || !StackUtils.itemsMatch(item, existing, true, false)) continue;
                int received = Math.max(0, Math.min(item.getMaxStackSize() - existingAmount, leftAmount));
                existing.setAmount(existingAmount + received);
                item.setAmount(leftAmount -= received);
            }
            if (leftAmount <= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean fits(@Nonnull BlockMenu blockMenu, @Nonnull LinkedOutput output, int ... slots) {
        int i;
        if (output == null) {
            return false;
        }
        ArrayList<ItemStack> cloneMenu = new ArrayList<ItemStack>();
        for (i = 0; i < 54; ++i) {
            cloneMenu.add(null);
        }
        for (i = 0; i < 54; ++i) {
            ItemStack stack = blockMenu.getItemInSlot(i);
            if (stack != null && stack.getType() != Material.AIR) {
                cloneMenu.set(i, stack.clone());
                continue;
            }
            cloneMenu.set(i, null);
        }
        ItemStack[] itemStackArray = output.getLinkedOutput().keySet().iterator();
        while (itemStackArray.hasNext()) {
            ItemStack PitemToPush;
            int pushToSlot = itemStackArray.next();
            if (pushToSlot < 0 || pushToSlot >= 54 || (PitemToPush = output.getLinkedOutput().get(pushToSlot)) == null || PitemToPush.getType() == Material.AIR) continue;
            ItemStack itemToPush = PitemToPush.clone();
            ItemStack existing = (ItemStack)cloneMenu.get(pushToSlot);
            if (existing == null || existing.getType() == Material.AIR) {
                int received = Math.min(itemToPush.getAmount(), itemToPush.getMaxStackSize());
                if (received <= 0) {
                    return false;
                }
                ItemStack clone = itemToPush.clone();
                clone.setAmount(received);
                cloneMenu.set(pushToSlot, clone);
                itemToPush.setAmount(itemToPush.getAmount() - received);
                continue;
            }
            if (StackUtils.itemsMatch(itemToPush, existing, true, false)) {
                int existingAmount = existing.getAmount();
                int received = Math.min(itemToPush.getMaxStackSize() - existingAmount, itemToPush.getAmount());
                if (received <= 0) {
                    return false;
                }
                existing.setAmount(existingAmount + received);
                itemToPush.setAmount(itemToPush.getAmount() - received);
                continue;
            }
            return false;
        }
        block3: for (ItemStack PitemToPush : output.getFreeOutput()) {
            if (PitemToPush == null || PitemToPush.getType() == Material.AIR) continue;
            ItemStack itemToPush = PitemToPush.clone();
            for (int slot : slots) {
                if (itemToPush.getAmount() <= 0) continue block3;
                ItemStack existing = (ItemStack)cloneMenu.get(slot);
                if (existing == null || existing.getType() == Material.AIR) {
                    int received = Math.min(itemToPush.getAmount(), itemToPush.getMaxStackSize());
                    ItemStack clone = itemToPush.clone();
                    clone.setAmount(received);
                    cloneMenu.set(slot, clone);
                    itemToPush.setAmount(itemToPush.getAmount() - received);
                    continue;
                }
                if (!StackUtils.itemsMatch(itemToPush, existing, true, false)) continue;
                int existingAmount = existing.getAmount();
                int received = Math.min(itemToPush.getMaxStackSize() - existingAmount, itemToPush.getAmount());
                existing.setAmount(existingAmount + received);
                itemToPush.setAmount(itemToPush.getAmount() - received);
            }
        }
        return true;
    }

    public static void pushItem(@Nonnull BlockMenu blockMenu, @Nonnull LinkedOutput output, boolean chooseOneIfHas, int ... slots) {
        int chance;
        ItemStack itemToPush;
        ItemStack PitemToPush;
        if (output == null) {
            return;
        }
        for (int pushToSlot : output.getLinkedOutput().keySet()) {
            if (pushToSlot < 0 || pushToSlot >= 54 || (PitemToPush = output.getLinkedOutput().get(pushToSlot)) == null || PitemToPush.getType() == Material.AIR) continue;
            itemToPush = PitemToPush.clone();
            chance = output.getLinkedChances().get(pushToSlot);
            if (chance > 0 && chance < 100 && Math.random() * 100.0 > (double)chance) continue;
            BlockMenuUtil.pushItem(blockMenu, itemToPush, pushToSlot);
            if (!chooseOneIfHas) continue;
            break;
        }
        ItemStack[] freeOutput = output.getFreeOutput();
        for (int i = 0; i < freeOutput.length; ++i) {
            PitemToPush = freeOutput[i];
            if (PitemToPush == null || PitemToPush.getType() == Material.AIR) continue;
            itemToPush = PitemToPush.clone();
            chance = output.getFreeChances()[i];
            if (chance > 0 && chance < 100 && Math.random() * 100.0 > (double)chance) continue;
            BlockMenuUtil.pushItem(blockMenu, itemToPush, slots);
            if (chooseOneIfHas) break;
        }
    }

    @Generated
    private BlockMenuUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

