/*
 * Decompiled with CFR 0.152.
 */
package org.lins.mmmjjkx.rykenslimefuncustomizer.objects;

import io.github.thebusybiscuit.slimefun4.api.researches.Research;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.bytebuddy.ByteBuddy;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;
import org.lins.mmmjjkx.rykenslimefuncustomizer.ProjectAddonManager;
import org.lins.mmmjjkx.rykenslimefuncustomizer.RykenSlimefunCustomizer;
import org.lins.mmmjjkx.rykenslimefuncustomizer.bulit_in.JavaScriptEval;
import org.lins.mmmjjkx.rykenslimefuncustomizer.listeners.ScriptableEventListener;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.ProjectAddon;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.CustomAddonConfig;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.global.RecipeTypeMap;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.yaml.ItemGroupReader;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.yaml.MenuReader;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.yaml.RecipeTypesReader;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.yaml.ResearchReader;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.yaml.item.ArmorReader;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.yaml.item.CapacitorsReader;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.yaml.item.FoodReader;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.yaml.item.GeoResourceReader;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.yaml.item.ItemReader;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.yaml.item.MobDropsReader;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.yaml.machine.GeneratorReader;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.yaml.machine.LinkedRecipeMachineReader;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.yaml.machine.MachineReader;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.yaml.machine.MaterialGeneratorReader;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.yaml.machine.MultiBlockMachineReader;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.yaml.machine.RecipeMachineReader;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.yaml.machine.SimpleMachineReader;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.yaml.machine.SolarGeneratorReader;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.yaml.machine.SuperReader;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.yaml.machine.TemplateMachineReader;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.yaml.machine.WorkbenchReader;
import org.lins.mmmjjkx.rykenslimefuncustomizer.update.GithubUpdater;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.CommonUtils;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.ExceptionHandler;

public class ProjectAddonLoader {
    private final Map<String, File> ids;
    private final File file;

    public ProjectAddonLoader(File dir, Map<String, File> ids) {
        Validate.notNull((Object)dir, (String)"File cannot be null!");
        Validate.isTrue((boolean)dir.isDirectory(), (String)"File must be a directory!");
        this.file = dir;
        this.ids = ids;
    }

    @Nullable
    public ProjectAddon load() {
        ProjectAddon addon;
        YamlConfiguration info = this.doFileLoad(this.file, "info.yml");
        ExceptionHandler.debugLog("Start reading project info from folder called " + this.file.getName() + " ...");
        if (info.contains("name") && info.contains("version") && info.contains("id")) {
            String idPattern;
            String scriptListener;
            boolean loadResult;
            YamlConfiguration info2;
            boolean b;
            String[] split;
            String name = info.getString("name");
            String version = info.getString("version", "1.0");
            String id = info.getString("id", "");
            String description = info.getString("description", "");
            String downloadZipName = info.getString("downloadZipName", "");
            List<String> depends = new ArrayList();
            List pluginDepends = new ArrayList<String>();
            List authors = info.getStringList("authors");
            String repo = info.getString("repo", "");
            if (!repo.isBlank() && (split = repo.split("/")).length == 2 && RykenSlimefunCustomizer.allowUpdate(id) && (b = GithubUpdater.checkAndUpdate(version, split[0], split[1], id, this.file.getName())) && !Objects.equals((info2 = this.doFileLoad(this.file, "info.yml")).getString("version"), version)) {
                return this.load();
            }
            if (name == null || name.isBlank()) {
                ExceptionHandler.handleError("A folder called " + this.file.getName() + "contains invalid project information, so the addon cannot be loaded\uff01");
                return null;
            }
            if (info.contains("depends") && !RykenSlimefunCustomizer.addonManager.isLoaded((depends = info.getStringList("depends")).toArray(new String[0])) && !(loadResult = this.loadDependencies(depends))) {
                ExceptionHandler.handleError("A addon called " + name + " (Addon id\uff1a" + id + ") needs the dependencies " + String.valueOf(depends) + "\uff0cbecause some of them are not loaded or installed, so the addon cannot be loaded! ");
                return null;
            }
            if (info.contains("pluginDepends")) {
                HashSet<String> unloadedPlugins = new HashSet<String>();
                pluginDepends = info.getStringList("pluginDepends");
                for (Object pluginDepend : pluginDepends) {
                    if (Bukkit.getPluginManager().isPluginEnabled((String)pluginDepend)) continue;
                    unloadedPlugins.add((String)pluginDepend);
                }
                if (!unloadedPlugins.isEmpty()) {
                    StringBuilder message = new StringBuilder("An addon called " + name + " (Addon id\uff1a" + id + ") needs the plugins: ");
                    for (String pluginDepend : pluginDepends) {
                        if (unloadedPlugins.contains(pluginDepend)) {
                            message.append("&c").append(pluginDepend).append("&r ");
                            continue;
                        }
                        message.append("&a").append(pluginDepend).append("&r ");
                    }
                    message.append(", because it is not loaded or installed, so the addon cannot be loaded!");
                    ExceptionHandler.handleError(message.toString());
                    return null;
                }
            }
            addon = new ProjectAddon(id, name, version, pluginDepends, depends, description, authors, this.file);
            if (!repo.isBlank()) {
                addon.setGithubRepo("https://github.com/" + repo);
            }
            if (!downloadZipName.isBlank()) {
                addon.setDownloadZipName(downloadZipName);
            }
            if (!(scriptListener = info.getString("scriptListener", "")).isBlank()) {
                File file = new File(addon.getScriptsFolder(), scriptListener + ".js");
                if (file.exists()) {
                    JavaScriptEval eval = new JavaScriptEval(file, addon);
                    String listenerName = scriptListener.replaceFirst(String.valueOf(scriptListener.charAt(0)), String.valueOf(Character.toUpperCase(scriptListener.charAt(0))));
                    Class sel = new ByteBuddy().subclass(ScriptableEventListener.class).name("org.rykenslimefuncustomizer.addoncontents.listeners." + listenerName).make().load(this.getClass().getClassLoader()).getLoaded();
                    try {
                        ScriptableEventListener listenerObj = (ScriptableEventListener)sel.getConstructors()[0].newInstance(eval);
                        Bukkit.getPluginManager().registerEvents((Listener)listenerObj, (Plugin)RykenSlimefunCustomizer.INSTANCE);
                        addon.setEventListener(listenerObj);
                        ExceptionHandler.info("\u6210\u529f\u6ce8\u518c\u9644\u5c5e " + addon.getAddonId() + " \u7684\u76d1\u542c\u811a\u672c " + file.getName() + "!");
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    ExceptionHandler.handleWarning("Cannot find the script listener file " + scriptListener + ".js for addon " + addon.getAddonId() + "!");
                }
            }
            File customConfigFolder = new File(ProjectAddonManager.CONFIGS_DIRECTORY, id);
            YamlConfiguration customConfigYaml = this.doFileLoad(this.file, "default_config.yml");
            if (!customConfigYaml.getKeys(false).isEmpty()) {
                File scriptHandler;
                File configFile = new File(this.file, "default_config.yml");
                File customConfig = new File(customConfigFolder, "config.yml");
                if (!customConfigFolder.exists()) {
                    customConfigFolder.mkdirs();
                }
                if (!customConfig.exists()) {
                    try {
                        Files.copy(configFile.toPath(), customConfig.toPath(), new CopyOption[0]);
                        customConfigYaml = this.doFileLoad(customConfigFolder, "config.yml");
                    }
                    catch (IOException e) {
                        ExceptionHandler.handleError("Cannot copy " + configFile.getName() + " to " + customConfigFolder.getName() + ", the addon may not work properly!", e);
                    }
                }
                JavaScriptEval eval = (scriptHandler = new File(addon.getScriptsFolder(), "configHandler.js")).exists() ? new JavaScriptEval(scriptHandler, addon) : null;
                CustomAddonConfig customConfigObj = new CustomAddonConfig(customConfig, customConfigYaml, eval);
                YamlConfiguration dest = YamlConfiguration.loadConfiguration((File)customConfig);
                CommonUtils.completeFile(customConfigYaml, dest);
                try {
                    dest.save(customConfig);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                addon.setConfig(customConfigObj);
                customConfigObj.tryReload();
            }
            if ((idPattern = info.getString("idPattern")) != null && !idPattern.isBlank()) {
                if (idPattern.contains("%0")) {
                    addon.setIdPattern(idPattern);
                } else {
                    ExceptionHandler.handleError("\u5728\u540d\u79f0\u4e3a " + this.file.getName() + "\u7684\u6587\u4ef6\u5939\u4e2d\u6709\u65e0\u6548\u7684\u914d\u7f6e: idPattern\uff0cidPattern \u5fc5\u987b\u5305\u542b %0\uff08\u539fid\uff09");
                }
            }
        } else {
            ExceptionHandler.handleError("A folder called " + this.file.getName() + "contains invalid project information, so the addon cannot be loaded\uff01");
            return null;
        }
        ExceptionHandler.debugLog("Read finished, start reading contents from addon " + addon.getAddonId() + "...");
        YamlConfiguration groups = this.doFileLoad(this.file, "groups.yml");
        ItemGroupReader groupReader = new ItemGroupReader(groups, addon);
        addon.setItemGroups(groupReader.readAll());
        YamlConfiguration recipeTypes = this.doFileLoad(this.file, "recipe_types.yml");
        RecipeTypesReader recipeTypesReader = new RecipeTypesReader(recipeTypes, addon);
        addon.setRecipeTypes(recipeTypesReader.readAll());
        RecipeTypeMap.pushRecipeType(addon.getRecipeTypes());
        YamlConfiguration mob_drops = this.doFileLoad(this.file, "mob_drops.yml");
        YamlConfiguration geo_resources = this.doFileLoad(this.file, "geo_resources.yml");
        YamlConfiguration items = this.doFileLoad(this.file, "items.yml");
        YamlConfiguration armors = this.doFileLoad(this.file, "armors.yml");
        YamlConfiguration capacitors = this.doFileLoad(this.file, "capacitors.yml");
        YamlConfiguration foods = this.doFileLoad(this.file, "foods.yml");
        YamlConfiguration menus = this.doFileLoad(this.file, "menus.yml");
        YamlConfiguration machines = this.doFileLoad(this.file, "machines.yml");
        YamlConfiguration generators = this.doFileLoad(this.file, "generators.yml");
        YamlConfiguration solarGenerators = this.doFileLoad(this.file, "solar_generators.yml");
        YamlConfiguration materialGenerators = this.doFileLoad(this.file, "mat_generators.yml");
        YamlConfiguration recipeMachines = this.doFileLoad(this.file, "recipe_machines.yml");
        YamlConfiguration simpleMachines = this.doFileLoad(this.file, "simple_machines.yml");
        YamlConfiguration multiBlockMachines = this.doFileLoad(this.file, "mb_machines.yml");
        YamlConfiguration supers = this.doFileLoad(this.file, "supers.yml");
        YamlConfiguration templateMachines = this.doFileLoad(this.file, "template_machines.yml");
        YamlConfiguration linkedRecipeMachines = this.doFileLoad(this.file, "linked_recipe_machines.yml");
        YamlConfiguration workbenches = this.doFileLoad(this.file, "workbenches.yml");
        MobDropsReader mobDropsReader = new MobDropsReader(mob_drops, addon);
        GeoResourceReader resourceReader = new GeoResourceReader(geo_resources, addon);
        ItemReader itemReader = new ItemReader(items, addon);
        ArmorReader armorReader = new ArmorReader(armors, addon);
        CapacitorsReader capacitorsReader = new CapacitorsReader(capacitors, addon);
        FoodReader foodReader = new FoodReader(foods, addon);
        MenuReader menuReader = new MenuReader(menus, addon);
        MachineReader machineReader = new MachineReader(machines, addon);
        GeneratorReader generatorReader = new GeneratorReader(generators, addon);
        SolarGeneratorReader solarGeneratorReader = new SolarGeneratorReader(solarGenerators, addon);
        MaterialGeneratorReader materialGeneratorReader = new MaterialGeneratorReader(materialGenerators, addon);
        RecipeMachineReader recipeMachineReader = new RecipeMachineReader(recipeMachines, addon);
        SimpleMachineReader simpleMachineReader = new SimpleMachineReader(simpleMachines, addon);
        MultiBlockMachineReader multiBlockMachineReader = new MultiBlockMachineReader(multiBlockMachines, addon);
        SuperReader superReader = new SuperReader(supers, addon);
        TemplateMachineReader templateMachineReader = new TemplateMachineReader(templateMachines, addon);
        LinkedRecipeMachineReader linkedRecipeMachineReader = new LinkedRecipeMachineReader(linkedRecipeMachines, addon);
        WorkbenchReader workbenchReader = new WorkbenchReader(workbenches, addon);
        ExceptionHandler.debugLog("Start preloading items from addon " + addon.getAddonId() + "...");
        mobDropsReader.preload();
        resourceReader.preload();
        itemReader.preload();
        armorReader.preload();
        capacitorsReader.preload();
        foodReader.preload();
        machineReader.preload();
        generatorReader.preload();
        solarGeneratorReader.preload();
        materialGeneratorReader.preload();
        recipeMachineReader.preload();
        simpleMachineReader.preload();
        multiBlockMachineReader.preload();
        superReader.preload();
        templateMachineReader.preload();
        linkedRecipeMachineReader.preload();
        workbenchReader.preload();
        ExceptionHandler.debugLog("Start registering contents from addon " + addon.getAddonId() + "...");
        addon.setMobDrops(mobDropsReader.readAll());
        addon.setGeoResources(resourceReader.readAll());
        addon.setItems(itemReader.readAll());
        addon.setArmors(armorReader.readAll());
        addon.setCapacitors(capacitorsReader.readAll());
        addon.setFoods(foodReader.readAll());
        addon.setMenus(menuReader.readAll());
        addon.setMachines(machineReader.readAll());
        addon.setGenerators(generatorReader.readAll());
        addon.setSolarGenerators(solarGeneratorReader.readAll());
        addon.setMaterialGenerators(materialGeneratorReader.readAll());
        addon.setRecipeMachines(recipeMachineReader.readAll());
        addon.setSimpleMachines(simpleMachineReader.readAll());
        addon.setMultiBlockMachines(multiBlockMachineReader.readAll());
        addon.setSupers(superReader.readAll());
        addon.setTemplateMachines(templateMachineReader.readAll());
        addon.setLinkedRecipeMachines(linkedRecipeMachineReader.readAll());
        addon.setWorkbenches(workbenchReader.readAll());
        ExceptionHandler.debugLog("Start late init contents from addon " + addon.getAddonId() + "...");
        addon.getMobDrops().addAll(mobDropsReader.loadLateInits());
        addon.getGeoResources().addAll(resourceReader.loadLateInits());
        addon.getItems().addAll(itemReader.loadLateInits());
        addon.getArmors().addAll(armorReader.loadLateInits());
        addon.getCapacitors().addAll(capacitorsReader.loadLateInits());
        addon.getFoods().addAll(foodReader.loadLateInits());
        addon.getMenus().addAll(menuReader.loadLateInits());
        addon.getMachines().addAll(machineReader.loadLateInits());
        addon.getGenerators().addAll(generatorReader.loadLateInits());
        addon.getSolarGenerators().addAll(solarGeneratorReader.loadLateInits());
        addon.getMaterialGenerators().addAll(materialGeneratorReader.loadLateInits());
        addon.getRecipeMachines().addAll(recipeMachineReader.loadLateInits());
        addon.getSimpleMachines().addAll(simpleMachineReader.loadLateInits());
        addon.getMultiBlockMachines().addAll(multiBlockMachineReader.loadLateInits());
        addon.getSupers().addAll(superReader.loadLateInits());
        addon.getTemplateMachines().addAll(templateMachineReader.loadLateInits());
        addon.getLinkedRecipeMachines().addAll(linkedRecipeMachineReader.loadLateInits());
        addon.getWorkbenches().addAll(workbenchReader.loadLateInits());
        YamlConfiguration researches = this.doFileLoad(this.file, "researches.yml");
        ResearchReader researchReader = new ResearchReader(researches, addon);
        List<Research> researchesList = researchReader.readAll();
        researchesList.addAll(researchReader.loadLateInits());
        addon.setResearches(researchesList);
        ExceptionHandler.debugLog("Loaded addon " + addon.getAddonId() + " successfully!");
        return addon;
    }

    private boolean loadDependencies(List<String> depends) {
        for (String dependency : depends) {
            if (RykenSlimefunCustomizer.addonManager.isLoaded(dependency)) continue;
            if (this.ids.containsKey(dependency)) {
                File dependencyFile = this.ids.get(dependency);
                ProjectAddonLoader loader = new ProjectAddonLoader(dependencyFile, this.ids);
                ProjectAddon addon = loader.load();
                if (addon == null) continue;
                addon.setMarkAsDepend(true);
                RykenSlimefunCustomizer.addonManager.pushProjectAddon(addon);
                continue;
            }
            return false;
        }
        return true;
    }

    private YamlConfiguration doFileLoad(File dir, String file) {
        File dest = new File(dir, file);
        if (!dest.exists()) {
            return new YamlConfiguration();
        }
        return YamlConfiguration.loadConfiguration((File)dest);
    }
}

