/*
 * Decompiled with CFR 0.152.
 */
package org.lins.mmmjjkx.rykenslimefuncustomizer;

import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.lins.mmmjjkx.rykenslimefuncustomizer.RykenSlimefunCustomizer;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.ProjectAddon;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.ProjectAddonLoader;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.global.RecipeTypeMap;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.ExceptionHandler;

public final class ProjectAddonManager {
    public static File ADDONS_DIRECTORY;
    public static File CONFIGS_DIRECTORY;
    private final Map<String, ProjectAddon> projectAddons = new HashMap<String, ProjectAddon>();
    private final Map<String, File> projectIds = new HashMap<String, File>();

    public ProjectAddonManager() {
        ADDONS_DIRECTORY = new File(RykenSlimefunCustomizer.INSTANCE.getDataFolder(), "addons");
        CONFIGS_DIRECTORY = new File(RykenSlimefunCustomizer.INSTANCE.getDataFolder(), "addon_configs");
        if (!CONFIGS_DIRECTORY.exists()) {
            CONFIGS_DIRECTORY.mkdirs();
        }
    }

    public void pushProjectAddon(ProjectAddon addon) {
        Validate.notNull((Object)addon, (String)"addon");
        if (!this.projectAddons.containsKey(addon.getAddonId())) {
            this.projectIds.put(addon.getAddonId(), addon.getFolder());
            this.projectAddons.put(addon.getAddonId(), addon);
        }
    }

    public void removeProjectAddon(ProjectAddon addon) {
        Validate.notNull((Object)addon, (String)"addon");
        this.projectIds.remove(addon.getAddonId());
        this.projectAddons.remove(addon.getAddonId());
    }

    public void setup(Plugin inst) {
        ProjectAddon addon;
        File addons = new File(inst.getDataFolder(), "addons");
        if (!addons.exists()) {
            addons.mkdirs();
            return;
        }
        File[] folders = addons.listFiles();
        if (folders == null) {
            return;
        }
        ArrayList<String> skip = new ArrayList<String>();
        for (File folder : folders) {
            File info = new File(folder, "info.yml");
            if (!info.exists()) {
                ExceptionHandler.handleError("A folder called " + folder.getName() + " contains invalid addon information\uff0cThe addon will not be loaded\uff01");
                skip.add(folder.getName());
                continue;
            }
            YamlConfiguration infoConfig = YamlConfiguration.loadConfiguration((File)info);
            String id = infoConfig.getString("id");
            if (id == null || id.isBlank()) {
                ExceptionHandler.handleError("A folder called " + folder.getName() + " contains invalid addon information that does not have an ID\uff0cThe addon will not be loaded\uff01");
                skip.add(folder.getName());
                continue;
            }
            if (this.projectIds.containsKey(id)) {
                addon = this.projectAddons.get(id);
                if (addon == null) {
                    ExceptionHandler.handleError("Cannot load addon with ID " + id + " normally! Please check the addon's configuration file\uff01");
                    continue;
                }
                if (addon.isMarkAsDepend()) continue;
                ExceptionHandler.handleError("A folder called " + folder.getName() + "has the same ID with " + addon.getFolder().getName() + "\uff0cThe addon will not be loaded\uff01");
                skip.add(folder.getName());
                continue;
            }
            this.projectIds.put(id, folder);
        }
        for (File folder : folders) {
            ProjectAddonLoader loader;
            YamlConfiguration infoConfig;
            String id;
            if (skip.contains(folder.getName()) || this.projectAddons.containsKey(id = (infoConfig = YamlConfiguration.loadConfiguration((File)new File(folder, "info.yml"))).getString("id")) || (addon = (loader = new ProjectAddonLoader(folder, this.projectIds)).load()) == null) continue;
            this.projectAddons.put(addon.getAddonId(), addon);
        }
    }

    public void reload(Plugin plugin) {
        for (ProjectAddon addon : this.projectAddons.values()) {
            addon.unregister();
        }
        this.projectAddons.clear();
        this.projectIds.clear();
        RecipeTypeMap.clearRecipeTypes();
        this.setup(plugin);
    }

    public boolean isLoaded(String id) {
        return this.projectAddons.containsKey(id);
    }

    public boolean isLoaded(String ... ids) {
        for (String id : ids) {
            if (this.isLoaded(id)) continue;
            return false;
        }
        return true;
    }

    public ProjectAddon get(String id) {
        return this.projectAddons.get(id);
    }

    public List<ProjectAddon> getAllValues() {
        return new ArrayList<ProjectAddon>(this.projectAddons.values());
    }

    public File getAddonFolder(String id) {
        return this.projectIds.get(id);
    }

    @Generated
    public Map<String, File> getProjectIds() {
        return this.projectIds;
    }
}

