/*
 * Decompiled with CFR 0.152.
 */
package org.lins.mmmjjkx.rykenslimefuncustomizer.utils;

import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.AxolotlBucketMeta;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockDataMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.BundleMeta;
import org.bukkit.inventory.meta.CompassMeta;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.KnowledgeBookMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.Repairable;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.SuspiciousStewMeta;
import org.bukkit.inventory.meta.TropicalFishBucketMeta;

public final class StackUtils {
    @Nonnull
    public static ItemStack getAsQuantity(@Nullable ItemStack itemStack, int amount) {
        if (itemStack == null) {
            return new ItemStack(Material.AIR);
        }
        ItemStack clone = itemStack.clone();
        clone.setAmount(amount);
        return clone;
    }

    public static boolean itemsMatch(@Nonnull ItemStack cache, @Nullable ItemStack itemStack) {
        return StackUtils.itemsMatch(cache, itemStack, false, false, false);
    }

    public static boolean itemsMatch(@Nonnull ItemStack cache, @Nullable ItemStack itemStack, boolean checkLore) {
        return StackUtils.itemsMatch(cache, itemStack, checkLore, false, false);
    }

    public static boolean itemsMatch(@Nonnull ItemStack cache, @Nullable ItemStack itemStack, boolean checkLore, boolean checkAmount) {
        return StackUtils.itemsMatch(cache, itemStack, checkLore, checkAmount, false);
    }

    public static boolean itemsMatch(@Nonnull ItemStack cache, @Nullable ItemStack itemStack, boolean checkLore, boolean checkAmount, boolean checkCustomModelId) {
        if (cache == null || itemStack == null) {
            return itemStack == null && itemStack == null;
        }
        if (itemStack.getType() != cache.getType()) {
            return false;
        }
        if (Tag.SHULKER_BOXES.isTagged((Keyed)itemStack.getType())) {
            return false;
        }
        if (itemStack.getType() == Material.BUNDLE) {
            return false;
        }
        if (checkAmount && itemStack.getAmount() > cache.getAmount()) {
            return false;
        }
        if (!itemStack.hasItemMeta() || !cache.hasItemMeta()) {
            return itemStack.hasItemMeta() == cache.hasItemMeta();
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        ItemMeta cachedMeta = cache.getItemMeta();
        if (itemMeta == null || cachedMeta == null) {
            return itemMeta == cachedMeta;
        }
        if (!itemMeta.getClass().equals(cachedMeta.getClass())) {
            return false;
        }
        if (StackUtils.canQuickEscapeMetaVariant(itemMeta, cachedMeta)) {
            return false;
        }
        if (itemMeta.hasDisplayName() != cachedMeta.hasDisplayName()) {
            return false;
        }
        if (checkCustomModelId) {
            boolean hasCustomOne = itemMeta.hasCustomModelData();
            boolean hasCustomTwo = cachedMeta.hasCustomModelData();
            if (hasCustomOne ? !hasCustomTwo || itemMeta.getCustomModelData() != cachedMeta.getCustomModelData() : hasCustomTwo) {
                return false;
            }
        }
        if (!itemMeta.getPersistentDataContainer().equals(cachedMeta.getPersistentDataContainer())) {
            return false;
        }
        if (!itemMeta.getEnchants().equals(cachedMeta.getEnchants())) {
            return false;
        }
        if (!itemMeta.getItemFlags().equals(cachedMeta.getItemFlags())) {
            return false;
        }
        boolean hasAttributeOne = itemMeta.hasAttributeModifiers();
        boolean hasAttributeTwo = cachedMeta.hasAttributeModifiers();
        if (hasAttributeOne ? !hasAttributeTwo || !Objects.equals(itemMeta.getAttributeModifiers(), cachedMeta.getAttributeModifiers()) : hasAttributeTwo) {
            return false;
        }
        if ((checkLore || itemStack.getType() == Material.PLAYER_HEAD || itemStack.getType() == Material.SPAWNER || itemStack.getType() == Material.SUGAR) && (itemMeta.hasLore() && cachedMeta.hasLore() ? !Objects.equals(itemMeta.getLore(), cachedMeta.getLore()) : itemMeta.hasLore() != cachedMeta.hasLore())) {
            return false;
        }
        Optional optionalStackId1 = Slimefun.getItemDataService().getItemData(itemMeta);
        Optional optionalStackId2 = Slimefun.getItemDataService().getItemData(cachedMeta);
        if (optionalStackId1.isPresent() != optionalStackId2.isPresent()) {
            return false;
        }
        if (optionalStackId1.isPresent()) {
            return ((String)optionalStackId1.get()).equals(optionalStackId2.get());
        }
        return !itemMeta.hasDisplayName() || Objects.equals(itemMeta.getDisplayName(), cachedMeta.getDisplayName());
    }

    public static boolean canQuickEscapeMetaVariant(@Nonnull ItemMeta metaOne, @Nonnull ItemMeta metaTwo) {
        Damageable instanceTwo;
        Damageable instanceOne;
        if (metaOne instanceof Damageable) {
            instanceOne = (Damageable)metaOne;
            if (metaTwo instanceof Damageable) {
                instanceTwo = (Damageable)metaTwo;
                if (instanceOne.hasDamage() != instanceTwo.hasDamage()) {
                    return true;
                }
                if (instanceOne.getDamage() != instanceTwo.getDamage()) {
                    return true;
                }
            }
        }
        if (metaOne instanceof Repairable) {
            instanceOne = (Repairable)metaOne;
            if (metaTwo instanceof Repairable) {
                instanceTwo = (Repairable)metaTwo;
                if (instanceOne.hasRepairCost() != instanceTwo.hasRepairCost()) {
                    return true;
                }
                if (instanceOne.getRepairCost() != instanceTwo.getRepairCost()) {
                    return true;
                }
            }
        }
        if (metaOne instanceof AxolotlBucketMeta) {
            instanceOne = (AxolotlBucketMeta)metaOne;
            if (metaTwo instanceof AxolotlBucketMeta) {
                instanceTwo = (AxolotlBucketMeta)metaTwo;
                if (instanceOne.hasVariant() != instanceTwo.hasVariant()) {
                    return true;
                }
                if (!instanceOne.hasVariant() || !instanceTwo.hasVariant()) {
                    return true;
                }
                if (instanceOne.getVariant() != instanceTwo.getVariant()) {
                    return true;
                }
            }
        }
        if (metaOne instanceof BannerMeta) {
            instanceOne = (BannerMeta)metaOne;
            if (metaTwo instanceof BannerMeta) {
                instanceTwo = (BannerMeta)metaTwo;
                if (instanceOne.numberOfPatterns() != instanceTwo.numberOfPatterns()) {
                    return true;
                }
                if (!instanceOne.getPatterns().equals(instanceTwo.getPatterns())) {
                    return true;
                }
            }
        }
        if (metaOne instanceof BlockDataMeta) {
            instanceOne = (BlockDataMeta)metaOne;
            if (metaTwo instanceof BlockDataMeta) {
                instanceTwo = (BlockDataMeta)metaTwo;
                if (instanceOne.hasBlockData() != instanceTwo.hasBlockData()) {
                    return true;
                }
            }
        }
        if (metaOne instanceof BlockStateMeta) {
            instanceOne = (BlockStateMeta)metaOne;
            if (metaTwo instanceof BlockStateMeta) {
                instanceTwo = (BlockStateMeta)metaTwo;
                if (instanceOne.hasBlockState() != instanceTwo.hasBlockState()) {
                    return true;
                }
                if (!instanceOne.getBlockState().equals(instanceTwo.getBlockState())) {
                    return true;
                }
            }
        }
        if (metaOne instanceof BookMeta) {
            instanceOne = (BookMeta)metaOne;
            if (metaTwo instanceof BookMeta) {
                instanceTwo = (BookMeta)metaTwo;
                if (instanceOne.getPageCount() != instanceTwo.getPageCount()) {
                    return true;
                }
                if (!Objects.equals(instanceOne.getAuthor(), instanceTwo.getAuthor())) {
                    return true;
                }
                if (!Objects.equals(instanceOne.getTitle(), instanceTwo.getTitle())) {
                    return true;
                }
                if (!Objects.equals(instanceOne.getGeneration(), instanceTwo.getGeneration())) {
                    return true;
                }
            }
        }
        if (metaOne instanceof BundleMeta) {
            instanceOne = (BundleMeta)metaOne;
            if (metaTwo instanceof BundleMeta) {
                instanceTwo = (BundleMeta)metaTwo;
                if (instanceOne.hasItems() != instanceTwo.hasItems()) {
                    return true;
                }
                if (!instanceOne.getItems().equals(instanceTwo.getItems())) {
                    return true;
                }
            }
        }
        if (metaOne instanceof CompassMeta) {
            instanceOne = (CompassMeta)metaOne;
            if (metaTwo instanceof CompassMeta) {
                instanceTwo = (CompassMeta)metaTwo;
                if (instanceOne.isLodestoneTracked() != instanceTwo.isLodestoneTracked()) {
                    return true;
                }
                if (!Objects.equals(instanceOne.getLodestone(), instanceTwo.getLodestone())) {
                    return true;
                }
            }
        }
        if (metaOne instanceof CrossbowMeta) {
            instanceOne = (CrossbowMeta)metaOne;
            if (metaTwo instanceof CrossbowMeta) {
                instanceTwo = (CrossbowMeta)metaTwo;
                if (instanceOne.hasChargedProjectiles() != instanceTwo.hasChargedProjectiles()) {
                    return true;
                }
                if (!instanceOne.getChargedProjectiles().equals(instanceTwo.getChargedProjectiles())) {
                    return true;
                }
            }
        }
        if (metaOne instanceof EnchantmentStorageMeta) {
            instanceOne = (EnchantmentStorageMeta)metaOne;
            if (metaTwo instanceof EnchantmentStorageMeta) {
                instanceTwo = (EnchantmentStorageMeta)metaTwo;
                if (instanceOne.hasStoredEnchants() != instanceTwo.hasStoredEnchants()) {
                    return true;
                }
                if (!instanceOne.getStoredEnchants().equals(instanceTwo.getStoredEnchants())) {
                    return true;
                }
            }
        }
        if (metaOne instanceof FireworkEffectMeta) {
            instanceOne = (FireworkEffectMeta)metaOne;
            if (metaTwo instanceof FireworkEffectMeta) {
                instanceTwo = (FireworkEffectMeta)metaTwo;
                if (!Objects.equals(instanceOne.getEffect(), instanceTwo.getEffect())) {
                    return true;
                }
            }
        }
        if (metaOne instanceof FireworkMeta) {
            instanceOne = (FireworkMeta)metaOne;
            if (metaTwo instanceof FireworkMeta) {
                instanceTwo = (FireworkMeta)metaTwo;
                if (instanceOne.getPower() != instanceTwo.getPower()) {
                    return true;
                }
                if (!instanceOne.getEffects().equals(instanceTwo.getEffects())) {
                    return true;
                }
            }
        }
        if (metaOne instanceof LeatherArmorMeta) {
            instanceOne = (LeatherArmorMeta)metaOne;
            if (metaTwo instanceof LeatherArmorMeta) {
                instanceTwo = (LeatherArmorMeta)metaTwo;
                if (!instanceOne.getColor().equals((Object)instanceTwo.getColor())) {
                    return true;
                }
            }
        }
        if (metaOne instanceof MapMeta) {
            instanceOne = (MapMeta)metaOne;
            if (metaTwo instanceof MapMeta) {
                instanceTwo = (MapMeta)metaTwo;
                if (instanceOne.hasMapView() != instanceTwo.hasMapView()) {
                    return true;
                }
                if (instanceOne.hasLocationName() != instanceTwo.hasLocationName()) {
                    return true;
                }
                if (instanceOne.hasColor() != instanceTwo.hasColor()) {
                    return true;
                }
                if (!Objects.equals(instanceOne.getMapView(), instanceTwo.getMapView())) {
                    return true;
                }
                if (!Objects.equals(instanceOne.getLocationName(), instanceTwo.getLocationName())) {
                    return true;
                }
                if (!Objects.equals(instanceOne.getColor(), instanceTwo.getColor())) {
                    return true;
                }
            }
        }
        if (metaOne instanceof PotionMeta) {
            instanceOne = (PotionMeta)metaOne;
            if (metaTwo instanceof PotionMeta) {
                instanceTwo = (PotionMeta)metaTwo;
                if (!Objects.equals(instanceOne.getBasePotionData(), instanceTwo.getBasePotionData())) {
                    return true;
                }
                if (instanceOne.hasCustomEffects() != instanceTwo.hasCustomEffects()) {
                    return true;
                }
                if (instanceOne.hasColor() != instanceTwo.hasColor()) {
                    return true;
                }
                if (!Objects.equals(instanceOne.getColor(), instanceTwo.getColor())) {
                    return true;
                }
                if (!instanceOne.getCustomEffects().equals(instanceTwo.getCustomEffects())) {
                    return true;
                }
            }
        }
        if (metaOne instanceof SkullMeta) {
            instanceOne = (SkullMeta)metaOne;
            if (metaTwo instanceof SkullMeta) {
                instanceTwo = (SkullMeta)metaTwo;
                if (instanceOne.hasOwner() != instanceTwo.hasOwner()) {
                    return true;
                }
                if (!Objects.equals(instanceOne.getOwningPlayer(), instanceTwo.getOwningPlayer())) {
                    return true;
                }
            }
        }
        if (metaOne instanceof SuspiciousStewMeta) {
            instanceOne = (SuspiciousStewMeta)metaOne;
            if (metaTwo instanceof SuspiciousStewMeta) {
                instanceTwo = (SuspiciousStewMeta)metaTwo;
                if (instanceOne.hasCustomEffects() != instanceTwo.hasCustomEffects()) {
                    return true;
                }
                if (!Objects.equals(instanceOne.getCustomEffects(), instanceTwo.getCustomEffects())) {
                    return true;
                }
            }
        }
        if (metaOne instanceof TropicalFishBucketMeta) {
            instanceOne = (TropicalFishBucketMeta)metaOne;
            if (metaTwo instanceof TropicalFishBucketMeta) {
                instanceTwo = (TropicalFishBucketMeta)metaTwo;
                if (instanceOne.hasVariant() != instanceTwo.hasVariant()) {
                    return true;
                }
                if (!instanceOne.getPattern().equals((Object)instanceTwo.getPattern())) {
                    return true;
                }
                if (!instanceOne.getBodyColor().equals((Object)instanceTwo.getBodyColor())) {
                    return true;
                }
                if (!instanceOne.getPatternColor().equals((Object)instanceTwo.getPatternColor())) {
                    return true;
                }
            }
        }
        if (metaOne instanceof KnowledgeBookMeta) {
            instanceOne = (KnowledgeBookMeta)metaOne;
            if (metaTwo instanceof KnowledgeBookMeta) {
                instanceTwo = (KnowledgeBookMeta)metaTwo;
                if (instanceOne.hasRecipes() != instanceTwo.hasRecipes()) {
                    return true;
                }
                if (!Objects.equals(instanceOne.getRecipes(), instanceTwo.getRecipes())) {
                    return true;
                }
            }
        }
        return false;
    }

    @Generated
    private StackUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

