/*
 * Decompiled with CFR 0.152.
 */
package org.lins.mmmjjkx.rykenslimefuncustomizer.objects.yaml.item;

import io.github.thebusybiscuit.slimefun4.api.geo.GEOResource;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.Pair;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.ProjectAddon;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.item.CustomGeoResource;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.global.DropFromBlock;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.yaml.YamlReader;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.CommonUtils;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.ExceptionHandler;

public class GeoResourceReader
extends YamlReader<GEOResource> {
    public GeoResourceReader(YamlConfiguration config, ProjectAddon addon) {
        super(config, addon);
    }

    @Override
    public GEOResource readEach(String s) {
        ConfigurationSection section = this.configuration.getConfigurationSection(s);
        if (section != null) {
            String id = section.getString("id_alias", s).toUpperCase();
            ExceptionHandler.HandleResult result = ExceptionHandler.handleIdConflict(id);
            if (result == ExceptionHandler.HandleResult.FAILED) {
                return null;
            }
            String igId = section.getString("item_group");
            Pair<ExceptionHandler.HandleResult, ItemGroup> group = ExceptionHandler.handleItemGroupGet(this.addon, igId);
            if (group.getFirstValue() == ExceptionHandler.HandleResult.FAILED) {
                return null;
            }
            SlimefunItemStack sfis = this.getPreloadItem(id);
            if (sfis == null) {
                return null;
            }
            ItemStack[] recipe = CommonUtils.readRecipe(section.getConfigurationSection("recipe"), this.addon);
            String recipeType = section.getString("recipe_type", "NULL");
            int maxDeviation = section.getInt("max_deviation", 1);
            boolean obtainableFromGEOMiner = section.getBoolean("obtain_from_geo_miner", true);
            String name = section.getString("geo_name", "");
            Pair<ExceptionHandler.HandleResult, RecipeType> rt = ExceptionHandler.getRecipeType("Found an error while loading the geo resource " + s + " in addon " + this.addon.getAddonId() + ": Invalid recipe type '" + recipeType + "'!", recipeType);
            if (rt.getFirstValue() == ExceptionHandler.HandleResult.FAILED) {
                return null;
            }
            ConfigurationSection sup = section.getConfigurationSection("supply");
            BiFunction<World.Environment, Biome, Integer> supply = (e, b) -> {
                if (sup == null) {
                    return 0;
                }
                if (e == World.Environment.CUSTOM) {
                    return 0;
                }
                String env = e.toString().toLowerCase();
                String path = b.toString().toLowerCase();
                boolean isSection = sup.isConfigurationSection(env);
                if (!isSection) {
                    return sup.getInt(env, 0);
                }
                ConfigurationSection biomes = sup.getConfigurationSection(env);
                if (biomes == null) {
                    return 0;
                }
                if (biomes.contains(path)) {
                    return biomes.getInt(path, 0);
                }
                return biomes.getInt("others", 0);
            };
            if (section.contains("drop_from")) {
                String dropMaterial;
                Optional<Material> xm;
                int amount;
                int chance = section.getInt("drop_chance", 100);
                int n = amount = section.isInt("drop_amount") ? section.getInt("drop_amount", 1) : -1;
                if (chance < 0 || chance > 100) {
                    ExceptionHandler.handleError("Found an error while loading the geo resource " + s + " in addon " + this.addon.getAddonId() + ": Drop chance must be between 0 and 100! Using 100 instead.");
                    chance = 100;
                }
                if ((xm = Optional.ofNullable(Material.matchMaterial((String)(dropMaterial = section.getString("drop_from", ""))))).isPresent()) {
                    Material material = xm.get();
                    if (amount == -1) {
                        String between = section.getString("drop_amount", "1");
                        if (between.contains("-")) {
                            String[] split = between.split("-");
                            if (split.length == 2) {
                                int min = Integer.parseInt(split[0]);
                                int max = Integer.parseInt(split[1]);
                                DropFromBlock.addDrop(material, new DropFromBlock.Drop((ItemStack)sfis, chance, this.addon, min, max));
                            } else {
                                ExceptionHandler.handleError("Found an error while loading the geo resource " + s + " in addon " + this.addon.getAddonId() + ": Invalid drop amount range format! The amount will using 1 instead.");
                                DropFromBlock.addDrop(material, new DropFromBlock.Drop((ItemStack)sfis, chance, this.addon));
                            }
                        }
                    } else {
                        DropFromBlock.addDrop(material, new DropFromBlock.Drop((ItemStack)sfis, chance, this.addon, amount, amount));
                    }
                } else {
                    ExceptionHandler.handleError("\u5728\u9644\u5c5e" + this.addon.getAddonId() + "\u4e2d\u52a0\u8f7d\u81ea\u7136\u8d44\u6e90" + s + "\u65f6\u9047\u5230\u4e86\u95ee\u9898: \u6307\u5b9a\u6389\u843d\u65b9\u5757\u6750\u6599\u7c7b\u578b" + dropMaterial + "\u4e0d\u5b58\u5728!");
                }
            }
            if (recipe == null) {
                recipe = new ItemStack[9];
            }
            return new CustomGeoResource((ItemGroup)group.getSecondValue(), sfis, (RecipeType)rt.getSecondValue(), recipe, supply, maxDeviation, obtainableFromGEOMiner, name);
        }
        return null;
    }

    @Override
    public List<SlimefunItemStack> preloadItems(String id) {
        ConfigurationSection section = this.configuration.getConfigurationSection(id);
        if (section == null) {
            return null;
        }
        ConfigurationSection item = section.getConfigurationSection("item");
        ItemStack stack = CommonUtils.readItem(item, false, this.addon);
        if (stack == null) {
            ExceptionHandler.handleError("Found an error while loading geo resource " + id + " in addon " + this.addon.getAddonId() + ": The item is null or has an invalid format");
            return null;
        }
        return List.of(new SlimefunItemStack(section.getString("id_alias", id).toUpperCase(), stack));
    }

    @Deprecated
    private GEOResource createGEO(final BiFunction<World.Environment, Biome, Integer> supply, final int maxDeviation, final boolean obtainableFromGEOMiner, final String name, final SlimefunItemStack item, final NamespacedKey key) {
        return new GEOResource(){

            public int getDefaultSupply(@NotNull World.Environment environment, @NotNull Biome biome) {
                return (Integer)supply.apply(environment, biome);
            }

            public int getMaxDeviation() {
                return maxDeviation;
            }

            @NotNull
            public String getName() {
                return name;
            }

            @NotNull
            public ItemStack getItem() {
                return item;
            }

            public boolean isObtainableFromGEOMiner() {
                return obtainableFromGEOMiner;
            }

            @NotNull
            public NamespacedKey getKey() {
                return key;
            }
        };
    }
}

