/*
 * Decompiled with CFR 0.152.
 */
package org.lins.mmmjjkx.rykenslimefuncustomizer.libraries.colors;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.bukkit.ChatColor;
import org.lins.mmmjjkx.rykenslimefuncustomizer.libraries.colors.CMICustomColors;
import org.lins.mmmjjkx.rykenslimefuncustomizer.libraries.version.Version;

public class CMIChatColor {
    private static final Map<Character, CMIChatColor> BY_CHAR = new HashMap<Character, CMIChatColor>();
    private static final Map<String, CMIChatColor> BY_NAME = new HashMap<String, CMIChatColor>();
    private static final LinkedHashMap<String, CMIChatColor> CUSTOM_BY_NAME = new LinkedHashMap();
    private static final Map<String, CMIChatColor> CUSTOM_BY_HEX = new HashMap<String, CMIChatColor>();
    private static final TreeMap<String, CMIChatColor> CUSTOM_BY_RGB = new TreeMap();
    public static final String colorReplacerPlaceholder = "\uff06";
    public static final String hexSymbol = "#";
    public static final String colorHexReplacerPlaceholder = "{\uff06#";
    public static final String colorFontPrefix = "{@";
    public static final String colorCodePrefix = "{#";
    public static final String colorCodeSuffix = "}";
    public static final String hexColorRegex = "(\\{#)([0-9A-Fa-f]{6}|[0-9A-Fa-f]{3})(\\})";
    public static final Pattern cleanOfficialColorRegexPattern;
    public static final Pattern cleanQuirkyHexColorRegexPattern;
    public static final Pattern hexColorRegexPattern;
    public static final Pattern hexColorRegexPatternLast;
    public static final Pattern hexDeColorNamePattern;
    public static final String ColorNameRegex = "(\\{#)([a-zA-Z_]{3,})(\\})";
    public static final Pattern hexColorNamePattern;
    public static final Pattern hexColorNamePatternLast;
    public static final String ColorFontRegex = "(\\{@)([a-zA-Z_]{3,})(\\})";
    public static final Pattern gradientPattern;
    public static final String hexColorDecolRegex = "(&x)(&[0-9A-Fa-f]){6}";
    public static final Pattern postGradientPattern;
    public static final Pattern post2GradientPattern;
    public static final Pattern fullPattern;
    public static final Pattern formatPattern;
    public static final CMIChatColor BLACK;
    public static final CMIChatColor DARK_BLUE;
    public static final CMIChatColor DARK_GREEN;
    public static final CMIChatColor DARK_AQUA;
    public static final CMIChatColor DARK_RED;
    public static final CMIChatColor DARK_PURPLE;
    public static final CMIChatColor GOLD;
    public static final CMIChatColor GRAY;
    public static final CMIChatColor DARK_GRAY;
    public static final CMIChatColor BLUE;
    public static final CMIChatColor GREEN;
    public static final CMIChatColor AQUA;
    public static final CMIChatColor RED;
    public static final CMIChatColor LIGHT_PURPLE;
    public static final CMIChatColor YELLOW;
    public static final CMIChatColor WHITE;
    public static final CMIChatColor OBFUSCATED;
    public static final CMIChatColor BOLD;
    public static final CMIChatColor STRIKETHROUGH;
    public static final CMIChatColor UNDERLINE;
    public static final CMIChatColor ITALIC;
    public static final CMIChatColor RESET;
    public static final CMIChatColor HEX;
    private char c = (char)10;
    private boolean colorable = true;
    private boolean isReset = false;
    private Pattern pattern = null;
    private int redChannel = -1;
    private int greenChannel = -1;
    private int blueChannel = -1;
    private String hexCode = null;
    private String name;

    private static String charEscape(String s) {
        StringBuilder sb = new StringBuilder();
        block10: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '/': {
                    sb.append("/");
                    continue block10;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        sb.append("0".repeat(4 - ss.length()));
                        sb.append(ss.toUpperCase());
                        continue block10;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    private static String escape(String text) {
        return text.replace(hexSymbol, "\\#").replace("{", "\\{").replace(colorCodeSuffix, "\\}");
    }

    public CMIChatColor(String name, char c, int red, int green, int blue) {
        this(name, c, true, false, red, green, blue);
    }

    public CMIChatColor(String hex) {
        this(null, hex);
    }

    public CMIChatColor(String name, String hex) {
        if (hex == null) {
            return;
        }
        if (hex.startsWith(colorCodePrefix)) {
            hex = hex.substring(colorCodePrefix.length());
        }
        if (hex.endsWith(colorCodeSuffix)) {
            hex = hex.substring(0, hex.length() - colorCodeSuffix.length());
        }
        if (hex.startsWith(hexSymbol)) {
            hex = hex.substring(1);
        }
        if (hex.length() == 3 || hex.length() == 6) {
            this.hexCode = hex;
        }
        this.name = name;
        try {
            if (this.hexCode != null) {
                this.redChannel = Integer.valueOf(this.hexCode.substring(0, 2), 16);
                this.greenChannel = Integer.valueOf(this.hexCode.substring(2, 4), 16);
                this.blueChannel = Integer.parseInt(this.hexCode.substring(4, 6), 16);
            }
        }
        catch (Throwable e) {
            this.redChannel = -1;
            this.greenChannel = -1;
            this.blueChannel = -1;
            this.hexCode = null;
        }
    }

    public CMIChatColor(String name, char c, Boolean color) {
        this(name, c, color, false);
    }

    public CMIChatColor(String name, char c, Boolean color, Boolean reset) {
        this(name, c, color, reset, -1, -1, -1);
    }

    public CMIChatColor(String name, char c, Boolean color, Boolean reset, int red, int green, int blue) {
        this.name = name;
        this.c = c;
        this.colorable = color;
        this.isReset = reset;
        this.pattern = Pattern.compile("(?i)(&[" + c + "])");
        this.redChannel = red;
        this.greenChannel = green;
        this.blueChannel = blue;
        BY_CHAR.put(Character.valueOf(c), this);
        BY_NAME.put(this.getName().toLowerCase().replace("_", ""), this);
    }

    public boolean isValid() {
        return this.c != '\n' || this.getHex() != null || this.name != null || this.blueChannel > -1 && this.greenChannel > -1 && this.redChannel > -1;
    }

    public static String processGradient(String text) {
        Matcher gradientMatch = gradientPattern.matcher(text);
        while (gradientMatch.find()) {
            String fullmatch = gradientMatch.group();
            CMIChatColor c1 = CMIChatColor.getColor(colorCodePrefix + gradientMatch.group(2).replace(hexSymbol, "") + colorCodeSuffix);
            CMIChatColor c2 = CMIChatColor.getColor(colorCodePrefix + gradientMatch.group(5).replace(hexSymbol, "") + colorCodeSuffix);
            if (c1 == null || c2 == null) continue;
            String gtext = gradientMatch.group(3);
            boolean continuous = !gradientMatch.group(6).isEmpty();
            StringBuilder updated = new StringBuilder();
            Set<CMIChatColor> formats = CMIChatColor.getFormats(gtext);
            gtext = CMIChatColor.stripColor(gtext);
            for (int i = 0; i < gtext.length(); ++i) {
                int codePoint;
                char ch = gtext.charAt(i);
                int length = gtext.length();
                length = Math.max(length, 2);
                double percent = (double)i * 100.0 / (double)(length - 1);
                CMIChatColor mix = CMIChatColor.mixColors(c1, c2, percent);
                updated.append(colorCodePrefix).append(mix.getHex()).append(colorCodeSuffix);
                if (!formats.isEmpty()) {
                    for (CMIChatColor one : formats) {
                        updated.append("&").append(one.getChar());
                    }
                }
                if ((codePoint = Character.codePointAt(gtext, i)) > 127) {
                    if (Character.isSurrogate(ch)) {
                        updated.append(ch).append(gtext.charAt(i + 1));
                        ++i;
                        continue;
                    }
                    updated.append(ch);
                    continue;
                }
                updated.append(ch);
            }
            if (continuous) {
                updated.append(colorCodePrefix).append(gradientMatch.group(5).replace(hexSymbol, "")).append(">").append(colorCodeSuffix);
            }
            text = text.replace(fullmatch, updated.toString());
            if (!continuous) continue;
            text = CMIChatColor.processGradient(text);
        }
        return text;
    }

    public static List<String> translate(List<String> lines) {
        lines.replaceAll(CMIChatColor::translate);
        return lines;
    }

    public static String translate(String text) {
        String shorten;
        StringBuilder magic;
        Object sb;
        String copy;
        String string;
        Matcher match;
        if (text == null) {
            return null;
        }
        if ((text = CMIChatColor.processGradient(text)).contains(colorCodePrefix)) {
            match = hexColorRegexPattern.matcher(text);
            while (match.find()) {
                string = match.group();
                if (Version.isCurrentLower(Version.v1_16_R1)) {
                    copy = string;
                    if ((copy = copy.substring(2, copy.length() - 1)).length() == 3) {
                        sb = new StringBuilder();
                        for (int i = 0; i < copy.length(); ++i) {
                            ((StringBuilder)sb).append(copy.charAt(i)).append(copy.charAt(i));
                        }
                        copy = ((StringBuilder)sb).toString();
                    }
                    copy = CMIChatColor.getClosestVanilla(copy);
                    text = text.replace(string, copy);
                    continue;
                }
                magic = new StringBuilder("\u00a7x");
                for (char c : string.substring(2, string.length() - 1).toCharArray()) {
                    magic.append('\u00a7').append(c);
                    if (string.substring(2, string.length() - 1).length() != 3) continue;
                    magic.append('\u00a7').append(c);
                }
                text = text.replace(string, magic.toString());
            }
            Matcher nameMatch = hexColorNamePattern.matcher(text);
            while (nameMatch.find()) {
                String string2 = nameMatch.group(2);
                CMIChatColor cn = CMIChatColor.getByCustomName(string2.toLowerCase().replace("_", ""));
                if (cn == null) continue;
                String gex = cn.getHex();
                StringBuilder magic2 = new StringBuilder("\u00a7x");
                for (char c : gex.toCharArray()) {
                    magic2.append('\u00a7').append(c);
                }
                text = text.replace(nameMatch.group(), magic2.toString());
            }
        }
        if (text.contains("&#")) {
            match = cleanQuirkyHexColorRegexPattern.matcher(text);
            while (match.find()) {
                string = match.group();
                if (Version.isCurrentLower(Version.v1_16_R1)) {
                    copy = string;
                    if ((copy = copy.substring(2)).length() == 3) {
                        sb = new StringBuilder();
                        for (int i = 0; i < copy.length(); ++i) {
                            ((StringBuilder)sb).append(copy.charAt(i)).append(copy.charAt(i));
                        }
                        copy = ((StringBuilder)sb).toString();
                    }
                    copy = CMIChatColor.getClosestVanilla(copy);
                    text = text.replace(string, copy);
                    continue;
                }
                magic = new StringBuilder("\u00a7x");
                shorten = string.substring(2);
                for (char c : shorten.toCharArray()) {
                    magic.append('\u00a7').append(c);
                    if (shorten.length() != 3) continue;
                    magic.append('\u00a7').append(c);
                }
                text = text.replace(string, magic.toString());
            }
        }
        if (text.contains(hexSymbol)) {
            match = cleanOfficialColorRegexPattern.matcher(text);
            while (match.find()) {
                string = match.group();
                if (Version.isCurrentLower(Version.v1_16_R1)) {
                    copy = string;
                    if ((copy = copy.substring(1)).length() == 3) {
                        sb = new StringBuilder();
                        for (int i = 0; i < copy.length(); ++i) {
                            ((StringBuilder)sb).append(copy.charAt(i)).append(copy.charAt(i));
                        }
                        copy = ((StringBuilder)sb).toString();
                    }
                    copy = CMIChatColor.getClosestVanilla(copy);
                    text = text.replace(string, copy);
                    continue;
                }
                magic = new StringBuilder("\u00a7x");
                shorten = string.substring(1);
                for (char c : shorten.toCharArray()) {
                    magic.append('\u00a7').append(c);
                    if (shorten.length() != 3) continue;
                    magic.append('\u00a7').append(c);
                }
                text = text.replace(string, magic.toString());
            }
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    public static String convertNamedHex(String text) {
        if (text == null) {
            return null;
        }
        if ((text = CMIChatColor.processGradient(text)).contains(colorCodePrefix)) {
            Matcher nameMatch = hexColorNamePattern.matcher(text);
            while (nameMatch.find()) {
                String string = nameMatch.group(2);
                CMIChatColor cn = CMIChatColor.getByCustomName(string.toLowerCase().replace("_", ""));
                if (cn == null) continue;
                String gex = cn.getHex();
                StringBuilder magic = new StringBuilder(colorCodePrefix);
                for (char c : gex.toCharArray()) {
                    magic.append('&').append(c);
                }
                magic.append(colorCodeSuffix);
                text = text.replace(nameMatch.group(), magic.toString());
            }
        }
        return text;
    }

    public static String applyEqualGradient(String text, List<CMIChatColor> gradients) {
        if (gradients == null || gradients.isEmpty()) {
            return text;
        }
        int size = text.length() / gradients.size();
        StringBuilder messageWithGradient = new StringBuilder();
        messageWithGradient.append(gradients.get(0).getFormatedHex(">"));
        for (int y = 0; y <= gradients.size() - 1; ++y) {
            if (y > 0 && size > 0) {
                messageWithGradient.append(gradients.get(y).getFormatedHex("<>"));
            }
            for (int i = 0; i < size; ++i) {
                messageWithGradient.append(text.charAt(0));
                text = text.substring(1);
            }
        }
        messageWithGradient.append(text).append(gradients.get(gradients.size() - 1).getFormatedHex("<"));
        return messageWithGradient.toString();
    }

    @Deprecated
    public static String translateAlternateColorCodes(String text) {
        return CMIChatColor.translate(text);
    }

    public static String colorize(String text) {
        if (text == null) {
            return null;
        }
        return CMIChatColor.translate(text);
    }

    public static String simpleFlaten(String text) {
        return text.replace("&", colorReplacerPlaceholder).replace(colorCodePrefix, colorHexReplacerPlaceholder);
    }

    public static String flaten(String text) {
        return CMIChatColor.flaten(text, true);
    }

    public static String flaten(String text, boolean colorizeBefore) {
        return CMIChatColor.deColorize(text, colorizeBefore).replace("&", colorReplacerPlaceholder).replace(colorCodePrefix, colorHexReplacerPlaceholder);
    }

    public static String deColorize(String text) {
        return CMIChatColor.deColorize(text, true);
    }

    public static String deColorize(String text, boolean colorizeBeforeDe) {
        if (text == null) {
            return null;
        }
        if (colorizeBeforeDe) {
            text = CMIChatColor.translate(text);
        }
        if ((text = text.replace("\u00a7", "&")).contains("&x")) {
            Matcher match = hexDeColorNamePattern.matcher(text);
            while (match.find()) {
                String reg = match.group(3).replace("&", "");
                CMIChatColor custom = CUSTOM_BY_HEX.get(reg.toLowerCase());
                if (custom != null) {
                    text = text.replace(match.group(), colorCodePrefix + custom.getName().toLowerCase().replace("_", "") + colorCodeSuffix);
                    continue;
                }
                text = text.replace(match.group(), colorCodePrefix + reg + colorCodeSuffix);
            }
        }
        return text;
    }

    public static List<String> deColorize(List<String> lore) {
        lore.replaceAll(CMIChatColor::deColorize);
        return lore;
    }

    public static String stripColor(String text) {
        if (text == null) {
            return null;
        }
        text = CMIChatColor.translate(text);
        return ChatColor.stripColor((String)text);
    }

    public static String stripHexColor(String message) {
        String string;
        message = CMIChatColor.translate(message);
        Matcher match = hexColorRegexPattern.matcher(message);
        while (match.find()) {
            string = match.group();
            message = message.replace(string, "");
        }
        if (message.contains("&x") || message.contains("\u00a7x")) {
            match = hexDeColorNamePattern.matcher(message);
            while (match.find()) {
                string = match.group();
                message = message.replace(string, "");
            }
        }
        return message;
    }

    public static String getLastColors(String text) {
        if (text == null) {
            return null;
        }
        Matcher match = hexColorRegexPatternLast.matcher(text = CMIChatColor.deColorize(text));
        if (match.find()) {
            String colorByHex = match.group(0);
            if (text.endsWith(colorByHex)) {
                return colorByHex;
            }
            String[] split = text.split(CMIChatColor.escape(colorByHex), 2);
            if (split.length < 2) {
                return colorByHex;
            }
            String last = CMIChatColor.getLastColors(split[1]);
            return last == null || last.isEmpty() ? colorByHex : last;
        }
        match = hexColorNamePatternLast.matcher(text);
        if (match.find()) {
            String colorByName = match.group();
            if (text.endsWith(colorByName)) {
                return colorByName;
            }
            String[] split = text.split(CMIChatColor.escape(colorByName), 2);
            if (split.length < 2) {
                return colorByName;
            }
            String last = CMIChatColor.getLastColors(split[1]);
            return last == null || last.isEmpty() ? colorByName : last;
        }
        return ChatColor.getLastColors((String)CMIChatColor.translate(text));
    }

    public String getColorCode() {
        if (this.hexCode != null) {
            return colorCodePrefix + this.hexCode + colorCodeSuffix;
        }
        return "&" + this.c;
    }

    public String getBukkitColorCode() {
        if (this.hexCode != null) {
            return CMIChatColor.translate(colorCodePrefix + this.hexCode + colorCodeSuffix);
        }
        return "\u00a7" + this.c;
    }

    public String toString() {
        return this.getBukkitColorCode();
    }

    public char getChar() {
        return this.c;
    }

    public void setChar(char c) {
        this.c = c;
    }

    public boolean isFormat() {
        return !this.colorable && !this.isReset;
    }

    public boolean isReset() {
        return this.isReset;
    }

    public ChatColor getColor() {
        return ChatColor.getByChar((char)this.getChar());
    }

    public static Set<CMIChatColor> getFormats(String text) {
        text = text.replace("\u00a7", "&");
        HashSet<CMIChatColor> formats = new HashSet<CMIChatColor>();
        Matcher match = formatPattern.matcher(text);
        while (match.find()) {
            String string = match.group();
            CMIChatColor format = CMIChatColor.getFormat(string);
            if (format == null || !format.isFormat()) continue;
            formats.add(format);
        }
        return formats;
    }

    public static CMIChatColor getFormat(String text) {
        if (text == null) {
            return null;
        }
        String or = CMIChatColor.deColorize(text);
        if ((text = text.replace("\u00a7", "&")).length() > 1) {
            String formated = text.toLowerCase().replace("_", "");
            CMIChatColor got = BY_NAME.get(formated);
            if (got != null) {
                return got;
            }
            got = CUSTOM_BY_NAME.get(formated);
            if (got != null) {
                return got;
            }
        }
        if (or.length() > 1 && String.valueOf(or.charAt(or.length() - 2)).equalsIgnoreCase("&")) {
            text = text.substring(text.length() - 1);
            for (Map.Entry<Character, CMIChatColor> one : BY_CHAR.entrySet()) {
                if (!String.valueOf(one.getKey()).equalsIgnoreCase(text)) continue;
                return one.getValue().isFormat() ? one.getValue() : null;
            }
        }
        return null;
    }

    public static CMIChatColor getColor(String text) {
        CMIChatColor hexColor;
        if (text == null) {
            return null;
        }
        String or = CMIChatColor.deColorize(text);
        if (or.contains(colorCodePrefix)) {
            Matcher match = hexColorRegexPatternLast.matcher(or);
            if (match.find()) {
                return new CMIChatColor(match.group(2));
            }
            match = hexColorNamePatternLast.matcher(or);
            if (match.find()) {
                return CMIChatColor.getByCustomName(match.group(2));
            }
        }
        if ((text = CMIChatColor.deColorize(text).replace("&", "")).length() > 1) {
            String formated = text.toLowerCase().replace("_", "");
            CMIChatColor cMIChatColor = BY_NAME.get(formated);
            if (cMIChatColor != null) {
                return cMIChatColor;
            }
            CMIChatColor cMIChatColor2 = CUSTOM_BY_NAME.get(formated);
            if (cMIChatColor2 != null) {
                return cMIChatColor2;
            }
        }
        if (or.length() > 1 && String.valueOf(or.charAt(or.length() - 2)).equalsIgnoreCase("&")) {
            text = text.substring(text.length() - 1);
            for (Map.Entry entry : BY_CHAR.entrySet()) {
                if (!String.valueOf(entry.getKey()).equalsIgnoreCase(text)) continue;
                return (CMIChatColor)entry.getValue();
            }
        }
        if ((hexColor = new CMIChatColor(text)).getHex() != null) {
            return hexColor;
        }
        return null;
    }

    public static CMIChatColor getRandomColor() {
        ArrayList<CMIChatColor> ls = new ArrayList<CMIChatColor>();
        for (Map.Entry<String, CMIChatColor> one : BY_NAME.entrySet()) {
            if (!one.getValue().isColorable()) continue;
            ls.add(one.getValue());
        }
        Collections.shuffle(ls);
        return (CMIChatColor)ls.get(0);
    }

    public org.bukkit.Color getRGBColor() {
        if (this.blueChannel < 0) {
            return null;
        }
        return org.bukkit.Color.fromRGB((int)this.redChannel, (int)this.greenChannel, (int)this.blueChannel);
    }

    public Color getJavaColor() {
        if (this.blueChannel < 0) {
            return null;
        }
        return new Color(this.redChannel, this.greenChannel, this.blueChannel);
    }

    public String getHex() {
        return this.hexCode;
    }

    public String getFormatedHex() {
        return this.getFormatedHex(null);
    }

    public String getFormatedHex(String subSuffix) {
        return colorCodePrefix + this.hexCode + (subSuffix == null ? "" : subSuffix) + colorCodeSuffix;
    }

    public String getCleanName() {
        return this.name == null ? this.getHex() : this.name.replace("_", "");
    }

    public static CMIChatColor getByCustomName(String name) {
        if (name.startsWith(colorCodePrefix)) {
            name = name.substring(colorCodePrefix.length());
        }
        if (name.endsWith(colorCodeSuffix)) {
            name = name.substring(0, name.length() - colorCodeSuffix.length());
        }
        if (name.equalsIgnoreCase("random")) {
            ArrayList<CMIChatColor> valuesList = new ArrayList<CMIChatColor>(CUSTOM_BY_NAME.values());
            int randomIndex = new Random().nextInt(valuesList.size());
            return (CMIChatColor)valuesList.get(randomIndex);
        }
        return CUSTOM_BY_NAME.get(name.toLowerCase().replace("_", ""));
    }

    public static CMIChatColor getByHex(String hex) {
        if (hex.startsWith(colorCodePrefix)) {
            hex = hex.substring(colorCodePrefix.length());
        }
        if (hex.endsWith(colorCodeSuffix)) {
            hex = hex.substring(0, hex.length() - colorCodeSuffix.length());
        }
        return CUSTOM_BY_HEX.get(hex.toLowerCase().replace("_", ""));
    }

    public static Map<String, CMIChatColor> getByName() {
        return BY_NAME;
    }

    public static Map<String, CMIChatColor> getByCustomName() {
        return CUSTOM_BY_NAME;
    }

    public static String getHexFromCoord(int x, int y) {
        x = x < 0 ? 0 : Math.min(x, 255);
        y = y < 0 ? 0 : Math.min(y, 255);
        int blue = (int)(255.0 - (double)(y * 255) * (1.0 + Math.sin(6.3 * (double)x)) / 2.0);
        int green = (int)(255.0 - (double)(y * 255) * (1.0 + Math.cos(6.3 * (double)x)) / 2.0);
        int red = (int)(255.0 - (double)(y * 255) * (1.0 - Math.sin(6.3 * (double)x)) / 2.0);
        StringBuilder hex = new StringBuilder().append(Integer.toHexString((red << 16) + (green << 8) + blue & 0xFFFFFF));
        while (hex.length() < 6) {
            hex.append("0").append((CharSequence)hex);
        }
        return hexSymbol + hex;
    }

    public static String getHexRedGreenByPercent(int percentage, int parts) {
        float percent = (float)percentage * 33.0f / 100.0f / 100.0f;
        Color color = Color.getHSBColor(percent, 1.0f, 1.0f);
        StringBuilder hex = new StringBuilder().append(Integer.toHexString((color.getRed() << 16) + (color.getGreen() << 8) + color.getBlue() & 0xFFFFFF));
        while (hex.length() < 6) {
            hex.append("0").append((CharSequence)hex);
        }
        return hexSymbol + hex;
    }

    public int getRed() {
        return this.redChannel;
    }

    public int getGreen() {
        return this.greenChannel;
    }

    public int getBlue() {
        return this.blueChannel;
    }

    public static CMIChatColor getClosest(String hex) {
        Color c2;
        CMIChatColor closest;
        if (hex.startsWith(hexSymbol)) {
            hex = hex.substring(1);
        }
        if ((closest = CUSTOM_BY_RGB.get(hex)) != null) {
            return closest;
        }
        try {
            c2 = new Color(Integer.valueOf(hex.substring(0, 2), 16), Integer.valueOf(hex.substring(2, 4), 16), Integer.valueOf(hex.substring(4, 6), 16));
        }
        catch (Throwable e) {
            return null;
        }
        double distance = Double.MAX_VALUE;
        for (Map.Entry<String, CMIChatColor> one : CUSTOM_BY_HEX.entrySet()) {
            int b;
            int g;
            int r;
            int red2;
            Color c1 = new Color(Integer.valueOf(one.getValue().hexCode.substring(0, 2), 16), Integer.valueOf(one.getValue().hexCode.substring(2, 4), 16), Integer.valueOf(one.getValue().hexCode.substring(4, 6), 16));
            int red1 = c1.getRed();
            int rmean = red1 + (red2 = c2.getRed()) >> 1;
            double dist = Math.sqrt(((512 + rmean) * (r = red1 - red2) * r >> 8) + 4 * (g = c1.getGreen() - c2.getGreen()) * g + ((767 - rmean) * (b = c1.getBlue() - c2.getBlue()) * b >> 8));
            if (!(dist < distance)) continue;
            closest = one.getValue();
            distance = dist;
        }
        if (closest != null) {
            CUSTOM_BY_RGB.put(hex, closest);
            return closest;
        }
        CUSTOM_BY_RGB.put(hex, null);
        return null;
    }

    public static String getClosestVanilla(String hex) {
        try {
            Color c2;
            CMIChatColor old;
            if (hex.startsWith(hexSymbol)) {
                hex = hex.substring(1);
            }
            if ((old = CUSTOM_BY_HEX.get(hex)) != null && old.getChar() != '\n') {
                return "&" + old.getChar();
            }
            try {
                c2 = new Color(Integer.valueOf(hex.substring(0, 2), 16), Integer.valueOf(hex.substring(2, 4), 16), Integer.valueOf(hex.substring(4, 6), 16));
            }
            catch (Throwable e) {
                return null;
            }
            double distance = Double.MAX_VALUE;
            CMIChatColor closest = null;
            for (Map.Entry<Character, CMIChatColor> one : BY_CHAR.entrySet()) {
                int b;
                int g;
                int r;
                int red2;
                Color c1;
                int red1;
                int rmean;
                double dist;
                if (!one.getValue().isColorable() || !((dist = Math.sqrt(((512 + (rmean = (red1 = (c1 = new Color(one.getValue().getRed(), one.getValue().getGreen(), one.getValue().getBlue())).getRed()) + (red2 = c2.getRed()) >> 1)) * (r = red1 - red2) * r >> 8) + 4 * (g = c1.getGreen() - c2.getGreen()) * g + ((767 - rmean) * (b = c1.getBlue() - c2.getBlue()) * b >> 8))) < distance)) continue;
                closest = one.getValue();
                distance = dist;
            }
            if (closest != null) {
                if (old != null) {
                    old.setChar(closest.getChar());
                } else {
                    CUSTOM_BY_HEX.put(hex, closest);
                }
                return "&" + closest.getChar();
            }
        }
        catch (Throwable ee) {
            ee.printStackTrace();
        }
        return null;
    }

    public CMIChatColor mixColors(CMIChatColor color, double percent) {
        return CMIChatColor.mixColors(this, color, percent);
    }

    public static CMIChatColor mixColors(CMIChatColor color1, CMIChatColor color2, double percent) {
        double inverse_percent = 1.0 - (percent /= 100.0);
        int redPart = (int)((double)color2.getRed() * percent + (double)color1.getRed() * inverse_percent);
        int greenPart = (int)((double)color2.getGreen() * percent + (double)color1.getGreen() * inverse_percent);
        int bluePart = (int)((double)color2.getBlue() * percent + (double)color1.getBlue() * inverse_percent);
        String hexCode = String.format("#%02x%02x%02x", redPart, greenPart, bluePart);
        return new CMIChatColor(hexCode);
    }

    @Generated
    public boolean isColorable() {
        return this.colorable;
    }

    @Generated
    public Pattern getPattern() {
        return this.pattern;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    static {
        for (CMICustomColors one : CMICustomColors.values()) {
            CUSTOM_BY_NAME.put(one.name().toLowerCase().replace("_", ""), new CMIChatColor(one.toString(), one.getHex()));
            CUSTOM_BY_HEX.put(one.getHex().toLowerCase(), new CMIChatColor(one.toString(), one.getHex()));
        }
        for (float x = 0.0f; x <= 1.0f; x += 0.1f) {
            for (float z = 0.1f; z <= 1.0f; z += 0.1f) {
                for (float y = 0.0f; y <= 1.0f; y += 0.03f) {
                    Color color = Color.getHSBColor(y, x, z);
                    StringBuilder hex = new StringBuilder().append(Integer.toHexString((color.getRed() << 16) + (color.getGreen() << 8) + color.getBlue() & 0xFFFFFF));
                    while (hex.length() < 6) {
                        hex.append("0").append((CharSequence)hex);
                    }
                    CMIChatColor.getClosest(hex.toString());
                }
            }
        }
        cleanOfficialColorRegexPattern = Pattern.compile("(?<!\\{|:\"|\uff06)#([a-fA-F0-9]{6}|[a-fA-F0-9]{3})");
        cleanQuirkyHexColorRegexPattern = Pattern.compile("&#([a-fA-F0-9]{6}|[a-fA-F0-9]{3})");
        hexColorRegexPattern = Pattern.compile(hexColorRegex);
        hexColorRegexPatternLast = Pattern.compile("(\\{#)([0-9A-Fa-f]{6}|[0-9A-Fa-f]{3})(\\})(?!.*\\{#)");
        hexDeColorNamePattern = Pattern.compile("((&|\u00a7)x)(((&|\u00a7)[0-9A-Fa-f]){6})");
        hexColorNamePattern = Pattern.compile(ColorNameRegex);
        hexColorNamePatternLast = Pattern.compile("(\\{#)([a-zA-Z_]{3,})(\\})(?!.*\\{#)");
        gradientPattern = Pattern.compile("(\\{(#[^\\{]*?)>\\})(.*?)(\\{(#.*?)<(>?)\\})");
        postGradientPattern = Pattern.compile("((\\{#)([0-9A-Fa-f]{6}|[0-9A-Fa-f]{3})(\\})|(\\{#)([a-zA-Z_]{3,})(\\}))(.)((\\{#)([0-9A-Fa-f]{6}|[0-9A-Fa-f]{3})(\\})|(\\{#)([a-zA-Z_]{3,})(\\}))");
        post2GradientPattern = Pattern.compile("((\\{#)([0-9A-Fa-f]{6}|[0-9A-Fa-f]{3})(\\})|(\\{#)([a-zA-Z_]{3,})(\\}))(.)(((\\{#)([0-9A-Fa-f]{6}|[0-9A-Fa-f]{3})(\\})|(\\{#)([a-zA-Z_]{3,})(\\}))(.))+");
        fullPattern = Pattern.compile("(&[0123456789abcdefklmnorABCDEFKLMNOR])|(\\{#)([0-9A-Fa-f]{6}|[0-9A-Fa-f]{3})(\\})|(\\{#)([a-zA-Z_]{3,})(\\})|(\\{@)([a-zA-Z_]{3,})(\\})");
        formatPattern = Pattern.compile("(&[klmnorKLMNOR])");
        BLACK = new CMIChatColor("Black", '0', 0, 0, 0);
        DARK_BLUE = new CMIChatColor("Dark_Blue", '1', 0, 0, 170);
        DARK_GREEN = new CMIChatColor("Dark_Green", '2', 0, 170, 0);
        DARK_AQUA = new CMIChatColor("Dark_Aqua", '3', 0, 170, 170);
        DARK_RED = new CMIChatColor("Dark_Red", '4', 170, 0, 0);
        DARK_PURPLE = new CMIChatColor("Dark_Purple", '5', 170, 0, 170);
        GOLD = new CMIChatColor("Gold", '6', 255, 170, 0);
        GRAY = new CMIChatColor("Gray", '7', 170, 170, 170);
        DARK_GRAY = new CMIChatColor("Dark_Gray", '8', 85, 85, 85);
        BLUE = new CMIChatColor("Blue", '9', 85, 85, 255);
        GREEN = new CMIChatColor("Green", 'a', 85, 255, 85);
        AQUA = new CMIChatColor("Aqua", 'b', 85, 255, 255);
        RED = new CMIChatColor("Red", 'c', 255, 85, 85);
        LIGHT_PURPLE = new CMIChatColor("Light_Purple", 'd', 255, 85, 255);
        YELLOW = new CMIChatColor("Yellow", 'e', 255, 255, 85);
        WHITE = new CMIChatColor("White", 'f', 255, 255, 255);
        OBFUSCATED = new CMIChatColor("Obfuscated", 'k', false);
        BOLD = new CMIChatColor("Bold", 'l', false);
        STRIKETHROUGH = new CMIChatColor("Strikethrough", 'm', false);
        UNDERLINE = new CMIChatColor("Underline", 'n', false);
        ITALIC = new CMIChatColor("Italic", 'o', false);
        RESET = new CMIChatColor("Reset", 'r', false, true);
        HEX = new CMIChatColor("Hex", 'x', false, false);
    }
}

