/*
 * Decompiled with CFR 0.152.
 */
package org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.machine;

import io.github.thebusybiscuit.slimefun4.api.events.MultiBlockCraftEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlockMachine;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundEffect;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.backpacks.SlimefunBackpack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Dispenser;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.lins.mmmjjkx.rykenslimefuncustomizer.RykenSlimefunCustomizer;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.script.ScriptEval;

public class CustomMultiBlockMachine
extends MultiBlockMachine {
    private final SoundEffect craftSound;
    private final int workIndex;
    private final ScriptEval eval;
    private final BlockFace dispenserFace;

    public CustomMultiBlockMachine(ItemGroup itemGroup, SlimefunItemStack item, ItemStack[] recipe, Map<ItemStack[], ItemStack> craftRecipes, int work, @Nullable SoundEffect soundEffect, @Nullable ScriptEval eval) {
        super(itemGroup, item, recipe, BlockFace.SELF);
        this.workIndex = work - 1;
        this.craftSound = soundEffect;
        this.eval = eval;
        this.dispenserFace = this.dispenserFaceGet();
        for (Map.Entry<ItemStack[], ItemStack> e : craftRecipes.entrySet()) {
            this.addRecipe(e.getKey(), e.getValue());
        }
        this.register(RykenSlimefunCustomizer.INSTANCE);
    }

    @Nonnull
    public List<ItemStack> getDisplayRecipes() {
        return new ArrayList<ItemStack>();
    }

    public void onInteract(Player p, Block block) {
        Material material = super.getRecipe()[this.workIndex].getType();
        if (block.getType().equals((Object)material)) {
            Block disBlock;
            BlockState bs;
            if (this.eval != null) {
                this.eval.evalFunction("onWork", p, block);
            }
            if ((bs = PaperLib.getBlockState((Block)(disBlock = block.getRelative(this.dispenserFace)), (boolean)false).getState()) instanceof Dispenser) {
                Dispenser dispenser = (Dispenser)bs;
                Inventory inv = dispenser.getInventory();
                List inputs = RecipeType.getRecipeInputList((MultiBlockMachine)this);
                ItemStack[] contents = inv.getContents();
                for (ItemStack[] input : inputs) {
                    if (!this.isCraftable(inv, input)) continue;
                    ItemStack output = RecipeType.getRecipeOutputList((MultiBlockMachine)this, (ItemStack[])input).clone();
                    MultiBlockCraftEvent event = new MultiBlockCraftEvent(p, (MultiBlockMachine)this, input, output);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (!event.isCancelled() && SlimefunUtils.canPlayerUseItem((Player)p, (ItemStack)output, (boolean)true)) {
                        Inventory fakeInv = this.createVirtualInventory(inv);
                        Inventory outputInv = this.findOutputInventory(output, disBlock, inv, fakeInv);
                        if (outputInv != null) {
                            boolean waitCallback = false;
                            for (int j = 0; j < input.length; ++j) {
                                ItemStack item = contents[j];
                                if (item == null || item.getType() == Material.AIR) continue;
                                ItemUtils.consumeItem((ItemStack)item, (int)input[j].getAmount(), (boolean)true);
                            }
                            if (!waitCallback) {
                                this.craftSound.playAt(block);
                                outputInv.addItem(new ItemStack[]{output});
                            }
                        } else {
                            Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.full-inventory", true);
                        }
                    }
                    return;
                }
                if (inv.isEmpty()) {
                    Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.inventory-empty", true);
                } else {
                    Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.pattern-not-found", true);
                }
            }
        }
    }

    @Nonnull
    protected Inventory createVirtualInventory(@Nonnull Inventory inv) {
        Inventory fakeInv = Bukkit.createInventory(null, (int)9, (Component)Component.text((String)"Fake Inventory"));
        for (int j = 0; j < inv.getContents().length; ++j) {
            ItemStack stack = inv.getContents()[j];
            if (stack != null) {
                stack = stack.clone();
                ItemUtils.consumeItem((ItemStack)stack, (boolean)true);
            }
            fakeInv.setItem(j, stack);
        }
        return fakeInv;
    }

    private boolean isCraftable(Inventory inv, ItemStack[] recipe) {
        for (int j = 0; j < inv.getContents().length; ++j) {
            if (SlimefunUtils.isItemSimilar((ItemStack)inv.getContents()[j], (ItemStack)recipe[j], (boolean)true, (boolean)true, (boolean)false)) continue;
            if (!(SlimefunItem.getByItem((ItemStack)recipe[j]) instanceof SlimefunBackpack)) {
                return false;
            }
            if (SlimefunUtils.isItemSimilar((ItemStack)inv.getContents()[j], (ItemStack)recipe[j], (boolean)false, (boolean)true, (boolean)false)) continue;
            return false;
        }
        return true;
    }

    private BlockFace dispenserFaceGet() {
        ItemStack o4;
        ItemStack o1;
        int center = this.workIndex;
        ItemStack[] is = this.getRecipe();
        if (center - 3 > 0 && (o1 = is[center - 3]) != null && o1.getType().equals((Object)Material.DISPENSER)) {
            return BlockFace.UP;
        }
        ItemStack o2 = is[center - 1];
        if (o2 != null && o2.getType().equals((Object)Material.DISPENSER)) {
            return BlockFace.EAST;
        }
        if (center + 1 >= 9) {
            return BlockFace.SELF;
        }
        ItemStack o3 = is[center + 1];
        if (o3 != null && o3.getType().equals((Object)Material.DISPENSER)) {
            return BlockFace.WEST;
        }
        if (center + 3 < 8 && (o4 = is[center + 3]) != null && o4.getType().equals((Object)Material.DISPENSER)) {
            return BlockFace.DOWN;
        }
        return BlockFace.SELF;
    }
}

