/*
 * Decompiled with CFR 0.152.
 */
package org.lins.mmmjjkx.rykenslimefuncustomizer.objects.yaml;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.Nullable;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.ProjectAddon;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.CustomAddonConfig;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.CommonUtils;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.ExceptionHandler;

public abstract class YamlReader<T> {
    private final List<String> lateInits;
    protected final ProjectAddon addon;
    protected final YamlConfiguration configuration;

    public YamlReader(YamlConfiguration config, ProjectAddon addon) {
        this.configuration = config;
        this.lateInits = new ArrayList<String>();
        this.addon = addon;
    }

    public abstract T readEach(String var1);

    public final void preload() {
        for (String key : this.configuration.getKeys(false)) {
            List<SlimefunItemStack> items;
            ConfigurationSection register;
            ConfigurationSection section = this.configuration.getConfigurationSection(key);
            if (section == null || !this.checkForRegistration(key, register = section.getConfigurationSection("register")) || (items = this.preloadItems(key)) == null || items.isEmpty()) continue;
            for (SlimefunItemStack item : items) {
                this.addon.getPreloadItems().put(item.getItemId(), item);
            }
        }
    }

    @Nullable
    protected final SlimefunItemStack getPreloadItem(String itemId) {
        return this.addon.getPreloadItems().get(itemId);
    }

    public final List<T> readAll() {
        ArrayList<T> objects = new ArrayList<T>();
        for (String key : this.configuration.getKeys(false)) {
            ConfigurationSection section = this.configuration.getConfigurationSection(key);
            if (section == null) continue;
            ExceptionHandler.debugLog("Start reading section: " + key);
            ConfigurationSection register = section.getConfigurationSection("register");
            if (!this.checkForRegistration(key, register)) continue;
            ExceptionHandler.debugLog("Check lateInit...");
            if (section.getBoolean("lateInit", false)) {
                this.putLateInit(key);
                ExceptionHandler.debugLog("Check result: lateInit");
                continue;
            }
            ExceptionHandler.debugLog("Start reading object...");
            T object = this.readEach(key);
            if (object != null) {
                objects.add(object);
                ExceptionHandler.debugLog("SUCCESS | Reading section " + key + "success\uff01");
                continue;
            }
            ExceptionHandler.debugLog("FAILURE | Reading section " + key + "failed\uff01");
        }
        return objects;
    }

    protected void putLateInit(String key) {
        this.lateInits.add(key);
    }

    public List<T> loadLateInits() {
        ArrayList objects = new ArrayList();
        this.lateInits.forEach(key -> {
            ExceptionHandler.debugLog("Start reading lateInit section\uff1a" + key);
            T object = this.readEach((String)key);
            if (object != null) {
                objects.add(object);
                ExceptionHandler.debugLog("SUCCESS | Reading section " + key + "success\uff01");
            } else {
                ExceptionHandler.debugLog("FAILURE | Reading section " + key + "failed\uff01");
            }
        });
        this.lateInits.clear();
        return objects;
    }

    public abstract List<SlimefunItemStack> preloadItems(String var1);

    private boolean checkForRegistration(String key, ConfigurationSection section) {
        if (section == null) {
            return true;
        }
        List conditions = section.getStringList("conditions");
        boolean warn = section.getBoolean("warn", false);
        boolean unfinished = section.getBoolean("unfinished", false);
        if (unfinished) {
            return false;
        }
        for (String condition : conditions) {
            String[] splits = condition.split(" ");
            String head = splits[0];
            if (head.equalsIgnoreCase("hasplugin")) {
                if (splits.length != 2) {
                    ExceptionHandler.handleError("Found invalid condition while reading register conditions in " + key + ": hasplugin only takes one argument");
                    continue;
                }
                boolean b = Bukkit.getPluginManager().isPluginEnabled(splits[1]);
                if (!b) {
                    if (warn) {
                        ExceptionHandler.handleError(key + "needs server plugin " + splits[1] + " to be registered");
                    }
                    return false;
                }
            } else if (head.equalsIgnoreCase("!hasplugin")) {
                if (splits.length != 2) {
                    ExceptionHandler.handleError("Found invalid condition while reading register conditions in " + key + ": !hasplugin only takes one argument");
                    continue;
                }
                boolean b = Bukkit.getPluginManager().isPluginEnabled(splits[1]);
                if (b) {
                    if (warn) {
                        ExceptionHandler.handleError(key + "needs removing server plugin " + splits[1] + " to be registered(may have conflicts?)");
                    }
                    return false;
                }
            } else if (head.equalsIgnoreCase("version")) {
                int destination;
                if (splits.length != 3) {
                    ExceptionHandler.handleError("Found invalid condition while reading register conditions in " + key + ": version needs two arguments");
                    continue;
                }
                int current = CommonUtils.versionToCode(Bukkit.getMinecraftVersion());
                if (!this.intCheck(splits[1], key, "version", current, destination = CommonUtils.versionToCode(splits[2]), op -> "Needs version is " + op + splits[2] + " so that it can be registered", warn)) {
                    return false;
                }
            } else if (head.contains("config")) {
                CustomAddonConfig config = this.addon.getConfig();
                if (config == null) {
                    ExceptionHandler.handleError("Found an issue while reading the registration conditions for " + key + ": cannot found the config");
                    continue;
                }
                switch (head) {
                    case "config.boolean": {
                        if (splits.length != 2) {
                            ExceptionHandler.handleError("Found an issue while reading the registration conditions for " + key + ": config.boolean takes one argument");
                            break;
                        }
                        if (config.config().getBoolean(splits[1])) break;
                        if (warn) {
                            ExceptionHandler.handleError(key + " needs config option " + splits[1] + "'s value is true so that it can be registered");
                        }
                        return false;
                    }
                    case "config.string": {
                        if (splits.length != 3) {
                            ExceptionHandler.handleError("Found an issue while reading the registration conditions for " + key + ": config.string takes two arguments");
                            break;
                        }
                        if (Objects.equals(config.config().getString(splits[1]), splits[2])) break;
                        if (warn) {
                            ExceptionHandler.handleError(key + " needs config option " + splits[1] + "'s value is" + splits[2] + " so that it can be registered");
                        }
                        return false;
                    }
                    case "config.int": {
                        int destination;
                        if (splits.length != 4) {
                            ExceptionHandler.handleError("Found an issue while reading the registration conditions for " + key + ": config.int takes three arguments");
                            break;
                        }
                        String configKey = splits[1];
                        int current = config.config().getInt(splits[2]);
                        if (this.intCheck(splits[1], key, "config.int", current, destination = Integer.parseInt(splits[3]), op -> " needs config option" + configKey + "'s value is " + op + splits[3] + " so that it can be registered", warn)) break;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean intCheck(String operator, String key, String regParam, int current, int destination, Function<String, String> msg, boolean warn) {
        boolean b;
        String operation = "";
        switch (operator) {
            case ">": {
                boolean bl;
                operation = "greater than";
                if (current > destination) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "<": {
                boolean bl;
                operation = "less than";
                if (current < destination) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case ">=": {
                boolean bl;
                operation = "greater than or equal to";
                if (current >= destination) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "<=": {
                boolean bl;
                operation = "less than or equal to";
                if (current <= destination) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "==": {
                boolean bl;
                operation = "equals";
                if (current == destination) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "!=": {
                boolean bl;
                operation = "not equals";
                if (current != destination) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                ExceptionHandler.handleError("Found an issue while reading the registration conditions for " + key + ": " + regParam + " requires a valid operator!");
                boolean bl = b = true;
            }
        }
        if (!b && warn) {
            ExceptionHandler.handleError(key + msg.apply(operation));
        }
        return b;
    }
}

