/*
 * Decompiled with CFR 0.152.
 */
package org.lins.mmmjjkx.rykenslimefuncustomizer.objects.yaml.item;

import de.tr7zw.nbtapi.NBT;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.Pair;
import java.io.File;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.lins.mmmjjkx.rykenslimefuncustomizer.bulit_in.JavaScriptEval;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.ProjectAddon;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.item.CustomFood;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.yaml.YamlReader;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.CommonUtils;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.ExceptionHandler;

public class FoodReader
extends YamlReader<CustomFood> {
    public FoodReader(YamlConfiguration config, ProjectAddon addon) {
        super(config, addon);
    }

    @Override
    public CustomFood readEach(String s) {
        ConfigurationSection section = this.configuration.getConfigurationSection(s);
        if (section == null) {
            return null;
        }
        String id = section.getString("id_alias", s);
        ExceptionHandler.HandleResult result = ExceptionHandler.handleIdConflict(id);
        if (result == ExceptionHandler.HandleResult.FAILED) {
            return null;
        }
        String igId = section.getString("item_group");
        Pair<ExceptionHandler.HandleResult, ItemGroup> group = ExceptionHandler.handleItemGroupGet(this.addon, igId);
        if (group.getFirstValue() == ExceptionHandler.HandleResult.FAILED) {
            return null;
        }
        SlimefunItemStack sfis = this.getPreloadItem(id);
        if (sfis == null) {
            return null;
        }
        ItemStack[] itemStacks = CommonUtils.readRecipe(section.getConfigurationSection("recipe"), this.addon);
        String recipeType = section.getString("recipe_type", "NULL");
        Pair<ExceptionHandler.HandleResult, RecipeType> rt = ExceptionHandler.getRecipeType("Found an error while loading capacitor " + s + " in addon " + this.addon.getAddonId() + ": Invalid recipe type '" + recipeType + "'!", recipeType);
        if (rt.getFirstValue() == ExceptionHandler.HandleResult.FAILED) {
            return null;
        }
        JavaScriptEval eval = null;
        if (section.contains("script")) {
            String script = section.getString("script", "");
            File file = new File(this.addon.getScriptsFolder(), script + ".js");
            if (!file.exists()) {
                ExceptionHandler.handleWarning("There was an error while loading food " + s + " in addon " + this.addon.getAddonId() + ": Could not find script file " + file.getName());
            } else {
                eval = new JavaScriptEval(file, this.addon);
            }
        }
        if (CommonUtils.versionToCode(Bukkit.getMinecraftVersion()) >= 1205 && Bukkit.getPluginManager().isPluginEnabled("NBTAPI")) {
            this.nbtApply(id, section, sfis);
        }
        return new CustomFood((ItemGroup)group.getSecondValue(), sfis, (RecipeType)rt.getSecondValue(), itemStacks, eval);
    }

    private void nbtApply(String s, ConfigurationSection section, SlimefunItemStack sfis) {
        int nutrition = section.getInt("nutrition");
        float saturation = section.getInt("saturation");
        boolean alwaysEatable = section.getBoolean("always_eatable", false);
        float eatseconds = section.getInt("eat_seconds", 0);
        if (nutrition < 1) {
            ExceptionHandler.handleError("Found an error while loading food " + s + " in addon " + this.addon.getAddonId() + ": Nutrition value " + nutrition + " is less than 1! Value has been set to 1.");
            nutrition = 1;
        }
        if (saturation < 0.0f) {
            ExceptionHandler.handleError("Found an error while loading food " + s + " in addon " + this.addon.getAddonId() + ": Saturation value " + saturation + " is less than 0! Value has been set to 0.");
            saturation = 0.0f;
        }
        if (eatseconds < 0.0f) {
            ExceptionHandler.handleError("Found an error while loading food " + s + " in addon " + this.addon.getAddonId() + ": Eat seconds value " + eatseconds + " is less than 0! Value has been set to 1.6.");
            eatseconds = 1.6f;
        }
        int finalNutrition = nutrition;
        float finalSaturation = saturation;
        float finalEatSeconds = eatseconds;
        NBT.modify((ItemStack)sfis, nbt -> {
            nbt.setInteger("nutrition", Integer.valueOf(finalNutrition));
            nbt.setFloat("saturation", Float.valueOf(finalSaturation));
            nbt.setBoolean("can_always_eat", Boolean.valueOf(alwaysEatable));
            nbt.setFloat("eat_seconds", Float.valueOf(finalEatSeconds));
        });
    }

    @Override
    public List<SlimefunItemStack> preloadItems(String id) {
        ConfigurationSection section = this.configuration.getConfigurationSection(id);
        if (section == null) {
            return null;
        }
        ConfigurationSection item = section.getConfigurationSection("item");
        ItemStack stack = CommonUtils.readItem(item, false, this.addon);
        if (stack == null) {
            ExceptionHandler.handleError("Found an error while loading food " + id + " in addon " + this.addon.getAddonId() + ": The item is null or has an invalid format");
            return null;
        }
        SlimefunItemStack sfis = new SlimefunItemStack(id.toUpperCase(), stack);
        return List.of(sfis);
    }
}

