/*
 * Decompiled with CFR 0.152.
 */
package org.lins.mmmjjkx.rykenslimefuncustomizer.objects.yaml.machine;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.Pair;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.ProjectAddon;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.CustomMenu;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.machine.CustomRecipeMachine;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.machine.CustomMachineRecipe;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.yaml.YamlReader;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.CommonUtils;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.ExceptionHandler;

public class RecipeMachineReader
extends YamlReader<CustomRecipeMachine> {
    public RecipeMachineReader(YamlConfiguration config, ProjectAddon addon) {
        super(config, addon);
    }

    @Override
    public CustomRecipeMachine readEach(String s) {
        ConfigurationSection section = this.configuration.getConfigurationSection(s);
        if (section == null) {
            return null;
        }
        String id = section.getString("id_alias", s);
        ExceptionHandler.HandleResult result = ExceptionHandler.handleIdConflict(id);
        if (result == ExceptionHandler.HandleResult.FAILED) {
            return null;
        }
        String igId = section.getString("item_group");
        Pair<ExceptionHandler.HandleResult, ItemGroup> group = ExceptionHandler.handleItemGroupGet(this.addon, igId);
        if (group.getFirstValue() == ExceptionHandler.HandleResult.FAILED) {
            return null;
        }
        SlimefunItemStack slimefunItemStack = this.getPreloadItem(id);
        if (slimefunItemStack == null) {
            return null;
        }
        ItemStack[] recipe = CommonUtils.readRecipe(section.getConfigurationSection("recipe"), this.addon);
        String recipeType = section.getString("recipe_type", "NULL");
        Pair<ExceptionHandler.HandleResult, RecipeType> rt = ExceptionHandler.getRecipeType("Found an error while loading recipe machine " + s + " in addon " + this.addon.getAddonId() + ": Invalid recipe type '" + recipeType + "'!", recipeType);
        if (rt.getFirstValue() == ExceptionHandler.HandleResult.FAILED) {
            return null;
        }
        CustomMenu menu = CommonUtils.getIf(this.addon.getMenus(), m -> m.getID().equalsIgnoreCase(s));
        List input = section.getIntegerList("input");
        List output = section.getIntegerList("output");
        if (input.isEmpty()) {
            ExceptionHandler.handleError("Found an error while loading recipe machine " + s + " in addon " + this.addon.getAddonId() + ": There's must be at least one input slots!");
            return null;
        }
        if (output.isEmpty()) {
            ExceptionHandler.handleError("Found an error while loading recipe machine " + s + " in addon " + this.addon.getAddonId() + ": There's must be at least one output slot!");
            return null;
        }
        ConfigurationSection recipes = section.getConfigurationSection("recipes");
        int capacity = section.getInt("capacity");
        if (capacity < 0) {
            ExceptionHandler.handleError("Found an error while loading recipe machine " + s + " in addon " + this.addon.getAddonId() + ": Capacity must be greater than or equal to 0!");
            return null;
        }
        int energy = section.getInt("energyPerCraft");
        if (energy <= 0) {
            ExceptionHandler.handleError("Found an error while loading recipe machine " + s + "in addon " + this.addon.getAddonId() + ": Energy per craft must be greater than 0!");
            return null;
        }
        int speed = section.getInt("speed");
        if (speed <= 0) {
            ExceptionHandler.handleError("Found an error while loading recipe machine " + s + " in addon " + this.addon.getAddonId() + ": Speed must be greater than 0!");
            return null;
        }
        boolean hideAllRecipes = section.getBoolean("hideAllRecipes", false);
        List<CustomMachineRecipe> mr = this.readRecipes(s, input.size(), output.size(), recipes, this.addon);
        return new CustomRecipeMachine((ItemGroup)group.getSecondValue(), slimefunItemStack, (RecipeType)rt.getSecondValue(), recipe, input.stream().mapToInt(x -> x).toArray(), output.stream().mapToInt(x -> x).toArray(), mr, energy, capacity, menu, speed, hideAllRecipes);
    }

    @Override
    public List<SlimefunItemStack> preloadItems(String s) {
        ConfigurationSection section = this.configuration.getConfigurationSection(s);
        if (section == null) {
            return null;
        }
        ConfigurationSection item = section.getConfigurationSection("item");
        ItemStack stack = CommonUtils.readItem(item, false, this.addon);
        if (stack == null) {
            ExceptionHandler.handleError("Found an error while loading recipe machine " + s + " in addon " + this.addon.getAddonId() + ": The item is null or has an invalid format");
            return null;
        }
        return List.of(new SlimefunItemStack(s, stack));
    }

    private List<CustomMachineRecipe> readRecipes(String s, int inputSize, int outputSize, ConfigurationSection section, ProjectAddon addon) {
        ArrayList<CustomMachineRecipe> list = new ArrayList<CustomMachineRecipe>();
        if (section == null) {
            return list;
        }
        for (String key : section.getKeys(false)) {
            ConfigurationSection recipes = section.getConfigurationSection(key);
            if (recipes == null) continue;
            int seconds = recipes.getInt("seconds");
            if (seconds < 0) {
                ExceptionHandler.handleError("Found an error while loading recipe machine " + s + "'s recipe " + key + " in addon " + addon.getAddonId() + ": Seconds must be greater than or equal to 0!");
                continue;
            }
            ConfigurationSection inputs = recipes.getConfigurationSection("input");
            if (inputs == null) {
                ExceptionHandler.handleError("Found an error while loading recipe machine " + s + "'s recipe " + key + " in addon " + addon.getAddonId() + ": There's must be at least one input!");
                continue;
            }
            ItemStack[] input = CommonUtils.readRecipe(inputs, addon, inputSize);
            if (input == null) {
                ExceptionHandler.handleError("Found an error while loading recipe machine " + s + "'s recipe " + key + " in addon " + addon.getAddonId() + ": Input items is null or has an invalid format!");
                continue;
            }
            ConfigurationSection outputs = recipes.getConfigurationSection("output");
            if (outputs == null) {
                ExceptionHandler.handleError("Found an error while loading recipe machine " + s + "'s recipe " + key + " in addon " + addon.getAddonId() + ": There's must be at least one output!");
                continue;
            }
            ArrayList<Integer> chances = new ArrayList<Integer>();
            ItemStack[] output = new ItemStack[outputSize];
            for (int i = 0; i < outputSize; ++i) {
                ConfigurationSection section1 = outputs.getConfigurationSection(String.valueOf(i + 1));
                ItemStack item = CommonUtils.readItem(section1, true, addon);
                if (item == null) continue;
                int chance = section1.getInt("chance", 100);
                if (chance < 1) {
                    ExceptionHandler.handleError("Found an error while loading recipe machine " + s + "'s recipe " + key + " in addon " + addon.getAddonId() + ": Chance must be greater than or equal to 1! Using 1 instead.");
                    chance = 1;
                }
                output[i] = item;
                chances.add(chance);
            }
            boolean chooseOne = recipes.getBoolean("chooseOne", false);
            boolean forDisplay = recipes.getBoolean("forDisplay", false);
            boolean hide = recipes.getBoolean("hide", false);
            input = CommonUtils.removeNulls(input);
            output = CommonUtils.removeNulls(output);
            list.add(new CustomMachineRecipe(seconds, input, output, chances, chooseOne, forDisplay, hide));
        }
        return list;
    }
}

