/*
 * Decompiled with CFR 0.152.
 */
package org.lins.mmmjjkx.rykenslimefuncustomizer.objects.slimefun;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.groups.NestedItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.groups.SubItemGroup;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.io.File;
import java.util.List;
import java.util.Optional;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.lins.mmmjjkx.rykenslimefuncustomizer.bulit_in.JavaScriptEval;
import org.lins.mmmjjkx.rykenslimefuncustomizer.libraries.colors.CMIChatColor;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.ProjectAddon;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.script.ban.CommandSafe;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.ExceptionHandler;

public class ItemGroupButton
extends SubItemGroup {
    private final List<String> actions;
    private final ProjectAddon addon;

    public ItemGroupButton(ProjectAddon addon, NamespacedKey key, NestedItemGroup parent, ItemStack item, int tier, @Nullable List<String> actions) {
        super(key, parent, item, tier);
        this.addon = addon;
        this.actions = actions;
    }

    public void run(Player p, int slot, ItemStack clickedItem, ClickAction clickAction, SlimefunGuideMode mode) {
        if (this.actions != null) {
            block16: for (String action : this.actions) {
                if (action.split(" ").length < 2) {
                    ExceptionHandler.handleWarning("Unknown action format found in item group button: " + action);
                    continue;
                }
                String type = action.split(" ")[0];
                String content = action.split(" ")[1];
                switch (type) {
                    case "link": {
                        p.sendMessage(CMIChatColor.translate("&eClick here: "));
                        TextComponent link = new TextComponent(content);
                        link.setColor(ChatColor.GRAY);
                        ClickEvent spigotClickEvent = new ClickEvent(ClickEvent.Action.OPEN_URL, content);
                        link.setClickEvent(spigotClickEvent);
                        p.sendMessage((BaseComponent)link);
                        break;
                    }
                    case "console": {
                        if (CommandSafe.isBadCommand(content)) {
                            ExceptionHandler.handleDanger("High-risk server operation detected in item group button. Please contact the author of the corresponding addon for processing!!!");
                            continue block16;
                        }
                        content = action.replace(type + " ", "");
                        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)content.replaceAll("%player%", p.getName()));
                        break;
                    }
                    case "open_itemgroup": {
                        Optional Oprofile;
                        if (content.split(":").length < 2) {
                            ExceptionHandler.handleWarning("Unknown NamespacedKey found in item group button: " + content);
                            continue block16;
                        }
                        String namespace = content.split(":")[0];
                        String key = content.split(":")[1];
                        int page = 1;
                        if (content.split(":").length > 2) {
                            try {
                                page = Integer.parseInt(content.split(":")[2]);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if ((Oprofile = PlayerProfile.find((OfflinePlayer)p)).isEmpty()) {
                            ExceptionHandler.handleWarning("Unable to retrieve PlayerProfile in item group button: " + p.getName());
                            continue block16;
                        }
                        PlayerProfile profile = (PlayerProfile)Oprofile.get();
                        for (ItemGroup group : Slimefun.getRegistry().getAllItemGroups()) {
                            if (!group.getKey().getNamespace().equals(namespace) || !group.getKey().getKey().equals(key)) continue;
                            SlimefunGuideImplementation implementation = Slimefun.getRegistry().getSlimefunGuide(mode);
                            implementation.openItemGroup(profile, group, page);
                        }
                        continue block16;
                    }
                    case "display_slimefunitem": {
                        Optional Oprofile = PlayerProfile.find((OfflinePlayer)p);
                        if (Oprofile.isEmpty()) {
                            ExceptionHandler.handleWarning("Unable to retrieve PlayerProfile in item group button: " + p.getName());
                            continue block16;
                        }
                        SlimefunItem item = SlimefunItem.getById((String)content);
                        if (item == null) {
                            ExceptionHandler.handleWarning("Unknown SlimefunItem ID found in item group button: " + content);
                            continue block16;
                        }
                        PlayerProfile profile = (PlayerProfile)Oprofile.get();
                        SlimefunGuideImplementation implementation = Slimefun.getRegistry().getSlimefunGuide(mode);
                        implementation.displayItem(profile, item, true);
                        break;
                    }
                    case "script": {
                        JavaScriptEval eval = null;
                        File file = new File(this.addon.getScriptsFolder(), content + ".js");
                        if (!file.exists()) {
                            ExceptionHandler.handleWarning("Script execution issue found in item group button: File not found " + file.getName());
                        } else {
                            eval = new JavaScriptEval(file, this.addon);
                        }
                        if (eval == null) continue block16;
                        eval.evalFunction("onButtonGroupClick", p, slot, clickedItem, clickAction, mode);
                        break;
                    }
                    default: {
                        ExceptionHandler.handleWarning("Unknown action type found in item group button: " + action);
                    }
                }
            }
        }
    }
}

