/*
 * Decompiled with CFR 0.152.
 */
package org.lins.mmmjjkx.rykenslimefuncustomizer.bulit_in;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.PolyglotAccess;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.io.IOAccess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lins.mmmjjkx.rykenslimefuncustomizer.RykenSlimefunCustomizer;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.ProjectAddon;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.script.ScriptEval;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.BlockMenuUtil;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.ExceptionHandler;

public class JavaScriptEval
extends ScriptEval {
    private static final File PLUGINS_FOLDER = RykenSlimefunCustomizer.INSTANCE.getDataFolder().getParentFile();
    private final Set<String> failed_functions = new HashSet<String>();
    private Context jsEngine;

    public JavaScriptEval(@NotNull File js, ProjectAddon addon) {
        super(js, addon);
        this.reSetup();
        this.setup();
        this.contextInit();
        addon.getScriptEvals().add(this);
    }

    private void advancedSetup() {
        JSRealm realm = JavaScriptLanguage.getJSRealm((Context)this.jsEngine);
        TruffleLanguage.Env env = realm.getEnv();
        this.addThing("SlimefunItems", env.asHostSymbol(SlimefunItems.class));
        this.addThing("SlimefunItem", env.asHostSymbol(SlimefunItem.class));
        this.addThing("SlimefunUtils", env.asHostSymbol(SlimefunUtils.class));
        this.addThing("BlockMenu", env.asHostSymbol(BlockMenu.class));
        this.addThing("BlockMenuUtil", env.asHostSymbol(BlockMenuUtil.class));
        this.addThing("PlayerProfile", env.asHostSymbol(PlayerProfile.class));
        this.addThing("Slimefun", env.asHostSymbol(Slimefun.class));
        for (File file : Objects.requireNonNull(PLUGINS_FOLDER.listFiles())) {
            TruffleFile truffleFile = env.getPublicTruffleFile(file.toURI());
            if (truffleFile.isDirectory(new LinkOption[0]) || !truffleFile.getName().endsWith(".jar")) continue;
            env.addToHostClassPath(truffleFile);
        }
        JSObject java = JSObjectUtil.createOrdinaryPrototypeObject((JSRealm)realm);
        JSObjectUtil.putToStringTag((JSDynamicObject)java, (TruffleString)JSRealm.JAVA_CLASS_NAME);
        JSObjectUtil.putDataProperty((JSDynamicObject)realm.getGlobalObject(), (Object)"Java", (Object)java, (int)JSAttributes.getDefaultNotEnumerable());
        this.jsEngine.enter();
    }

    @Override
    public void close() {
        try {
            this.jsEngine.leave();
            this.jsEngine.close();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public void addThing(String name, Object value) {
        this.jsEngine.getBindings("js").putMember(name, value);
    }

    @Override
    public String key() {
        return "js";
    }

    @Override
    protected final void contextInit() {
        super.contextInit();
        if (this.jsEngine != null) {
            try {
                this.jsEngine.eval(Source.newBuilder((String)"js", (CharSequence)this.getFileContext(), (String)"JavaScript").build());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    @Nullable
    @CanIgnoreReturnValue
    public Object evalFunction(String funName, Object ... args) {
        if (this.getFileContext() == null || this.getFileContext().isBlank()) {
            this.contextInit();
        }
        if (this.failed_functions.contains(funName)) {
            return null;
        }
        Value member = this.jsEngine.getBindings("js").getMember(funName);
        if (member == null) {
            this.failed_functions.add(funName);
            return null;
        }
        try {
            Value result = member.execute(args);
            ExceptionHandler.debugLog("Run function " + funName + " in file " + this.getFile().getName() + " of addon " + this.getAddon().getAddonName());
            return result;
        }
        catch (IllegalStateException e) {
            String message = e.getMessage();
            if (!message.contains("Multi threaded access")) {
                ExceptionHandler.handleError("An error occcured while executing script file " + this.getFile().getName() + "of addon" + this.getAddon().getAddonName(), e);
            }
        }
        catch (Throwable e) {
            ExceptionHandler.handleError("An error occcured while executing script file " + this.getFile().getName() + "of addon" + this.getAddon().getAddonName(), e);
        }
        return null;
    }

    private void reSetup() {
        this.jsEngine = Context.newBuilder((String[])new String[]{"js"}).hostClassLoader(RykenSlimefunCustomizer.class.getClassLoader()).hostClassLoader(ClassLoader.getSystemClassLoader()).allowAllAccess(true).allowHostAccess(this.UNIVERSAL_HOST_ACCESS).allowNativeAccess(false).allowExperimentalOptions(true).allowPolyglotAccess(PolyglotAccess.ALL).allowCreateProcess(true).allowValueSharing(true).allowIO(IOAccess.ALL).allowHostClassLookup(s -> true).allowHostClassLoading(true).engine(Engine.newBuilder((String[])new String[]{"js"}).allowExperimentalOptions(true).build()).currentWorkingDirectory(this.getAddon().getScriptsFolder().toPath().toAbsolutePath()).build();
        this.advancedSetup();
    }
}

