/*
 * Decompiled with CFR 0.152.
 */
package org.lins.mmmjjkx.rykenslimefuncustomizer.objects.global;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.ProjectAddon;

public class DropFromBlock {
    private static final Map<Material, List<Drop>> drops = new HashMap<Material, List<Drop>>();

    public static void addDrop(Material material, Drop drop) {
        drops.computeIfAbsent(material, k -> new ArrayList()).add(drop);
    }

    public static List<Drop> getDrops(Material material) {
        return drops.getOrDefault(material, Collections.emptyList());
    }

    public static void unregisterAddonDrops(ProjectAddon addon) {
        for (Material material : new ArrayList<Material>(drops.keySet())) {
            List<Drop> dropsList = DropFromBlock.getDrops(material);
            dropsList.removeIf(drop -> drop.owner.equals(addon));
            if (!dropsList.isEmpty()) continue;
            drops.remove(material);
        }
    }

    public record Drop(ItemStack itemStack, int dropChance, ProjectAddon owner, int minDropAmount, int maxDropAmount) {
        private final ItemStack itemStack;

        public Drop(ItemStack itemStack, int dropChance, ProjectAddon owner) {
            this(itemStack, dropChance, owner, itemStack.getAmount(), itemStack.getAmount());
        }

        public ItemStack itemStack() {
            ItemStack itemStack = this.itemStack.clone();
            itemStack.setAmount(this.randomDropAmount());
            return itemStack;
        }

        private int randomDropAmount() {
            Random random = new Random();
            int min = Math.min(this.minDropAmount, this.maxDropAmount);
            int max = Math.max(this.minDropAmount, this.maxDropAmount);
            return random.nextInt(max - min + 1) + min;
        }
    }
}

