/*
 * Decompiled with CFR 0.152.
 */
package org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.machine;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.handlers.SimpleBlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces.InventoryBlock;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.lins.mmmjjkx.rykenslimefuncustomizer.RykenSlimefunCustomizer;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.CustomMenu;

public class CustomMaterialGenerator
extends SlimefunItem
implements InventoryBlock,
EnergyNetComponent,
RecipeDisplayItem {
    private final int capacity;
    private final List<Integer> output;
    private final int tickRate;
    private final int statusSlot;
    private final List<ItemStack> generation;
    private final int per;
    private final List<Integer> chances;
    private final boolean chooseOne;
    private final Random RNG;

    public CustomMaterialGenerator(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, int capacity, List<Integer> output, int statusSlot, int tickRate, List<ItemStack> generation, CustomMenu menu, int per, List<Integer> chances, boolean chooseOne) {
        super(itemGroup, item, recipeType, recipe);
        this.capacity = capacity;
        this.output = output;
        this.statusSlot = statusSlot;
        this.tickRate = tickRate;
        this.generation = generation;
        this.per = per;
        this.chances = chances;
        this.chooseOne = chooseOne;
        this.RNG = new Random();
        this.addItemHandler(new ItemHandler[]{this.getBlockTicker()});
        this.addItemHandler(new ItemHandler[]{new SimpleBlockBreakHandler(){

            public void onBlockBreak(@NotNull Block block) {
                BlockMenu bm = BlockStorage.getInventory((Location)block.getLocation());
                if (bm != null) {
                    bm.dropItems(block.getLocation(), CustomMaterialGenerator.this.getOutputSlots());
                }
            }
        }});
        menu.addItem(statusSlot, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        this.createPreset(this, menu::apply);
        this.register(RykenSlimefunCustomizer.INSTANCE);
    }

    private void tick(Block b) {
        int progress = this.getProgress(b);
        BlockMenu blockMenu = BlockStorage.getInventory((Location)b.getLocation());
        if (blockMenu != null) {
            if (this.getCharge(b.getLocation()) >= this.per) {
                if (progress >= this.tickRate) {
                    this.setProgress(b, 1);
                    this.pushItems(blockMenu);
                } else {
                    this.addProgress(b);
                }
            } else if (this.statusSlot > -1) {
                blockMenu.replaceExistingItem(this.statusSlot, CustomItemStack.create((Material)Material.RED_STAINED_GLASS_PANE, (String)"&4No enough energy", (String[])new String[0]));
            }
        }
    }

    private void addProgress(Block b) {
        this.setProgress(b, this.getProgress(b) + 1);
    }

    private void setProgress(Block b, int progress) {
        BlockStorage.addBlockInfo((Location)b.getLocation(), (String)"progress", (String)String.valueOf(progress));
    }

    private int getProgress(Block b) {
        int progress;
        try {
            progress = Integer.parseInt(Objects.requireNonNull(BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"progress")));
        }
        catch (NullPointerException | NumberFormatException ex) {
            BlockStorage.addBlockInfo((Location)b.getLocation(), (String)"progress", (String)"1");
            progress = 0;
        }
        return progress;
    }

    @NotNull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int[] getInputSlots() {
        return new int[0];
    }

    public int[] getOutputSlots() {
        int[] output = new int[this.output.size()];
        for (int i = 0; i < this.output.size(); ++i) {
            output[i] = this.output.get(i);
        }
        return output;
    }

    public BlockTicker getBlockTicker() {
        return new BlockTicker(){

            public boolean isSynchronized() {
                return false;
            }

            public void tick(Block b, SlimefunItem item, Config data) {
                CustomMaterialGenerator.this.tick(b);
            }
        };
    }

    @NotNull
    public List<ItemStack> getDisplayRecipes() {
        ItemStack speed = CustomItemStack.create((Material)Material.KNOWLEDGE_BOOK, (String)"&a&lSpeed", Collections.singletonList("&a&lGenerates per &b&l" + this.tickRate + " &a&lticks once"));
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack gen : this.generation) {
            list.add(speed);
            list.add(gen.clone());
        }
        return list;
    }

    private void pushItems(BlockMenu blockMenu) {
        Block b = blockMenu.getBlock();
        List<ItemStack> generations = this.getMatchChanceResult();
        if (this.chooseOne && !generations.isEmpty()) {
            generations = Collections.singletonList(generations.get(this.RNG.nextInt(generations.size())));
        }
        for (ItemStack item : generations) {
            if (blockMenu.fits(item, this.getOutputSlots())) {
                if (blockMenu.hasViewer() && this.statusSlot > -1) {
                    blockMenu.replaceExistingItem(this.statusSlot, CustomItemStack.create((Material)Material.LIME_STAINED_GLASS_PANE, (String)"&aProducing", (String[])new String[0]));
                }
                blockMenu.pushItem(item.clone(), this.getOutputSlots());
                this.removeCharge(b.getLocation(), this.per);
                continue;
            }
            if (!blockMenu.hasViewer() || this.statusSlot <= -1) continue;
            blockMenu.replaceExistingItem(this.statusSlot, CustomItemStack.create((Material)Material.ORANGE_STAINED_GLASS_PANE, (String)"&cNo enough space", (String[])new String[0]));
        }
    }

    private List<ItemStack> getMatchChanceResult() {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (int i = 0; i < this.generation.size(); ++i) {
            ItemStack output = this.generation.get(i);
            int chance = this.chances.get(i);
            if (!this.matchChance(chance)) continue;
            itemStacks.add(output);
        }
        return itemStacks;
    }

    private boolean matchChance(Integer chance) {
        if (chance == null) {
            return false;
        }
        if (chance >= 100) {
            return true;
        }
        if (chance < 1) {
            return false;
        }
        int result = this.RNG.nextInt(100);
        return result < chance;
    }
}

