/*
 * Decompiled with CFR 0.152.
 */
package org.lins.mmmjjkx.rykenslimefuncustomizer.objects.script;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.Permission;
import java.security.Permissions;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import lombok.Generated;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.graalvm.polyglot.HostAccess;
import org.jetbrains.annotations.Nullable;
import org.lins.mmmjjkx.rykenslimefuncustomizer.RykenSlimefunCustomizer;
import org.lins.mmmjjkx.rykenslimefuncustomizer.libraries.colors.CMIChatColor;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.ProjectAddon;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.script.enhanced.NBTAPIIntegration;

public abstract class ScriptEval {
    protected final HostAccess UNIVERSAL_HOST_ACCESS = HostAccess.newBuilder().allowPublicAccess(true).allowAllImplementations(true).allowAllClassImplementations(true).allowArrayAccess(true).allowListAccess(true).allowBufferAccess(true).allowIterableAccess(true).allowIteratorAccess(true).allowMapAccess(true).allowAccessInheritance(true).targetTypeMapping(Double.class, Float.class, null, Double::floatValue).targetTypeMapping(Integer.class, Float.class, null, Integer::floatValue).targetTypeMapping(Boolean.class, String.class, null, String::valueOf).targetTypeMapping(Integer.class, String.class, null, String::valueOf).targetTypeMapping(Character.class, String.class, null, String::valueOf).targetTypeMapping(Long.class, String.class, null, String::valueOf).targetTypeMapping(Float.class, String.class, null, String::valueOf).targetTypeMapping(Double.class, String.class, null, String::valueOf).targetTypeMapping(Object.class, String.class, null, String::valueOf).denyAccess(System.class).denyAccess(Process.class).denyAccess(Runtime.class).denyAccess(ProcessBuilder.class).denyAccess(ClassLoader.class).denyAccess(Permission.class).denyAccess(Permissions.class).build();
    private final File file;
    private final ProjectAddon addon;
    private String fileContext;

    public ScriptEval(File file, ProjectAddon addon) {
        this.file = file;
        this.addon = addon;
        this.contextInit();
    }

    public abstract String key();

    protected void contextInit() {
        try {
            this.fileContext = Files.readString(this.file.toPath(), StandardCharsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            try {
                this.file.createNewFile();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            this.fileContext = "";
            e.printStackTrace();
        }
        catch (IOException e) {
            this.fileContext = "";
            e.printStackTrace();
        }
    }

    protected final void setup() {
        this.addThing("server", Bukkit.getServer());
        this.addThing("isPluginLoaded", s -> Bukkit.getPluginManager().isPluginEnabled(s));
        this.addThing("runOpCommand", (p, s) -> {
            boolean op = p.isOp();
            p.setOp(true);
            try {
                p.performCommand(this.parsePlaceholder((Player)p, (String)s));
            }
            finally {
                p.setOp(op);
            }
        });
        this.addThing("runConsoleCommand", s -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)this.parsePlaceholder(null, (String)s)));
        this.addThing("sendMessage", (p, s) -> p.sendMessage(CMIChatColor.translate(this.parsePlaceholder((Player)p, (String)s))));
        this.addThing("getSfItemById", SlimefunItem::getById);
        this.addThing("getSfItemByItem", SlimefunItem::getByItem);
        this.addThing("isItemSimilar", SlimefunUtils::isItemSimilar);
        this.addThing("isRadioactiveItem", SlimefunUtils::isRadioactive);
        this.addThing("isSoulbound", SlimefunUtils::isSoulbound);
        this.addThing("canPlayerUseItem", SlimefunUtils::canPlayerUseItem);
        this.addThing("randintA", i -> new Random().nextInt((int)i));
        this.addThing("randintB", (i, b) -> new Random().nextInt(b != false ? i + 1 : i));
        this.addThing("randintC", (start, end) -> {
            IntStream is = IntStream.range(start, end);
            Random random = new Random();
            int[] arr = is.toArray();
            return arr[random.nextInt(arr.length)];
        });
        this.addThing("randintD", (start, end, rangeClosed) -> {
            IntStream stream = rangeClosed != false ? IntStream.rangeClosed(start, end) : IntStream.range(start, end);
            Random random = new Random();
            int[] arr = stream.toArray();
            return arr[random.nextInt(arr.length)];
        });
        this.addThing("runLater", (r, l) -> {
            AtomicReference task = new AtomicReference();
            Bukkit.getScheduler().runTaskLater((Plugin)RykenSlimefunCustomizer.INSTANCE, t -> {
                r.apply(new Object[]{t});
                task.set(t);
            }, (long)l.intValue());
            return (BukkitTask)task.get();
        });
        this.addThing("runRepeating", (r, l, t) -> {
            AtomicReference task = new AtomicReference();
            Bukkit.getScheduler().runTaskTimer((Plugin)RykenSlimefunCustomizer.INSTANCE, ta -> {
                r.apply(new Object[]{ta});
                task.set(ta);
            }, (long)l.intValue(), (long)t.intValue());
            return (BukkitTask)task.get();
        });
        this.addThing("getAddonConfig", () -> {
            if (this.addon.getConfig() == null) {
                throw new RuntimeException("The addon does not have a config file!");
            }
            return this.addon.getConfig().config();
        });
        if (Bukkit.getPluginManager().isPluginEnabled("NBTAPI")) {
            this.addThing("NBTAPI", NBTAPIIntegration.instance);
        }
    }

    private String parsePlaceholder(@Nullable Player p, String text) {
        if (p != null) {
            text = text.replaceAll("%player%", p.getName());
        }
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            text = PlaceholderAPI.setPlaceholders((Player)p, (String)text);
        }
        return text;
    }

    public abstract void addThing(String var1, Object var2);

    public final void doInit() {
        if (this.fileContext == null || this.fileContext.isBlank()) {
            this.contextInit();
        }
        this.evalFunction("init", new Object[0]);
    }

    @CanIgnoreReturnValue
    @Nullable
    public abstract Object evalFunction(String var1, Object ... var2);

    public abstract void close();

    @Generated
    protected HostAccess getUNIVERSAL_HOST_ACCESS() {
        return this.UNIVERSAL_HOST_ACCESS;
    }

    @Generated
    protected File getFile() {
        return this.file;
    }

    @Generated
    protected ProjectAddon getAddon() {
        return this.addon;
    }

    @Generated
    protected String getFileContext() {
        return this.fileContext;
    }
}

