/*
 * Decompiled with CFR 0.152.
 */
package org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.inventory.ItemStack;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.ExceptionHandler;

public class LinkedOutput {
    private final ItemStack[] freeOutput;
    private final Map<Integer, ItemStack> linkedOutput;
    private final int[] freeChances;
    private final Map<Integer, Integer> linkedChances;

    public LinkedOutput(ItemStack[] freeOutput, Map<Integer, ItemStack> linkedOutput, int[] freeChances, Map<Integer, Integer> linkedChances) {
        this.freeOutput = freeOutput;
        this.linkedOutput = linkedOutput;
        this.freeChances = freeChances;
        this.linkedChances = linkedChances;
    }

    public ItemStack[] toArray() {
        ItemStack[] result = new ItemStack[this.freeOutput.length + this.linkedOutput.size()];
        System.arraycopy(this.freeOutput, 0, result, 0, this.freeOutput.length);
        int i = this.freeOutput.length;
        Iterator<ItemStack> iterator = this.linkedOutput.values().iterator();
        while (iterator.hasNext()) {
            ItemStack item;
            result[i] = item = iterator.next();
            ++i;
        }
        return result;
    }

    public List<Integer> chancesToArray() {
        ArrayList<Integer> result = new ArrayList<Integer>(this.freeChances.length + this.linkedChances.size());
        for (int chance : this.freeChances) {
            result.add(chance);
        }
        result.addAll(this.linkedChances.values());
        return result;
    }

    public void log() {
        for (int i = 0; i < this.freeOutput.length; ++i) {
            ItemStack item = this.freeOutput[i];
            ExceptionHandler.info("FreeOutput: " + i + " Item: " + String.valueOf(item));
        }
        for (int slot : this.linkedOutput.keySet()) {
            ItemStack item = this.linkedOutput.get(slot);
            ExceptionHandler.info("LinkedOutput: " + slot + " Item: " + String.valueOf(item) + " Slot: " + slot);
        }
    }

    @Generated
    public ItemStack[] getFreeOutput() {
        return this.freeOutput;
    }

    @Generated
    public Map<Integer, ItemStack> getLinkedOutput() {
        return this.linkedOutput;
    }

    @Generated
    public int[] getFreeChances() {
        return this.freeChances;
    }

    @Generated
    public Map<Integer, Integer> getLinkedChances() {
        return this.linkedChances;
    }
}

