/*
 * Decompiled with CFR 0.152.
 */
package org.lins.mmmjjkx.rykenslimefuncustomizer.listeners;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.guide.GuideHistory;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.guide.SurvivalSlimefunGuide;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.lins.mmmjjkx.rykenslimefuncustomizer.RykenSlimefunCustomizer;
import org.lins.mmmjjkx.rykenslimefuncustomizer.libraries.colors.CMIChatColor;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.CustomMenu;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.LinkedOutput;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.machine.CustomLinkedRecipeMachine;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.machine.CustomRecipeMachine;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.machine.CustomTemplateMachine;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.machine.CustomWorkbench;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.machine.CustomLinkedMachineRecipe;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.machine.CustomMachineRecipe;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.machine.MachineTemplate;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.slimefun.AsyncChanceRecipeTask;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.CommonUtils;

public class SingleItemRecipeGuideListener
implements Listener {
    private static final NamespacedKey RECIPE_KEY = new NamespacedKey((Plugin)RykenSlimefunCustomizer.INSTANCE, "rsc_recipe");
    private static final NamespacedKey RECIPE_INDEX_KEY = new NamespacedKey((Plugin)RykenSlimefunCustomizer.INSTANCE, "rsc_recipe_index");
    private static final NamespacedKey RECIPE_TEMPLATE_INDEX_KEY = new NamespacedKey((Plugin)RykenSlimefunCustomizer.INSTANCE, "rsc_recipe_template_index");

    public SingleItemRecipeGuideListener() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)RykenSlimefunCustomizer.INSTANCE);
    }

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        ChestMenu menu;
        SlimefunItem sfItemObj;
        ItemStack sfItem;
        PersistentDataContainer pdc;
        Integer index;
        Player p = (Player)e.getWhoClicked();
        Inventory inv = e.getInventory();
        ItemStack item = e.getCurrentItem();
        if (SingleItemRecipeGuideListener.isTaggedItem(item) && (index = (Integer)(pdc = item.getItemMeta().getPersistentDataContainer()).get(RECIPE_INDEX_KEY, PersistentDataType.INTEGER)) != null && index >= 0 && (sfItem = inv.getItem(16)) != null && (sfItemObj = SlimefunItem.getByItem((ItemStack)sfItem)) != null && (menu = this.createGUI(p, sfItemObj, (PersistentDataHolder)item.getItemMeta())) != null) {
            menu.open(new Player[]{p});
        }
    }

    private static boolean isTaggedItem(ItemStack item) {
        if (item == null || item.getItemMeta() == null) {
            return false;
        }
        PersistentDataContainer pdc = item.getItemMeta().getPersistentDataContainer();
        return pdc.getKeys().contains(RECIPE_KEY) && pdc.getKeys().contains(RECIPE_INDEX_KEY);
    }

    public static ItemStack tagItemRecipe(ItemStack item, int index) {
        item = item.clone();
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        pdc.set(RECIPE_KEY, PersistentDataType.INTEGER, (Object)1);
        pdc.set(RECIPE_INDEX_KEY, PersistentDataType.INTEGER, (Object)index);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack tagItemTemplateRecipe(ItemStack item, int templateIndex, int recipeIndex) {
        item = item.clone();
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        pdc.set(RECIPE_KEY, PersistentDataType.INTEGER, (Object)2);
        pdc.set(RECIPE_INDEX_KEY, PersistentDataType.INTEGER, (Object)recipeIndex);
        pdc.set(RECIPE_TEMPLATE_INDEX_KEY, PersistentDataType.INTEGER, (Object)templateIndex);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack tagItemLinkedRecipe(ItemStack item, int recipeIndex) {
        item = item.clone();
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        pdc.set(RECIPE_KEY, PersistentDataType.INTEGER, (Object)3);
        pdc.set(RECIPE_INDEX_KEY, PersistentDataType.INTEGER, (Object)recipeIndex);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack tagItemWorkbenchRecipe(ItemStack item, int index) {
        item = item.clone();
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        pdc.set(RECIPE_KEY, PersistentDataType.INTEGER, (Object)4);
        pdc.set(RECIPE_INDEX_KEY, PersistentDataType.INTEGER, (Object)index);
        item.setItemMeta(meta);
        return item;
    }

    private ChestMenu createGUI(Player p, SlimefunItem machine, PersistentDataHolder holder) {
        int type = PersistentDataAPI.getInt((PersistentDataHolder)holder, (NamespacedKey)RECIPE_KEY, (int)1);
        if (machine instanceof AContainer) {
            AContainer ac = (AContainer)machine;
            if (type == 1) {
                int index = PersistentDataAPI.getInt((PersistentDataHolder)holder, (NamespacedKey)RECIPE_INDEX_KEY, (int)0);
                return new RecipeMenu(ac, p, index);
            }
        }
        if (machine instanceof CustomTemplateMachine) {
            CustomTemplateMachine ctm = (CustomTemplateMachine)machine;
            if (type == 2) {
                int templateIndex = PersistentDataAPI.getInt((PersistentDataHolder)holder, (NamespacedKey)RECIPE_TEMPLATE_INDEX_KEY, (int)0);
                int recipeIndex = PersistentDataAPI.getInt((PersistentDataHolder)holder, (NamespacedKey)RECIPE_INDEX_KEY, (int)0);
                return new TemplateRecipeMenu(ctm, p, templateIndex, recipeIndex);
            }
        }
        if (machine instanceof CustomLinkedRecipeMachine) {
            CustomLinkedRecipeMachine clrm = (CustomLinkedRecipeMachine)machine;
            if (type == 3) {
                int recipeIndex = PersistentDataAPI.getInt((PersistentDataHolder)holder, (NamespacedKey)RECIPE_INDEX_KEY, (int)0);
                return new LinkedRecipeMenu(clrm, p, recipeIndex);
            }
        }
        if (machine instanceof CustomWorkbench) {
            CustomWorkbench cw = (CustomWorkbench)machine;
            if (type == 4) {
                int index = PersistentDataAPI.getInt((PersistentDataHolder)holder, (NamespacedKey)RECIPE_INDEX_KEY, (int)0);
                return new WorkbenchRecipeMenu(cw, p, index);
            }
        }
        return null;
    }

    private static class RecipeMenu
    extends ChestMenu {
        private final AsyncChanceRecipeTask recipeTask = new AsyncChanceRecipeTask();

        /*
         * WARNING - void declaration
         */
        public RecipeMenu(AContainer item, Player p, int index) {
            super(Slimefun.getLocalization().getMessage(p, "guide.title.main"));
            Object menu;
            Optional profile = PlayerProfile.find((OfflinePlayer)p);
            this.setEmptySlotsClickable(false);
            this.setPlayerInventoryClickable(false);
            boolean defaultRecipeGUI = true;
            int progressSlot = 31;
            ItemStack progressBar = item.getProgressBar();
            int[] inputSlots = item.getInputSlots();
            int[] outputSlots = item.getOutputSlots();
            if (item instanceof CustomRecipeMachine) {
                CustomRecipeMachine crm = (CustomRecipeMachine)item;
                menu = crm.getMenu();
                if (menu != null) {
                    defaultRecipeGUI = false;
                    progressSlot = ((CustomMenu)menu).getProgressSlot();
                    if (((CustomMenu)menu).getProgressBarItem() != null) {
                        progressBar = ((CustomMenu)menu).getProgressBarItem();
                    }
                }
            } else {
                inputSlots = new int[]{28, 29};
                outputSlots = new int[]{33, 34};
            }
            BlockMenuPreset preset = (BlockMenuPreset)Slimefun.getRegistry().getMenuPresets().get(item.getId());
            if (preset == null) {
                return;
            }
            if (!defaultRecipeGUI) {
                menu = preset.getPresetSlots().iterator();
                while (menu.hasNext()) {
                    int slot = (Integer)menu.next();
                    ItemStack itemStack = preset.getItemInSlot(slot);
                    if (itemStack == null) continue;
                    this.addItem(slot, itemStack, (pl, s, is, action) -> false);
                }
            }
            if (defaultRecipeGUI) {
                void var16_32;
                int[] nArray;
                int[] inputBorderSlots;
                int background22;
                int[] backgroundSlots;
                for (int background22 : backgroundSlots = new int[]{1, 2, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 22, 31, 40, 45, 46, 47, 48, 49, 50, 51, 52, 53}) {
                    this.addItem(background22, ChestMenuUtils.getBackground(), (pl, s, is, action) -> false);
                }
                for (int n : inputBorderSlots = new int[]{18, 19, 20, 21, 27, 30, 36, 37, 38, 39}) {
                    this.addItem(n, ChestMenuUtils.getInputSlotTexture(), (pl, s, is, action) -> false);
                }
                int[] nArray2 = nArray = new int[]{23, 24, 25, 26, 32, 35, 41, 42, 43, 44};
                background22 = nArray2.length;
                boolean bl = false;
                while (var16_32 < background22) {
                    int outputBackground = nArray2[var16_32];
                    this.addItem(outputBackground, ChestMenuUtils.getOutputSlotTexture(), (pl, s, is, action) -> false);
                    ++var16_32;
                }
                profile.ifPresent(prof -> this.addItem(0, ChestMenuUtils.getBackButton((Player)p, (String[])new String[]{"", "&fLeft click: &7back to previous page", "&fShift + left click: &7back to the main menu"}), (pl, s, is, action) -> {
                    SurvivalSlimefunGuide guide = new SurvivalSlimefunGuide(false, false);
                    GuideHistory history = prof.getGuideHistory();
                    if (action.isShiftClicked()) {
                        guide.openMainMenu(prof, history.getMainMenuPage());
                    } else {
                        history.goBack((SlimefunGuideImplementation)guide);
                    }
                    return false;
                }));
            }
            List recipes = item.getMachineRecipes();
            MachineRecipe recipe = (MachineRecipe)recipes.get(index);
            ItemStack[] itemStackArray = recipe.getInput();
            for (int i = 0; i < itemStackArray.length; ++i) {
                ItemStack inputItem = itemStackArray[i];
                if (inputItem == null) continue;
                this.addItem(inputSlots[i], inputItem, (pl, s, is, action) -> false);
            }
            if (recipe instanceof CustomMachineRecipe) {
                CustomMachineRecipe rmr = (CustomMachineRecipe)recipe;
                int outputSlot = outputSlots[0];
                ItemStack[] itemStackArray2 = recipe.getOutput();
                if (rmr.isChooseOneIfHas()) {
                    ArrayList<ItemStack> taggedChanceOutputs = new ArrayList<ItemStack>();
                    for (int i = 0; i < itemStackArray2.length; ++i) {
                        Integer chance = rmr.getChances().get(i);
                        ItemStack output = itemStackArray2[i];
                        if (chance == null || chance <= 0 || output == null) continue;
                        taggedChanceOutputs.add(this.tagOutputChance(output, chance));
                    }
                    this.recipeTask.add(outputSlot, taggedChanceOutputs);
                    this.addMenuClickHandler(outputSlot, (pl, s, is, action) -> false);
                } else {
                    List<Integer> chances = rmr.getChances();
                    for (int i = 0; i < itemStackArray2.length; ++i) {
                        int chance = chances.get(i);
                        ItemStack originalOutput = itemStackArray2[i];
                        if (originalOutput == null) continue;
                        ItemStack chanceOutput = originalOutput.clone();
                        if (chance < 100) {
                            CommonUtils.addLore(chanceOutput, true, CMIChatColor.translate("&aThere's a &b " + chance + "% &aprobability of producing"));
                        }
                        if (chance <= 0) continue;
                        this.addItem(outputSlots[i], chanceOutput, (pl, s, is, action) -> false);
                    }
                }
            } else {
                for (int i = 0; i < outputSlots.length; ++i) {
                    ItemStack itemStack = recipe.getOutput()[i];
                    if (itemStack == null) continue;
                    this.addItem(outputSlots[i], itemStack, (pl, s, is, action) -> false);
                }
            }
            int seconds = recipe.getTicks() / 2;
            Object rawName = "&eProduction time: &b" + seconds + "&es";
            if (seconds > 60) {
                rawName = ((String)rawName).concat("(" + CommonUtils.formatSeconds(seconds) + "&e)");
            }
            progressBar = CustomItemStack.create((ItemStack)progressBar, (String)rawName, (String[])new String[0]);
            this.addItem(progressSlot, progressBar, (pl, s, is, action) -> false);
        }

        public void open(Player ... players) {
            super.open(players);
            if (!this.recipeTask.isEmpty()) {
                this.recipeTask.start(this.toInventory());
            }
        }

        private ItemStack tagOutputChance(ItemStack item, int chance) {
            item = item.clone();
            CommonUtils.addLore(item, true, CMIChatColor.translate("&aThere's a &b " + chance + "% &aprobability of producing"));
            return item;
        }
    }

    private static class TemplateRecipeMenu
    extends ChestMenu {
        private final AsyncChanceRecipeTask recipeTask = new AsyncChanceRecipeTask();

        public TemplateRecipeMenu(CustomTemplateMachine ctm, Player p, int templateIndex, int recipeIndex) {
            super(Slimefun.getLocalization().getMessage(p, "guide.title.main"));
            this.setEmptySlotsClickable(false);
            this.setPlayerInventoryClickable(false);
            CustomMenu menu = ctm.getMenu();
            for (int i2 = 0; i2 < 54; ++i2) {
                ItemStack item = menu.getItems().get(i2);
                if (item == null) continue;
                this.addItem(i2, item, (pl, s, is, action) -> false);
            }
            int maxSlot = menu.getSize() - 1;
            if (maxSlot > 0) {
                this.addItem(maxSlot, new ItemStack(Material.AIR), (player, i, itemStack, clickAction) -> false);
            }
            int[] inputSlots = ctm.getInputSlots();
            int[] outputSlots = ctm.getOutputSlots();
            int progressSlot = menu.getProgressSlot();
            ItemStack progressBar = menu.getProgressBarItem();
            int templateSlot = ctm.getTemplateSlot();
            MachineTemplate template = ctm.getTemplates().get(templateIndex);
            if (template == null) {
                return;
            }
            CustomMachineRecipe recipe = template.recipes().get(recipeIndex);
            if (recipe == null) {
                return;
            }
            int seconds = recipe.getTicks() / 2;
            ItemStack templateItem = template.template().clone();
            CommonUtils.addLore(templateItem, true, "&d&l&o*Template item doesn't consuming*");
            this.addItem(templateSlot, templateItem, (pl, s, is, action) -> false);
            if (inputSlots.length != 0 && recipe.getInput().length != 0) {
                for (int i3 = 0; i3 < inputSlots.length && i3 < recipe.getInput().length; ++i3) {
                    ItemStack inputItem = recipe.getInput()[i3];
                    if (inputItem == null) continue;
                    this.addItem(inputSlots[i3], inputItem.clone(), (pl, s, is, action) -> false);
                }
            }
            ItemStack[] outputs = recipe.getOutput();
            if (recipe.isChooseOneIfHas()) {
                ArrayList<ItemStack> taggedChanceOutputs = new ArrayList<ItemStack>();
                for (int i4 = 0; i4 < outputs.length; ++i4) {
                    Integer chance = recipe.getChances().get(i4);
                    ItemStack output = outputs[i4];
                    if (chance == null || chance <= 0 || output == null) continue;
                    taggedChanceOutputs.add(this.tagOutputChance(output, chance));
                }
                this.recipeTask.add(outputSlots[0], taggedChanceOutputs);
                this.addMenuClickHandler(outputSlots[0], (pl, s, is, action) -> false);
            } else {
                List<Integer> chances = recipe.getChances();
                for (int i5 = 0; i5 < outputSlots.length; ++i5) {
                    if (i5 >= outputs.length) {
                        return;
                    }
                    int chance = chances.get(i5);
                    ItemStack originalOutput = outputs[i5];
                    if (originalOutput == null) continue;
                    ItemStack chanceOutput = originalOutput.clone();
                    if (chance < 100) {
                        CommonUtils.addLore(chanceOutput, true, CMIChatColor.translate("&aThere's a &b " + chance + "% &aprobability of producing"));
                    }
                    if (chance <= 0) continue;
                    this.addItem(outputSlots[i5], chanceOutput, (pl, s, is, action) -> false);
                }
            }
            if (progressSlot >= 0 && progressBar != null) {
                Object rawName = "&eProduction time: &b" + seconds + "&es";
                if (seconds > 60) {
                    rawName = ((String)rawName).concat("(" + CommonUtils.formatSeconds(seconds) + "&e)");
                }
                progressBar = CustomItemStack.create((ItemStack)progressBar, (String)rawName, (String[])new String[0]);
                this.addItem(progressSlot, progressBar, (pl, s, is, action) -> false);
            }
        }

        public void open(Player ... players) {
            super.open(players);
            if (!this.recipeTask.isEmpty()) {
                this.recipeTask.start(this.toInventory());
            }
        }

        private ItemStack tagOutputChance(ItemStack item, int chance) {
            item = item.clone();
            CommonUtils.addLore(item, true, CMIChatColor.translate("&aThere's a &b " + chance + "% &aprobability of producing"));
            return item;
        }
    }

    private static class LinkedRecipeMenu
    extends ChestMenu {
        private final AsyncChanceRecipeTask recipeTask = new AsyncChanceRecipeTask();

        /*
         * WARNING - void declaration
         */
        public LinkedRecipeMenu(AContainer item, Player p, int index) {
            super(Slimefun.getLocalization().getMessage(p, "guide.title.main"));
            List recipes;
            MachineRecipe recipe;
            Object menu;
            Optional profile = PlayerProfile.find((OfflinePlayer)p);
            this.setEmptySlotsClickable(false);
            this.setPlayerInventoryClickable(false);
            boolean defaultRecipeGUI = true;
            int progressSlot = 31;
            ItemStack progressBar = item.getProgressBar();
            int[] inputSlots = item.getInputSlots();
            int[] outputSlots = item.getOutputSlots();
            if (item instanceof CustomLinkedRecipeMachine) {
                CustomLinkedRecipeMachine clrm = (CustomLinkedRecipeMachine)item;
                menu = clrm.getMenu();
                if (menu != null) {
                    defaultRecipeGUI = false;
                    progressSlot = ((CustomMenu)menu).getProgressSlot();
                    if (((CustomMenu)menu).getProgressBarItem() != null) {
                        progressBar = ((CustomMenu)menu).getProgressBarItem();
                    }
                }
            } else {
                inputSlots = new int[]{28, 29};
                outputSlots = new int[]{33, 34};
            }
            BlockMenuPreset preset = (BlockMenuPreset)Slimefun.getRegistry().getMenuPresets().get(item.getId());
            if (preset == null) {
                return;
            }
            if (!defaultRecipeGUI) {
                menu = preset.getPresetSlots().iterator();
                while (menu.hasNext()) {
                    int slot = (Integer)menu.next();
                    ItemStack itemStack = preset.getItemInSlot(slot);
                    if (itemStack == null) continue;
                    this.addItem(slot, itemStack, (pl, s, is, action) -> false);
                }
            }
            if (defaultRecipeGUI) {
                void var16_30;
                int[] nArray;
                int[] inputBorderSlots;
                int background22;
                int[] backgroundSlots;
                for (int background22 : backgroundSlots = new int[]{1, 2, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 22, 31, 40, 45, 46, 47, 48, 49, 50, 51, 52, 53}) {
                    this.addItem(background22, ChestMenuUtils.getBackground(), (pl, s, is, action) -> false);
                }
                for (int n : inputBorderSlots = new int[]{18, 19, 20, 21, 27, 30, 36, 37, 38, 39}) {
                    this.addItem(n, ChestMenuUtils.getInputSlotTexture(), (pl, s, is, action) -> false);
                }
                int[] nArray2 = nArray = new int[]{23, 24, 25, 26, 32, 35, 41, 42, 43, 44};
                background22 = nArray2.length;
                boolean bl = false;
                while (var16_30 < background22) {
                    int outputBackground = nArray2[var16_30];
                    this.addItem(outputBackground, ChestMenuUtils.getOutputSlotTexture(), (pl, s, is, action) -> false);
                    ++var16_30;
                }
                profile.ifPresent(prof -> this.addItem(0, ChestMenuUtils.getBackButton((Player)p, (String[])new String[]{"", "&fLeft click: &7back to previous page", "&fShift + left click: &7back to the main menu"}), (pl, s, is, action) -> {
                    SurvivalSlimefunGuide guide = new SurvivalSlimefunGuide(false, false);
                    GuideHistory history = prof.getGuideHistory();
                    if (action.isShiftClicked()) {
                        guide.openMainMenu(prof, history.getMainMenuPage());
                    } else {
                        history.goBack((SlimefunGuideImplementation)guide);
                    }
                    return false;
                }));
            }
            if ((recipe = (MachineRecipe)(recipes = item.getMachineRecipes()).get(index)) instanceof CustomLinkedMachineRecipe) {
                CustomLinkedMachineRecipe customLinkedMachineRecipe = (CustomLinkedMachineRecipe)recipe;
                Map<Integer, ItemStack> linkedInput = customLinkedMachineRecipe.getLinkedInput();
                for (int n : linkedInput.keySet()) {
                    ItemStack inputItem = linkedInput.get(n);
                    if (inputItem == null) continue;
                    this.addItem(n, inputItem.clone(), (pl, s, is, action) -> false);
                }
                int outputSlot = outputSlots[0];
                ItemStack[] itemStackArray = recipe.getOutput();
                if (customLinkedMachineRecipe.isChooseOneIfHas()) {
                    ArrayList<ItemStack> taggedChanceOutputs = new ArrayList<ItemStack>();
                    for (int i = 0; i < itemStackArray.length; ++i) {
                        Integer chance = customLinkedMachineRecipe.getChances().get(i);
                        ItemStack output = itemStackArray[i];
                        if (chance == null || chance <= 0 || output == null) continue;
                        taggedChanceOutputs.add(this.tagOutputChance(output, chance));
                    }
                    this.recipeTask.add(outputSlot, taggedChanceOutputs);
                    this.addMenuClickHandler(outputSlot, (pl, s, is, action) -> false);
                } else {
                    List<Integer> chances = customLinkedMachineRecipe.getChances();
                    for (int i = 0; i < itemStackArray.length; ++i) {
                        int chance = chances.get(i);
                        ItemStack originalOutput = itemStackArray[i];
                        if (originalOutput == null) continue;
                        ItemStack chanceOutput = originalOutput.clone();
                        if (chance < 100) {
                            CommonUtils.addLore(chanceOutput, true, CMIChatColor.translate("&b" + chance + "% &achance of &aproducing"));
                        }
                        if (chance <= 0) continue;
                        this.addItem(outputSlots[i], chanceOutput, (pl, s, is, action) -> false);
                    }
                }
            } else {
                int i;
                ItemStack[] input = recipe.getInput();
                for (i = 0; i < input.length; ++i) {
                    ItemStack itemStack = input[i];
                    if (itemStack == null) continue;
                    this.addItem(inputSlots[i], itemStack, (pl, s, is, action) -> false);
                }
                for (i = 0; i < outputSlots.length; ++i) {
                    ItemStack itemStack = recipe.getOutput()[i];
                    if (itemStack == null) continue;
                    this.addItem(outputSlots[i], itemStack, (pl, s, is, action) -> false);
                }
            }
            int n = recipe.getTicks() / 2;
            Object rawName = "&eProduction time: &b" + n + "&es";
            if (n > 60) {
                rawName = ((String)rawName).concat("(" + CommonUtils.formatSeconds(n) + "&e)");
            }
            progressBar = CustomItemStack.create((ItemStack)progressBar, (String)rawName, (String[])new String[0]);
            this.addItem(progressSlot, progressBar, (pl, s, is, action) -> false);
        }

        public void open(Player ... players) {
            super.open(players);
            if (!this.recipeTask.isEmpty()) {
                this.recipeTask.start(this.toInventory());
            }
        }

        private ItemStack tagOutputChance(ItemStack item, int chance) {
            item = item.clone();
            CommonUtils.addLore(item, true, CMIChatColor.translate("&aThere's a &b " + chance + "% &aprobability of producing"));
            return item;
        }
    }

    private static class WorkbenchRecipeMenu
    extends ChestMenu {
        private final AsyncChanceRecipeTask recipeTask = new AsyncChanceRecipeTask();

        public WorkbenchRecipeMenu(AContainer item, Player p, int index) {
            super(Slimefun.getLocalization().getMessage(p, "guide.title.main"));
            CustomWorkbench cw;
            CustomMenu menu;
            this.setEmptySlotsClickable(false);
            this.setPlayerInventoryClickable(false);
            int[] outputSlots = item.getOutputSlots();
            if (item instanceof CustomWorkbench && (menu = (cw = (CustomWorkbench)item).getMenu()) != null) {
                Object itemStack;
                BlockMenuPreset preset = (BlockMenuPreset)Slimefun.getRegistry().getMenuPresets().get(item.getId());
                Iterator iterator = preset.getPresetSlots().iterator();
                while (iterator.hasNext()) {
                    int slot = (Integer)iterator.next();
                    itemStack = preset.getItemInSlot(slot);
                    if (itemStack == null || itemStack.getType() == Material.AIR) continue;
                    this.addItem(slot, (ItemStack)itemStack, (pl, s, is, action) -> false);
                }
                CustomLinkedMachineRecipe recipe = (CustomLinkedMachineRecipe)((Object)cw.getMachineRecipes().get(index));
                Map<Integer, ItemStack> linkedInput = recipe.getLinkedInput();
                itemStack = linkedInput.keySet().iterator();
                while (itemStack.hasNext()) {
                    int slot = (Integer)itemStack.next();
                    this.addItem(slot, linkedInput.get(slot).clone(), (pl, s, is, action) -> false);
                }
                LinkedOutput linkedOutput = recipe.getLinkedOutput();
                Map<Integer, Integer> chanceMap = linkedOutput.getLinkedChances();
                Map<Integer, ItemStack> outputMap = linkedOutput.getLinkedOutput();
                ItemStack[] itemStackArray = outputMap.keySet().iterator();
                while (itemStackArray.hasNext()) {
                    int slot = itemStackArray.next();
                    if (chanceMap.containsKey(slot)) {
                        int chance = chanceMap.get(slot);
                        ItemStack output = outputMap.get(slot);
                        if (output == null || output.getType() == Material.AIR) continue;
                        ItemStack chanceOutput = output.clone();
                        if (chance < 100) {
                            CommonUtils.addLore(chanceOutput, true, CMIChatColor.translate("&aThere's a &b " + chance + "% &aprobability of producing"));
                        }
                        if (chance <= 0) continue;
                        this.addItem(slot, chanceOutput, (pl, s, is, action) -> false);
                        continue;
                    }
                    this.addItem(slot, outputMap.get(slot).clone(), (pl, s, is, action) -> false);
                }
                block3: for (ItemStack itemStack2 : linkedOutput.getFreeOutput()) {
                    for (int slot : outputSlots) {
                        ItemStack existing = this.getItemInSlot(slot);
                        if (existing != null && existing.getType() != Material.AIR) continue;
                        this.addItem(slot, itemStack2.clone(), (pl, s, is, action) -> false);
                        continue block3;
                    }
                }
            }
        }

        public void open(Player ... players) {
            super.open(players);
            if (!this.recipeTask.isEmpty()) {
                this.recipeTask.start(this.toInventory());
            }
        }

        private ItemStack tagOutputChance(ItemStack item, int chance) {
            item = item.clone();
            CommonUtils.addLore(item, true, CMIChatColor.translate("&aThere's a &b " + chance + "% &aprobability of producing"));
            return item;
        }
    }
}

