/*
 * Decompiled with CFR 0.152.
 */
package org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.machine;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.MachineProcessHolder;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineOperation;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineProcessor;
import io.github.thebusybiscuit.slimefun4.implementation.handlers.SimpleBlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.implementation.operations.CraftingOperation;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lins.mmmjjkx.rykenslimefuncustomizer.RykenSlimefunCustomizer;
import org.lins.mmmjjkx.rykenslimefuncustomizer.listeners.SingleItemRecipeGuideListener;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.CustomMenu;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.machine.CustomCraftingOperation;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.machine.CustomMachineRecipe;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.CommonUtils;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.ExceptionHandler;

public class CustomRecipeMachine
extends AContainer
implements RecipeDisplayItem {
    private final MachineProcessor<CraftingOperation> processor = new MachineProcessor((MachineProcessHolder)this);
    private final int[] input;
    private final int[] output;
    private final List<CustomMachineRecipe> raw_recipes;
    private final List<CustomMachineRecipe> recipes;
    private final int energyPerCraft;
    private final int capacity;
    private final boolean hideAllRecipes;
    public static final ItemStack RECIPE_INPUT = CustomItemStack.create((Material)Material.GREEN_STAINED_GLASS_PANE, (String)"&aMulti-Item Input", (String[])new String[]{"", "&2> &aClick to view"});
    public static final ItemStack RECIPE_OUTPUT = CustomItemStack.create((Material)Material.GREEN_STAINED_GLASS_PANE, (String)"&aMulti-Item Output", (String[])new String[]{"", "&2> &aClick to view"});
    @Nullable
    private final CustomMenu menu;

    public CustomRecipeMachine(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, int[] input, int[] output, List<CustomMachineRecipe> recipes, int energyPerCraft, int capacity, @Nullable CustomMenu menu, int speed, boolean hideAllRecipes) {
        super(itemGroup, item, recipeType, recipe);
        this.input = input;
        this.output = output;
        this.raw_recipes = recipes;
        this.recipes = new ArrayList<CustomMachineRecipe>(this.raw_recipes.stream().filter(r -> !r.isForDisplay()).toList());
        this.energyPerCraft = energyPerCraft;
        this.capacity = capacity;
        this.menu = menu;
        this.hideAllRecipes = hideAllRecipes;
        if (menu == null) {
            ExceptionHandler.handleWarning("Cannot find menu for " + item.getItemId() + " . Will use the default one.");
            this.createPreset((SlimefunItem)this, this.getInventoryTitle(), x$0 -> super.constructMenu(x$0));
        }
        if (menu != null) {
            this.processor.setProgressBar(menu.getProgressBarItem());
            this.createPreset((SlimefunItem)this, menu::apply);
        }
        this.setProcessingSpeed(speed);
        this.setCapacity(capacity);
        this.setEnergyConsumption(energyPerCraft);
        this.register(RykenSlimefunCustomizer.INSTANCE);
    }

    @NotNull
    protected BlockBreakHandler onBlockBreak() {
        return new SimpleBlockBreakHandler(){

            public void onBlockBreak(@NotNull Block b) {
                BlockMenu inv = BlockStorage.getInventory((Block)b);
                if (inv != null) {
                    inv.dropItems(b.getLocation(), CustomRecipeMachine.this.getInputSlots());
                    inv.dropItems(b.getLocation(), CustomRecipeMachine.this.getOutputSlots());
                }
                CustomRecipeMachine.this.processor.endOperation(b);
            }
        };
    }

    protected void registerDefaultRecipes() {
        if (this.recipes == null || this.recipes.isEmpty()) {
            return;
        }
        this.recipes.forEach(x$0 -> super.registerRecipe(x$0));
    }

    public int getEnergyConsumption() {
        return this.energyPerCraft;
    }

    @NotNull
    public MachineProcessor<CraftingOperation> getMachineProcessor() {
        return this.processor;
    }

    public ItemStack getProgressBar() {
        return new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
    }

    @NotNull
    public List<ItemStack> getDisplayRecipes() {
        ArrayList<ItemStack> displayRecipes = new ArrayList<ItemStack>();
        if (this.hideAllRecipes) {
            return displayRecipes;
        }
        int i = 0;
        for (CustomMachineRecipe recipe : this.raw_recipes) {
            if (recipe.isHide()) continue;
            ItemStack[] input = recipe.getInput();
            ItemStack[] output = recipe.getOutput();
            if (input.length == 1) {
                displayRecipes.add(input[0]);
            } else {
                ItemStack in = SingleItemRecipeGuideListener.tagItemRecipe(RECIPE_INPUT, i);
                displayRecipes.add(in);
            }
            if (output.length == 1) {
                int seconds = recipe.getTicks() / 2;
                ItemStack out = output[0].clone();
                Object rawLore = "&eProduction Time: &b" + seconds + "&es";
                if (seconds > 60) {
                    rawLore = ((String)rawLore).concat("(" + CommonUtils.formatSeconds(seconds) + "&e)");
                }
                CommonUtils.addLore(out, true, new String[]{rawLore});
                displayRecipes.add(out);
            } else {
                ItemStack out = SingleItemRecipeGuideListener.tagItemRecipe(RECIPE_OUTPUT, i);
                displayRecipes.add(out);
            }
            ++i;
        }
        return displayRecipes;
    }

    public int[] getInputSlots() {
        return this.input;
    }

    public int[] getOutputSlots() {
        return this.output;
    }

    public int getCapacity() {
        return this.capacity;
    }

    @NotNull
    public String getMachineIdentifier() {
        return this.getId();
    }

    protected void constructMenu(BlockMenuPreset preset) {
    }

    protected void tick(Block b) {
        int progressSlot;
        BlockMenu inv = BlockStorage.getInventory((Block)b);
        CustomCraftingOperation currentOperation = (CustomCraftingOperation)this.processor.getOperation(b);
        int n = progressSlot = this.menu == null || this.menu.getProgressSlot() == -1 ? 22 : this.menu.getProgressSlot();
        if (inv != null) {
            if (currentOperation != null) {
                if (this.takeCharge(b.getLocation())) {
                    if (!currentOperation.isFinished()) {
                        this.processor.updateProgressBar(inv, progressSlot, (MachineOperation)currentOperation);
                        currentOperation.addProgress(1);
                    } else {
                        CustomMachineRecipe currentRecipe = currentOperation.getRecipe();
                        if (currentRecipe != null) {
                            int index;
                            ItemStack is;
                            ItemStack[] outputs = (ItemStack[])currentRecipe.getMatchChanceResult().toArray(ItemStack[]::new);
                            if (!currentRecipe.isChooseOneIfHas()) {
                                for (ItemStack o : outputs) {
                                    if (o == null) continue;
                                    inv.pushItem(o.clone(), this.getOutputSlots());
                                }
                            } else if (outputs.length > 0 && (is = outputs[index = new SecureRandom().nextInt(outputs.length)]) != null) {
                                inv.pushItem(is.clone(), this.getOutputSlots());
                            }
                        }
                        ItemStack progress = this.menu == null ? ChestMenuUtils.getBackground() : this.menu.getItems().getOrDefault(progressSlot, ChestMenuUtils.getBackground());
                        inv.replaceExistingItem(progressSlot, progress);
                        this.processor.endOperation(b);
                    }
                }
            } else {
                MachineRecipe next = this.findNextRecipe(inv);
                if (next != null) {
                    CustomMachineRecipe currentRecipe = (CustomMachineRecipe)next;
                    currentOperation = new CustomCraftingOperation(currentRecipe);
                    this.processor.startOperation(b, (MachineOperation)currentOperation);
                    this.processor.updateProgressBar(inv, progressSlot, (MachineOperation)currentOperation);
                }
            }
        }
    }

    @Nullable
    @Generated
    public CustomMenu getMenu() {
        return this.menu;
    }
}

