/*
 * Decompiled with CFR 0.152.
 */
package org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.machine;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.MachineProcessHolder;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineOperation;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineProcessor;
import io.github.thebusybiscuit.slimefun4.implementation.handlers.SimpleBlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.implementation.operations.CraftingOperation;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lins.mmmjjkx.rykenslimefuncustomizer.RykenSlimefunCustomizer;
import org.lins.mmmjjkx.rykenslimefuncustomizer.listeners.SingleItemRecipeGuideListener;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.CustomMenu;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.machine.CustomLinkedMachineOperation;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.machine.CustomLinkedMachineRecipe;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.BlockMenuUtil;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.CommonUtils;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.ExceptionHandler;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.StackUtils;

public class CustomLinkedRecipeMachine
extends AContainer
implements RecipeDisplayItem {
    private static final Map<Location, Integer> lastMatch = new HashMap<Location, Integer>();
    private final MachineProcessor<CraftingOperation> processor = new MachineProcessor((MachineProcessHolder)this);
    private final int[] input;
    private final int[] output;
    private final List<CustomLinkedMachineRecipe> raw_recipes;
    private final List<CustomLinkedMachineRecipe> recipes;
    private final int energyPerCraft;
    private final int capacity;
    private final boolean hideAllRecipes;
    private final int saveAmount;
    public static final ItemStack RECIPE_INPUT = CustomItemStack.create((Material)Material.GREEN_STAINED_GLASS_PANE, (String)"&aMulti-Item Input", (String[])new String[]{"", "&2> &aClick to view"});
    public static final ItemStack RECIPE_OUTPUT = CustomItemStack.create((Material)Material.GREEN_STAINED_GLASS_PANE, (String)"&aMulti-Item Output", (String[])new String[]{"", "&2> &aClick to view"});
    @Nullable
    private final CustomMenu menu;

    public CustomLinkedRecipeMachine(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, int[] input, int[] output, List<CustomLinkedMachineRecipe> recipes, int energyPerCraft, int capacity, @Nullable CustomMenu menu, int speed, boolean hideAllRecipes, int saveAmount) {
        super(itemGroup, item, recipeType, recipe);
        this.input = input;
        this.output = output;
        this.raw_recipes = recipes;
        this.recipes = new ArrayList<CustomLinkedMachineRecipe>(this.raw_recipes.stream().filter(r -> !r.isForDisplay()).toList());
        this.energyPerCraft = energyPerCraft;
        this.capacity = capacity;
        this.menu = menu;
        this.hideAllRecipes = hideAllRecipes;
        this.saveAmount = saveAmount;
        if (menu == null) {
            ExceptionHandler.handleWarning("Cannot find menu for " + item.getItemId() + " . Will use the default one.");
            this.createPreset((SlimefunItem)this, this.getInventoryTitle(), x$0 -> super.constructMenu(x$0));
        }
        if (menu != null) {
            this.processor.setProgressBar(menu.getProgressBarItem());
            this.createPreset((SlimefunItem)this, menu::apply);
        }
        this.setProcessingSpeed(speed);
        this.setCapacity(capacity);
        this.setEnergyConsumption(energyPerCraft);
        this.register(RykenSlimefunCustomizer.INSTANCE);
    }

    @NotNull
    protected BlockBreakHandler onBlockBreak() {
        return new SimpleBlockBreakHandler(){

            public void onBlockBreak(@NotNull Block b) {
                BlockMenu inv = BlockStorage.getInventory((Location)b.getLocation());
                if (inv != null) {
                    inv.dropItems(b.getLocation(), CustomLinkedRecipeMachine.this.getInputSlots());
                    inv.dropItems(b.getLocation(), CustomLinkedRecipeMachine.this.getOutputSlots());
                }
                CustomLinkedRecipeMachine.this.processor.endOperation(b);
            }
        };
    }

    protected void registerDefaultRecipes() {
        if (this.recipes == null || this.recipes.isEmpty()) {
            return;
        }
        this.recipes.forEach(x$0 -> super.registerRecipe(x$0));
    }

    public int getEnergyConsumption() {
        return this.energyPerCraft;
    }

    @NotNull
    public MachineProcessor<CraftingOperation> getMachineProcessor() {
        return this.processor;
    }

    public ItemStack getProgressBar() {
        return new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
    }

    @NotNull
    public List<ItemStack> getDisplayRecipes() {
        ArrayList<ItemStack> displayRecipes = new ArrayList<ItemStack>();
        if (this.hideAllRecipes) {
            return displayRecipes;
        }
        int i = 0;
        for (CustomLinkedMachineRecipe recipe : this.raw_recipes) {
            if (recipe.isHide()) continue;
            ItemStack[] input = recipe.getInput();
            ItemStack[] output = recipe.getOutput();
            if (input.length == 1) {
                displayRecipes.add(input[0]);
            } else {
                ItemStack in = SingleItemRecipeGuideListener.tagItemLinkedRecipe(RECIPE_INPUT, i);
                displayRecipes.add(in);
            }
            if (output.length == 1) {
                int seconds = recipe.getTicks() / 2;
                ItemStack out = output[0].clone();
                Object rawLore = "&eProduction Time: &b" + seconds + "&es";
                if (seconds > 60) {
                    rawLore = ((String)rawLore).concat("(" + CommonUtils.formatSeconds(seconds) + "&e)");
                }
                CommonUtils.addLore(out, true, new String[]{rawLore});
                displayRecipes.add(out);
            } else {
                ItemStack out = SingleItemRecipeGuideListener.tagItemLinkedRecipe(RECIPE_OUTPUT, i);
                displayRecipes.add(out);
            }
            ++i;
        }
        return displayRecipes;
    }

    public int[] getInputSlots() {
        return this.input;
    }

    public int[] getOutputSlots() {
        return this.output;
    }

    public int getCapacity() {
        return this.capacity;
    }

    @NotNull
    public String getMachineIdentifier() {
        return this.getId();
    }

    protected void constructMenu(BlockMenuPreset preset) {
    }

    protected void tick(Block b) {
        int progressSlot;
        BlockMenu inv = BlockStorage.getInventory((Location)b.getLocation());
        CustomLinkedMachineOperation currentOperation = (CustomLinkedMachineOperation)this.processor.getOperation(b);
        int n = progressSlot = this.menu == null || this.menu.getProgressSlot() == -1 ? 22 : this.menu.getProgressSlot();
        if (inv != null) {
            if (currentOperation != null) {
                if (this.takeCharge(b.getLocation())) {
                    if (!currentOperation.isFinished()) {
                        if (inv.hasViewer()) {
                            this.processor.updateProgressBar(inv, progressSlot, (MachineOperation)currentOperation);
                        }
                        currentOperation.addProgress(1);
                    } else {
                        CustomLinkedMachineRecipe currentRecipe = currentOperation.getRecipe();
                        if (currentRecipe != null) {
                            BlockMenuUtil.pushItem(inv, currentRecipe.getLinkedOutput(), currentRecipe.isChooseOneIfHas(), new int[0]);
                        }
                        ItemStack progress = this.menu == null ? ChestMenuUtils.getBackground() : this.menu.getItems().getOrDefault(progressSlot, ChestMenuUtils.getBackground());
                        inv.replaceExistingItem(progressSlot, progress);
                        this.processor.endOperation(b);
                    }
                }
            } else {
                CustomLinkedMachineRecipe next = this.findNextLinkedRecipe(inv);
                if (next == null) {
                    return;
                }
                currentOperation = new CustomLinkedMachineOperation(next);
                this.processor.startOperation(b, (MachineOperation)currentOperation);
                if (inv.hasViewer()) {
                    this.processor.updateProgressBar(inv, progressSlot, (MachineOperation)currentOperation);
                }
            }
        }
    }

    @Nullable
    public CustomLinkedMachineRecipe findNextLinkedRecipe(BlockMenu blockMenu) {
        Location location = blockMenu.getLocation();
        Integer lastMatchIndex = lastMatch.get(blockMenu.getLocation());
        if (lastMatchIndex != null) {
            CustomLinkedMachineRecipe recipe = this.recipes.get(lastMatchIndex);
            if (this.matchRecipe(blockMenu, recipe)) {
                return recipe;
            }
            lastMatch.remove(location);
        }
        for (int i = 0; i < this.recipes.size(); ++i) {
            CustomLinkedMachineRecipe recipe;
            if (lastMatchIndex != null && i == lastMatchIndex || !this.matchRecipe(blockMenu, recipe = this.recipes.get(i))) continue;
            lastMatch.put(location, i);
            return recipe;
        }
        return null;
    }

    private boolean matchRecipe(BlockMenu blockMenu, CustomLinkedMachineRecipe recipe) {
        Map<Integer, ItemStack> inputMap = recipe.getLinkedInput();
        boolean matched = true;
        if (!BlockMenuUtil.fits(blockMenu, recipe.getLinkedOutput(), new int[0])) {
            return false;
        }
        for (int slot : inputMap.keySet()) {
            ItemStack item = blockMenu.getItemInSlot(slot);
            if (this.saveAmount > 0) {
                if (item != null) {
                    ItemStack clone;
                    if (item.getMaxStackSize() == 1) {
                        clone = item.clone();
                    } else {
                        if (item.getAmount() <= this.saveAmount) {
                            matched = false;
                            break;
                        }
                        clone = item.clone();
                        clone.setAmount(clone.getAmount() - this.saveAmount);
                    }
                    if (StackUtils.itemsMatch(clone, inputMap.get(slot), false, true)) continue;
                    matched = false;
                    break;
                }
                if (inputMap.get(slot) == null) continue;
                matched = false;
                break;
            }
            if (StackUtils.itemsMatch(item, inputMap.get(slot), false, true)) continue;
            matched = false;
            break;
        }
        if (!matched) {
            return false;
        }
        for (int slot : inputMap.keySet()) {
            blockMenu.consumeItem(slot, inputMap.get(slot).getAmount());
        }
        return true;
    }

    @Nullable
    @Generated
    public CustomMenu getMenu() {
        return this.menu;
    }
}

