/*
 * Decompiled with CFR 0.152.
 */
package org.lins.mmmjjkx.rykenslimefuncustomizer.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ReflectionUtils {
    @Nullable
    public static <T> T getField(@Nonnull Object object, @Nonnull String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field[] fields = ReflectionUtils.getAllFields(object);
        Field field = null;
        for (Field f : fields) {
            if (!f.getName().equals(fieldName)) continue;
            field = f;
            break;
        }
        if (field == null) {
            throw new NoSuchFieldException(fieldName);
        }
        field.setAccessible(true);
        return (T)field.get(object);
    }

    public static <T> void setField(@Nonnull Object object, @Nonnull String fieldName, @Nullable T value) throws NoSuchFieldException, IllegalAccessException {
        Field[] fields = ReflectionUtils.getAllFields(object);
        Field field = null;
        for (Field f : fields) {
            if (!f.getName().equals(fieldName)) continue;
            field = f;
            break;
        }
        if (field == null) {
            throw new NoSuchFieldException(fieldName);
        }
        field.setAccessible(true);
        field.set(object, value);
    }

    @Nonnull
    public static Field[] getAllFields(@Nonnull Object object) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            fieldList.addAll(new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields())));
        }
        Field[] fields = new Field[fieldList.size()];
        fieldList.toArray(fields);
        return fields;
    }

    @Nonnull
    public static Method[] getAllMethods(@Nonnull Object object) {
        ArrayList<Method> methodList = new ArrayList<Method>();
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            methodList.addAll(new ArrayList<Method>(Arrays.asList(clazz.getDeclaredMethods())));
        }
        Method[] methods = new Method[methodList.size()];
        methodList.toArray(methods);
        return methods;
    }
}

