/*
 * Decompiled with CFR 0.152.
 */
package org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.machine;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.attributes.MachineProcessHolder;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineProcessor;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.handlers.SimpleBlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.implementation.operations.CraftingOperation;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lins.mmmjjkx.rykenslimefuncustomizer.RykenSlimefunCustomizer;
import org.lins.mmmjjkx.rykenslimefuncustomizer.listeners.SingleItemRecipeGuideListener;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.CustomMenu;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.machine.CustomLinkedMachineRecipe;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.script.ScriptEval;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.BlockMenuUtil;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.ExceptionHandler;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.StackUtils;

public class CustomWorkbench
extends AContainer
implements EnergyNetComponent,
RecipeDisplayItem {
    private final BlockTicker blockTicker = new BlockTicker(){

        public boolean isSynchronized() {
            return false;
        }

        public void tick(Block block, SlimefunItem slimefunItem, Config config) {
        }
    };
    private final MachineProcessor<CraftingOperation> processor = new MachineProcessor((MachineProcessHolder)this);
    private final int[] input;
    private final int[] output;
    private final List<CustomLinkedMachineRecipe> raw_recipes;
    private final List<CustomLinkedMachineRecipe> recipes;
    private final int energyPerCraft;
    private final int capacity;
    private final boolean hideAllRecipes;
    private final int click;
    private final ScriptEval eval;
    public static final ItemStack RECIPE_INPUT = CustomItemStack.create((Material)Material.GREEN_STAINED_GLASS_PANE, (String)"&aMulti-Item Input", (String[])new String[]{"", "&2> &aClick to view"});
    public static final ItemStack RECIPE_OUTPUT = CustomItemStack.create((Material)Material.GREEN_STAINED_GLASS_PANE, (String)"&aMulti-Item Output", (String[])new String[]{"", "&2> &aClick to view"});
    @Nullable
    private final CustomMenu menu;

    public CustomWorkbench(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, final int[] input, final int[] output, List<CustomLinkedMachineRecipe> recipes, int energyPerCraft, int capacity, final @Nullable CustomMenu menu, boolean hideAllRecipes, int click, @Nullable ScriptEval eval) {
        super(itemGroup, item, recipeType, recipe);
        this.input = input;
        this.output = output;
        this.raw_recipes = recipes;
        this.recipes = new ArrayList<CustomLinkedMachineRecipe>(this.raw_recipes.stream().filter(r -> !r.isForDisplay()).toList());
        this.energyPerCraft = energyPerCraft;
        this.capacity = capacity;
        this.menu = menu;
        this.hideAllRecipes = hideAllRecipes;
        this.click = click;
        this.eval = eval;
        if (menu == null) {
            ExceptionHandler.handleWarning("Cannot find menu for " + item.getItemId() + "!");
            return;
        }
        this.processor.setProgressBar(menu.getProgressBarItem());
        if (eval != null) {
            eval.doInit();
        }
        new BlockMenuPreset(this.getId(), this.getItemName()){

            public void init() {
                menu.apply(this);
            }

            public void newInstance(@NotNull BlockMenu menu2, @NotNull Block b) {
                menu2.addMenuClickHandler(CustomWorkbench.this.click, (player, clickedSlot, clickedItem, clickAction) -> {
                    if (CustomWorkbench.this.eval != null) {
                        Object result = CustomWorkbench.this.eval.evalFunction("onClick", new Object[]{this, player, clickedSlot, clickedItem, clickAction});
                        if (result instanceof Boolean) {
                            Boolean booleanResult = (Boolean)result;
                            return booleanResult;
                        }
                        return false;
                    }
                    if (!CustomWorkbench.this.takeCharge(menu2.getLocation())) {
                        return false;
                    }
                    CustomLinkedMachineRecipe nextRecipe = CustomWorkbench.this.findNextLinkedRecipe(menu2);
                    if (nextRecipe != null) {
                        BlockMenuUtil.pushItem(menu2, nextRecipe.getLinkedOutput(), nextRecipe.isChooseOneIfHas(), new int[0]);
                    }
                    return false;
                });
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                return flow == ItemTransportFlow.INSERT ? input : output;
            }

            public boolean canOpen(Block b, Player p) {
                if (p.hasPermission("slimefun.inventory.bypass")) {
                    return true;
                }
                return CustomWorkbench.this.canUse(p, false) && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), Interaction.INTERACT_BLOCK);
            }
        };
        this.setProcessingSpeed(1);
        this.setCapacity(capacity);
        this.setEnergyConsumption(energyPerCraft);
        this.register(RykenSlimefunCustomizer.INSTANCE);
    }

    @NotNull
    protected BlockBreakHandler onBlockBreak() {
        return new SimpleBlockBreakHandler(){

            public void onBlockBreak(@NotNull Block b) {
                BlockMenu inv = BlockStorage.getInventory((Location)b.getLocation());
                if (inv != null) {
                    inv.dropItems(b.getLocation(), CustomWorkbench.this.getInputSlots());
                    inv.dropItems(b.getLocation(), CustomWorkbench.this.getOutputSlots());
                }
                CustomWorkbench.this.processor.endOperation(b);
            }
        };
    }

    protected void registerDefaultRecipes() {
        if (this.recipes == null || this.recipes.isEmpty()) {
            return;
        }
        this.recipes.forEach(x$0 -> super.registerRecipe(x$0));
    }

    public int getEnergyConsumption() {
        return this.energyPerCraft;
    }

    @NotNull
    public MachineProcessor<CraftingOperation> getMachineProcessor() {
        return this.processor;
    }

    public ItemStack getProgressBar() {
        return new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
    }

    @NotNull
    public List<ItemStack> getDisplayRecipes() {
        ArrayList<ItemStack> displayRecipes = new ArrayList<ItemStack>();
        if (this.hideAllRecipes) {
            return displayRecipes;
        }
        int i = 0;
        for (CustomLinkedMachineRecipe recipe : this.raw_recipes) {
            if (recipe.isHide()) continue;
            ItemStack[] input = recipe.getInput();
            ItemStack[] output = recipe.getOutput();
            if (input.length == 1) {
                displayRecipes.add(input[0]);
            } else {
                ItemStack in = SingleItemRecipeGuideListener.tagItemWorkbenchRecipe(RECIPE_INPUT, i);
                displayRecipes.add(in);
            }
            if (output.length == 1) {
                displayRecipes.add(output[0]);
            } else {
                ItemStack out = SingleItemRecipeGuideListener.tagItemWorkbenchRecipe(RECIPE_OUTPUT, i);
                displayRecipes.add(out);
            }
            ++i;
        }
        return displayRecipes;
    }

    public int[] getInputSlots() {
        return this.input;
    }

    public int[] getOutputSlots() {
        return this.output;
    }

    @NotNull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int getCapacity() {
        return this.capacity;
    }

    @NotNull
    public String getMachineIdentifier() {
        return this.getId();
    }

    protected void constructMenu(BlockMenuPreset preset) {
    }

    protected void tick(Block b) {
    }

    @Nullable
    public CustomLinkedMachineRecipe findNextLinkedRecipe(BlockMenu blockMenu) {
        for (CustomLinkedMachineRecipe recipe : this.recipes) {
            Map<Integer, ItemStack> inputMap = recipe.getLinkedInput();
            boolean matched = true;
            for (int slot : inputMap.keySet()) {
                ItemStack item = blockMenu.getItemInSlot(slot);
                if (StackUtils.itemsMatch(item, inputMap.get(slot), false, true)) continue;
                matched = false;
                break;
            }
            if (!matched || !BlockMenuUtil.fits(blockMenu, recipe.getLinkedOutput(), new int[0])) continue;
            for (int slot : inputMap.keySet()) {
                ItemStack itemStack = blockMenu.getItemInSlot(slot);
                if (itemStack == null || itemStack.getType() == Material.AIR) continue;
                blockMenu.consumeItem(slot, inputMap.get(slot).getAmount());
            }
            return recipe;
        }
        return null;
    }

    public BlockTicker getBlockTicker() {
        return this.blockTicker;
    }

    @Nullable
    @Generated
    public CustomMenu getMenu() {
        return this.menu;
    }
}

