/*
 * Decompiled with CFR 0.152.
 */
package org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.machine;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.attributes.MachineProcessHolder;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineOperation;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineProcessor;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.handlers.SimpleBlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.inventory.InvUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.ItemStackWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.lins.mmmjjkx.rykenslimefuncustomizer.RykenSlimefunCustomizer;
import org.lins.mmmjjkx.rykenslimefuncustomizer.listeners.SingleItemRecipeGuideListener;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.CustomMenu;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.machine.CustomRecipeMachine;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.parent.AbstractEmptyMachine;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.machine.CustomMachineRecipe;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.machine.CustomTemplateCraftingOperation;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.machine.MachineTemplate;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.CommonUtils;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.ItemUtils;

public class CustomTemplateMachine
extends AbstractEmptyMachine<CustomTemplateCraftingOperation>
implements RecipeDisplayItem,
EnergyNetComponent {
    private final MachineProcessor<CustomTemplateCraftingOperation> processor = new MachineProcessor((MachineProcessHolder)this);
    private final CustomMenu menu;
    private final List<Integer> inputSlots;
    private final List<Integer> outputSlots;
    private final int templateSlot;
    private final List<MachineTemplate> templates;
    private final int consumption;
    private final int capacity;
    private final boolean fasterIfMoreTemplates;
    private final boolean moreOutputIfMoreTemplates;
    private final boolean hideAllRecipes;

    public CustomTemplateMachine(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, @NotNull CustomMenu menu, List<Integer> inputSlots, List<Integer> outputSlots, final int templateSlot, List<MachineTemplate> templates, int consumption, int capacity, boolean fasterIfMoreTemplates, boolean moreOutputIfMoreTemplates, boolean hideAllRecipes) {
        super(itemGroup, item, recipeType, recipe);
        this.menu = menu;
        this.inputSlots = inputSlots;
        this.outputSlots = outputSlots;
        this.templateSlot = templateSlot;
        this.templates = templates;
        this.consumption = consumption;
        this.capacity = capacity;
        this.fasterIfMoreTemplates = fasterIfMoreTemplates;
        this.moreOutputIfMoreTemplates = moreOutputIfMoreTemplates;
        this.hideAllRecipes = hideAllRecipes;
        this.createPreset(this, bmp -> {
            menu.apply((BlockMenuPreset)bmp);
            if (menu.getMenuClickHandler(templateSlot) != null) {
                bmp.addItem(templateSlot, null, (player, i, itemStack, clickAction) -> true);
            }
        });
        this.addItemHandler(new ItemHandler[]{this.getBlockTicker()});
        this.addItemHandler(new ItemHandler[]{new SimpleBlockBreakHandler(){

            public void onBlockBreak(@NotNull Block block) {
                BlockMenu inv = BlockStorage.getInventory((Block)block);
                if (inv != null) {
                    inv.dropItems(block.getLocation(), new int[]{templateSlot});
                    inv.dropItems(block.getLocation(), CustomTemplateMachine.this.getOutputSlots());
                    inv.dropItems(block.getLocation(), CustomTemplateMachine.this.getInputSlots());
                }
            }
        }});
        this.processor.setProgressBar(menu.getProgressBarItem());
        this.register(RykenSlimefunCustomizer.INSTANCE);
    }

    @Override
    public BlockTicker getBlockTicker() {
        return new BlockTicker(){

            public boolean isSynchronized() {
                return true;
            }

            public void tick(Block b, SlimefunItem item, Config data) {
                CustomTemplateMachine.this.tick(b);
            }
        };
    }

    @NotNull
    public List<ItemStack> getDisplayRecipes() {
        ArrayList<ItemStack> displayRecipes = new ArrayList<ItemStack>();
        if (this.hideAllRecipes) {
            return displayRecipes;
        }
        int templateIndex = 0;
        int recipeIndex = 0;
        for (MachineTemplate template : this.templates) {
            for (CustomMachineRecipe recipe : template.recipes()) {
                if (recipe.isHide()) continue;
                if (recipe.getInput().length == 0) {
                    ItemStack templateItem = template.template().clone();
                    CommonUtils.addLore(templateItem, true, "&d&l&o*\u6a21\u677f\u7269\u54c1\u4e0d\u6d88\u8017*");
                    displayRecipes.add(templateItem);
                } else {
                    displayRecipes.add(SingleItemRecipeGuideListener.tagItemTemplateRecipe(CustomRecipeMachine.RECIPE_INPUT, templateIndex, recipeIndex));
                }
                if (recipe.getOutput().length == 1) {
                    int seconds = recipe.getTicks() / 2;
                    ItemStack out = recipe.getOutput()[0].clone();
                    Object rawLore = "&e\u5236\u4f5c\u65f6\u95f4: &b" + seconds + "&es";
                    if (seconds > 60) {
                        rawLore = ((String)rawLore).concat("(" + CommonUtils.formatSeconds(seconds) + "&e)");
                    }
                    CommonUtils.addLore(out, true, new String[]{rawLore});
                    displayRecipes.add(out);
                } else {
                    displayRecipes.add(SingleItemRecipeGuideListener.tagItemTemplateRecipe(CustomRecipeMachine.RECIPE_OUTPUT, templateIndex, recipeIndex));
                }
                ++recipeIndex;
            }
            ++templateIndex;
            recipeIndex = 0;
        }
        return displayRecipes;
    }

    private void tick(Block b) {
        BlockMenu inv = BlockStorage.getInventory((Block)b);
        if (inv != null) {
            ItemStack templateItem = inv.getItemInSlot(this.templateSlot);
            if (templateItem == null || templateItem.getType() == Material.AIR) {
                if (this.menu.getProgressSlot() >= 0) {
                    inv.replaceExistingItem(this.menu.getProgressSlot(), this.menu.getItems().getOrDefault(this.menu.getProgressSlot(), ChestMenuUtils.getBackground()));
                }
                this.processor.endOperation(b);
                return;
            }
            CustomTemplateCraftingOperation currentOperation = (CustomTemplateCraftingOperation)this.processor.getOperation(b);
            if (currentOperation != null) {
                if (!currentOperation.getTemplate().isItemSimilar(templateItem)) {
                    this.processor.endOperation(b);
                    if (this.menu.getProgressSlot() >= 0) {
                        inv.replaceExistingItem(this.menu.getProgressSlot(), this.menu.getItems().getOrDefault(this.menu.getProgressSlot(), ChestMenuUtils.getBackground()));
                    }
                    return;
                }
                if (this.takeCharge(b.getLocation())) {
                    if (!currentOperation.isFinished()) {
                        this.processor.updateProgressBar(inv, this.menu.getProgressSlot(), (MachineOperation)currentOperation);
                        currentOperation.addProgress(1);
                    } else {
                        if (this.menu.getProgressSlot() >= 0) {
                            inv.replaceExistingItem(this.menu.getProgressSlot(), this.menu.getItems().getOrDefault(this.menu.getProgressSlot(), ChestMenuUtils.getBackground()));
                        }
                        List<ItemStack> result = currentOperation.getRecipe().getMatchChanceResult();
                        for (ItemStack output : result) {
                            ItemStack outputItem = output.clone();
                            if (this.moreOutputIfMoreTemplates) {
                                outputItem.setAmount(outputItem.getAmount() * templateItem.getAmount());
                            }
                            inv.pushItem(outputItem, this.getOutputSlots());
                        }
                        this.processor.endOperation(b);
                    }
                }
            } else {
                for (MachineTemplate template : this.templates) {
                    CustomMachineRecipe recipe;
                    if (!template.isItemSimilar(templateItem) || (recipe = this.findNextRecipe(template, inv)) == null) continue;
                    int ticks = recipe.getTicks();
                    if (this.fasterIfMoreTemplates && templateItem.getAmount() > 1) {
                        ticks /= templateItem.getAmount();
                    }
                    this.processor.startOperation(b, (MachineOperation)new CustomTemplateCraftingOperation(template, recipe, ticks));
                }
            }
        }
    }

    private boolean takeCharge(Location l) {
        Validate.notNull((Object)l, (String)"Can't attempt to take charge from a null location!");
        if (this.isChargeable()) {
            int charge = this.getCharge(l);
            if (charge < this.consumption) {
                return false;
            }
            this.setCharge(l, charge - this.consumption);
            return true;
        }
        return true;
    }

    @NotNull
    public MachineProcessor<CustomTemplateCraftingOperation> getMachineProcessor() {
        return this.processor;
    }

    public int[] getInputSlots() {
        return this.inputSlots.stream().mapToInt(i -> i).toArray();
    }

    public int[] getOutputSlots() {
        return this.outputSlots.stream().mapToInt(i -> i).toArray();
    }

    private CustomMachineRecipe findNextRecipe(MachineTemplate currentTemplate, BlockMenu inv) {
        List<CustomMachineRecipe> recipes = currentTemplate.recipes();
        HashMap<Integer, ItemStackWrapper> inventory = new HashMap<Integer, ItemStackWrapper>();
        for (int slot : this.getInputSlots()) {
            ItemStack itemStack = inv.getItemInSlot(slot);
            if (itemStack == null) continue;
            inventory.put(slot, ItemStackWrapper.wrap((ItemStack)itemStack));
        }
        HashMap matched = new HashMap();
        for (CustomMachineRecipe recipe : recipes) {
            HashMap<Integer, Integer> found = new HashMap<Integer, Integer>();
            if (recipe.getInput().length == 0) {
                boolean bl;
                if (this.getInputSlots().length == 0) {
                    if (!InvUtils.fitAll((Inventory)inv.toInventory(), (ItemStack[])recipe.getOutput(), (int[])this.getOutputSlots())) {
                        return null;
                    }
                    return recipe;
                }
                boolean bl2 = true;
                int[] nArray = this.getInputSlots();
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int i2 = nArray[i];
                    ItemStack item = inv.getItemInSlot(i2);
                    if (item == null || item.getType() == Material.AIR) continue;
                    bl = false;
                }
                if (bl) {
                    if (!InvUtils.fitAll((Inventory)inv.toInventory(), (ItemStack[])recipe.getOutput(), (int[])this.getOutputSlots())) {
                        return null;
                    }
                    return recipe;
                }
            }
            for (ItemStack input : recipe.getInput()) {
                for (int slot : this.getInputSlots()) {
                    if (found.containsKey(slot) || !SlimefunUtils.isItemSimilar((ItemStack)((ItemStack)inventory.get(slot)), (ItemStack)input, (boolean)true)) continue;
                    found.put(slot, input.getAmount());
                    break;
                }
                if (found.size() != recipe.getInput().length) continue;
                matched.put(recipe, found);
            }
        }
        if (matched.isEmpty()) {
            return null;
        }
        Map.Entry recipe = null;
        int max_Size = 0;
        for (Map.Entry entry : matched.entrySet()) {
            int size = ItemUtils.getAllItemTypeAmount(((CustomMachineRecipe)((Object)entry.getKey())).getInput()) * 1000 + ItemUtils.getAllItemAmount(((CustomMachineRecipe)((Object)entry.getKey())).getInput());
            if (size <= max_Size) continue;
            recipe = entry;
            max_Size = size;
        }
        if (recipe == null) {
            return null;
        }
        if (!InvUtils.fitAll((Inventory)inv.toInventory(), (ItemStack[])((CustomMachineRecipe)((Object)recipe.getKey())).getOutput(), (int[])this.getOutputSlots())) {
            return null;
        }
        for (Map.Entry entry : ((Map)recipe.getValue()).entrySet()) {
            inv.consumeItem(((Integer)entry.getKey()).intValue(), ((Integer)entry.getValue()).intValue());
        }
        return (CustomMachineRecipe)((Object)recipe.getKey());
    }

    @NotNull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int getCapacity() {
        return this.capacity;
    }

    @Generated
    public CustomMenu getMenu() {
        return this.menu;
    }

    @Generated
    public int getTemplateSlot() {
        return this.templateSlot;
    }

    @Generated
    public List<MachineTemplate> getTemplates() {
        return this.templates;
    }
}

