/*
 * Decompiled with CFR 0.152.
 */
package org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.machine;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetProvider;
import io.github.thebusybiscuit.slimefun4.core.attributes.MachineProcessHolder;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineOperation;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineProcessor;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.handlers.SimpleBlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.implementation.operations.FuelOperation;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.ItemStackWrapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import lombok.Generated;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AGenerator;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineFuel;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lins.mmmjjkx.rykenslimefuncustomizer.RykenSlimefunCustomizer;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.CustomMenu;

public class CustomGenerator
extends AGenerator
implements MachineProcessHolder<FuelOperation>,
EnergyNetProvider {
    private final MachineProcessor<FuelOperation> processor = new MachineProcessor((MachineProcessHolder)this);
    private final int capacity;
    private final List<Integer> input;
    private final List<Integer> output;
    private final CustomMenu menu;
    private final int production;

    public CustomGenerator(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, @Nullable CustomMenu menu, int capacity, List<Integer> input, List<Integer> output, int production, List<MachineFuel> machineFuels) {
        super(itemGroup, item, recipeType, recipe);
        if (menu != null) {
            this.processor.setProgressBar(menu.getProgressBarItem());
            this.createPreset((SlimefunItem)this, menu::apply);
        }
        this.capacity = capacity;
        this.input = input;
        this.output = output;
        this.production = production;
        this.menu = menu;
        this.setCapacity(capacity);
        this.setEnergyProduction(production);
        for (MachineFuel fuel : machineFuels) {
            this.registerFuel(fuel);
        }
        this.register(RykenSlimefunCustomizer.INSTANCE);
    }

    public int getGeneratedOutput(@NotNull Location l, @NotNull Config data) {
        int progressSlot;
        BlockMenu inv = BlockStorage.getInventory((Location)l);
        FuelOperation operation = (FuelOperation)this.processor.getOperation(l);
        int n = progressSlot = this.menu == null || this.menu.getProgressSlot() == -1 ? 22 : this.menu.getProgressSlot();
        if (inv != null) {
            if (operation != null) {
                if (!operation.isFinished()) {
                    this.processor.updateProgressBar(inv, progressSlot, (MachineOperation)operation);
                    if (this.isChargeable()) {
                        int charge = this.getCharge(l, data);
                        if (this.getCapacity() - charge >= this.getEnergyProduction()) {
                            operation.addProgress(1);
                            return this.getEnergyProduction();
                        }
                        return 0;
                    }
                    operation.addProgress(1);
                    return this.getEnergyProduction();
                }
                ItemStack fuel = operation.getIngredient();
                if (this.isBucket(fuel)) {
                    inv.pushItem(new ItemStack(Material.BUCKET), this.getOutputSlots());
                }
                if (operation.getResult() != null) {
                    inv.pushItem(operation.getResult().clone(), this.getOutputSlots());
                }
                ItemStack progress = this.menu == null ? ChestMenuUtils.getBackground() : this.menu.getItems().getOrDefault(progressSlot, ChestMenuUtils.getBackground());
                inv.replaceExistingItem(progressSlot, progress);
                this.processor.endOperation(l);
                return 0;
            }
            HashMap<Integer, Integer> found = new HashMap<Integer, Integer>();
            MachineFuel fuel = this.findRecipe(inv, found);
            if (fuel != null) {
                for (Map.Entry entry : found.entrySet()) {
                    inv.consumeItem(((Integer)entry.getKey()).intValue(), ((Integer)entry.getValue()).intValue());
                }
                this.processor.startOperation(l, (MachineOperation)new FuelOperation(fuel));
            }
            return 0;
        }
        return 0;
    }

    private boolean isBucket(ItemStack item) {
        if (item == null) {
            return false;
        }
        ItemStackWrapper wrapper = ItemStackWrapper.wrap((ItemStack)item);
        return item.getType() == Material.LAVA_BUCKET || item.getType() == Material.WATER_BUCKET || SlimefunUtils.isItemSimilar((ItemStack)wrapper, (ItemStack)SlimefunItems.FUEL_BUCKET.item(), (boolean)true) || SlimefunUtils.isItemSimilar((ItemStack)wrapper, (ItemStack)SlimefunItems.OIL_BUCKET.item(), (boolean)true);
    }

    private MachineFuel findRecipe(BlockMenu menu, Map<Integer, Integer> found) {
        for (MachineFuel fuel : this.fuelTypes) {
            for (int slot : this.getInputSlots()) {
                if (!fuel.test(menu.getItemInSlot(slot))) continue;
                found.put(slot, fuel.getInput().getAmount());
                return fuel;
            }
        }
        return null;
    }

    @Nonnull
    protected BlockBreakHandler onBlockBreak() {
        return new SimpleBlockBreakHandler(){

            public void onBlockBreak(@NotNull Block b) {
                BlockMenu inv = BlockStorage.getInventory((Location)b.getLocation());
                if (inv != null) {
                    inv.dropItems(b.getLocation(), CustomGenerator.this.getInputSlots());
                    inv.dropItems(b.getLocation(), CustomGenerator.this.getOutputSlots());
                }
                CustomGenerator.this.processor.endOperation(b);
            }
        };
    }

    @NotNull
    public String getInventoryTitle() {
        return "";
    }

    @NotNull
    public ItemStack getProgressBar() {
        return new ItemStack(Material.FLINT_AND_STEEL);
    }

    public int getEnergyProduction() {
        return this.production;
    }

    @NotNull
    public MachineProcessor<FuelOperation> getMachineProcessor() {
        return this.processor;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int[] getInputSlots() {
        if (this.input == null) {
            return new int[0];
        }
        int[] input = new int[this.input.size()];
        for (int i = 0; i < this.input.size(); ++i) {
            input[i] = this.input.get(i);
        }
        return input;
    }

    public int[] getOutputSlots() {
        if (this.output == null) {
            return new int[0];
        }
        int[] output = new int[this.output.size()];
        for (int i = 0; i < this.output.size(); ++i) {
            output[i] = this.output.get(i);
        }
        return output;
    }

    public void registerDefaultFuelTypes() {
    }

    @Generated
    public MachineProcessor<FuelOperation> getProcessor() {
        return this.processor;
    }
}

