/*
 * Decompiled with CFR 0.152.
 */
package org.lins.mmmjjkx.rykenslimefuncustomizer.objects.yaml;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.Nullable;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.ProjectAddon;
import org.lins.mmmjjkx.rykenslimefuncustomizer.objects.customs.CustomAddonConfig;
import org.lins.mmmjjkx.rykenslimefuncustomizer.utils.ExceptionHandler;

public abstract class YamlReader<T> {
    public static final int MAJOR_VERSION = PaperLib.getMinecraftVersion();
    public static final int MINOR_VERSION = PaperLib.getMinecraftPatchVersion();
    private final List<String> lateInits;
    protected final ProjectAddon addon;
    protected final YamlConfiguration configuration;

    public YamlReader(YamlConfiguration config, ProjectAddon addon) {
        this.configuration = config;
        this.lateInits = new ArrayList<String>();
        this.addon = addon;
    }

    public abstract T readEach(String var1);

    public final void preload() {
        for (String key : this.configuration.getKeys(false)) {
            List<SlimefunItemStack> items;
            ConfigurationSection register;
            ConfigurationSection section = this.configuration.getConfigurationSection(key);
            if (section == null || !this.checkForRegistration(key, register = section.getConfigurationSection("register")) || (items = this.preloadItems(key)) == null || items.isEmpty()) continue;
            for (SlimefunItemStack item : items) {
                this.addon.getPreloadItems().put(item.getItemId(), item);
                ExceptionHandler.debugLog("&aPreloaded item: " + item.getItemId());
            }
        }
    }

    @Nullable
    protected final SlimefunItemStack getPreloadItem(String itemId) {
        return this.addon.getPreloadItems().get(itemId);
    }

    public final List<T> readAll() {
        ArrayList<T> objects = new ArrayList<T>();
        for (String key : this.configuration.getKeys(false)) {
            ConfigurationSection section = this.configuration.getConfigurationSection(key);
            if (section == null) continue;
            ExceptionHandler.debugLog("Starting to read item: " + key);
            ConfigurationSection register = section.getConfigurationSection("register");
            if (!this.checkForRegistration(key, register)) continue;
            ExceptionHandler.debugLog("Checking for late initialization...");
            if (section.getBoolean("lateInit", false)) {
                this.putLateInit(key);
                ExceptionHandler.debugLog("Check result: no late initialization");
                continue;
            }
            ExceptionHandler.debugLog("Starting to read...");
            T object = this.readEach(key);
            if (object != null) {
                objects.add(object);
                ExceptionHandler.debugLog("&aSUCCESS | Item " + key + " read successfully!");
                continue;
            }
            ExceptionHandler.debugLog("&cFAILURE | Item " + key + " read failed!");
        }
        return objects;
    }

    protected void putLateInit(String key) {
        this.lateInits.add(key);
    }

    public List<T> loadLateInits() {
        ArrayList objects = new ArrayList();
        this.lateInits.forEach(key -> {
            ExceptionHandler.debugLog("Starting to read late initialization item: " + key);
            T object = this.readEach((String)key);
            if (object != null) {
                objects.add(object);
                ExceptionHandler.debugLog("&aSUCCESS | Item " + key + " read successfully!");
            } else {
                ExceptionHandler.debugLog("&cFAILURE | Item " + key + " read failed!");
            }
        });
        this.lateInits.clear();
        return objects;
    }

    public abstract List<SlimefunItemStack> preloadItems(String var1);

    private boolean checkForRegistration(String key, ConfigurationSection section) {
        if (section == null) {
            return true;
        }
        List conditions = section.getStringList("conditions");
        boolean warn = section.getBoolean("warn", false);
        boolean unfinished = section.getBoolean("unfinished", false);
        if (unfinished) {
            return false;
        }
        for (String condition : conditions) {
            String[] splits = condition.split(" ");
            String head = splits[0];
            if (head.equalsIgnoreCase("hasplugin")) {
                if (splits.length != 2) {
                    ExceptionHandler.handleError("Issue found while reading registration condition for " + key + ": hasplugin requires only one parameter");
                    continue;
                }
                boolean b = Bukkit.getPluginManager().isPluginEnabled(splits[1]);
                if (!b) {
                    if (warn) {
                        ExceptionHandler.handleError(key + " requires server plugin " + splits[1] + " to be registered");
                    }
                    return false;
                }
            } else if (head.equalsIgnoreCase("!hasplugin")) {
                if (splits.length != 2) {
                    ExceptionHandler.handleError("Issue found while reading registration condition for " + key + ": !hasplugin requires only one parameter");
                    continue;
                }
                boolean b = Bukkit.getPluginManager().isPluginEnabled(splits[1]);
                if (b) {
                    if (warn) {
                        ExceptionHandler.handleError(key + " requires server plugin " + splits[1] + " to be uninstalled to be registered (possible conflict?)");
                    }
                    return false;
                }
            } else if (head.equalsIgnoreCase("version")) {
                int targetMinor;
                int targetMajor;
                block57: {
                    if (splits.length != 3) {
                        ExceptionHandler.handleError("Issue found while reading registration condition for " + key + ": version requires two parameters");
                        continue;
                    }
                    targetMajor = 0;
                    targetMinor = 0;
                    String[] versionSplit = splits[2].split("\\.");
                    if (versionSplit.length == 2) {
                        try {
                            targetMajor = Integer.parseInt(versionSplit[1]);
                            break block57;
                        }
                        catch (NumberFormatException e) {
                            ExceptionHandler.handleError("Issue found while reading registration condition for " + key + ": version number " + splits[2] + " is not a valid version number!");
                            continue;
                        }
                    }
                    if (versionSplit.length == 3) {
                        try {
                            targetMajor = Integer.parseInt(versionSplit[1]);
                            targetMinor = Integer.parseInt(versionSplit[2]);
                            break block57;
                        }
                        catch (NumberFormatException e) {
                            ExceptionHandler.handleError("Issue found while reading registration condition for " + key + ": version number " + splits[2] + " is not a valid version number!");
                            continue;
                        }
                    }
                    ExceptionHandler.handleError("Issue found while reading registration condition for " + key + ": version number " + splits[2] + " is not a valid version number!");
                }
                boolean pass = false;
                switch (splits[1]) {
                    case ">": {
                        if (MAJOR_VERSION <= targetMajor && (MAJOR_VERSION != targetMajor || MINOR_VERSION <= targetMinor)) break;
                        pass = true;
                        break;
                    }
                    case "<": {
                        if (MAJOR_VERSION >= targetMajor && (MAJOR_VERSION != targetMajor || MINOR_VERSION >= targetMinor)) break;
                        pass = true;
                        break;
                    }
                    case ">=": {
                        if (MAJOR_VERSION <= targetMajor && (MAJOR_VERSION != targetMajor || MINOR_VERSION < targetMinor)) break;
                        pass = true;
                        break;
                    }
                    case "<=": {
                        if (MAJOR_VERSION >= targetMajor && (MAJOR_VERSION != targetMajor || MINOR_VERSION > targetMinor)) break;
                        pass = true;
                        break;
                    }
                    case "==": {
                        if (MAJOR_VERSION != targetMajor || MINOR_VERSION != targetMinor) break;
                        pass = true;
                        break;
                    }
                    case "!=": {
                        if (MAJOR_VERSION == targetMajor && MINOR_VERSION == targetMinor) break;
                        pass = true;
                        break;
                    }
                    default: {
                        ExceptionHandler.handleError("Issue found while reading registration condition for " + key + ": version requires a valid comparison operator!");
                        pass = true;
                    }
                }
                if (!pass) {
                    if (warn) {
                        ExceptionHandler.handleError(key + " requires server version " + splits[1] + " " + splits[2] + " to be registered");
                    }
                    return false;
                }
            } else if (head.contains("config")) {
                CustomAddonConfig config = this.addon.getConfig();
                if (config == null) {
                    ExceptionHandler.handleError("Issue found while reading registration condition for " + key + ": unable to get configuration");
                    continue;
                }
                switch (head) {
                    case "config.boolean": {
                        if (splits.length != 2) {
                            ExceptionHandler.handleError("Issue found while reading registration condition for " + key + ": config.boolean requires one parameter");
                            break;
                        }
                        if (config.config().getBoolean(splits[1])) break;
                        if (warn) {
                            ExceptionHandler.handleError(key + " requires configuration option " + splits[1] + " to be true to be registered");
                        }
                        return false;
                    }
                    case "config.string": {
                        if (splits.length != 3) {
                            ExceptionHandler.handleError("Issue found while reading registration condition for " + key + ": config.string requires two parameters");
                            break;
                        }
                        if (Objects.equals(config.config().getString(splits[1]), splits[2])) break;
                        if (warn) {
                            ExceptionHandler.handleError(key + " requires configuration option " + splits[1] + " to be " + splits[2] + " to be registered");
                        }
                        return false;
                    }
                    case "config.int": {
                        int destination;
                        if (splits.length != 4) {
                            ExceptionHandler.handleError("Issue found while reading registration condition for " + key + ": config.int requires three parameters");
                            break;
                        }
                        String configKey = splits[1];
                        int current = config.config().getInt(splits[2]);
                        if (this.intCheck(splits[1], key, "config.int", current, destination = Integer.parseInt(splits[3]), op -> "Needs the config value of " + configKey + op + splits[3] + ", so that it can be registered", warn)) break;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean intCheck(String operator, String key, String regParam, int current, int destination, Function<String, String> msg, boolean warn) {
        boolean b;
        String operation = "";
        switch (operator) {
            case ">": {
                boolean bl;
                operation = "greater than";
                if (current > destination) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "<": {
                boolean bl;
                operation = "less than";
                if (current < destination) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case ">=": {
                boolean bl;
                operation = "greater than or equal to";
                if (current >= destination) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "<=": {
                boolean bl;
                operation = "less than or equal to";
                if (current <= destination) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "==": {
                boolean bl;
                operation = "equal to";
                if (current == destination) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "!=": {
                boolean bl;
                operation = "not equal to";
                if (current != destination) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                ExceptionHandler.handleError("Issue found while reading registration condition for " + key + ": " + regParam + " requires a valid comparison operator!");
                boolean bl = b = true;
            }
        }
        if (!b && warn) {
            ExceptionHandler.handleError(key + msg.apply(operation));
        }
        return b;
    }
}

