/*
 * Decompiled with CFR 0.152.
 */
package org.lins.mmmjjkx.rykenslimefuncustomizer.objects.slimefun;

import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.LoopIterator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.lins.mmmjjkx.rykenslimefuncustomizer.RykenSlimefunCustomizer;

public class AsyncChanceRecipeTask
implements Runnable {
    private final Map<Integer, LoopIterator<ItemStack>> iterators = new HashMap<Integer, LoopIterator<ItemStack>>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private Inventory inventory;
    private int id;

    public void start(@Nonnull Inventory inv) {
        Validate.notNull((Object)inv, (String)"Inventory must not be null");
        this.inventory = inv;
        this.id = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)RykenSlimefunCustomizer.INSTANCE, (Runnable)this, 0L, 14L).getTaskId();
    }

    public void add(int slot, @Nonnull List<ItemStack> item) {
        Validate.notNull(item, (String)"Cannot add a null list of ItemStacks");
        this.lock.writeLock().lock();
        try {
            this.iterators.put(slot, (LoopIterator<ItemStack>)new LoopIterator(item));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean isEmpty() {
        boolean var1;
        this.lock.readLock().lock();
        try {
            var1 = this.iterators.isEmpty();
        }
        finally {
            this.lock.readLock().unlock();
        }
        return var1;
    }

    @Override
    public void run() {
        if (this.inventory.getViewers().isEmpty()) {
            Bukkit.getScheduler().cancelTask(this.id);
        } else {
            this.lock.readLock().lock();
            try {
                for (Map.Entry<Integer, LoopIterator<ItemStack>> entry : this.iterators.entrySet()) {
                    this.inventory.setItem(entry.getKey().intValue(), (ItemStack)entry.getValue().next());
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }
}

