/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.relicsofcthonia.listeners;

import io.github.thebusybiscuit.slimefun4.api.events.BlockPlacerPlaceEvent;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import ne.fnfal113.relicsofcthonia.RelicsOfCthonia;
import ne.fnfal113.relicsofcthonia.RelicsRegistry;
import ne.fnfal113.relicsofcthonia.slimefun.relics.AbstractRelic;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class MiningListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled() || event.getPlayer().getWorld().getEnvironment() != World.Environment.NETHER) {
            return;
        }
        Block block = event.getBlock();
        if (block.hasMetadata("placed_block")) {
            block.removeMetadata("placed_block", (Plugin)RelicsOfCthonia.getInstance());
            return;
        }
        int dropped = 0;
        List<AbstractRelic> relics = RelicsRegistry.BLOCK_SOURCES.get(block.getType());
        if (relics == null || relics.isEmpty()) {
            return;
        }
        Collections.shuffle(relics);
        for (AbstractRelic relic : relics) {
            if (relic.isDisabledIn(event.getPlayer().getWorld()) || relic.isDisabled() || !(ThreadLocalRandom.current().nextDouble() < relic.getDropChance())) continue;
            ItemStack drop = relic.randomRelic();
            block.getWorld().dropItemNaturally(block.getLocation(), drop);
            if (++dropped < 2) continue;
            break;
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onBlockPlace(BlockPlaceEvent event) {
        event.getBlock().setMetadata("placed_block", (MetadataValue)new FixedMetadataValue((Plugin)RelicsOfCthonia.getInstance(), (Object)"placed"));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onBlockPlacerPlaced(BlockPlacerPlaceEvent event) {
        event.getBlock().setMetadata("placed_block", (MetadataValue)new FixedMetadataValue((Plugin)RelicsOfCthonia.getInstance(), (Object)"placed"));
    }
}

