/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.relicsofcthonia.relics.abstracts;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import ne.fnfal113.relicsofcthonia.RelicsOfCthonia;
import ne.fnfal113.relicsofcthonia.RelicsRegistry;
import ne.fnfal113.relicsofcthonia.config.ConfigManager;
import ne.fnfal113.relicsofcthonia.relics.implementation.NetherMaterials;
import ne.fnfal113.relicsofcthonia.relics.implementation.OffHandRightClickHandler;
import ne.fnfal113.relicsofcthonia.relics.implementation.Rarity;
import ne.fnfal113.relicsofcthonia.utils.Utils;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public abstract class AbstractRelic
extends SlimefunItem
implements OffHandRightClickHandler {
    private final double dropChance;
    private final int defaultDropSize;
    private final int piglinRewardAmount;
    private final List<Material> netherMaterials = new ArrayList<Material>();
    private final ConfigManager configManager = RelicsOfCthonia.getInstance().getConfigManager();
    private final RelicsRegistry relicsRegistry = RelicsOfCthonia.getInstance().getRelicsRegistry();

    @ParametersAreNonnullByDefault
    public AbstractRelic(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, double dropChance, int piglinRewardAmount, int defaultDropSize) {
        super(itemGroup, item, recipeType, recipe);
        this.initializeSettings(dropChance, piglinRewardAmount, defaultDropSize);
        this.dropChance = this.getConfigManager().getCustomConfig("relic-settings").getDouble(this.getId() + ".drop-chance");
        this.piglinRewardAmount = this.getConfigManager().getCustomConfig("relic-settings").getInt(this.getId() + ".piglin-reward-amount");
        this.defaultDropSize = defaultDropSize;
        this.updateRelicLore();
    }

    public void updateRelicLore() {
        Utils.setLoreByConfigValue((ItemStack)Utils.getField(SlimefunItem.class, "itemStackTemplate", this), this.getId(), "drop-chance", "%", "&e", "%", "relic-settings");
        Utils.setLoreByConfigStringList((ItemStack)Utils.getField(SlimefunItem.class, "itemStackTemplate", this), this.getId(), "drops-on-material", "Drops on:", "&e", "\u2023 ", "", "relic-settings");
        Utils.setLoreByConfigStringList((ItemStack)Utils.getField(SlimefunItem.class, "itemStackTemplate", this), this.getId(), "drops-on-mob", "Drops on:", "&e", "\u2023 ", "", "relic-settings");
        Utils.setLoreByConfigStringList((ItemStack)Utils.getField(SlimefunItem.class, "itemStackTemplate", this), this.getId(), "piglin-barter-rewards", "Possible Piglin reward:", "&a", "\u2023 " + this.getPiglinRewardAmount() + " ", "", "relic-settings");
    }

    public void initializeSettings(double dropChance, int piglinRewardAmount, int defaultDropSize) {
        this.initNetherMaterials();
        this.initSingleSectionSettings(dropChance, piglinRewardAmount);
        this.initDefaultWhereToDrop(defaultDropSize);
        this.initDefaultPiglinRewards(defaultDropSize);
        this.setRelicsRegistry();
    }

    public void setRelicsRegistry() {
        try {
            FileConfiguration config = this.getConfigManager().getCustomConfig("relic-settings");
            if (config.isConfigurationSection(this.getId()) && config.getConfigurationSection(this.getId()).contains("drops-on-material")) {
                ArrayList<Material> finalMaterialList = new ArrayList<Material>();
                for (String materials : config.getConfigurationSection(this.getId()).getStringList("drops-on-material")) {
                    finalMaterialList.add(Material.matchMaterial((String)materials));
                }
                this.getRelicsRegistry().getWhereToDropMaterialMap().put(this, finalMaterialList);
            }
            if (config.isConfigurationSection(this.getId()) && config.getConfigurationSection(this.getId()).contains("drops-on-mob")) {
                List finalMobList = config.getConfigurationSection(this.getId()).getStringList("drops-on-mob");
                this.getRelicsRegistry().getWhereToDropMobMap().put(this, finalMobList);
            }
            if (config.isConfigurationSection(this.getId()) && config.getConfigurationSection(this.getId()).contains("piglin-barter-rewards")) {
                List finalRewardList = config.getConfigurationSection(this.getId()).getStringList("piglin-barter-rewards");
                this.getRelicsRegistry().getPiglinRewardList().put(this, finalRewardList);
            }
        }
        catch (IllegalArgumentException | NullPointerException e) {
            RelicsOfCthonia.getInstance().getLogger().info("An error has occurred on adding data to relics registry! Please report on github issue tracker!");
            e.printStackTrace();
        }
    }

    public void initNetherMaterials() {
        this.getNetherMaterials().addAll(NetherMaterials.BASE_STONES_NETHER.getMaterial());
        this.getNetherMaterials().addAll(NetherMaterials.WART_BLOCKS.getMaterial());
        this.getNetherMaterials().addAll(NetherMaterials.GROW_MUSHROOM_BLOCKS.getMaterial());
        this.getNetherMaterials().addAll(NetherMaterials.SOUL_BLOCKS.getMaterial());
        this.getNetherMaterials().addAll(NetherMaterials.INFINIBURN_BLOCKS.getMaterial());
        this.getNetherMaterials().addAll(NetherMaterials.OTHER_BLOCKS.getMaterial());
    }

    public void initSingleSectionSettings(double dropChance, int piglinRewardAmount) {
        try {
            this.getConfigManager().initializeConfig(this.getId(), "drop-chance", dropChance, "relic-settings");
            this.getConfigManager().initializeConfig(this.getId(), "piglin-reward-amount", piglinRewardAmount, "relic-settings");
        }
        catch (IllegalArgumentException | NullPointerException e) {
            RelicsOfCthonia.getInstance().getLogger().info("An error has occurred upon initializing default single section settings! Please report on github issue tracker!");
            e.printStackTrace();
        }
    }

    public void initDefaultWhereToDrop(int defaultDropSize) {
        try {
            int i;
            JsonObject jsonObject = this.configManager.loadJson("nether_mobs");
            ArrayList<String> randomMobList = new ArrayList<String>();
            ArrayList<String> randomMaterialList = new ArrayList<String>();
            for (i = 0; i < defaultDropSize; ++i) {
                String mob = jsonObject.getAsJsonPrimitive("nether_mob_" + ThreadLocalRandom.current().nextInt(1, 12)).getAsString();
                if (randomMobList.contains(mob)) continue;
                randomMobList.add(mob);
            }
            for (i = 0; i < defaultDropSize; ++i) {
                String material = this.getNetherMaterials().get(ThreadLocalRandom.current().nextInt(0, this.getNetherMaterials().size())).toString();
                if (randomMaterialList.contains(material)) continue;
                randomMaterialList.add(material);
            }
            this.getConfigManager().initializeConfig(this.getId(), "drops-on-mob", randomMobList, "relic-settings");
            this.getConfigManager().initializeConfig(this.getId(), "drops-on-material", randomMaterialList, "relic-settings");
        }
        catch (IllegalArgumentException | NullPointerException e) {
            RelicsOfCthonia.getInstance().getLogger().info("An error has occurred upon initializing default drop settings! Please report on github issue tracker!");
            e.printStackTrace();
        }
    }

    public void initDefaultPiglinRewards(int defaultDropSize) {
        try {
            JsonObject jsonObject = this.configManager.loadJson("piglin_barter_list");
            ArrayList<String> randomRewardList = new ArrayList<String>();
            for (int i = 1; i <= defaultDropSize; ++i) {
                String reward = jsonObject.getAsJsonObject(this.getRarity().name()).get("drop-" + ThreadLocalRandom.current().nextInt(1, 8)).getAsString();
                if (randomRewardList.contains(reward)) continue;
                randomRewardList.add(reward);
            }
            this.getConfigManager().initializeConfig(this.getId(), "piglin-barter-rewards", randomRewardList, "relic-settings");
        }
        catch (IllegalArgumentException | NullPointerException e) {
            RelicsOfCthonia.getInstance().getLogger().info("An error has occurred upon initializing default piglin rewards! Please report on github issue tracker!");
            e.printStackTrace();
        }
    }

    public ItemStack setRelicConditionAndGet(boolean isNaturallyDropped, int condition) {
        ItemStack itemStack = this.getItem().clone();
        ItemMeta meta = itemStack.getItemMeta();
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        int randomCondition = isNaturallyDropped ? ThreadLocalRandom.current().nextInt(1, 100) : condition;
        pdc.set(Utils.createKey("relic_condition"), PersistentDataType.INTEGER, (Object)randomCondition);
        itemStack.setItemMeta(meta);
        Utils.setLoreByFixedIntValue(itemStack, randomCondition, "%", "&d", "%");
        return itemStack.clone();
    }

    public int getRelicCondition(@Nonnull ItemStack itemStack) {
        return (Integer)itemStack.getItemMeta().getPersistentDataContainer().getOrDefault(Utils.createKey("relic_condition"), PersistentDataType.INTEGER, (Object)0);
    }

    public <T extends OffHandRightClickHandler> void callRelicHandler(Class<T> clazz, Consumer<T> callback, AbstractRelic abstractRelic) {
        if (clazz.isInstance(abstractRelic)) {
            callback.accept((OffHandRightClickHandler)clazz.cast(abstractRelic));
        }
    }

    public void consumeRelic(ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        itemStack.setAmount(itemStack.getAmount() - 1);
    }

    public abstract Rarity getRarity();

    public boolean isDisenchantable() {
        return false;
    }

    public boolean isEnchantable() {
        return false;
    }

    public double getDropChance() {
        return this.dropChance;
    }

    public int getDefaultDropSize() {
        return this.defaultDropSize;
    }

    public int getPiglinRewardAmount() {
        return this.piglinRewardAmount;
    }

    public List<Material> getNetherMaterials() {
        return this.netherMaterials;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public RelicsRegistry getRelicsRegistry() {
        return this.relicsRegistry;
    }
}

