/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.relicsofcthonia.miscellaneous.abstracts;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.items.blocks.UnplaceableBlock;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import ne.fnfal113.relicsofcthonia.RelicsOfCthonia;
import ne.fnfal113.relicsofcthonia.relics.implementation.Rarity;
import ne.fnfal113.relicsofcthonia.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class AbstractRelicVoider
extends UnplaceableBlock {
    private static final ItemStack DECREMENT_CONDITION = CustomItemStack.create((Material)Material.RED_STAINED_GLASS_PANE, (String)"&cDecrement Condition Quota", (String[])new String[]{"&7Click to decrement the quota by 1"});
    private static final ItemStack INCREMENT_CONDITION = CustomItemStack.create((Material)Material.GREEN_STAINED_GLASS_PANE, (String)"&cIncrement Condition Quota", (String[])new String[]{"&7Click to increment the quota by 1"});
    private final boolean notifEnabled = RelicsOfCthonia.getInstance().getConfig().getBoolean("enable-relic-voider-notif", true);
    private final Rarity rarity;
    final NamespacedKey conditionKey;

    public AbstractRelicVoider(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Rarity rarity) {
        super(itemGroup, item, recipeType, recipe);
        this.rarity = rarity;
        this.conditionKey = new NamespacedKey((Plugin)RelicsOfCthonia.getInstance(), "condition_quota");
    }

    public void onInventoryClick(InventoryClickEvent event, ItemStack itemStack) {
        ItemStack currentClickedItem = event.getCurrentItem();
        if (currentClickedItem.getType() == Material.RED_STAINED_GLASS_PANE) {
            this.setConditionQuota(itemStack, event.getInventory(), -1);
        } else if (currentClickedItem.getType() == Material.GREEN_STAINED_GLASS_PANE) {
            this.setConditionQuota(itemStack, event.getInventory(), 1);
        }
    }

    public void setConditionQuota(ItemStack itemStack, Inventory inventory, int integer) {
        ItemMeta meta = itemStack.getItemMeta();
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        int conditionQuota = (Integer)pdc.getOrDefault(this.getConditionKey(), PersistentDataType.INTEGER, (Object)0);
        int finalCondition = conditionQuota + integer;
        if (finalCondition < 0 || finalCondition > 100) {
            return;
        }
        pdc.set(this.getConditionKey(), PersistentDataType.INTEGER, (Object)finalCondition);
        itemStack.setItemMeta(meta);
        inventory.setItem(4, CustomItemStack.create((Material)Material.PURPLE_STAINED_GLASS, (String)("&fVoids any " + this.getRarity().name() + " relic whose"), (String[])new String[]{"&fcondition is below &6&l" + finalCondition + "%"}));
    }

    public void onClick(ItemStack itemStack, Player player) {
        ItemMeta meta = itemStack.getItemMeta();
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        int conditionQuota = (Integer)pdc.getOrDefault(this.getConditionKey(), PersistentDataType.INTEGER, (Object)0);
        Inventory inventory = Bukkit.createInventory(null, (int)9, (String)Utils.colorTranslator(meta.getDisplayName()));
        for (int i = 0; i < inventory.getSize(); ++i) {
            if (i == 0) {
                inventory.setItem(i, DECREMENT_CONDITION);
                continue;
            }
            if (i == 8) {
                inventory.setItem(i, INCREMENT_CONDITION);
                continue;
            }
            if (i == 4) {
                inventory.setItem(i, CustomItemStack.create((Material)Material.PURPLE_STAINED_GLASS, (String)("&fVoids any " + this.getRarity().name() + " relic whose"), (String[])new String[]{"&fcondition is below &6&l" + conditionQuota + "%"}));
                continue;
            }
            inventory.setItem(i, ChestMenuUtils.getBackground());
        }
        player.openInventory(inventory);
    }

    public void onRelicPickup(EntityPickupItemEvent event, ItemStack voider, Item pickedUpRelic, int pickedUpRelicCondition) {
        ItemMeta meta = voider.getItemMeta();
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        int conditionQuota = (Integer)pdc.getOrDefault(this.getConditionKey(), PersistentDataType.INTEGER, (Object)0);
        if (pickedUpRelicCondition <= conditionQuota) {
            if (this.isNotifEnabled()) {
                Utils.sendRelicMessage("&6Successfully voided &r" + pickedUpRelic.getItemStack().getItemMeta().getDisplayName(), event.getEntity());
            }
            pickedUpRelic.remove();
            event.setCancelled(true);
        }
    }

    public boolean isNotifEnabled() {
        return this.notifEnabled;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public NamespacedKey getConditionKey() {
        return this.conditionKey;
    }
}

