/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.relicsofcthonia.listeners;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.items.misc.StrangeNetherGoo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import ne.fnfal113.relicsofcthonia.RelicsOfCthonia;
import ne.fnfal113.relicsofcthonia.relics.abstracts.AbstractRelic;
import ne.fnfal113.relicsofcthonia.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.PiglinBarterEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class PiglinMainListener
implements Listener {
    private final Map<UUID, UUID> currentTradeMap = new HashMap<UUID, UUID>();

    @EventHandler
    public void onPiglinRightClick(PlayerInteractEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getRightClicked() instanceof Piglin)) {
            return;
        }
        Piglin piglin = (Piglin)event.getRightClicked();
        Player player = event.getPlayer();
        if (event.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        if (!piglin.isAdult()) {
            return;
        }
        if (piglin.hasMetadata("NPC")) {
            return;
        }
        if (piglin.hasMetadata("relic_trader")) {
            Utils.sendRelicMessage("&ePiglin is currently in trade!", (LivingEntity)player);
            event.setCancelled(true);
            return;
        }
        ItemStack mainHandItem = player.getInventory().getItemInMainHand();
        Optional<SlimefunItem> sfItem = Optional.ofNullable(SlimefunItem.getByItem((ItemStack)mainHandItem));
        if (!sfItem.isPresent()) {
            return;
        }
        if (sfItem.get() instanceof AbstractRelic) {
            piglin.addBarterMaterial(mainHandItem.getType());
            piglin.setMetadata("relic_trader", (MetadataValue)new FixedMetadataValue((Plugin)RelicsOfCthonia.getInstance(), (Object)"trading"));
            this.getCurrentTradeMap().put(piglin.getUniqueId(), player.getUniqueId());
            Utils.createDelayedTask(task -> {
                piglin.setAI(false);
                piglin.setInvulnerable(true);
                piglin.setGlowing(true);
                EntityEquipment entityEquipment = piglin.getEquipment();
                entityEquipment.setItemInOffHand(mainHandItem);
                mainHandItem.setAmount(mainHandItem.getAmount() - 1);
                Location loc = piglin.getLocation().clone();
                loc.setPitch(47.0f);
                piglin.teleport(loc);
            }, 2L);
            Utils.createDelayedTask(task -> {
                Location loc = piglin.getLocation().clone();
                loc.setDirection(player.getLocation().getDirection().multiply(-1));
                piglin.teleport(loc);
            }, 25L);
            Utils.createDelayedTask(task -> {
                Location loc = piglin.getLocation().clone();
                loc.setPitch(47.0f);
                piglin.teleport(loc);
            }, 45L);
            Utils.createDelayedTask(task -> {
                piglin.setAI(true);
                piglin.setInvulnerable(false);
                piglin.setGlowing(false);
            }, 90L);
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onDrop(EntityDropItemEvent event) {
        if (!(event.getEntity() instanceof Piglin)) {
            return;
        }
        if (!event.getEntity().hasMetadata("relic_trader")) {
            return;
        }
        this.removePiglinMetadata((Piglin)event.getEntity());
        ItemStack itemStack = event.getItemDrop().getItemStack();
        if (SlimefunItem.getByItem((ItemStack)itemStack) instanceof StrangeNetherGoo && !event.isCancelled()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBarter(PiglinBarterEvent event) {
        if (!event.getEntity().hasMetadata("relic_trader")) {
            return;
        }
        Piglin piglin = event.getEntity();
        if (event.isCancelled()) {
            this.clearTradeData(event, piglin);
            this.executeTradeMessage(event, "&cFailed trade! piglin is not allowed to trade in the current location!");
            return;
        }
        Optional<SlimefunItem> sfItem = Optional.ofNullable(SlimefunItem.getByItem((ItemStack)event.getInput()));
        if (!sfItem.isPresent()) {
            this.clearTradeData(event, piglin);
            this.executeTradeMessage(event, "&cFailed trade! the barter item you gave is not a cthonian relic.");
            return;
        }
        if (sfItem.get() instanceof AbstractRelic) {
            boolean haveCondition;
            AbstractRelic relic = (AbstractRelic)sfItem.get();
            int relicCondition = relic.getRelicCondition(event.getInput());
            boolean bl = haveCondition = relicCondition != 0;
            if (haveCondition && ThreadLocalRandom.current().nextInt(0, 100) > relicCondition) {
                this.removeBarterMaterial(event);
                this.executeTradeMessage(event, "&cUnsuccessful trade! piglin trader is not satisfied with the relic condition and got destroyed upon examining!");
                return;
            }
            if (RelicsOfCthonia.getInstance().getRelicsRegistry().getPiglinRewardList().containsKey(relic)) {
                List<String> rewardList = RelicsOfCthonia.getInstance().getRelicsRegistry().getPiglinRewardList().get(relic);
                int randomRewardIndex = ThreadLocalRandom.current().nextInt(0, rewardList.size());
                int rewardAmount = relic.getPiglinRewardAmount();
                String item = rewardList.get(randomRewardIndex);
                Optional<SlimefunItem> sfRewardItem = Optional.ofNullable(SlimefunItem.getById((String)item));
                Optional<Material> rewardItem = Optional.ofNullable(Material.matchMaterial((String)item));
                this.removeBarterMaterial(event);
                event.getOutcome().clear();
                rewardItem.ifPresent(material -> event.getOutcome().add(new ItemStack(material, rewardAmount)));
                sfRewardItem.ifPresent(slimefunItem -> {
                    ItemStack finalReward = new ItemStack(slimefunItem.getItem()).clone();
                    finalReward.setAmount(rewardAmount);
                    event.getOutcome().add(finalReward);
                });
                this.executeTradeMessage(event, "&aSuccessful trade! Piglin trader is happy to trade with you anytime!");
                piglin.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, piglin.getLocation().add(0.0, 2.2, 0.0), 0);
                piglin.getWorld().playSound(piglin.getLocation(), Sound.ENTITY_PIGLIN_ADMIRING_ITEM, 1.0f, 1.0f);
                if (!haveCondition) {
                    this.executeTradeMessage(event, "&aRelic obtained from sf give command, successful trade!");
                }
            } else {
                this.removeBarterMaterial(event);
            }
        }
    }

    public void clearTradeData(PiglinBarterEvent event, Piglin piglin) {
        this.removeBarterMaterial(event);
        this.removePiglinMetadata(piglin);
    }

    public void removePiglinMetadata(Piglin piglin) {
        piglin.removeMetadata("relic_trader", (Plugin)RelicsOfCthonia.getInstance());
    }

    public void removeBarterMaterial(PiglinBarterEvent event) {
        event.getEntity().removeBarterMaterial(event.getInput().getType());
    }

    public void executeTradeMessage(PiglinBarterEvent event, String message) {
        Optional<Player> player = Optional.ofNullable(Bukkit.getPlayer((UUID)this.getCurrentTradeMap().get(event.getEntity().getUniqueId())));
        this.getCurrentTradeMap().remove(event.getEntity().getUniqueId());
        player.ifPresent(p -> Utils.sendRelicMessage(message, (LivingEntity)p));
    }

    @EventHandler
    public void onEntityDeathEvent(EntityDeathEvent e) {
        LivingEntity livingEntity = e.getEntity();
        if (!(livingEntity instanceof Piglin)) {
            return;
        }
        Piglin piglin = (Piglin)livingEntity;
        if (piglin.hasMetadata("relic_trader")) {
            e.getDrops().clear();
            piglin.removeMetadata("relic_trader", (Plugin)RelicsOfCthonia.getInstance());
        }
    }

    public Map<UUID, UUID> getCurrentTradeMap() {
        return this.currentTradeMap;
    }
}

