/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.relicsofcthonia.listeners;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import ne.fnfal113.relicsofcthonia.RelicsOfCthonia;
import ne.fnfal113.relicsofcthonia.relics.abstracts.AbstractRelic;
import ne.fnfal113.relicsofcthonia.utils.Utils;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class MobKillListener
implements Listener {
    private final Map<AbstractRelic, List<String>> whereToDropMobMap = RelicsOfCthonia.getInstance().getRelicsRegistry().getWhereToDropMobMap();

    @EventHandler
    public void onMobSpawn(CreatureSpawnEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getSpawnReason() != CreatureSpawnEvent.SpawnReason.SPAWNER) {
            return;
        }
        if (event.getEntity().getWorld().getEnvironment() != World.Environment.NETHER) {
            return;
        }
        LivingEntity entity = event.getEntity();
        entity.setMetadata("relic_spawned_mob", (MetadataValue)new FixedMetadataValue((Plugin)RelicsOfCthonia.getInstance(), (Object)"spawned_mob"));
    }

    @EventHandler
    public void onMobKill(EntityDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity.getKiller() == null) {
            return;
        }
        if (livingEntity.getWorld().getEnvironment() != World.Environment.NETHER) {
            return;
        }
        if (livingEntity.hasMetadata("relic_spawned_mob")) {
            livingEntity.removeMetadata("relic_spawned_mob", (Plugin)RelicsOfCthonia.getInstance());
            return;
        }
        String entityType = livingEntity.getType().name().toLowerCase();
        World world = livingEntity.getWorld();
        ThreadLocalRandom currentRandomThread = ThreadLocalRandom.current();
        AtomicInteger i = new AtomicInteger(0);
        Utils.createAsyncTask(asyncTask -> {
            for (Map.Entry<AbstractRelic, List<String>> entry : this.getWhereToDropMobMap().entrySet()) {
                AbstractRelic abstractRelic = entry.getKey();
                if (abstractRelic.isDisabledIn(world) || abstractRelic.isDisabled() || !entry.getValue().contains(entityType)) continue;
                double randomOrigin = currentRandomThread.nextDouble(0.0, 60.0);
                double randomNum = currentRandomThread.nextDouble(randomOrigin, 100.0);
                if (randomNum < abstractRelic.getDropChance()) {
                    ItemStack drop = abstractRelic.setRelicCondition(true, 0);
                    Utils.createSyncTask(syncTask -> livingEntity.getWorld().dropItemNaturally(livingEntity.getLocation(), drop));
                    i.getAndIncrement();
                }
                if (i.get() != 2) continue;
                return;
            }
        });
    }

    public Map<AbstractRelic, List<String>> getWhereToDropMobMap() {
        return this.whereToDropMobMap;
    }
}

