/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.relicsofcthonia.config;

import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ne.fnfal113.relicsofcthonia.RelicsOfCthonia;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private File customConfigFile;
    private FileConfiguration customConfig;
    private final Map<String, Integer> integerValues = new HashMap<String, Integer>();
    private final Map<String, Double> doubleValues = new HashMap<String, Double>();
    private final Map<String, Boolean> booleanValues = new HashMap<String, Boolean>();
    private final Map<String, String> stringValues = new HashMap<String, String>();
    private final Map<String, List<String>> stringListValues = new HashMap<String, List<String>>();
    private final List<String> autoUpdateFile = new ArrayList<String>();

    public void setConfigBooleanValues(String itemNameSection, String settings, boolean bool, String fileName, boolean autoUpdate) throws IOException {
        if (this.initializeConfig(itemNameSection, settings, bool, fileName, autoUpdate)) {
            this.getCustomConfig().save(this.customConfigFile);
            if (this.getCustomConfig().isConfigurationSection(itemNameSection)) {
                boolean value = this.getCustomConfig().getConfigurationSection(itemNameSection).getBoolean(settings, false);
                this.booleanValues.put(itemNameSection + "." + settings, value);
            }
        }
    }

    public void setConfigIntegerValues(String itemNameSection, String settings, int val, String fileName, boolean autoUpdate) throws IOException {
        if (this.initializeConfig(itemNameSection, settings, val, fileName, autoUpdate)) {
            this.getCustomConfig().save(this.customConfigFile);
            if (this.getCustomConfig().isConfigurationSection(itemNameSection)) {
                int value = this.getCustomConfig().getConfigurationSection(itemNameSection).getInt(settings, 0);
                this.integerValues.put(itemNameSection + "." + settings, value);
            }
        }
    }

    public void setConfigDoubleValues(String itemNameSection, String settings, double val, String fileName, boolean autoUpdate) throws IOException {
        if (this.initializeConfig(itemNameSection, settings, val, fileName, autoUpdate)) {
            this.getCustomConfig().save(this.customConfigFile);
            if (this.getCustomConfig().isConfigurationSection(itemNameSection)) {
                double value = this.getCustomConfig().getConfigurationSection(itemNameSection).getDouble(settings, 0.0);
                this.doubleValues.put(itemNameSection + "." + settings, value);
            }
        }
    }

    public void setConfigStringValues(String itemNameSection, String settings, String val, String fileName, boolean autoUpdate) throws IOException {
        if (this.initializeConfig(itemNameSection, settings, val, fileName, autoUpdate)) {
            this.getCustomConfig().save(this.customConfigFile);
            if (this.getCustomConfig().isConfigurationSection(itemNameSection)) {
                String value = this.getCustomConfig().getConfigurationSection(itemNameSection).getString(settings, "null");
                this.stringValues.put(itemNameSection + "." + settings, value);
            }
        }
    }

    public void setConfigStringListValues(String itemNameSection, String settings, List<String> val, String fileName, boolean autoUpdate) throws IOException {
        if (this.initializeConfig(itemNameSection, settings, val, fileName, autoUpdate)) {
            this.getCustomConfig().save(this.customConfigFile);
            if (this.getCustomConfig().isConfigurationSection(itemNameSection)) {
                List value = this.getCustomConfig().getConfigurationSection(itemNameSection).getStringList(settings);
                this.stringListValues.put(itemNameSection + "." + settings, value);
            }
        }
    }

    public <T> boolean initializeConfig(String itemNameSection, String settings, T val, String fileName, boolean autoUpdate) {
        if (!this.loadOrCreateCustomConfig(fileName, autoUpdate)) {
            return false;
        }
        if (autoUpdate) {
            if (!this.getCustomConfig().isConfigurationSection(itemNameSection)) {
                this.getCustomConfig().createSection(itemNameSection).set(settings, val);
            } else if (!this.getCustomConfig().getConfigurationSection(itemNameSection).getKeys(false).contains(settings)) {
                this.getCustomConfig().getConfigurationSection(itemNameSection).set(settings, val);
            }
            this.autoUpdateFile.remove(fileName);
        } else if (!this.getCustomConfig().isConfigurationSection(itemNameSection) && this.autoUpdateFile.contains(fileName)) {
            this.getCustomConfig().createSection(itemNameSection).set(settings, val);
        } else if (this.getCustomConfig().isConfigurationSection(itemNameSection) && this.autoUpdateFile.contains(fileName) && !this.getCustomConfig().getConfigurationSection(itemNameSection).getKeys(false).contains(settings)) {
            this.getCustomConfig().getConfigurationSection(itemNameSection).set(settings, val);
        }
        return true;
    }

    public boolean loadOrCreateCustomConfig(String fileName, boolean autoUpdate) {
        this.customConfigFile = new File(RelicsOfCthonia.getInstance().getDataFolder(), fileName + ".yml");
        if (!this.customConfigFile.exists()) {
            this.customConfigFile.getParentFile().mkdirs();
            RelicsOfCthonia.getInstance().saveResource(fileName + ".yml", false);
            this.autoUpdateFile.add(fileName);
        }
        if (autoUpdate) {
            this.autoUpdateFile.add(fileName);
        }
        this.customConfig = new YamlConfiguration();
        try {
            this.customConfig.load(this.customConfigFile);
            return true;
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
            return false;
        }
    }

    public FileConfiguration loadCustomConfig(String fileName, boolean autoUpdate) {
        this.customConfigFile = new File(RelicsOfCthonia.getInstance().getDataFolder(), fileName + ".yml");
        if (!this.customConfigFile.exists()) {
            this.customConfigFile.getParentFile().mkdirs();
            RelicsOfCthonia.getInstance().saveResource(fileName + ".yml", false);
            this.autoUpdateFile.add(fileName);
        }
        if (autoUpdate) {
            this.autoUpdateFile.add(fileName);
        }
        this.customConfig = new YamlConfiguration();
        try {
            this.customConfig.load(this.customConfigFile);
            return this.customConfig;
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object loadJson(String jsonName) {
        try {
            String line;
            File file = File.createTempFile(jsonName, ".json", new File(System.getProperty("java.io.tmpdir")));
            InputStream inputStream = RelicsOfCthonia.class.getResourceAsStream("/" + jsonName + ".json");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            PrintWriter writer = new PrintWriter(file);
            while ((line = bufferedReader.readLine()) != null) {
                writer.append(line).append(System.getProperty("line.separator"));
            }
            file.deleteOnExit();
            bufferedReader.close();
            writer.close();
            JsonParser parser = new JsonParser();
            return parser.parse((Reader)new FileReader(file));
        }
        catch (JsonParseException | IOException | NullPointerException e) {
            e.printStackTrace();
            return new FileReader("resource not found");
        }
    }

    public FileConfiguration getCustomConfig() {
        return this.customConfig;
    }

    public int getValueById(String itemSection, String setting) {
        return this.getIntegerValues().getOrDefault(itemSection + "." + setting, 0);
    }

    public double getDoubleValueById(String itemSection, String setting) {
        return this.getDoubleValues().getOrDefault(itemSection + "." + setting, 0.0);
    }

    public String getStringById(String itemSection, String setting) {
        return this.getStringValues().getOrDefault(itemSection + "." + setting, "null");
    }

    public List<String> getStringListById(String itemSection, String setting) {
        return this.getStringListValues().getOrDefault(itemSection + "." + setting, new ArrayList());
    }

    public boolean getBoolById(String itemSection, String setting) {
        return this.getBooleanValues().getOrDefault(itemSection + "." + setting, false);
    }

    public void setMapIntValue(String itemSection, String setting, int value) {
        this.getIntegerValues().put(itemSection + "." + setting, value);
    }

    public void setMapDoubleValue(String itemSection, String setting, double value) {
        this.getDoubleValues().put(itemSection + "." + setting, value);
    }

    public void setMapStringValue(String itemSection, String setting, String value) {
        this.getStringValues().put(itemSection + "." + setting, value);
    }

    public void setMapBooleanValue(String itemSection, String setting, boolean value) {
        this.getBooleanValues().put(itemSection + "." + setting, value);
    }

    public Map<String, Integer> getIntegerValues() {
        return this.integerValues;
    }

    public Map<String, Double> getDoubleValues() {
        return this.doubleValues;
    }

    public Map<String, Boolean> getBooleanValues() {
        return this.booleanValues;
    }

    public Map<String, String> getStringValues() {
        return this.stringValues;
    }

    public Map<String, List<String>> getStringListValues() {
        return this.stringListValues;
    }
}

