/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.relicsofcthonia.utils;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import ne.fnfal113.relicsofcthonia.RelicsOfCthonia;
import ne.fnfal113.relicsofcthonia.config.ConfigManager;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class Utils {
    public static String colorTranslator(String strings) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)strings);
    }

    public static void sendRelicMessage(String message, LivingEntity livingEntity) {
        livingEntity.sendMessage(Utils.colorTranslator("&6[RelicsOfCthonia] > " + message));
    }

    public static void setLoreByIntValue(@Nonnull ItemStack itemStack, String section, String settings, String stringToReplace, String color, String suffix) {
        ItemMeta meta = itemStack.getItemMeta();
        List lore = meta.getLore();
        for (int i = 0; i < lore.size(); ++i) {
            int value;
            if (!((String)lore.get(i)).contains(Utils.colorTranslator(color + stringToReplace)) || (value = RelicsOfCthonia.getInstance().getConfigManager().getValueById(section, settings)) == 0) continue;
            String line = ((String)lore.get(i)).replace(Utils.colorTranslator(color + stringToReplace), Utils.colorTranslator(color + value + suffix));
            lore.set(i, line);
        }
        meta.setLore(lore);
        itemStack.setItemMeta(meta);
    }

    public static void setLoreByFixedIntValue(@Nonnull ItemStack itemStack, int value, String stringToReplace, String color, String suffix) {
        ItemMeta meta = itemStack.getItemMeta();
        List lore = meta.getLore();
        for (int i = 0; i < lore.size(); ++i) {
            if (!((String)lore.get(i)).contains(Utils.colorTranslator(color + stringToReplace)) || value == 0) continue;
            String line = ((String)lore.get(i)).replace(Utils.colorTranslator(color + stringToReplace), Utils.colorTranslator(color + value + suffix));
            lore.set(i, line);
        }
        meta.setLore(lore);
        itemStack.setItemMeta(meta);
    }

    public static void setLoreByDoubleValue(@Nonnull ItemStack itemStack, String section, String settings, String stringToReplace, String color, String suffix) {
        ItemMeta meta = itemStack.getItemMeta();
        List lore = meta.getLore();
        for (int i = 0; i < lore.size(); ++i) {
            double value;
            if (!((String)lore.get(i)).contains(Utils.colorTranslator(color + stringToReplace)) || (value = RelicsOfCthonia.getInstance().getConfigManager().getDoubleValueById(section, settings)) == 0.0) continue;
            String line = ((String)lore.get(i)).replace(Utils.colorTranslator(color + stringToReplace), Utils.colorTranslator(color + value + suffix));
            lore.set(i, line);
        }
        meta.setLore(lore);
        itemStack.setItemMeta(meta);
    }

    public static void addLoreByStringList(@Nonnull ItemStack itemStack, String section, String settings, String stringToReplace, String color, String prefix, String suffix) {
        ConfigManager configManager = RelicsOfCthonia.getInstance().getConfigManager();
        ItemMeta meta = itemStack.getItemMeta();
        List lore = meta.getLore();
        int j = 0;
        for (int i = 0; i < lore.size(); ++i) {
            if (!((String)lore.get(i)).contains(Utils.colorTranslator(color + stringToReplace))) continue;
            j = i;
            break;
        }
        for (int x = 0; x <= RelicsOfCthonia.getInstance().getConfigManager().getStringListById(section, settings).size() - 1; ++x) {
            String value = configManager.getStringListById(section, settings).get(x);
            if (value.isEmpty()) continue;
            lore.add(j + 1, Utils.colorTranslator(color + prefix + value.replace("_", " ").toLowerCase()));
        }
        meta.setLore(lore);
        itemStack.setItemMeta(meta);
    }

    public static void createDelayedTask(Consumer<BukkitTask> taskConsumer, long delay) {
        Bukkit.getScheduler().runTaskLater((Plugin)RelicsOfCthonia.getInstance(), taskConsumer, delay);
    }

    public static void createAsyncTask(Consumer<BukkitTask> taskConsumer) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)RelicsOfCthonia.getInstance(), taskConsumer);
    }

    public static void createSyncTask(Consumer<BukkitTask> taskConsumer) {
        Bukkit.getScheduler().runTask((Plugin)RelicsOfCthonia.getInstance(), taskConsumer);
    }

    public static NamespacedKey createKey(String id) {
        return new NamespacedKey((Plugin)RelicsOfCthonia.getInstance(), id.toLowerCase());
    }
}

