/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.relicsofcthonia.listeners;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import ne.fnfal113.relicsofcthonia.RelicsOfCthonia;
import ne.fnfal113.relicsofcthonia.relics.abstracts.AbstractRelic;
import ne.fnfal113.relicsofcthonia.utils.Utils;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class MiningListener
implements Listener {
    private final Map<AbstractRelic, List<Material>> whereToDropMaterialMap = RelicsOfCthonia.getInstance().getRelicsRegistry().getWhereToDropMaterialMap();

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getPlayer().getWorld().getEnvironment() != World.Environment.NETHER) {
            return;
        }
        Block block = event.getBlock();
        Material blockBrokeType = block.getType();
        if (block.hasMetadata("placed_block")) {
            block.removeMetadata("placed_block", (Plugin)RelicsOfCthonia.getInstance());
            return;
        }
        ThreadLocalRandom currentRandomThread = ThreadLocalRandom.current();
        AtomicInteger i = new AtomicInteger(0);
        Utils.createAsyncTask(asyncTask -> {
            for (Map.Entry<AbstractRelic, List<Material>> entry : this.getWhereToDropMaterialMap().entrySet()) {
                if (!entry.getValue().contains(blockBrokeType)) continue;
                double randomOrigin = currentRandomThread.nextDouble(0.0, 60.0);
                double randomNum = currentRandomThread.nextDouble(randomOrigin, 100.0);
                if (randomNum < entry.getKey().getDropChance()) {
                    ItemStack drop = entry.getKey().setRelicCondition(true, 0);
                    Utils.createSyncTask(syncTask -> block.getWorld().dropItemNaturally(block.getLocation(), drop));
                    i.getAndIncrement();
                }
                if (i.get() != 2) continue;
                return;
            }
        });
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (event.isCancelled()) {
            return;
        }
        event.getBlockPlaced().setMetadata("placed_block", (MetadataValue)new FixedMetadataValue((Plugin)RelicsOfCthonia.getInstance(), (Object)"placed"));
    }

    public Map<AbstractRelic, List<Material>> getWhereToDropMaterialMap() {
        return this.whereToDropMaterialMap;
    }
}

