/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.relicsofcthonia.listeners;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.Objects;
import java.util.Optional;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import ne.fnfal113.relicsofcthonia.relics.abstracts.AbstractRelic;
import ne.fnfal113.relicsofcthonia.utils.Utils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class RelicPlaceBreakListener
implements Listener {
    @EventHandler
    public void onRelicClick(PlayerInteractEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        if (event.getClickedBlock() == null) {
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        Player player = event.getPlayer();
        Optional<SlimefunItem> relic = Optional.ofNullable(BlockStorage.check((Block)clickedBlock));
        relic.ifPresent(item -> {
            if (item instanceof AbstractRelic) {
                event.setCancelled(true);
                AbstractRelic abstractRelic = (AbstractRelic)item;
                String value = BlockStorage.getLocationInfo((Location)clickedBlock.getLocation(), (String)"relic_condition");
                if (!Objects.equals(BlockStorage.getLocationInfo((Location)clickedBlock.getLocation(), (String)"owner"), player.getUniqueId().toString())) {
                    player.sendMessage(Utils.colorTranslator("&6Hey, you are not the owner of this relic!"));
                    return;
                }
                ItemStack itemStack = abstractRelic.setRelicCondition(false, Integer.parseInt(value));
                BlockStorage.clearBlockInfo((Block)clickedBlock);
                clickedBlock.setType(Material.AIR);
                if (player.getInventory().firstEmpty() == -1) {
                    clickedBlock.getWorld().dropItemNaturally(clickedBlock.getLocation(), itemStack.clone());
                    return;
                }
                player.getInventory().addItem(new ItemStack[]{itemStack.clone()});
            }
        });
    }

    @EventHandler
    public void onRelicPlace(BlockPlaceEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block blockPlaced = event.getBlockPlaced();
        ItemStack itemInHand = event.getItemInHand();
        Optional<SlimefunItem> relic = Optional.ofNullable(SlimefunItem.getByItem((ItemStack)itemInHand));
        relic.ifPresent(item -> {
            if (item instanceof AbstractRelic) {
                AbstractRelic abstractRelic = (AbstractRelic)item;
                String value = String.valueOf(abstractRelic.getRelicCondition(itemInHand));
                BlockStorage.addBlockInfo((Block)blockPlaced, (String)"relic_condition", (String)value);
                BlockStorage.addBlockInfo((Block)blockPlaced, (String)"owner", (String)event.getPlayer().getUniqueId().toString());
            }
        });
    }

    @EventHandler
    public void onRelicBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block blockBroken = event.getBlock();
        Player player = event.getPlayer();
        Optional<SlimefunItem> relic = Optional.ofNullable(BlockStorage.check((Block)blockBroken));
        relic.ifPresent(item -> {
            if (item instanceof AbstractRelic) {
                event.setCancelled(true);
                BlockStorage.clearBlockInfo((Block)blockBroken);
                blockBroken.setType(Material.AIR);
                player.sendMessage(Utils.colorTranslator("&6You broke the relic! right click the relic instead next time to pick it up."));
            }
        });
    }
}

