/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.relicsofcthonia.listeners;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.core.attributes.PiglinBarterDrop;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import ne.fnfal113.relicsofcthonia.RelicsOfCthonia;
import ne.fnfal113.relicsofcthonia.RelicsRegistry;
import ne.fnfal113.relicsofcthonia.core.Keys;
import ne.fnfal113.relicsofcthonia.slimefun.relics.AbstractRelic;
import ne.fnfal113.relicsofcthonia.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.PiglinBarterEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;

public class PiglinMainListener
implements Listener {
    private static final Map<UUID, ItemStack> DROPPING_ITEM = new HashMap<UUID, ItemStack>();

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void cancelInteractingWhileTrading(PlayerInteractEntityEvent event) {
        Piglin piglin;
        Entity entity = event.getRightClicked();
        if (entity instanceof Piglin && this.isCurrentlyTradingRelic(piglin = (Piglin)entity)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPiglinRightClick(PlayerInteractEntityEvent event) {
        Piglin piglin;
        Player player = event.getPlayer();
        ItemStack mainHandItem = player.getInventory().getItemInMainHand();
        Entity entity = event.getRightClicked();
        if (!(entity instanceof Piglin) || !(piglin = (Piglin)entity).isAdult() || piglin.hasMetadata("NPC") || event.getHand() == EquipmentSlot.OFF_HAND || !(SlimefunItem.getByItem((ItemStack)mainHandItem) instanceof AbstractRelic)) {
            return;
        }
        Material type = mainHandItem.getType();
        piglin.addBarterMaterial(type);
        this.setCurrentlyTradingPlayer(piglin, player);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBarter(PiglinBarterEvent event) {
        Piglin piglin = event.getEntity();
        UUID uuid = this.clearCurrentlyTradingPlayer(piglin);
        if (uuid == null) {
            return;
        }
        Optional<Player> player = Optional.ofNullable(Bukkit.getPlayer((UUID)uuid));
        if (event.isCancelled()) {
            player.ifPresent(p -> Utils.sendRelicMessage("&cThe trade was cancelled by an external source!", (LivingEntity)p));
            return;
        }
        SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)event.getInput());
        if (!(slimefunItem instanceof AbstractRelic)) {
            RelicsOfCthonia.getInstance().getLogger().severe("Something modified the piglin's input item while a RelicsOfCthonia trade was in progress");
            player.ifPresent(p -> Utils.sendRelicMessage("&cThe trade was cancelled by an external source!", (LivingEntity)p));
            return;
        }
        AbstractRelic relic = (AbstractRelic)slimefunItem;
        piglin.removeBarterMaterial(event.getInput().getType());
        if (ThreadLocalRandom.current().nextInt(100) > AbstractRelic.getRelicCondition(event.getInput())) {
            piglin.getWorld().spawnParticle(Particle.ANGRY_VILLAGER, piglin.getLocation().add(0.0, 2.2, 0.0), 0);
            piglin.getWorld().playSound(piglin.getLocation(), Sound.ENTITY_PIGLIN_ANGRY, 1.0f, 1.0f);
            return;
        }
        List<ItemStack> rewards = RelicsRegistry.RELIC_OUTPUTS.get((Object)relic);
        if (rewards == null || rewards.isEmpty()) {
            RelicsOfCthonia.getInstance().getLogger().severe("&cThe relic " + relic.getId() + " does not have a corresponding reward list");
            player.ifPresent(p -> Utils.sendRelicMessage("&cThe relic has no configured rewards, notify your server!", (LivingEntity)p));
            return;
        }
        int rewardIndex = ThreadLocalRandom.current().nextInt(0, rewards.size());
        ItemStack reward = rewards.get(rewardIndex).clone();
        reward.setAmount(relic.getPiglinRewardAmount());
        event.getOutcome().clear();
        event.getOutcome().add(reward);
        DROPPING_ITEM.put(piglin.getUniqueId(), reward);
        piglin.getWorld().spawnParticle(Particle.HAPPY_VILLAGER, piglin.getLocation().add(0.0, 2.2, 0.0), 0);
        piglin.getWorld().playSound(piglin.getLocation(), Sound.ENTITY_PIGLIN_ADMIRING_ITEM, 1.0f, 1.0f);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDamage(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Piglin) {
            Piglin piglin = (Piglin)entity;
            this.clearCurrentlyTradingPlayer(piglin);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDrop(EntityDropItemEvent event) {
        ItemStack droppingItem = DROPPING_ITEM.remove(event.getEntity().getUniqueId());
        if (droppingItem != null && SlimefunItem.getByItem((ItemStack)event.getItemDrop().getItemStack()) instanceof PiglinBarterDrop) {
            event.getItemDrop().setItemStack(droppingItem);
        }
    }

    private void setCurrentlyTradingPlayer(Piglin piglin, Player player) {
        piglin.getPersistentDataContainer().set(Keys.CURRENTLY_TRADING_PLAYER, PersistentDataType.STRING, (Object)player.getUniqueId().toString());
    }

    private UUID clearCurrentlyTradingPlayer(Piglin piglin) {
        UUID uuid = this.getCurrentlyTradingPlayer(piglin);
        piglin.getPersistentDataContainer().remove(Keys.CURRENTLY_TRADING_PLAYER);
        return uuid;
    }

    private UUID getCurrentlyTradingPlayer(Piglin piglin) {
        String idString = (String)piglin.getPersistentDataContainer().get(Keys.CURRENTLY_TRADING_PLAYER, PersistentDataType.STRING);
        return idString == null ? null : UUID.fromString(idString);
    }

    private boolean isCurrentlyTradingRelic(Piglin piglin) {
        return this.getCurrentlyTradingPlayer(piglin) != null && SlimefunItem.getByItem((ItemStack)piglin.getEquipment().getItemInOffHand()) instanceof AbstractRelic;
    }
}

