/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.relicsofcthonia.slimefun.relics;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.implementation.items.blocks.UnplaceableBlock;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import ne.fnfal113.relicsofcthonia.RelicsOfCthonia;
import ne.fnfal113.relicsofcthonia.RelicsRegistry;
import ne.fnfal113.relicsofcthonia.api.Rarity;
import ne.fnfal113.relicsofcthonia.core.Keys;
import ne.fnfal113.relicsofcthonia.core.RecipeTypes;
import ne.fnfal113.relicsofcthonia.utils.Utils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractRelic
extends UnplaceableBlock {
    private static final List<Material> DEFAULT_BLOCK_SOURCES = List.of(Material.NETHERRACK, Material.BLACKSTONE, Material.BASALT, Material.MAGMA_BLOCK, Material.SOUL_SOIL, Material.SOUL_SAND, Material.NETHER_WART_BLOCK, Material.WARPED_WART_BLOCK, Material.CRIMSON_NYLIUM, Material.MYCELIUM, Material.PODZOL, Material.WARPED_NYLIUM, Material.GRAVEL, Material.NETHER_GOLD_ORE, Material.NETHER_QUARTZ_ORE, Material.ANCIENT_DEBRIS);
    private final Rarity rarity;
    private final double dropChance;
    private final int piglinRewardAmount;
    private final int defaultDropSize;

    @ParametersAreNonnullByDefault
    public AbstractRelic(ItemGroup itemGroup, SlimefunItemStack item, Rarity rarity, double dropChance, int piglinRewardAmount, int defaultDropSize) {
        super(itemGroup, item, RecipeTypes.DROP_TYPE, new ItemStack[9]);
        this.rarity = rarity;
        this.initSingleSectionSettings(dropChance, piglinRewardAmount);
        this.initDefaultWhereToDrop(defaultDropSize);
        this.initDefaultPiglinRewards(defaultDropSize);
        this.dropChance = RelicsOfCthonia.CONFIG_MANAGER.getCustomConfig("relic-settings").getDouble(this.getId() + ".drop-chance") / 100.0;
        this.piglinRewardAmount = RelicsOfCthonia.CONFIG_MANAGER.getCustomConfig("relic-settings").getInt(this.getId() + ".piglin-reward-amount");
        this.defaultDropSize = defaultDropSize;
    }

    @NotNull
    public ItemStack getItem() {
        return (ItemStack)Utils.getField(SlimefunItem.class, "itemStackTemplate", (Object)this);
    }

    public ItemStack randomRelic() {
        ItemStack itemStack = this.getItem().clone();
        int condition = ThreadLocalRandom.current().nextInt(1, 100);
        itemStack.editMeta(meta -> PersistentDataAPI.setInt((PersistentDataHolder)meta, (NamespacedKey)Keys.RELIC_CONDITION, (int)condition));
        Utils.replaceLoreValue(itemStack, "%", "&d", "", "%", condition);
        return itemStack;
    }

    public static int getRelicCondition(@Nonnull ItemStack itemStack) {
        return PersistentDataAPI.getInt((PersistentDataHolder)itemStack.getItemMeta(), (NamespacedKey)Keys.RELIC_CONDITION, (int)0);
    }

    public void postInit() {
        Utils.replaceLoreValue(this.getItem(), "%", "&e", "", "%", this.dropChance * 100.0);
        this.registerRelic();
    }

    private void registerRelic() {
        ArrayList<String> sourcesLore = new ArrayList<String>();
        ArrayList<String> rewardsLore = new ArrayList<String>();
        try {
            FileConfiguration config = RelicsOfCthonia.CONFIG_MANAGER.getCustomConfig("relic-settings");
            ConfigurationSection section = config.getConfigurationSection(this.getId());
            if (section == null) {
                RelicsOfCthonia.getInstance().getLogger().warning("No configuration section found for relic: " + this.getId());
                return;
            }
            if (section.contains("drops-on-material")) {
                for (String material : section.getStringList("drops-on-material")) {
                    Material mat = Material.matchMaterial((String)material);
                    if (mat == null) {
                        RelicsOfCthonia.getInstance().getLogger().warning("Invalid material '" + material + "' for relic: " + this.getId());
                        continue;
                    }
                    RelicsRegistry.BLOCK_SOURCES.compute(mat, (key, relics) -> {
                        if (relics == null) {
                            relics = new ArrayList<AbstractRelic>();
                        }
                        relics.add(this);
                        return relics;
                    });
                    sourcesLore.add(Utils.translate(mat.getItemTranslationKey()));
                }
            } else {
                RelicsOfCthonia.getInstance().getLogger().warning("No 'drops-on-material' section found for relic: " + this.getId());
            }
            if (section.contains("drops-on-mob")) {
                for (String type : section.getStringList("drops-on-mob")) {
                    try {
                        EntityType entityType = EntityType.valueOf((String)type.toUpperCase());
                        RelicsRegistry.ENTITY_SOURCES.compute(entityType, (mobType, relics) -> {
                            if (relics == null) {
                                relics = new ArrayList<AbstractRelic>();
                            }
                            relics.add(this);
                            return relics;
                        });
                        sourcesLore.add(Utils.translate(entityType.translationKey()));
                    }
                    catch (IllegalArgumentException e) {
                        RelicsOfCthonia.getInstance().getLogger().warning("Invalid entity type '" + type + "' for relic: " + this.getId());
                    }
                }
            } else {
                RelicsOfCthonia.getInstance().getLogger().warning("No 'drops-on-mob' section found for relic: " + this.getId());
            }
            if (section.contains("piglin-barter-rewards")) {
                for (String id : section.getStringList("piglin-barter-rewards")) {
                    Material material = Material.matchMaterial((String)id);
                    SlimefunItem item = SlimefunItem.getById((String)id);
                    if (item == null && material == null) {
                        RelicsOfCthonia.getInstance().getLogger().warning("Invalid item ID '" + id + "' for relic: " + this.getId());
                        continue;
                    }
                    RelicsRegistry.RELIC_OUTPUTS.compute(this, (relic, rewards) -> {
                        if (rewards == null) {
                            rewards = new ArrayList<ItemStack>();
                        }
                        rewards.add(item != null ? item.getItem() : new ItemStack(material));
                        return rewards;
                    });
                    rewardsLore.add(item != null ? ChatColor.stripColor((String)item.getItemName()) : Utils.translate(material.getItemTranslationKey()));
                }
            } else {
                RelicsOfCthonia.getInstance().getLogger().warning("No 'piglin-barter-rewards' section found for relic: " + this.getId());
            }
        }
        catch (Exception e) {
            RelicsOfCthonia.getInstance().getLogger().info("An error has occurred on adding data to relics registry! Please report on github issue tracker!");
            e.printStackTrace();
        }
        Utils.replaceLoreList(this.getItem(), "Drops on:", "&e", "\u2023 ", sourcesLore);
        Utils.replaceLoreList(this.getItem(), "Possible Piglin reward:", "&a", "\u2023 " + this.piglinRewardAmount + "x ", rewardsLore);
    }

    public void initSingleSectionSettings(double dropChance, int piglinRewardAmount) {
        try {
            RelicsOfCthonia.CONFIG_MANAGER.initializeConfig(this.getId(), "drop-chance", dropChance, "relic-settings");
            RelicsOfCthonia.CONFIG_MANAGER.initializeConfig(this.getId(), "piglin-reward-amount", piglinRewardAmount, "relic-settings");
        }
        catch (IllegalArgumentException | NullPointerException e) {
            RelicsOfCthonia.getInstance().getLogger().info("An error has occurred upon initializing default single section settings! Please report on github issue tracker!");
            e.printStackTrace();
        }
    }

    public void initDefaultWhereToDrop(int defaultDropSize) {
        try {
            int i;
            ThreadLocalRandom random = ThreadLocalRandom.current();
            JsonObject jsonObject = RelicsOfCthonia.CONFIG_MANAGER.loadJson("nether_mobs");
            ArrayList<String> randomMobList = new ArrayList<String>();
            ArrayList<String> randomMaterialList = new ArrayList<String>();
            for (i = 0; i < defaultDropSize; ++i) {
                String mob = jsonObject.getAsJsonPrimitive("nether_mob_" + random.nextInt(1, 12)).getAsString();
                if (randomMobList.contains(mob)) continue;
                randomMobList.add(mob);
            }
            for (i = 0; i < defaultDropSize; ++i) {
                String material = DEFAULT_BLOCK_SOURCES.get(random.nextInt(0, DEFAULT_BLOCK_SOURCES.size())).toString();
                if (randomMaterialList.contains(material)) continue;
                randomMaterialList.add(material);
            }
            RelicsOfCthonia.CONFIG_MANAGER.initializeConfig(this.getId(), "drops-on-mob", randomMobList, "relic-settings");
            RelicsOfCthonia.CONFIG_MANAGER.initializeConfig(this.getId(), "drops-on-material", randomMaterialList, "relic-settings");
        }
        catch (IllegalArgumentException | NullPointerException e) {
            RelicsOfCthonia.getInstance().getLogger().info("An error has occurred upon initializing default drop settings! Please report on github issue tracker!");
            e.printStackTrace();
        }
    }

    public void initDefaultPiglinRewards(int defaultDropSize) {
        try {
            JsonObject jsonObject = RelicsOfCthonia.CONFIG_MANAGER.loadJson("piglin_barter_list");
            ArrayList<String> randomRewardList = new ArrayList<String>();
            for (int i = 1; i <= defaultDropSize; ++i) {
                String reward = jsonObject.getAsJsonObject(this.rarity.name()).get("drop-" + ThreadLocalRandom.current().nextInt(1, 8)).getAsString();
                if (randomRewardList.contains(reward)) continue;
                randomRewardList.add(reward);
            }
            RelicsOfCthonia.CONFIG_MANAGER.initializeConfig(this.getId(), "piglin-barter-rewards", randomRewardList, "relic-settings");
        }
        catch (IllegalArgumentException | NullPointerException e) {
            RelicsOfCthonia.getInstance().getLogger().info("An error has occurred upon initializing default piglin rewards! Please report on github issue tracker!");
            e.printStackTrace();
        }
    }

    public boolean isDisenchantable() {
        return false;
    }

    public boolean isEnchantable() {
        return false;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public double getDropChance() {
        return this.dropChance;
    }

    public int getPiglinRewardAmount() {
        return this.piglinRewardAmount;
    }

    public int getDefaultDropSize() {
        return this.defaultDropSize;
    }
}

