/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.rsceditor.core.listeners;

import com.balugaq.rsceditor.utils.Debug;
import io.github.thebusybiscuit.slimefun4.core.attributes.MachineTier;
import io.github.thebusybiscuit.slimefun4.core.attributes.MachineType;
import io.github.thebusybiscuit.slimefun4.core.attributes.Radioactivity;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.Pair;
import io.github.thebusybiscuit.slimefun4.libraries.dough.skins.PlayerHead;
import io.github.thebusybiscuit.slimefun4.libraries.dough.skins.PlayerSkin;
import io.github.thebusybiscuit.slimefun4.utils.LoreBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class ItemEditListener
implements Listener {
    public static final Pattern materialPattern = Pattern.compile("m\\((.+)\\)");
    public static final Pattern hungerPattern = Pattern.compile("h\\(([-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?)\\)");
    public static final Pattern machinePattern = Pattern.compile("ma\\((BASIC|AVERAGE|MEDIUM|GOOD|ADVANCED|END_GAME),\\s*(CAPACITOR|GENERATOR|MACHINE)\\)");
    public static final Pattern radioactivePattern = Pattern.compile("ra\\((LOW|MODERATE|HIGH|VERY_HIGH|VERY_DEADLY)\\)");
    public static final Pattern powerBufferPattern = Pattern.compile("pb\\((\\d+)\\)");
    public static final Pattern powerPerSecondPattern = Pattern.compile("pps\\((\\d+)\\)");
    public static final Pattern powerChargedPattern = Pattern.compile("pc\\((\\d+),\\s*(\\d+)\\)");
    public static final Pattern powerPattern = Pattern.compile("p\\((\\d+),\\s*(.+)\\)");
    public static final Pattern rangePattern = Pattern.compile("r\\((\\d+)\\)");
    public static final Pattern usesLeftPattern = Pattern.compile("ul\\((\\d+)\\)");
    public static final Pattern speedPattern = Pattern.compile("s\\(([-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?)\\)");
    private static final Set<PersistentDataType<?, ?>> types = new HashSet<PersistentDataType>(Arrays.asList(PersistentDataType.STRING, PersistentDataType.DOUBLE, PersistentDataType.INTEGER, PersistentDataType.BYTE, PersistentDataType.BOOLEAN, PersistentDataType.BYTE_ARRAY, PersistentDataType.FLOAT, PersistentDataType.INTEGER_ARRAY, PersistentDataType.LONG, PersistentDataType.LONG_ARRAY, PersistentDataType.SHORT, PersistentDataType.TAG_CONTAINER, PersistentDataType.TAG_CONTAINER_ARRAY));
    private final Set<Player> editingPlayers = new HashSet<Player>();
    private final Map<Player, Integer> selectingLines = new HashMap<Player, Integer>();

    public static String compile(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    @Nonnull
    public static String placeholder(@Nonnull String message) {
        return ItemEditListener.placeholder(message, null);
    }

    @Nonnull
    public static String placeholder(@Nonnull String message, @Nullable Player player) {
        return ItemEditListener.placeholder(message, player, "%0");
    }

    @Nonnull
    public static String placeholder(@Nonnull String message, @Nullable Player player, @Nullable String origin) {
        if (message == null || message.isBlank()) {
            return "";
        }
        String newMessage = message.replace("%ctu", "&eCrouch&7 to use").replace("%hsr", "&8\u21e8 &4Hazmat Suit required!").replace("%rai", "&dCycles through all Colors of the Rainbow!").replace("%rcto", "&eRight Click&7 to open").replace("%rctu", "&eRight Click&7 to use");
        if (origin != null) {
            newMessage = newMessage.replace("%0", origin);
        }
        if (player != null) {
            newMessage = newMessage.replace("%p", player.getName());
        }
        Matcher matcher = materialPattern.matcher(newMessage);
        newMessage = matcher.replaceAll(matchResult -> {
            String material = matchResult.group(1);
            return LoreBuilder.material((String)material);
        });
        Matcher matcher2 = hungerPattern.matcher(newMessage);
        newMessage = matcher2.replaceAll(matchResult -> {
            try {
                double hunger = Double.parseDouble(matchResult.group(1));
                return LoreBuilder.hunger((double)hunger);
            }
            catch (NumberFormatException e) {
                return "";
            }
        });
        Matcher matcher3 = machinePattern.matcher(newMessage);
        newMessage = matcher3.replaceAll(matchResult -> {
            String tier = matchResult.group(1);
            String type = matchResult.group(2);
            try {
                MachineTier tierEnum = MachineTier.valueOf((String)tier);
                MachineType typeEnum = MachineType.valueOf((String)type);
                return LoreBuilder.machine((MachineTier)tierEnum, (MachineType)typeEnum);
            }
            catch (IllegalArgumentException e) {
                return "";
            }
        });
        Matcher matcher4 = radioactivePattern.matcher(newMessage);
        newMessage = matcher4.replaceAll(matchResult -> {
            String radioactivity = matchResult.group(1);
            try {
                Radioactivity radioactivityEnum = Radioactivity.valueOf((String)radioactivity);
                return LoreBuilder.radioactive((Radioactivity)radioactivityEnum);
            }
            catch (IllegalArgumentException e) {
                return "";
            }
        });
        Matcher matcher5 = powerBufferPattern.matcher(newMessage);
        newMessage = matcher5.replaceAll(matchResult -> {
            try {
                int power = Integer.parseInt(matchResult.group(1));
                return LoreBuilder.powerBuffer((int)power);
            }
            catch (NumberFormatException e) {
                return "";
            }
        });
        Matcher matcher6 = powerPerSecondPattern.matcher(newMessage);
        newMessage = matcher6.replaceAll(matchResult -> {
            try {
                int power = Integer.parseInt(matchResult.group(1));
                return LoreBuilder.powerPerSecond((int)power);
            }
            catch (NumberFormatException e) {
                return "";
            }
        });
        Matcher matcher7 = powerChargedPattern.matcher(newMessage);
        newMessage = matcher7.replaceAll(matchResult -> {
            try {
                int charge = Integer.parseInt(matchResult.group(1));
                int capacity = Integer.parseInt(matchResult.group(2));
                return LoreBuilder.powerCharged((int)charge, (int)capacity);
            }
            catch (NumberFormatException e) {
                return "";
            }
        });
        Matcher matcher8 = powerPattern.matcher(newMessage);
        newMessage = matcher8.replaceAll(matchResult -> {
            try {
                int power = Integer.parseInt(matchResult.group(1));
                String suffix = matchResult.group(2);
                return LoreBuilder.power((int)power, (String)suffix);
            }
            catch (NumberFormatException e) {
                return "";
            }
        });
        Matcher matcher9 = rangePattern.matcher(newMessage);
        newMessage = matcher9.replaceAll(matchResult -> {
            try {
                int blocks = Integer.parseInt(matchResult.group(1));
                return LoreBuilder.range((int)blocks);
            }
            catch (NumberFormatException e) {
                return "";
            }
        });
        Matcher matcher10 = usesLeftPattern.matcher(newMessage);
        newMessage = matcher10.replaceAll(matchResult -> {
            try {
                int usesLeft = Integer.parseInt(matchResult.group(1));
                return LoreBuilder.usesLeft((int)usesLeft);
            }
            catch (NumberFormatException e) {
                return "";
            }
        });
        Matcher matcher11 = speedPattern.matcher(newMessage);
        newMessage = matcher11.replaceAll(matchResult -> {
            try {
                float speed = Float.parseFloat(matchResult.group(1));
                return LoreBuilder.speed((float)speed);
            }
            catch (NumberFormatException e) {
                return "";
            }
        });
        return newMessage;
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onEditing(PlayerChatEvent event) {
        Debug.log("editing");
        String message = event.getMessage();
        Player player = event.getPlayer();
        if (!player.isOp()) {
            return;
        }
        if ("rhelp".equals(message)) {
            player.sendMessage(ItemEditListener.compile("&2=========ItemEditor Help========="));
            player.sendMessage(ItemEditListener.compile(""));
            player.sendMessage(ItemEditListener.compile("&brhelp - Show this help message."));
            player.sendMessage(ItemEditListener.compile("&bdone - Exit the editor."));
            player.sendMessage(ItemEditListener.compile("&bl - Enter edit mode"));
            player.sendMessage(ItemEditListener.compile("&2=====ItemEditor Name Commands====="));
            player.sendMessage(ItemEditListener.compile(""));
            player.sendMessage(ItemEditListener.compile("&bn [content] - Set the display name of the item to the specified content."));
            player.sendMessage(ItemEditListener.compile("&bp [content] - Preview the specified content."));
            player.sendMessage(ItemEditListener.compile("&2=====ItemEditor Lore Commands====="));
            player.sendMessage(ItemEditListener.compile(""));
            player.sendMessage(ItemEditListener.compile("&eScroll to select lore lines!"));
            player.sendMessage(ItemEditListener.compile("&bdd - Delete the selected line."));
            player.sendMessage(ItemEditListener.compile("&baa [content] - Add a new line at the end of the lore with the specified content."));
            player.sendMessage(ItemEditListener.compile("&bii [content] - Insert a new line at the selected line with the specified content."));
            player.sendMessage(ItemEditListener.compile("&bmm [content] - Modify the selected line with the specified content."));
            player.sendMessage(ItemEditListener.compile("&2=====ItemEditor Rebase Commands====="));
            player.sendMessage(ItemEditListener.compile(""));
            player.sendMessage(ItemEditListener.compile("&bcc [slot] - Rebase whole current item to the specified slot."));
            player.sendMessage(ItemEditListener.compile("&2=====ItemEditor Other Commands====="));
            player.sendMessage(ItemEditListener.compile(""));
            player.sendMessage(ItemEditListener.compile("&bt<- - Rebase the current item's type to the next slot."));
            player.sendMessage(ItemEditListener.compile("&b->t - Rebase the current item's type to the previous slot."));
            player.sendMessage(ItemEditListener.compile("&btt [hashcode|base64|url|material] - Set the current item's type to the specified type. Allows head textures."));
            player.sendMessage(ItemEditListener.compile("&b%q[content] - Input content and avoid conflicts with commands."));
            player.sendMessage(ItemEditListener.compile("&bamt [int] - Set the amount of the current item to the specified value."));
            player.sendMessage(ItemEditListener.compile("&2==========Placeholders=========="));
            player.sendMessage(ItemEditListener.compile(""));
            player.sendMessage(ItemEditListener.compile("&b%ctu = LoreBuilder.CROUCH_TO_USE"));
            player.sendMessage(ItemEditListener.compile("&b%hsr = LoreBuilder.HAZMAT_SUIT_REQUIRED"));
            player.sendMessage(ItemEditListener.compile("&b%rai = LoreBuilder.RAINBOW"));
            player.sendMessage(ItemEditListener.compile("&b%rcto = LoreBuilder.RIGHT_CLICK_TO_OPEN"));
            player.sendMessage(ItemEditListener.compile("&b%rctu = LoreBuilder.RIGHT_CLICK_TO_USE"));
            player.sendMessage(ItemEditListener.compile("&b%0 = original lore line"));
            player.sendMessage(ItemEditListener.compile("&b%p = your name"));
            player.sendMessage(ItemEditListener.compile("&2======Function Placeholders======"));
            player.sendMessage(ItemEditListener.compile(""));
            player.sendMessage(ItemEditListener.compile("&bm(String) = LoreBuilder.material(String)"));
            player.sendMessage(ItemEditListener.compile("&bh(double) = LoreBuilder.hunger(double)"));
            player.sendMessage(ItemEditListener.compile("&bs(float) = LoreBuilder.speed(float)"));
            player.sendMessage(ItemEditListener.compile("&bma(MachineTier, MachineType) = LoreBuilder.machine(MachineTier, MachineType)"));
            player.sendMessage(ItemEditListener.compile("&bra(Radioactivity) = LoreBuilder.radioactive(Radioactivity)"));
            player.sendMessage(ItemEditListener.compile("&bpb(int) = LoreBuilder.powerBuffer(int)"));
            player.sendMessage(ItemEditListener.compile("&bpps(int) = LoreBuilder.powerPerSecond(int)"));
            player.sendMessage(ItemEditListener.compile("&bpc(int, int) = LoreBuilder.powerCharged(int, int)"));
            player.sendMessage(ItemEditListener.compile("&bp(int, String) = LoreBuilder.power(int, String)"));
            player.sendMessage(ItemEditListener.compile("&br(int) = LoreBuilder.range(int)"));
            player.sendMessage(ItemEditListener.compile("&bul(int) = LoreBuilder.usesLeft(int)"));
            player.sendMessage(ItemEditListener.compile("&2=========ItemEditor Help========="));
            event.setCancelled(true);
        } else if ("l".equals(message)) {
            this.editingPlayers.add(player);
            this.clearScreen(player);
            ItemStack itemStack = player.getInventory().getItemInMainHand();
            if (itemStack.getType() == Material.AIR) {
                player.sendMessage(ItemEditListener.compile("&c[RSCEditor] ItemEditor: &cYou need to hold an item in your main hand."));
                return;
            }
            this.sendLore(player, itemStack.getItemMeta().getLore(), 0);
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onSelecting(PlayerChatEvent event) {
        Debug.log("selecting");
        String message = event.getMessage();
        Player player = event.getPlayer();
        if (!player.isOp()) {
            return;
        }
        if (this.editingPlayers.contains(player)) {
            if ("done".equals(message)) {
                Debug.log("trigger done editing");
                this.doneEditing(player);
                event.setCancelled(true);
                return;
            }
            ItemStack itemStack = player.getInventory().getItemInMainHand();
            if (!itemStack.hasItemMeta()) {
                player.sendMessage(ItemEditListener.compile("&c[RSCEditor] ItemEditor: &cYou need to hold a valid item in your main hand."));
                event.setCancelled(true);
                return;
            }
            if ("dd".equals(message)) {
                Debug.log("trigger delete line");
                this.removeLine(player, this.getSelectingLine(player));
                this.clearScreen(player);
                this.sendLore(player, itemStack.getItemMeta().getLore(), this.getSelectingLine(player));
                event.setCancelled(true);
            } else if (message.startsWith("aa ")) {
                Debug.log("trigger add line");
                String value = message.substring(3);
                this.addLine(player, this.getSelectingLine(player), "&f" + value);
                this.clearScreen(player);
                this.sendLore(player, itemStack.getItemMeta().getLore(), this.getSelectingLine(player));
                event.setCancelled(true);
            } else if (message.startsWith("ii ")) {
                Debug.log("trigger insert line");
                String value = message.substring(3);
                this.insertLine(player, this.getSelectingLine(player), "&f" + value);
                this.clearScreen(player);
                this.sendLore(player, itemStack.getItemMeta().getLore(), this.getSelectingLine(player));
                event.setCancelled(true);
            } else if (message.startsWith("mm ")) {
                Debug.log("trigger modify line");
                String value = message.substring(3);
                this.modifyLine(player, this.getSelectingLine(player), "&f" + value);
                this.clearScreen(player);
                this.sendLore(player, itemStack.getItemMeta().getLore(), this.getSelectingLine(player));
                event.setCancelled(true);
            } else if (message.startsWith("p ")) {
                String value = message.substring(2);
                player.sendMessage(ItemEditListener.compile("&c[RSCEditor] ItemEditor: &ePreview: " + ItemEditListener.compile(value)));
                event.setCancelled(true);
            } else if (message.startsWith("n ")) {
                String value = message.substring(2);
                if (itemStack.getType() == Material.AIR) {
                    player.sendMessage(ItemEditListener.compile("&c[RSCEditor] ItemEditor: &cYou need to hold an item in your main hand."));
                    event.setCancelled(true);
                    return;
                }
                ItemMeta meta = itemStack.getItemMeta();
                String oldName = meta.getDisplayName();
                meta.setDisplayName(ItemEditListener.compile(ItemEditListener.placeholder("&f" + value, player, oldName)));
                itemStack.setItemMeta(meta);
                player.updateInventory();
                event.setCancelled(true);
            } else if ("t<-".equals(message)) {
                int slot = player.getInventory().getHeldItemSlot();
                int nextSlot = slot >= 8 ? 0 : slot + 1;
                ItemStack anotherItemStack = player.getInventory().getItem(nextSlot);
                if (anotherItemStack == null || anotherItemStack.getType() == Material.AIR) {
                    player.sendMessage(ItemEditListener.compile("&c[RSCEditor] ItemEditor: &cYou need to contain an item in next slot."));
                    event.setCancelled(true);
                    return;
                }
                itemStack.setType(anotherItemStack.getType());
                this.setSkullTexture(itemStack, anotherItemStack);
                player.getInventory().setItemInMainHand(anotherItemStack);
                event.setCancelled(true);
            } else if ("->t".equals(message)) {
                int slot = player.getInventory().getHeldItemSlot();
                int previousSlot = slot <= 0 ? 8 : slot - 1;
                ItemStack anotherItemStack = player.getInventory().getItem(previousSlot);
                if (anotherItemStack == null || anotherItemStack.getType() == Material.AIR) {
                    player.sendMessage(ItemEditListener.compile("&c[RSCEditor] ItemEditor: &cYou need to contain an item in previous slot."));
                    event.setCancelled(true);
                    return;
                }
                itemStack.setType(anotherItemStack.getType());
                this.setSkullTexture(itemStack, anotherItemStack);
                player.getInventory().setItemInMainHand(anotherItemStack);
                event.setCancelled(true);
            } else if (message.startsWith("cc ")) {
                String value = message.substring(3);
                try {
                    int slot = Integer.parseInt(value);
                    if (slot < 0 || slot > 8) {
                        player.sendMessage(ItemEditListener.compile("&c[RSCEditor] ItemEditor: &cInvalid slot number."));
                        event.setCancelled(true);
                        return;
                    }
                    ItemStack anotherItemStack = player.getInventory().getItem(slot);
                    if (anotherItemStack == null || anotherItemStack.getType() == Material.AIR) {
                        player.sendMessage(ItemEditListener.compile("&c[RSCEditor] ItemEditor: &cYou need to contain an item in the specified slot."));
                        event.setCancelled(true);
                        return;
                    }
                    player.getInventory().setItemInMainHand(itemStack);
                    player.updateInventory();
                    event.setCancelled(true);
                }
                catch (NumberFormatException e) {
                    player.sendMessage(ItemEditListener.compile("&c[RSCEditor] ItemEditor: &cInvalid slot number."));
                    event.setCancelled(true);
                    return;
                }
            } else {
                if (message.startsWith("%q")) {
                    String value = message.substring(2);
                    event.setMessage(value);
                    return;
                }
                if (message.startsWith("amt ")) {
                    String value = message.substring(4);
                    try {
                        int amount = Integer.parseInt(value);
                        itemStack.setAmount(amount);
                        player.updateInventory();
                        event.setCancelled(true);
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage(ItemEditListener.compile("&c[RSCEditor] ItemEditor: &cInvalid amount."));
                        event.setCancelled(true);
                        return;
                    }
                } else if (message.startsWith("tt ")) {
                    String value = message.substring(3).toLowerCase();
                    if (this.isHashcodeLike(value)) {
                        PlayerSkin skin = PlayerSkin.fromHashCode((String)value);
                        ItemStack head = PlayerHead.getItemStack((PlayerSkin)skin);
                        this.setSkullTexture(itemStack, head);
                        player.getInventory().setItemInMainHand(head);
                    } else if (this.isBase64Like(value)) {
                        PlayerSkin skin = PlayerSkin.fromBase64((String)value);
                        ItemStack head = PlayerHead.getItemStack((PlayerSkin)skin);
                        this.setSkullTexture(itemStack, head);
                        player.getInventory().setItemInMainHand(head);
                    } else if (this.isURLLike(value)) {
                        PlayerSkin skin = PlayerSkin.fromURL((String)value);
                        ItemStack head = PlayerHead.getItemStack((PlayerSkin)skin);
                        this.setSkullTexture(itemStack, head);
                        player.getInventory().setItemInMainHand(head);
                    } else {
                        Material material = Material.getMaterial((String)value.toUpperCase());
                        if (material == null || !material.isItem()) {
                            player.sendMessage(ItemEditListener.compile("&c[RSCEditor] ItemEditor: &cInvalid texture value."));
                            event.setCancelled(true);
                            return;
                        }
                        itemStack.setType(material);
                    }
                    event.setCancelled(true);
                } else if (!"rhelp".equals(message) && !"l".equals(message)) {
                    player.sendMessage(ItemEditListener.compile("&c[RSCEditor] ItemEditor: type \"rhelp\" for information."));
                    event.setCancelled(true);
                }
            }
        }
    }

    public boolean isHashcodeLike(String value) {
        return value.matches("^[a-fA-F0-9]{32,}$");
    }

    public boolean isBase64Like(String value) {
        return value.length() > 32 && value.matches("^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$");
    }

    public boolean isURLLike(String value) {
        return value.matches("^https?://(?:[-\\w]+\\.)?[-\\w]+(?:\\.[a-zA-Z]{2,5}|\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})(?::\\d{1,5})?(/[-\\w./]*)*(\\?[-\\w.&=]*)?(#[-\\w]*)?$");
    }

    public void setSkullTexture(ItemStack itemStack, ItemStack head) {
        head.setAmount(itemStack.getAmount());
        ItemMeta meta = itemStack.getItemMeta();
        ItemMeta headMeta = head.getItemMeta();
        if (meta.hasDisplayName()) {
            headMeta.setDisplayName(meta.getDisplayName());
        }
        if (meta.hasLore()) {
            headMeta.setLore(meta.getLore());
        }
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        HashMap<NamespacedKey, Pair> data = new HashMap<NamespacedKey, Pair>();
        for (NamespacedKey namespacedKey : pdc.getKeys()) {
            Iterator<PersistentDataType<?, ?>> iterator = types.iterator();
            while (iterator.hasNext()) {
                PersistentDataType<?, ?> atype;
                PersistentDataType<?, ?> type = atype = iterator.next();
                try {
                    Object value = pdc.get(namespacedKey, type);
                    if (value == null) continue;
                    data.put(namespacedKey, new Pair(type, value));
                }
                catch (Exception exception) {}
            }
        }
        data.remove(Slimefun.getItemDataService().getKey());
        for (NamespacedKey namespacedKey : data.keySet()) {
            headMeta.getPersistentDataContainer().set(namespacedKey, (PersistentDataType)((Pair)data.get(namespacedKey)).getFirstValue(), ((Pair)data.get(namespacedKey)).getSecondValue());
        }
        headMeta.addItemFlags(meta.getItemFlags().toArray(new ItemFlag[0]));
        if (meta.hasEnchants()) {
            for (Map.Entry entry : meta.getEnchants().entrySet()) {
                headMeta.addEnchant((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue(), true);
            }
        }
        if (meta.hasAttributeModifiers()) {
            headMeta.setAttributeModifiers(meta.getAttributeModifiers());
        }
        if (meta.hasCustomModelData()) {
            headMeta.setCustomModelData(Integer.valueOf(meta.getCustomModelData()));
        }
        headMeta.setUnbreakable(meta.isUnbreakable());
        headMeta.setPlaceableKeys((Collection)meta.getPlaceableKeys());
        headMeta.setDestroyableKeys((Collection)meta.getDestroyableKeys());
        head.setItemMeta(headMeta);
    }

    public void modifyLine(Player player, int line, String value) {
        Debug.log("modify line " + line + ": " + value);
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        List lore = Objects.requireNonNullElse(itemStack.getItemMeta().getLore(), new ArrayList());
        if (line >= 0 && line < lore.size()) {
            String oldLine = (String)lore.get(line);
            lore.set(line, ItemEditListener.compile(ItemEditListener.placeholder(value, player, oldLine)));
            ItemMeta meta = itemStack.getItemMeta();
            meta.setLore(lore);
            itemStack.setItemMeta(meta);
            player.updateInventory();
        }
    }

    public void addLine(Player player, int line, String value) {
        Debug.log("add line: " + value);
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        List lore = Objects.requireNonNullElse(itemStack.getItemMeta().getLore(), new ArrayList());
        if (line >= 0 && line < lore.size()) {
            String current = (String)lore.get(line);
            lore.add(ItemEditListener.compile(ItemEditListener.placeholder(value, player, current)));
        } else {
            lore.add(ItemEditListener.compile(value));
        }
        ItemMeta meta = itemStack.getItemMeta();
        meta.setLore(lore);
        itemStack.setItemMeta(meta);
        player.updateInventory();
    }

    public void insertLine(Player player, int line, String value) {
        Debug.log("insert line " + line + ": " + value);
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        List lore = Objects.requireNonNullElse(itemStack.getItemMeta().getLore(), new ArrayList());
        if (line >= 0 && line < lore.size()) {
            String current = (String)lore.get(line);
            lore.add(line, ItemEditListener.compile(ItemEditListener.placeholder(value, player, current)));
            ItemMeta meta = itemStack.getItemMeta();
            meta.setLore(lore);
            itemStack.setItemMeta(meta);
            player.updateInventory();
        }
    }

    @EventHandler
    public void onLineSelect(PlayerItemHeldEvent event) {
        Debug.log("line select");
        Player player = event.getPlayer();
        if (this.editingPlayers.contains(player)) {
            ItemStack itemStack = player.getInventory().getItem(event.getPreviousSlot());
            if (itemStack == null || itemStack.getType() == Material.AIR) {
                player.sendMessage(ItemEditListener.compile("&c[RSCEditor] ItemEditor: &cYou need to hold an item in your main hand."));
                return;
            }
            List lore = Objects.requireNonNullElse(itemStack.getItemMeta().getLore(), new ArrayList());
            int newSlot = event.getNewSlot();
            int previousSlot = event.getPreviousSlot();
            Debug.log("new slot: " + newSlot + ", previous slot: " + previousSlot);
            if (newSlot >= 5 && previousSlot == 0) {
                Debug.log("scroll left type 1");
                this.setSelectingLine(player, this.getSelectingLine(player) - 1, lore.size());
            } else if (newSlot < 5 && previousSlot == 8) {
                Debug.log("scroll right type 2");
                this.setSelectingLine(player, this.getSelectingLine(player) + 1, lore.size());
            } else if (newSlot > previousSlot) {
                Debug.log("scroll right type 3");
                this.setSelectingLine(player, this.getSelectingLine(player) + 1, lore.size());
            } else if (newSlot < previousSlot) {
                Debug.log("scroll left type 4");
                this.setSelectingLine(player, this.getSelectingLine(player) - 1, lore.size());
            }
            if (itemStack != null && itemStack.getType() != Material.AIR) {
                this.clearScreen(player);
                this.sendLore(player, lore, this.getSelectingLine(player));
                event.setCancelled(true);
            }
        }
    }

    public void removeLine(Player player, int line) {
        Debug.log("remove line " + line);
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        List lore = Objects.requireNonNullElse(itemStack.getItemMeta().getLore(), new ArrayList());
        if (line >= 0 && line < lore.size()) {
            lore.remove(line);
            ItemMeta meta = itemStack.getItemMeta();
            meta.setLore(lore);
            itemStack.setItemMeta(meta);
            player.updateInventory();
        }
    }

    public int getSelectingLine(Player player) {
        if (!this.selectingLines.containsKey(player)) {
            this.selectingLines.put(player, 0);
            return 0;
        }
        return this.selectingLines.get(player);
    }

    public void setSelectingLine(Player player, int line, int loreSize) {
        if (line < 0) {
            line = 0;
        }
        if (line > loreSize - 1) {
            line = loreSize - 1;
        }
        this.selectingLines.put(player, line);
    }

    public void clearScreen(Player player) {
        for (int i = 0; i < 20; ++i) {
            player.sendMessage("");
        }
    }

    public void sendLore(Player player, List<String> lore, int selectingLine) {
        Debug.log("send lore");
        ArrayList<String> showLines = new ArrayList<String>();
        List<String> lines = lore == null ? new ArrayList<String>() : lore;
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (i == selectingLine) {
                showLines.add(ItemEditListener.compile(" &a>&r    " + line));
                continue;
            }
            showLines.add(ItemEditListener.compile(" &7|&r    " + line));
        }
        player.sendMessage(ItemEditListener.compile("&2=======Edit lore======="));
        for (String line : showLines) {
            player.sendMessage(ItemEditListener.compile(line));
        }
        player.sendMessage(ItemEditListener.compile("&2=======Edit lore======="));
    }

    public void doneEditing(Player player) {
        Debug.log("done editing");
        this.editingPlayers.remove(player);
        this.selectingLines.remove(player);
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        Debug.log("quit");
        Player player = event.getPlayer();
        this.doneEditing(player);
    }
}

