/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.rsceditor.utils;

import javax.annotation.Nonnull;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemStackHelper {
    @Nonnull
    public static String getDisplayName(@Nonnull ItemStack item) {
        if (item.hasItemMeta() && item.getItemMeta().hasDisplayName()) {
            return item.getItemMeta().getDisplayName();
        }
        return ItemStackHelper.getName(item);
    }

    @Nonnull
    public static String getName(@Nonnull ItemStack item) {
        Material type = item.getType();
        if (type == Material.POTION || type == Material.SPLASH_POTION || type == Material.LINGERING_POTION || type == Material.TIPPED_ARROW) {
            String potion = ((PotionMeta)item.getItemMeta()).getBasePotionData().getType().toString().toLowerCase();
            return LegacyComponentSerializer.legacySection().serialize((Component)Component.translatable((String)(type.translationKey() + ".effect." + potion)));
        }
        if (type == Material.PLAYER_HEAD || type == Material.PLAYER_WALL_HEAD) {
            return ItemStackHelper.getPlayerSkullName(item);
        }
        Component component = item.displayName();
        if (component instanceof TranslatableComponent) {
            TranslatableComponent tc = (TranslatableComponent)component;
            Component component2 = (Component)tc.children().get(0);
            return LegacyComponentSerializer.legacySection().serialize(component2);
        }
        return type.name();
    }

    @Nonnull
    private static String getPlayerSkullName(@Nonnull ItemStack skull) {
        SkullMeta meta = (SkullMeta)skull.getItemMeta();
        if (meta != null && meta.hasOwner()) {
            return LegacyComponentSerializer.legacySection().serialize((Component)Component.translatable((String)"block.minecraft.player_head.named").args(new ComponentLike[]{Component.text((String)meta.getOwningPlayer().getName())}));
        }
        return LegacyComponentSerializer.legacySection().serialize((Component)Component.translatable((String)"block.minecraft.player_head"));
    }
}

