/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.rsceditor.implementation.items.machines.container;

import com.balugaq.rsceditor.api.base.AbstractContainer;
import com.balugaq.rsceditor.api.objects.MenuMatrix;
import com.balugaq.rsceditor.utils.Debug;
import com.balugaq.rsceditor.utils.YamlWriter;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MenuContainer
extends AbstractContainer {
    private static final MenuMatrix matrix = new MenuMatrix().addLine("NNNNNNNNN").addLine("NNNNNNNNN").addLine("NNNNNNNNN").addLine("NNNNNNNNN").addLine("NNNNNNNNN").addLine("NNNNNNNNN");

    public MenuContainer(@NotNull SlimefunItemStack item) {
        super(item);
    }

    @Override
    @NotNull
    public BlockMenuPreset setBlockMenuPreset() {
        return new BlockMenuPreset(this.getId(), this.getItemName()){

            public void init() {
                this.setSize(54);
                matrix.build(this);
            }

            public boolean canOpen(@NotNull Block block, @NotNull Player player) {
                return player.isOp();
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow itemTransportFlow) {
                return new int[0];
            }
        };
    }

    @NotNull
    public Map<Integer, ItemStack> getMenuContent(@NotNull BlockMenu menu) {
        HashMap<Integer, ItemStack> content = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < 54; ++i) {
            ItemStack item = menu.getItemInSlot(i);
            content.put(i, item);
        }
        return content;
    }

    @NotNull
    public YamlWriter getAsYamlWriter(@NotNull BlockMenu menu, int[] input_slots, int[] output_slots, @NotNull String id, String title) {
        return this.getAsYamlWriter(menu, input_slots, output_slots, id, title, 100);
    }

    @NotNull
    public YamlWriter getAsYamlWriter(@NotNull BlockMenu menu, int[] input_slots, int[] output_slots, @NotNull String id, String title, int progress_bar_slot) {
        ItemStack itemStack;
        if (progress_bar_slot < 0 || progress_bar_slot > 53) {
            progress_bar_slot = 100;
        }
        YamlWriter writer = new YamlWriter();
        Map<Integer, ItemStack> content = this.getMenuContent(menu);
        ArrayList<Integer> input_slot_list = new ArrayList<Integer>();
        for (int i : input_slots) {
            input_slot_list.add(i);
        }
        ArrayList<Integer> output_slot_list = new ArrayList<Integer>();
        for (int i : output_slots) {
            output_slot_list.add(i);
        }
        Debug.log("input_slots: " + Arrays.toString(input_slots));
        Debug.log("output_slots: " + Arrays.toString(output_slots));
        writer.setRoot(id);
        writer.set("title", title);
        if (progress_bar_slot <= 53 && (itemStack = content.get(progress_bar_slot)) != null && itemStack.getType() != Material.AIR) {
            writer.set("slots." + progress_bar_slot, itemStack.clone());
            writer.set("slots." + progress_bar_slot + ".progressbar", true);
        }
        HashSet<Integer> keys = new HashSet<Integer>(content.keySet());
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            int i;
            i = (Integer)iterator.next();
            if (!input_slot_list.contains(i) && !output_slot_list.contains(i) && i != progress_bar_slot) continue;
            content.remove(i);
        }
        for (int i = 0; i < 54; ++i) {
            ItemStack item = content.get(i);
            if (item == null || item.getType() == Material.AIR) continue;
            int last_index = i;
            boolean found = false;
            ItemStack next_item = content.get(i + 1);
            while (next_item != null && SlimefunUtils.isItemSimilar((ItemStack)item, (ItemStack)next_item, (boolean)true, (boolean)true, (boolean)true)) {
                if (input_slot_list.contains(i) || output_slot_list.contains(i) || i == progress_bar_slot) {
                    found = true;
                    break;
                }
                next_item = content.get(++i + 1);
                found = true;
            }
            if (found) {
                writer.set("slots." + last_index + "-" + i, item.clone());
                continue;
            }
            writer.set("slots." + last_index, item.clone());
        }
        return writer;
    }
}

