/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.rsceditor.api.items;

import com.balugaq.rsceditor.api.base.PlaceholderItem;
import com.balugaq.rsceditor.api.objects.types.LinkedMachineRecipe;
import com.balugaq.rsceditor.implementation.groups.RSCEItemGroups;
import com.balugaq.rsceditor.utils.ItemStackHelper;
import com.balugaq.rsceditor.utils.KeyUtil;
import com.balugaq.rsceditor.utils.PersistentUtil;
import com.balugaq.rsceditor.utils.datatypes.PersistentLinkedMachineRecipeType;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import java.util.ArrayList;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinkedMachineRecipeItem
extends PlaceholderItem {
    public LinkedMachineRecipeItem(@NotNull SlimefunItemStack item) {
        super((ItemGroup)RSCEItemGroups.TYPE_GROUP, item);
    }

    @Nullable
    public LinkedMachineRecipe getLinkedRecipe(ItemStack itemStack) {
        return PersistentUtil.get(itemStack, PersistentLinkedMachineRecipeType.TYPE, KeyUtil.LINKED_MACHINE_RECIPE_KEY);
    }

    /*
     * WARNING - void declaration
     */
    public void setRecipe(@NotNull ItemStack itemStack, @NotNull LinkedMachineRecipe recipe) {
        void var7_14;
        PersistentUtil.set(itemStack, PersistentLinkedMachineRecipeType.TYPE, KeyUtil.LINKED_MACHINE_RECIPE_KEY, recipe);
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add("&bLinked Machine Recipe");
        lore.add("&b Name: " + recipe.getName());
        lore.add("&d Processing Time: " + recipe.getProcessingTime());
        for (Map.Entry<Integer, ItemStack> entry : recipe.getLinkedInputs().entrySet()) {
            lore.add("&b Linked to slot (input) " + String.valueOf(entry.getKey()) + ": " + ItemStackHelper.getDisplayName(entry.getValue()));
        }
        for (Map.Entry<Integer, ItemStack> entry : recipe.getLinkedOutputs().entrySet()) {
            lore.add("&e \u94fe\u63a5\u81f3\u69fd\u4f4d\uff08\u8f93\u51fa\uff09 " + String.valueOf(entry.getKey()) + ": " + ItemStackHelper.getDisplayName(entry.getValue()));
        }
        int i = 0;
        ItemStack[] itemStackArray = recipe.getFreeOutputs();
        int n = itemStackArray.length;
        boolean bl = false;
        while (var7_14 < n) {
            ItemStack item = itemStackArray[var7_14];
            lore.add("&b \u81ea\u7531\u8f93\u51fa " + i + ": " + ItemStackHelper.getDisplayName(item));
            ++i;
            ++var7_14;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : lore) {
            arrayList.add(ChatColor.translateAlternateColorCodes((char)'&', (String)string));
        }
        ItemMeta meta = itemStack.getItemMeta();
        meta.setLore(arrayList);
        itemStack.setItemMeta(meta);
    }
}

