/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.rsceditor.utils;

import com.balugaq.rsceditor.api.objects.types.ItemFlowType;
import com.balugaq.rsceditor.api.objects.types.RainbowType;
import com.balugaq.rsceditor.api.objects.types.SimpleMachineType;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Biome;
import org.jetbrains.annotations.NotNull;

public final class MaterialUtil {
    @NotNull
    public static Material getMaterial(@NotNull SimpleMachineType type) {
        return switch (type) {
            case SimpleMachineType.ELECTRIC_CRUCIBLE, SimpleMachineType.ELECTRIC_INGOT_FACTORY -> Material.RED_TERRACOTTA;
            case SimpleMachineType.ELECTRIC_FURNACE, SimpleMachineType.ELECTRIC_ORE_GRINDER, SimpleMachineType.ELECTRIC_INGOT_PULVERIZER, SimpleMachineType.ELECTRIC_SMELTERY -> Material.FURNACE;
            case SimpleMachineType.ELECTRIC_GOLD_PAN, SimpleMachineType.TREE_GROWTH_ACCELERATOR -> Material.BROWN_TERRACOTTA;
            case SimpleMachineType.ELECTRIC_DUST_WASHER -> Material.BLUE_STAINED_GLASS;
            case SimpleMachineType.CHARGING_BENCH -> Material.CRAFTING_TABLE;
            case SimpleMachineType.ANIMAL_GROWTH_ACCELERATOR, SimpleMachineType.PRODUCE_COLLECTOR -> Material.HAY_BLOCK;
            case SimpleMachineType.CROP_GROWTH_ACCELERATOR -> Material.GREEN_TERRACOTTA;
            case SimpleMachineType.FREEZER -> Material.LIGHT_BLUE_STAINED_GLASS;
            case SimpleMachineType.CARBON_PRESS -> Material.BLACK_STAINED_GLASS;
            case SimpleMachineType.ELECTRIC_PRESS -> SlimefunItems.ELECTRIC_PRESS.getType();
            case SimpleMachineType.FOOD_FABRICATOR -> Material.GREEN_STAINED_GLASS;
            case SimpleMachineType.HEATED_PRESSURE_CHAMBER -> Material.LIGHT_GRAY_STAINED_GLASS;
            case SimpleMachineType.AUTO_ENCHANTER, SimpleMachineType.AUTO_DISENCHANTER -> Material.ENCHANTING_TABLE;
            case SimpleMachineType.BOOK_BINDER -> Material.BOOKSHELF;
            case SimpleMachineType.AUTO_ANVIL -> Material.IRON_BLOCK;
            case SimpleMachineType.AUTO_DRIER, SimpleMachineType.AUTO_BREWER -> Material.SMOKER;
            case SimpleMachineType.REFINERY -> Material.PISTON;
            default -> Material.BARRIER;
        };
    }

    @NotNull
    public static Material getMaterial(@NotNull Biome biome) {
        return switch (biome) {
            case Biome.OCEAN, Biome.RIVER, Biome.DEEP_LUKEWARM_OCEAN, Biome.DEEP_COLD_OCEAN, Biome.COLD_OCEAN, Biome.LUKEWARM_OCEAN, Biome.DEEP_OCEAN, Biome.WARM_OCEAN -> Material.WATER_BUCKET;
            case Biome.PLAINS, Biome.MEADOW -> Material.GRASS_BLOCK;
            case Biome.DESERT, Biome.SNOWY_BEACH, Biome.BEACH -> Material.SAND;
            case Biome.WINDSWEPT_HILLS, Biome.JAGGED_PEAKS -> Material.STONE;
            case Biome.FOREST, Biome.WINDSWEPT_FOREST -> Material.OAK_LOG;
            case Biome.TAIGA, Biome.GROVE, Biome.OLD_GROWTH_SPRUCE_TAIGA, Biome.SNOWY_TAIGA, Biome.OLD_GROWTH_PINE_TAIGA -> Material.SPRUCE_LOG;
            case Biome.SWAMP -> Material.LILY_PAD;
            case Biome.MANGROVE_SWAMP -> Material.MANGROVE_ROOTS;
            case Biome.NETHER_WASTES -> Material.NETHERRACK;
            case Biome.THE_END, Biome.END_HIGHLANDS, Biome.END_MIDLANDS, Biome.END_BARRENS, Biome.SMALL_END_ISLANDS -> Material.END_STONE;
            case Biome.FROZEN_OCEAN, Biome.FROZEN_PEAKS, Biome.ICE_SPIKES, Biome.DEEP_FROZEN_OCEAN, Biome.FROZEN_RIVER -> Material.ICE;
            case Biome.SNOWY_PLAINS, Biome.SNOWY_SLOPES -> Material.SNOW_BLOCK;
            case Biome.MUSHROOM_FIELDS -> Material.RED_MUSHROOM_BLOCK;
            case Biome.JUNGLE, Biome.SPARSE_JUNGLE -> Material.JUNGLE_LOG;
            case Biome.STONY_SHORE, Biome.STONY_PEAKS -> Material.COBBLESTONE;
            case Biome.BIRCH_FOREST, Biome.OLD_GROWTH_BIRCH_FOREST -> Material.BIRCH_LOG;
            case Biome.DARK_FOREST -> Material.DARK_OAK_LOG;
            case Biome.SAVANNA, Biome.WINDSWEPT_SAVANNA, Biome.SAVANNA_PLATEAU, Biome.WOODED_BADLANDS -> Material.ACACIA_LOG;
            case Biome.BADLANDS, Biome.ERODED_BADLANDS -> Material.TERRACOTTA;
            case Biome.SUNFLOWER_PLAINS -> Material.SUNFLOWER;
            case Biome.WINDSWEPT_GRAVELLY_HILLS -> Material.GRAVEL;
            case Biome.FLOWER_FOREST -> Material.DANDELION;
            case Biome.BAMBOO_JUNGLE -> Material.BAMBOO;
            case Biome.SOUL_SAND_VALLEY -> Material.SOUL_SAND;
            case Biome.CRIMSON_FOREST -> Material.CRIMSON_STEM;
            case Biome.WARPED_FOREST -> Material.WARPED_STEM;
            case Biome.BASALT_DELTAS -> Material.BASALT;
            case Biome.DRIPSTONE_CAVES -> Material.POINTED_DRIPSTONE;
            case Biome.LUSH_CAVES -> Material.MOSS_BLOCK;
            case Biome.DEEP_DARK -> Material.CALCITE;
            case Biome.CHERRY_GROVE -> Material.CHERRY_LOG;
            default -> Material.BARRIER;
        };
    }

    @NotNull
    public static Material getMaterial(@NotNull RainbowType type) {
        return switch (type) {
            case RainbowType.WOOL -> Material.WHITE_WOOL;
            case RainbowType.CARPET -> Material.WHITE_CARPET;
            case RainbowType.STAINED_GLASS -> Material.WHITE_STAINED_GLASS;
            case RainbowType.STAINED_GLASS_PANE -> Material.WHITE_STAINED_GLASS_PANE;
            case RainbowType.CONCRETE -> Material.WHITE_CONCRETE;
            case RainbowType.TERRACOTTA -> Material.WHITE_TERRACOTTA;
            case RainbowType.GLAZED_TERRACOTTA -> Material.WHITE_GLAZED_TERRACOTTA;
            case RainbowType.SHULKER_BOX -> Material.WHITE_SHULKER_BOX;
            default -> Material.BARRIER;
        };
    }

    @NotNull
    public static Material getMaterial(@NotNull EnergyNetComponentType type) {
        return switch (type) {
            case EnergyNetComponentType.GENERATOR -> Material.GLOWSTONE;
            case EnergyNetComponentType.CAPACITOR -> Material.IRON_BLOCK;
            case EnergyNetComponentType.CONSUMER -> Material.GOLD_BLOCK;
            case EnergyNetComponentType.CONNECTOR -> Material.REDSTONE_BLOCK;
            default -> Material.BARRIER;
        };
    }

    @NotNull
    public static Material getMaterial(@NotNull ItemFlowType type) {
        return switch (type) {
            case ItemFlowType.NONE -> Material.GRAY_STAINED_GLASS_PANE;
            case ItemFlowType.INSERT -> Material.BLUE_STAINED_GLASS_PANE;
            case ItemFlowType.WITHDRAW -> Material.ORANGE_STAINED_GLASS_PANE;
            case ItemFlowType.INSERT_AND_WITHDRAW -> Material.PURPLE_STAINED_GLASS_PANE;
            case ItemFlowType.FREE_OUTPUT -> Material.GREEN_STAINED_GLASS_PANE;
            default -> Material.BARRIER;
        };
    }

    public static Material getMaterial(@NotNull Sound sound) {
        return switch (sound) {
            case Sound.AMBIENT_BASALT_DELTAS_ADDITIONS, Sound.AMBIENT_BASALT_DELTAS_LOOP, Sound.AMBIENT_BASALT_DELTAS_MOOD, Sound.BLOCK_BASALT_BREAK, Sound.BLOCK_BASALT_FALL, Sound.BLOCK_BASALT_HIT, Sound.BLOCK_BASALT_PLACE, Sound.BLOCK_BASALT_STEP -> Material.BASALT;
            case Sound.AMBIENT_CAVE, Sound.BLOCK_STONE_STEP, Sound.BLOCK_STONE_BREAK, Sound.BLOCK_STONE_FALL, Sound.BLOCK_STONE_HIT, Sound.BLOCK_STONE_PLACE -> Material.STONE;
            case Sound.AMBIENT_CRIMSON_FOREST_ADDITIONS, Sound.AMBIENT_CRIMSON_FOREST_LOOP, Sound.AMBIENT_CRIMSON_FOREST_MOOD -> Material.CRIMSON_STEM;
            case Sound.AMBIENT_NETHER_WASTES_ADDITIONS, Sound.AMBIENT_NETHER_WASTES_LOOP, Sound.AMBIENT_NETHER_WASTES_MOOD, Sound.BLOCK_NETHERRACK_BREAK, Sound.BLOCK_NETHERRACK_FALL, Sound.BLOCK_NETHERRACK_HIT, Sound.BLOCK_NETHERRACK_PLACE, Sound.BLOCK_NETHERRACK_STEP, Sound.BLOCK_PORTAL_TRIGGER, Sound.BLOCK_PORTAL_AMBIENT, Sound.BLOCK_PORTAL_TRAVEL -> Material.NETHERRACK;
            case Sound.AMBIENT_SOUL_SAND_VALLEY_ADDITIONS, Sound.AMBIENT_SOUL_SAND_VALLEY_LOOP, Sound.AMBIENT_SOUL_SAND_VALLEY_MOOD, Sound.PARTICLE_SOUL_ESCAPE, Sound.BLOCK_SOUL_SAND_BREAK, Sound.BLOCK_SOUL_SAND_FALL, Sound.BLOCK_SOUL_SAND_HIT, Sound.BLOCK_SOUL_SAND_PLACE, Sound.BLOCK_SOUL_SAND_STEP -> Material.SOUL_SAND;
            case Sound.AMBIENT_UNDERWATER_ENTER, Sound.AMBIENT_UNDERWATER_EXIT, Sound.AMBIENT_UNDERWATER_LOOP, Sound.AMBIENT_UNDERWATER_LOOP_ADDITIONS, Sound.AMBIENT_UNDERWATER_LOOP_ADDITIONS_RARE, Sound.AMBIENT_UNDERWATER_LOOP_ADDITIONS_ULTRA_RARE, Sound.BLOCK_WATER_AMBIENT, Sound.WEATHER_RAIN, Sound.WEATHER_RAIN_ABOVE, Sound.BLOCK_BUBBLE_COLUMN_BUBBLE_POP, Sound.BLOCK_BUBBLE_COLUMN_UPWARDS_AMBIENT, Sound.BLOCK_BUBBLE_COLUMN_UPWARDS_INSIDE, Sound.BLOCK_BUBBLE_COLUMN_WHIRLPOOL_AMBIENT, Sound.BLOCK_BUBBLE_COLUMN_WHIRLPOOL_INSIDE -> Material.WATER_BUCKET;
            case Sound.AMBIENT_WARPED_FOREST_ADDITIONS, Sound.AMBIENT_WARPED_FOREST_LOOP, Sound.AMBIENT_WARPED_FOREST_MOOD -> Material.WARPED_STEM;
            case Sound.BLOCK_AMETHYST_BLOCK_BREAK, Sound.BLOCK_AMETHYST_BLOCK_CHIME, Sound.BLOCK_AMETHYST_BLOCK_FALL, Sound.BLOCK_AMETHYST_BLOCK_HIT, Sound.BLOCK_AMETHYST_BLOCK_PLACE, Sound.BLOCK_AMETHYST_BLOCK_RESONATE, Sound.BLOCK_AMETHYST_BLOCK_STEP -> Material.AMETHYST_BLOCK;
            case Sound.BLOCK_AMETHYST_CLUSTER_BREAK, Sound.BLOCK_AMETHYST_CLUSTER_FALL, Sound.BLOCK_AMETHYST_CLUSTER_HIT, Sound.BLOCK_AMETHYST_CLUSTER_PLACE, Sound.BLOCK_AMETHYST_CLUSTER_STEP -> Material.AMETHYST_CLUSTER;
            case Sound.BLOCK_ANCIENT_DEBRIS_BREAK, Sound.BLOCK_ANCIENT_DEBRIS_FALL, Sound.BLOCK_ANCIENT_DEBRIS_HIT, Sound.BLOCK_ANCIENT_DEBRIS_PLACE, Sound.BLOCK_ANCIENT_DEBRIS_STEP -> Material.ANCIENT_DEBRIS;
            case Sound.BLOCK_ANVIL_BREAK, Sound.BLOCK_ANVIL_DESTROY, Sound.BLOCK_ANVIL_FALL, Sound.BLOCK_ANVIL_HIT, Sound.BLOCK_ANVIL_LAND, Sound.BLOCK_ANVIL_PLACE, Sound.BLOCK_ANVIL_STEP, Sound.BLOCK_ANVIL_USE -> Material.ANVIL;
            case Sound.BLOCK_AZALEA_BREAK, Sound.BLOCK_AZALEA_FALL, Sound.BLOCK_AZALEA_HIT, Sound.BLOCK_AZALEA_LEAVES_BREAK, Sound.BLOCK_AZALEA_LEAVES_FALL, Sound.BLOCK_AZALEA_LEAVES_HIT, Sound.BLOCK_AZALEA_LEAVES_PLACE, Sound.BLOCK_AZALEA_LEAVES_STEP, Sound.BLOCK_AZALEA_PLACE, Sound.BLOCK_AZALEA_STEP -> Material.AZALEA;
            case Sound.BLOCK_BAMBOO_WOOD_BREAK, Sound.BLOCK_BAMBOO_BREAK, Sound.BLOCK_BAMBOO_FALL, Sound.BLOCK_BAMBOO_HIT, Sound.BLOCK_BAMBOO_PLACE, Sound.BLOCK_BAMBOO_SAPLING_BREAK, Sound.BLOCK_BAMBOO_SAPLING_HIT, Sound.BLOCK_BAMBOO_SAPLING_PLACE, Sound.BLOCK_BAMBOO_STEP, Sound.BLOCK_BAMBOO_WOOD_BUTTON_CLICK_OFF, Sound.BLOCK_BAMBOO_WOOD_BUTTON_CLICK_ON, Sound.BLOCK_BAMBOO_WOOD_DOOR_CLOSE, Sound.BLOCK_BAMBOO_WOOD_DOOR_OPEN, Sound.BLOCK_BAMBOO_WOOD_FALL, Sound.BLOCK_BAMBOO_WOOD_FENCE_GATE_CLOSE, Sound.BLOCK_BAMBOO_WOOD_FENCE_GATE_OPEN, Sound.BLOCK_BAMBOO_WOOD_HANGING_SIGN_BREAK, Sound.BLOCK_BAMBOO_WOOD_HANGING_SIGN_FALL, Sound.BLOCK_BAMBOO_WOOD_HANGING_SIGN_HIT, Sound.BLOCK_BAMBOO_WOOD_HANGING_SIGN_PLACE, Sound.BLOCK_BAMBOO_WOOD_HANGING_SIGN_STEP, Sound.BLOCK_BAMBOO_WOOD_HIT, Sound.BLOCK_BAMBOO_WOOD_PLACE, Sound.BLOCK_BAMBOO_WOOD_PRESSURE_PLATE_CLICK_OFF, Sound.BLOCK_BAMBOO_WOOD_PRESSURE_PLATE_CLICK_ON, Sound.BLOCK_BAMBOO_WOOD_STEP, Sound.BLOCK_BAMBOO_WOOD_TRAPDOOR_CLOSE, Sound.BLOCK_BAMBOO_WOOD_TRAPDOOR_OPEN -> Material.BAMBOO;
            case Sound.BLOCK_BARREL_CLOSE, Sound.BLOCK_BARREL_OPEN -> Material.BARREL;
            case Sound.BLOCK_BEACON_ACTIVATE, Sound.BLOCK_BEACON_AMBIENT, Sound.BLOCK_BEACON_DEACTIVATE, Sound.BLOCK_BEACON_POWER_SELECT -> Material.BEACON;
            case Sound.BLOCK_BEEHIVE_DRIP, Sound.BLOCK_BEEHIVE_ENTER, Sound.BLOCK_BEEHIVE_EXIT, Sound.BLOCK_BEEHIVE_SHEAR, Sound.BLOCK_BEEHIVE_WORK -> Material.BEEHIVE;
            case Sound.BLOCK_BELL_RESONATE, Sound.BLOCK_BELL_USE -> Material.BELL;
            case Sound.BLOCK_BIG_DRIPLEAF_BREAK, Sound.BLOCK_BIG_DRIPLEAF_FALL, Sound.BLOCK_BIG_DRIPLEAF_HIT, Sound.BLOCK_BIG_DRIPLEAF_PLACE, Sound.BLOCK_BIG_DRIPLEAF_STEP, Sound.BLOCK_BIG_DRIPLEAF_TILT_DOWN, Sound.BLOCK_BIG_DRIPLEAF_TILT_UP -> Material.BIG_DRIPLEAF;
            case Sound.BLOCK_BLASTFURNACE_FIRE_CRACKLE -> Material.BLAST_FURNACE;
            case Sound.BLOCK_BONE_BLOCK_BREAK, Sound.BLOCK_BONE_BLOCK_FALL, Sound.BLOCK_BONE_BLOCK_HIT, Sound.BLOCK_BONE_BLOCK_PLACE, Sound.BLOCK_BONE_BLOCK_STEP -> Material.BONE_BLOCK;
            case Sound.BLOCK_BREWING_STAND_BREW -> Material.BREWING_STAND;
            case Sound.BLOCK_CAKE_ADD_CANDLE -> Material.CAKE;
            case Sound.BLOCK_CALCITE_BREAK, Sound.BLOCK_CALCITE_FALL, Sound.BLOCK_CALCITE_HIT, Sound.BLOCK_CALCITE_PLACE, Sound.BLOCK_CALCITE_STEP -> Material.CALCITE;
            case Sound.BLOCK_CAMPFIRE_CRACKLE -> Material.CAMPFIRE;
            case Sound.BLOCK_CANDLE_AMBIENT, Sound.BLOCK_CANDLE_BREAK, Sound.BLOCK_CANDLE_EXTINGUISH, Sound.BLOCK_CANDLE_FALL, Sound.BLOCK_CANDLE_HIT, Sound.BLOCK_CANDLE_PLACE, Sound.BLOCK_CANDLE_STEP -> Material.CANDLE;
            case Sound.BLOCK_CAVE_VINES_BREAK, Sound.BLOCK_CAVE_VINES_FALL, Sound.BLOCK_CAVE_VINES_HIT, Sound.BLOCK_CAVE_VINES_PICK_BERRIES, Sound.BLOCK_CAVE_VINES_PLACE, Sound.BLOCK_CAVE_VINES_STEP, Sound.BLOCK_VINE_FALL, Sound.BLOCK_VINE_HIT, Sound.BLOCK_VINE_STEP, Sound.BLOCK_VINE_PLACE, Sound.BLOCK_VINE_BREAK -> Material.VINE;
            case Sound.BLOCK_CHAIN_BREAK, Sound.BLOCK_CHAIN_FALL, Sound.BLOCK_CHAIN_HIT, Sound.BLOCK_CHAIN_PLACE, Sound.BLOCK_CHAIN_STEP -> Material.CHAIN;
            case Sound.BLOCK_CHERRY_LEAVES_BREAK, Sound.BLOCK_CHERRY_LEAVES_FALL, Sound.BLOCK_CHERRY_LEAVES_HIT, Sound.BLOCK_CHERRY_LEAVES_PLACE, Sound.BLOCK_CHERRY_LEAVES_STEP -> Material.CHERRY_LEAVES;
            case Sound.BLOCK_CHERRY_SAPLING_BREAK, Sound.BLOCK_CHERRY_SAPLING_FALL, Sound.BLOCK_CHERRY_SAPLING_HIT, Sound.BLOCK_CHERRY_SAPLING_PLACE, Sound.BLOCK_CHERRY_SAPLING_STEP -> Material.CHERRY_SAPLING;
            case Sound.BLOCK_CHERRY_WOOD_BREAK, Sound.BLOCK_CHERRY_WOOD_BUTTON_CLICK_OFF, Sound.BLOCK_CHERRY_WOOD_BUTTON_CLICK_ON, Sound.BLOCK_CHERRY_WOOD_DOOR_CLOSE, Sound.BLOCK_CHERRY_WOOD_DOOR_OPEN, Sound.BLOCK_CHERRY_WOOD_FALL, Sound.BLOCK_CHERRY_WOOD_FENCE_GATE_CLOSE, Sound.BLOCK_CHERRY_WOOD_FENCE_GATE_OPEN, Sound.BLOCK_CHERRY_WOOD_HANGING_SIGN_BREAK, Sound.BLOCK_CHERRY_WOOD_HANGING_SIGN_FALL, Sound.BLOCK_CHERRY_WOOD_HANGING_SIGN_HIT, Sound.BLOCK_CHERRY_WOOD_HANGING_SIGN_PLACE, Sound.BLOCK_CHERRY_WOOD_HANGING_SIGN_STEP, Sound.BLOCK_CHERRY_WOOD_HIT, Sound.BLOCK_CHERRY_WOOD_PLACE, Sound.BLOCK_CHERRY_WOOD_PRESSURE_PLATE_CLICK_OFF, Sound.BLOCK_CHERRY_WOOD_PRESSURE_PLATE_CLICK_ON, Sound.BLOCK_CHERRY_WOOD_STEP, Sound.BLOCK_CHERRY_WOOD_TRAPDOOR_CLOSE, Sound.BLOCK_CHERRY_WOOD_TRAPDOOR_OPEN -> Material.CHERRY_WOOD;
            case Sound.BLOCK_CHEST_CLOSE, Sound.BLOCK_CHEST_LOCKED, Sound.BLOCK_CHEST_OPEN -> Material.CHEST;
            case Sound.BLOCK_CHISELED_BOOKSHELF_BREAK, Sound.BLOCK_CHISELED_BOOKSHELF_FALL, Sound.BLOCK_CHISELED_BOOKSHELF_HIT, Sound.BLOCK_CHISELED_BOOKSHELF_INSERT, Sound.BLOCK_CHISELED_BOOKSHELF_INSERT_ENCHANTED, Sound.BLOCK_CHISELED_BOOKSHELF_PICKUP, Sound.BLOCK_CHISELED_BOOKSHELF_PICKUP_ENCHANTED, Sound.BLOCK_CHISELED_BOOKSHELF_PLACE, Sound.BLOCK_CHISELED_BOOKSHELF_STEP -> Material.BOOKSHELF;
            case Sound.BLOCK_CHORUS_FLOWER_DEATH, Sound.BLOCK_CHORUS_FLOWER_GROW -> Material.CHORUS_FLOWER;
            case Sound.BLOCK_COMPARATOR_CLICK -> Material.COMPARATOR;
            case Sound.BLOCK_COMPOSTER_EMPTY, Sound.BLOCK_COMPOSTER_FILL, Sound.BLOCK_COMPOSTER_FILL_SUCCESS, Sound.BLOCK_COMPOSTER_READY -> Material.COMPOSTER;
            case Sound.BLOCK_CONDUIT_ACTIVATE, Sound.BLOCK_CONDUIT_AMBIENT, Sound.BLOCK_CONDUIT_AMBIENT_SHORT, Sound.BLOCK_CONDUIT_ATTACK_TARGET, Sound.BLOCK_CONDUIT_DEACTIVATE -> Material.CONDUIT;
            case Sound.BLOCK_COPPER_BREAK, Sound.BLOCK_COPPER_FALL, Sound.BLOCK_COPPER_HIT, Sound.BLOCK_COPPER_PLACE, Sound.BLOCK_COPPER_STEP -> Material.COPPER_BLOCK;
            case Sound.BLOCK_CORAL_BLOCK_BREAK, Sound.BLOCK_CORAL_BLOCK_FALL, Sound.BLOCK_CORAL_BLOCK_HIT, Sound.BLOCK_CORAL_BLOCK_PLACE, Sound.BLOCK_CORAL_BLOCK_STEP -> Material.BRAIN_CORAL_BLOCK;
            case Sound.BLOCK_CROP_BREAK, Sound.ITEM_CROP_PLANT -> Material.WHEAT_SEEDS;
            case Sound.BLOCK_DECORATED_POT_BREAK, Sound.BLOCK_DECORATED_POT_FALL, Sound.BLOCK_DECORATED_POT_HIT, Sound.BLOCK_DECORATED_POT_PLACE, Sound.BLOCK_DECORATED_POT_SHATTER, Sound.BLOCK_DECORATED_POT_STEP -> Material.DECORATED_POT;
            case Sound.BLOCK_DEEPSLATE_BREAK, Sound.BLOCK_DEEPSLATE_BRICKS_BREAK, Sound.BLOCK_DEEPSLATE_BRICKS_FALL, Sound.BLOCK_DEEPSLATE_BRICKS_HIT, Sound.BLOCK_DEEPSLATE_BRICKS_PLACE, Sound.BLOCK_DEEPSLATE_BRICKS_STEP, Sound.BLOCK_DEEPSLATE_FALL, Sound.BLOCK_DEEPSLATE_HIT, Sound.BLOCK_DEEPSLATE_PLACE, Sound.BLOCK_DEEPSLATE_STEP, Sound.BLOCK_DEEPSLATE_TILES_BREAK, Sound.BLOCK_DEEPSLATE_TILES_FALL, Sound.BLOCK_DEEPSLATE_TILES_HIT, Sound.BLOCK_DEEPSLATE_TILES_PLACE, Sound.BLOCK_DEEPSLATE_TILES_STEP, Sound.BLOCK_NETHER_ORE_BREAK, Sound.BLOCK_NETHER_ORE_FALL, Sound.BLOCK_NETHER_ORE_HIT, Sound.BLOCK_NETHER_ORE_PLACE, Sound.BLOCK_NETHER_ORE_STEP -> Material.DEEPSLATE;
            case Sound.BLOCK_DISPENSER_DISPENSE, Sound.BLOCK_DISPENSER_FAIL, Sound.BLOCK_DISPENSER_LAUNCH -> Material.DISPENSER;
            case Sound.BLOCK_DRIPSTONE_BLOCK_BREAK, Sound.BLOCK_DRIPSTONE_BLOCK_FALL, Sound.BLOCK_DRIPSTONE_BLOCK_HIT, Sound.BLOCK_DRIPSTONE_BLOCK_PLACE, Sound.BLOCK_DRIPSTONE_BLOCK_STEP -> Material.DRIPSTONE_BLOCK;
            case Sound.BLOCK_ENCHANTMENT_TABLE_USE -> Material.ENCHANTING_TABLE;
            case Sound.BLOCK_ENDER_CHEST_CLOSE, Sound.BLOCK_ENDER_CHEST_OPEN -> Material.ENDER_CHEST;
            case Sound.BLOCK_END_GATEWAY_SPAWN, Sound.BLOCK_END_PORTAL_FRAME_FILL, Sound.BLOCK_END_PORTAL_SPAWN -> Material.END_PORTAL_FRAME;
            case Sound.BLOCK_FENCE_GATE_CLOSE, Sound.BLOCK_FENCE_GATE_OPEN -> Material.OAK_FENCE_GATE;
            case Sound.BLOCK_FIRE_AMBIENT, Sound.BLOCK_FIRE_EXTINGUISH, Sound.ITEM_FLINTANDSTEEL_USE -> Material.FLINT_AND_STEEL;
            case Sound.BLOCK_FLOWERING_AZALEA_BREAK, Sound.BLOCK_FLOWERING_AZALEA_FALL, Sound.BLOCK_FLOWERING_AZALEA_HIT, Sound.BLOCK_FLOWERING_AZALEA_PLACE, Sound.BLOCK_FLOWERING_AZALEA_STEP -> Material.FLOWERING_AZALEA;
            case Sound.BLOCK_FROGLIGHT_BREAK, Sound.BLOCK_FROGLIGHT_FALL, Sound.BLOCK_FROGLIGHT_HIT, Sound.BLOCK_FROGLIGHT_PLACE, Sound.BLOCK_FROGLIGHT_STEP -> Material.OCHRE_FROGLIGHT;
            case Sound.BLOCK_FROGSPAWN_BREAK, Sound.BLOCK_FROGSPAWN_FALL, Sound.BLOCK_FROGSPAWN_HATCH, Sound.BLOCK_FROGSPAWN_HIT, Sound.BLOCK_FROGSPAWN_PLACE, Sound.BLOCK_FROGSPAWN_STEP -> Material.FROGSPAWN;
            case Sound.BLOCK_FUNGUS_BREAK, Sound.BLOCK_FUNGUS_FALL, Sound.BLOCK_FUNGUS_HIT, Sound.BLOCK_FUNGUS_PLACE, Sound.BLOCK_FUNGUS_STEP -> Material.CRIMSON_FUNGUS;
            case Sound.BLOCK_FURNACE_FIRE_CRACKLE -> Material.FURNACE;
            case Sound.BLOCK_GILDED_BLACKSTONE_BREAK, Sound.BLOCK_GILDED_BLACKSTONE_FALL, Sound.BLOCK_GILDED_BLACKSTONE_HIT, Sound.BLOCK_GILDED_BLACKSTONE_PLACE, Sound.BLOCK_GILDED_BLACKSTONE_STEP -> Material.GILDED_BLACKSTONE;
            case Sound.BLOCK_GLASS_BREAK, Sound.BLOCK_GLASS_FALL, Sound.BLOCK_GLASS_HIT, Sound.BLOCK_GLASS_PLACE, Sound.BLOCK_GLASS_STEP -> Material.GLASS;
            case Sound.BLOCK_GRASS_BREAK, Sound.BLOCK_GRASS_FALL, Sound.BLOCK_GRASS_HIT, Sound.BLOCK_GRASS_PLACE, Sound.BLOCK_GRASS_STEP -> Material.GRASS_BLOCK;
            case Sound.BLOCK_GRAVEL_BREAK, Sound.BLOCK_GRAVEL_FALL, Sound.BLOCK_GRAVEL_HIT, Sound.BLOCK_GRAVEL_PLACE, Sound.BLOCK_GRAVEL_STEP -> Material.GRAVEL;
            case Sound.BLOCK_GRINDSTONE_USE -> Material.GRINDSTONE;
            case Sound.BLOCK_GROWING_PLANT_CROP -> Material.WHEAT;
            case Sound.BLOCK_HANGING_ROOTS_BREAK, Sound.BLOCK_HANGING_ROOTS_FALL, Sound.BLOCK_HANGING_ROOTS_HIT, Sound.BLOCK_HANGING_ROOTS_PLACE, Sound.BLOCK_HANGING_ROOTS_STEP -> Material.HANGING_ROOTS;
            case Sound.BLOCK_HANGING_SIGN_BREAK, Sound.BLOCK_HANGING_SIGN_FALL, Sound.BLOCK_HANGING_SIGN_HIT, Sound.BLOCK_HANGING_SIGN_PLACE, Sound.BLOCK_HANGING_SIGN_STEP -> Material.OAK_HANGING_SIGN;
            case Sound.BLOCK_HONEY_BLOCK_BREAK, Sound.BLOCK_HONEY_BLOCK_FALL, Sound.BLOCK_HONEY_BLOCK_HIT, Sound.BLOCK_HONEY_BLOCK_PLACE, Sound.BLOCK_HONEY_BLOCK_SLIDE, Sound.BLOCK_HONEY_BLOCK_STEP -> Material.HONEY_BLOCK;
            case Sound.BLOCK_IRON_DOOR_CLOSE, Sound.BLOCK_IRON_DOOR_OPEN, Sound.BLOCK_IRON_TRAPDOOR_CLOSE, Sound.BLOCK_IRON_TRAPDOOR_OPEN -> Material.IRON_DOOR;
            case Sound.BLOCK_LADDER_BREAK, Sound.BLOCK_LADDER_FALL, Sound.BLOCK_LADDER_HIT, Sound.BLOCK_LADDER_PLACE, Sound.BLOCK_LADDER_STEP -> Material.LADDER;
            case Sound.BLOCK_LANTERN_BREAK, Sound.BLOCK_LANTERN_FALL, Sound.BLOCK_LANTERN_HIT, Sound.BLOCK_LANTERN_PLACE, Sound.BLOCK_LANTERN_STEP -> Material.LANTERN;
            case Sound.BLOCK_LARGE_AMETHYST_BUD_BREAK, Sound.BLOCK_LARGE_AMETHYST_BUD_PLACE -> Material.LARGE_AMETHYST_BUD;
            case Sound.BLOCK_LAVA_AMBIENT, Sound.BLOCK_LAVA_EXTINGUISH, Sound.BLOCK_LAVA_POP -> Material.LAVA_BUCKET;
            case Sound.BLOCK_LEVER_CLICK -> Material.LEVER;
            case Sound.BLOCK_LILY_PAD_PLACE -> Material.LILY_PAD;
            case Sound.BLOCK_LODESTONE_BREAK, Sound.BLOCK_LODESTONE_FALL, Sound.BLOCK_LODESTONE_HIT, Sound.BLOCK_LODESTONE_PLACE, Sound.BLOCK_LODESTONE_STEP, Sound.ITEM_LODESTONE_COMPASS_LOCK -> Material.LODESTONE;
            case Sound.BLOCK_MANGROVE_ROOTS_BREAK, Sound.BLOCK_MANGROVE_ROOTS_FALL, Sound.BLOCK_MANGROVE_ROOTS_HIT, Sound.BLOCK_MANGROVE_ROOTS_PLACE, Sound.BLOCK_MANGROVE_ROOTS_STEP -> Material.MANGROVE_ROOTS;
            case Sound.BLOCK_MEDIUM_AMETHYST_BUD_BREAK, Sound.BLOCK_MEDIUM_AMETHYST_BUD_PLACE -> Material.MEDIUM_AMETHYST_BUD;
            case Sound.BLOCK_METAL_BREAK, Sound.BLOCK_METAL_FALL, Sound.BLOCK_METAL_HIT, Sound.BLOCK_METAL_PLACE, Sound.BLOCK_METAL_PRESSURE_PLATE_CLICK_OFF, Sound.BLOCK_METAL_PRESSURE_PLATE_CLICK_ON, Sound.BLOCK_METAL_STEP -> Material.LIGHT_WEIGHTED_PRESSURE_PLATE;
            case Sound.BLOCK_MOSS_BREAK, Sound.BLOCK_MOSS_CARPET_BREAK, Sound.BLOCK_MOSS_CARPET_FALL, Sound.BLOCK_MOSS_CARPET_HIT, Sound.BLOCK_MOSS_CARPET_PLACE, Sound.BLOCK_MOSS_CARPET_STEP, Sound.BLOCK_MOSS_FALL, Sound.BLOCK_MOSS_HIT, Sound.BLOCK_MOSS_PLACE, Sound.BLOCK_MOSS_STEP -> Material.MOSS_BLOCK;
            case Sound.BLOCK_MUDDY_MANGROVE_ROOTS_BREAK, Sound.BLOCK_MUDDY_MANGROVE_ROOTS_FALL, Sound.BLOCK_MUDDY_MANGROVE_ROOTS_HIT, Sound.BLOCK_MUDDY_MANGROVE_ROOTS_PLACE, Sound.BLOCK_MUDDY_MANGROVE_ROOTS_STEP -> Material.MUDDY_MANGROVE_ROOTS;
            case Sound.BLOCK_MUD_BREAK, Sound.BLOCK_MUD_BRICKS_BREAK, Sound.BLOCK_MUD_BRICKS_FALL, Sound.BLOCK_MUD_BRICKS_HIT, Sound.BLOCK_MUD_BRICKS_PLACE, Sound.BLOCK_MUD_BRICKS_STEP, Sound.BLOCK_MUD_FALL, Sound.BLOCK_MUD_HIT, Sound.BLOCK_MUD_PLACE, Sound.BLOCK_MUD_STEP -> Material.MUD;
            case Sound.BLOCK_NETHERITE_BLOCK_BREAK, Sound.BLOCK_NETHERITE_BLOCK_FALL, Sound.BLOCK_NETHERITE_BLOCK_HIT, Sound.BLOCK_NETHERITE_BLOCK_PLACE, Sound.BLOCK_NETHERITE_BLOCK_STEP -> Material.NETHERITE_BLOCK;
            case Sound.BLOCK_NETHER_BRICKS_BREAK, Sound.BLOCK_NETHER_BRICKS_FALL, Sound.BLOCK_NETHER_BRICKS_HIT, Sound.BLOCK_NETHER_BRICKS_PLACE, Sound.BLOCK_NETHER_BRICKS_STEP -> Material.NETHER_BRICKS;
            case Sound.BLOCK_NETHER_GOLD_ORE_BREAK, Sound.BLOCK_NETHER_GOLD_ORE_FALL, Sound.BLOCK_NETHER_GOLD_ORE_HIT, Sound.BLOCK_NETHER_GOLD_ORE_PLACE, Sound.BLOCK_NETHER_GOLD_ORE_STEP -> Material.GOLD_ORE;
            case Sound.BLOCK_NETHER_SPROUTS_BREAK, Sound.BLOCK_NETHER_SPROUTS_FALL, Sound.BLOCK_NETHER_SPROUTS_HIT, Sound.BLOCK_NETHER_SPROUTS_PLACE, Sound.BLOCK_NETHER_SPROUTS_STEP -> Material.NETHER_SPROUTS;
            case Sound.BLOCK_NETHER_WART_BREAK, Sound.BLOCK_WART_BLOCK_BREAK, Sound.BLOCK_WART_BLOCK_FALL, Sound.BLOCK_WART_BLOCK_HIT, Sound.BLOCK_WART_BLOCK_PLACE, Sound.BLOCK_WART_BLOCK_STEP, Sound.ITEM_NETHER_WART_PLANT -> Material.NETHER_WART;
            case Sound.BLOCK_NETHER_WOOD_BREAK, Sound.BLOCK_NETHER_WOOD_BUTTON_CLICK_OFF, Sound.BLOCK_NETHER_WOOD_BUTTON_CLICK_ON, Sound.BLOCK_NETHER_WOOD_DOOR_CLOSE, Sound.BLOCK_NETHER_WOOD_DOOR_OPEN, Sound.BLOCK_NETHER_WOOD_FALL, Sound.BLOCK_NETHER_WOOD_FENCE_GATE_CLOSE, Sound.BLOCK_NETHER_WOOD_FENCE_GATE_OPEN, Sound.BLOCK_NETHER_WOOD_HANGING_SIGN_BREAK, Sound.BLOCK_NETHER_WOOD_HANGING_SIGN_FALL, Sound.BLOCK_NETHER_WOOD_HANGING_SIGN_HIT, Sound.BLOCK_NETHER_WOOD_HANGING_SIGN_PLACE, Sound.BLOCK_NETHER_WOOD_HANGING_SIGN_STEP, Sound.BLOCK_NETHER_WOOD_HIT, Sound.BLOCK_NETHER_WOOD_PLACE, Sound.BLOCK_NETHER_WOOD_PRESSURE_PLATE_CLICK_OFF, Sound.BLOCK_NETHER_WOOD_PRESSURE_PLATE_CLICK_ON, Sound.BLOCK_NETHER_WOOD_STEP, Sound.BLOCK_NETHER_WOOD_TRAPDOOR_CLOSE, Sound.BLOCK_NETHER_WOOD_TRAPDOOR_OPEN -> Material.STRIPPED_OAK_LOG;
            case Sound.BLOCK_WEEPING_VINES_BREAK, Sound.BLOCK_WEEPING_VINES_FALL, Sound.BLOCK_WEEPING_VINES_HIT, Sound.BLOCK_WEEPING_VINES_PLACE, Sound.BLOCK_WEEPING_VINES_STEP -> Material.WEEPING_VINES;
            case Sound.BLOCK_WET_GRASS_BREAK, Sound.BLOCK_WET_GRASS_FALL, Sound.BLOCK_WET_GRASS_HIT, Sound.BLOCK_WET_GRASS_PLACE, Sound.BLOCK_WET_GRASS_STEP -> Material.GRASS;
            case Sound.BLOCK_WOODEN_BUTTON_CLICK_OFF, Sound.BLOCK_WOODEN_BUTTON_CLICK_ON, Sound.UI_BUTTON_CLICK -> Material.OAK_BUTTON;
            case Sound.BLOCK_WOODEN_DOOR_CLOSE, Sound.BLOCK_WOODEN_DOOR_OPEN -> Material.OAK_DOOR;
            case Sound.BLOCK_WOODEN_PRESSURE_PLATE_CLICK_OFF, Sound.BLOCK_WOODEN_PRESSURE_PLATE_CLICK_ON -> Material.OAK_PRESSURE_PLATE;
            case Sound.BLOCK_WOODEN_TRAPDOOR_CLOSE, Sound.BLOCK_WOODEN_TRAPDOOR_OPEN -> Material.OAK_TRAPDOOR;
            case Sound.BLOCK_WOOD_BREAK, Sound.BLOCK_WOOD_FALL, Sound.BLOCK_WOOD_HIT, Sound.BLOCK_WOOD_PLACE, Sound.BLOCK_WOOD_STEP -> Material.OAK_WOOD;
            case Sound.BLOCK_WOOL_BREAK, Sound.BLOCK_WOOL_FALL, Sound.BLOCK_WOOL_HIT, Sound.BLOCK_WOOL_PLACE, Sound.BLOCK_WOOL_STEP -> Material.WHITE_WOOL;
            case Sound.ENCHANT_THORNS_HIT, Sound.ITEM_TRIDENT_HIT, Sound.ITEM_TRIDENT_HIT_GROUND, Sound.ITEM_TRIDENT_RETURN, Sound.ITEM_TRIDENT_RIPTIDE_1, Sound.ITEM_TRIDENT_RIPTIDE_2, Sound.ITEM_TRIDENT_RIPTIDE_3, Sound.ITEM_TRIDENT_THROW, Sound.ITEM_TRIDENT_THUNDER -> Material.TRIDENT;
            case Sound.ENTITY_ALLAY_AMBIENT_WITHOUT_ITEM, Sound.ENTITY_ALLAY_AMBIENT_WITH_ITEM, Sound.ENTITY_ALLAY_DEATH, Sound.ENTITY_ALLAY_HURT, Sound.ENTITY_ALLAY_ITEM_GIVEN, Sound.ENTITY_ALLAY_ITEM_TAKEN, Sound.ENTITY_ALLAY_ITEM_THROWN -> Material.ALLAY_SPAWN_EGG;
            case Sound.ENTITY_ARMOR_STAND_BREAK, Sound.ENTITY_ARMOR_STAND_FALL, Sound.ENTITY_ARMOR_STAND_HIT, Sound.ENTITY_ARMOR_STAND_PLACE -> Material.ARMOR_STAND;
            case Sound.ENTITY_ARROW_HIT, Sound.ENTITY_ARROW_HIT_PLAYER, Sound.ENTITY_ARROW_SHOOT -> Material.ARROW;
            case Sound.ENTITY_AXOLOTL_ATTACK, Sound.ENTITY_AXOLOTL_DEATH, Sound.ENTITY_AXOLOTL_HURT, Sound.ENTITY_AXOLOTL_IDLE_AIR, Sound.ENTITY_AXOLOTL_IDLE_WATER, Sound.ENTITY_AXOLOTL_SPLASH, Sound.ENTITY_AXOLOTL_SWIM -> Material.AXOLOTL_SPAWN_EGG;
            case Sound.ENTITY_BAT_AMBIENT, Sound.ENTITY_BAT_DEATH, Sound.ENTITY_BAT_HURT, Sound.ENTITY_BAT_LOOP, Sound.ENTITY_BAT_TAKEOFF -> Material.BAT_SPAWN_EGG;
            case Sound.ENTITY_BEE_DEATH, Sound.ENTITY_BEE_HURT, Sound.ENTITY_BEE_LOOP, Sound.ENTITY_BEE_LOOP_AGGRESSIVE, Sound.ENTITY_BEE_POLLINATE, Sound.ENTITY_BEE_STING -> Material.BEE_SPAWN_EGG;
            case Sound.ENTITY_BLAZE_AMBIENT, Sound.ENTITY_BLAZE_BURN, Sound.ENTITY_BLAZE_DEATH, Sound.ENTITY_BLAZE_HURT, Sound.ENTITY_BLAZE_SHOOT -> Material.BLAZE_SPAWN_EGG;
            case Sound.ENTITY_BOAT_PADDLE_LAND, Sound.ENTITY_BOAT_PADDLE_WATER -> Material.OAK_BOAT;
            case Sound.ENTITY_CAMEL_AMBIENT, Sound.ENTITY_CAMEL_DASH, Sound.ENTITY_CAMEL_DASH_READY, Sound.ENTITY_CAMEL_DEATH, Sound.ENTITY_CAMEL_EAT, Sound.ENTITY_CAMEL_HURT, Sound.ENTITY_CAMEL_SADDLE, Sound.ENTITY_CAMEL_SIT, Sound.ENTITY_CAMEL_STAND, Sound.ENTITY_CAMEL_STEP, Sound.ENTITY_CAMEL_STEP_SAND -> Material.CAMEL_SPAWN_EGG;
            case Sound.ENTITY_CAT_AMBIENT, Sound.ENTITY_CAT_BEG_FOR_FOOD, Sound.ENTITY_CAT_DEATH, Sound.ENTITY_CAT_EAT, Sound.ENTITY_CAT_HISS, Sound.ENTITY_CAT_HURT, Sound.ENTITY_CAT_PURR, Sound.ENTITY_CAT_PURREOW, Sound.ENTITY_CAT_STRAY_AMBIENT -> Material.CAT_SPAWN_EGG;
            case Sound.ENTITY_CHICKEN_AMBIENT, Sound.ENTITY_CHICKEN_DEATH, Sound.ENTITY_CHICKEN_EGG, Sound.ENTITY_CHICKEN_HURT, Sound.ENTITY_CHICKEN_STEP -> Material.CHICKEN;
            case Sound.ENTITY_COD_AMBIENT, Sound.ENTITY_COD_DEATH, Sound.ENTITY_COD_FLOP, Sound.ENTITY_COD_HURT, Sound.ENTITY_FISH_SWIM -> Material.COD;
            case Sound.ENTITY_COW_AMBIENT, Sound.ENTITY_COW_DEATH, Sound.ENTITY_COW_HURT, Sound.ENTITY_COW_MILK, Sound.ENTITY_COW_STEP -> Material.COW_SPAWN_EGG;
            case Sound.ENTITY_CREEPER_DEATH, Sound.ENTITY_CREEPER_HURT, Sound.ENTITY_CREEPER_PRIMED -> Material.CREEPER_SPAWN_EGG;
            case Sound.ENTITY_DOLPHIN_AMBIENT, Sound.ENTITY_DOLPHIN_AMBIENT_WATER, Sound.ENTITY_DOLPHIN_ATTACK, Sound.ENTITY_DOLPHIN_DEATH, Sound.ENTITY_DOLPHIN_EAT, Sound.ENTITY_DOLPHIN_HURT, Sound.ENTITY_DOLPHIN_JUMP, Sound.ENTITY_DOLPHIN_PLAY, Sound.ENTITY_DOLPHIN_SPLASH, Sound.ENTITY_DOLPHIN_SWIM -> Material.DOLPHIN_SPAWN_EGG;
            case Sound.ENTITY_DONKEY_AMBIENT, Sound.ENTITY_DONKEY_ANGRY, Sound.ENTITY_DONKEY_CHEST, Sound.ENTITY_DONKEY_DEATH, Sound.ENTITY_DONKEY_EAT, Sound.ENTITY_DONKEY_HURT -> Material.DONKEY_SPAWN_EGG;
            case Sound.ENTITY_DRAGON_FIREBALL_EXPLODE -> Material.DRAGON_BREATH;
            case Sound.ENTITY_DROWNED_AMBIENT, Sound.ENTITY_DROWNED_AMBIENT_WATER, Sound.ENTITY_DROWNED_DEATH, Sound.ENTITY_DROWNED_DEATH_WATER, Sound.ENTITY_DROWNED_HURT, Sound.ENTITY_DROWNED_HURT_WATER, Sound.ENTITY_DROWNED_SHOOT, Sound.ENTITY_DROWNED_STEP, Sound.ENTITY_DROWNED_SWIM -> Material.DROWNED_SPAWN_EGG;
            case Sound.ENTITY_EGG_THROW -> Material.EGG;
            case Sound.ENTITY_ELDER_GUARDIAN_AMBIENT, Sound.ENTITY_ELDER_GUARDIAN_AMBIENT_LAND, Sound.ENTITY_ELDER_GUARDIAN_CURSE, Sound.ENTITY_ELDER_GUARDIAN_DEATH, Sound.ENTITY_ELDER_GUARDIAN_DEATH_LAND, Sound.ENTITY_ELDER_GUARDIAN_FLOP, Sound.ENTITY_ELDER_GUARDIAN_HURT, Sound.ENTITY_ELDER_GUARDIAN_HURT_LAND -> Material.ELDER_GUARDIAN_SPAWN_EGG;
            case Sound.ENTITY_ENDERMAN_AMBIENT, Sound.ENTITY_ENDERMAN_DEATH, Sound.ENTITY_ENDERMAN_HURT, Sound.ENTITY_ENDERMAN_SCREAM, Sound.ENTITY_ENDERMAN_STARE, Sound.ENTITY_ENDERMAN_TELEPORT -> Material.ENDERMAN_SPAWN_EGG;
            case Sound.ENTITY_ENDERMITE_AMBIENT, Sound.ENTITY_ENDERMITE_DEATH, Sound.ENTITY_ENDERMITE_HURT, Sound.ENTITY_ENDERMITE_STEP -> Material.ENDERMITE_SPAWN_EGG;
            case Sound.ENTITY_ENDER_DRAGON_AMBIENT, Sound.ENTITY_ENDER_DRAGON_DEATH, Sound.ENTITY_ENDER_DRAGON_FLAP, Sound.ENTITY_ENDER_DRAGON_GROWL, Sound.ENTITY_ENDER_DRAGON_HURT, Sound.ENTITY_ENDER_DRAGON_SHOOT -> Material.ENDER_DRAGON_SPAWN_EGG;
            case Sound.ENTITY_ENDER_EYE_DEATH, Sound.ENTITY_ENDER_EYE_LAUNCH -> Material.ENDER_EYE;
            case Sound.ENTITY_ENDER_PEARL_THROW -> Material.ENDER_PEARL;
            case Sound.ENTITY_EVOKER_AMBIENT, Sound.ENTITY_EVOKER_CAST_SPELL, Sound.ENTITY_EVOKER_CELEBRATE, Sound.ENTITY_EVOKER_DEATH, Sound.ENTITY_EVOKER_FANGS_ATTACK, Sound.ENTITY_EVOKER_HURT, Sound.ENTITY_EVOKER_PREPARE_ATTACK, Sound.ENTITY_EVOKER_PREPARE_SUMMON, Sound.ENTITY_EVOKER_PREPARE_WOLOLO -> Material.EVOKER_SPAWN_EGG;
            case Sound.ENTITY_EXPERIENCE_BOTTLE_THROW, Sound.ENTITY_EXPERIENCE_ORB_PICKUP -> Material.EXPERIENCE_BOTTLE;
            case Sound.ENTITY_FIREWORK_ROCKET_BLAST, Sound.ENTITY_FIREWORK_ROCKET_BLAST_FAR, Sound.ENTITY_FIREWORK_ROCKET_LARGE_BLAST, Sound.ENTITY_FIREWORK_ROCKET_LARGE_BLAST_FAR, Sound.ENTITY_FIREWORK_ROCKET_LAUNCH, Sound.ENTITY_FIREWORK_ROCKET_SHOOT, Sound.ENTITY_FIREWORK_ROCKET_TWINKLE, Sound.ENTITY_FIREWORK_ROCKET_TWINKLE_FAR -> Material.FIREWORK_ROCKET;
            case Sound.ENTITY_FISHING_BOBBER_RETRIEVE, Sound.ENTITY_FISHING_BOBBER_SPLASH, Sound.ENTITY_FISHING_BOBBER_THROW -> Material.FISHING_ROD;
            case Sound.ENTITY_FOX_AGGRO, Sound.ENTITY_FOX_AMBIENT, Sound.ENTITY_FOX_BITE, Sound.ENTITY_FOX_DEATH, Sound.ENTITY_FOX_EAT, Sound.ENTITY_FOX_HURT, Sound.ENTITY_FOX_SCREECH, Sound.ENTITY_FOX_SLEEP, Sound.ENTITY_FOX_SNIFF, Sound.ENTITY_FOX_SPIT, Sound.ENTITY_FOX_TELEPORT -> Material.FOX_SPAWN_EGG;
            case Sound.ENTITY_FROG_AMBIENT, Sound.ENTITY_FROG_DEATH, Sound.ENTITY_FROG_EAT, Sound.ENTITY_FROG_HURT, Sound.ENTITY_FROG_LAY_SPAWN, Sound.ENTITY_FROG_LONG_JUMP, Sound.ENTITY_FROG_STEP, Sound.ENTITY_FROG_TONGUE -> Material.FROG_SPAWN_EGG;
            case Sound.ENTITY_GENERIC_BIG_FALL, Sound.ENTITY_GENERIC_BURN, Sound.ENTITY_GENERIC_DEATH, Sound.ENTITY_GENERIC_DRINK, Sound.ENTITY_GENERIC_EAT, Sound.ENTITY_GENERIC_EXPLODE, Sound.ENTITY_GENERIC_EXTINGUISH_FIRE, Sound.ENTITY_GENERIC_HURT, Sound.ENTITY_GENERIC_SMALL_FALL, Sound.ENTITY_GENERIC_SPLASH, Sound.ENTITY_GENERIC_SWIM -> Material.SPAWNER;
            case Sound.ENTITY_GHAST_AMBIENT, Sound.ENTITY_GHAST_DEATH, Sound.ENTITY_GHAST_HURT, Sound.ENTITY_GHAST_SCREAM, Sound.ENTITY_GHAST_SHOOT, Sound.ENTITY_GHAST_WARN -> Material.GHAST_SPAWN_EGG;
            case Sound.ENTITY_GLOW_ITEM_FRAME_ADD_ITEM, Sound.ENTITY_GLOW_ITEM_FRAME_BREAK, Sound.ENTITY_GLOW_ITEM_FRAME_PLACE, Sound.ENTITY_GLOW_ITEM_FRAME_REMOVE_ITEM, Sound.ENTITY_GLOW_ITEM_FRAME_ROTATE_ITEM -> Material.GLOW_ITEM_FRAME;
            case Sound.ENTITY_GLOW_SQUID_AMBIENT, Sound.ENTITY_GLOW_SQUID_DEATH, Sound.ENTITY_GLOW_SQUID_HURT, Sound.ENTITY_GLOW_SQUID_SQUIRT -> Material.GLOW_SQUID_SPAWN_EGG;
            case Sound.ENTITY_GOAT_AMBIENT, Sound.ENTITY_GOAT_DEATH, Sound.ENTITY_GOAT_EAT, Sound.ENTITY_GOAT_HORN_BREAK, Sound.ENTITY_GOAT_HURT, Sound.ENTITY_GOAT_LONG_JUMP, Sound.ENTITY_GOAT_MILK, Sound.ENTITY_GOAT_PREPARE_RAM, Sound.ENTITY_GOAT_RAM_IMPACT, Sound.ENTITY_GOAT_SCREAMING_AMBIENT, Sound.ENTITY_GOAT_SCREAMING_DEATH, Sound.ENTITY_GOAT_SCREAMING_EAT, Sound.ENTITY_GOAT_SCREAMING_HORN_BREAK, Sound.ENTITY_GOAT_SCREAMING_HURT, Sound.ENTITY_GOAT_SCREAMING_LONG_JUMP, Sound.ENTITY_GOAT_SCREAMING_MILK, Sound.ENTITY_GOAT_SCREAMING_PREPARE_RAM, Sound.ENTITY_GOAT_SCREAMING_RAM_IMPACT, Sound.ENTITY_GOAT_STEP -> Material.GOAT_SPAWN_EGG;
            case Sound.ENTITY_GUARDIAN_AMBIENT, Sound.ENTITY_GUARDIAN_AMBIENT_LAND, Sound.ENTITY_GUARDIAN_ATTACK, Sound.ENTITY_GUARDIAN_DEATH, Sound.ENTITY_GUARDIAN_DEATH_LAND, Sound.ENTITY_GUARDIAN_FLOP, Sound.ENTITY_GUARDIAN_HURT, Sound.ENTITY_GUARDIAN_HURT_LAND -> Material.GUARDIAN_SPAWN_EGG;
            case Sound.ENTITY_HOGLIN_AMBIENT, Sound.ENTITY_HOGLIN_ANGRY, Sound.ENTITY_HOGLIN_ATTACK, Sound.ENTITY_HOGLIN_CONVERTED_TO_ZOMBIFIED, Sound.ENTITY_HOGLIN_DEATH, Sound.ENTITY_HOGLIN_HURT, Sound.ENTITY_HOGLIN_RETREAT, Sound.ENTITY_HOGLIN_STEP -> Material.HOGLIN_SPAWN_EGG;
            case Sound.ENTITY_HORSE_AMBIENT, Sound.ENTITY_HORSE_ANGRY, Sound.ENTITY_HORSE_ARMOR, Sound.ENTITY_HORSE_BREATHE, Sound.ENTITY_HORSE_DEATH, Sound.ENTITY_HORSE_EAT, Sound.ENTITY_HORSE_GALLOP, Sound.ENTITY_HORSE_HURT, Sound.ENTITY_HORSE_JUMP, Sound.ENTITY_HORSE_LAND, Sound.ENTITY_HORSE_SADDLE, Sound.ENTITY_HORSE_STEP, Sound.ENTITY_HORSE_STEP_WOOD -> Material.HORSE_SPAWN_EGG;
            case Sound.ENTITY_HUSK_AMBIENT, Sound.ENTITY_HUSK_CONVERTED_TO_ZOMBIE, Sound.ENTITY_HUSK_DEATH, Sound.ENTITY_HUSK_HURT, Sound.ENTITY_HUSK_STEP -> Material.HUSK_SPAWN_EGG;
            case Sound.ENTITY_ILLUSIONER_AMBIENT, Sound.ENTITY_ILLUSIONER_CAST_SPELL, Sound.ENTITY_ILLUSIONER_DEATH, Sound.ENTITY_ILLUSIONER_HURT, Sound.ENTITY_ILLUSIONER_MIRROR_MOVE, Sound.ENTITY_ILLUSIONER_PREPARE_BLINDNESS, Sound.ENTITY_ILLUSIONER_PREPARE_MIRROR -> Material.RED_WOOL;
            case Sound.ENTITY_IRON_GOLEM_ATTACK, Sound.ENTITY_IRON_GOLEM_DAMAGE, Sound.ENTITY_IRON_GOLEM_DEATH, Sound.ENTITY_IRON_GOLEM_HURT, Sound.ENTITY_IRON_GOLEM_REPAIR, Sound.ENTITY_IRON_GOLEM_STEP -> Material.IRON_GOLEM_SPAWN_EGG;
            case Sound.ENTITY_ITEM_BREAK, Sound.ENTITY_ITEM_FRAME_ADD_ITEM, Sound.ENTITY_ITEM_FRAME_BREAK, Sound.ENTITY_ITEM_FRAME_PLACE, Sound.ENTITY_ITEM_FRAME_REMOVE_ITEM, Sound.ENTITY_ITEM_FRAME_ROTATE_ITEM, Sound.ENTITY_ITEM_PICKUP -> Material.ITEM_FRAME;
            case Sound.ENTITY_LEASH_KNOT_BREAK, Sound.ENTITY_LEASH_KNOT_PLACE -> Material.LEAD;
            case Sound.ENTITY_LIGHTNING_BOLT_IMPACT, Sound.ENTITY_LIGHTNING_BOLT_THUNDER -> Material.LIGHTNING_ROD;
            case Sound.ENTITY_LINGERING_POTION_THROW -> Material.LINGERING_POTION;
            case Sound.ENTITY_LLAMA_AMBIENT, Sound.ENTITY_LLAMA_ANGRY, Sound.ENTITY_LLAMA_CHEST, Sound.ENTITY_LLAMA_DEATH, Sound.ENTITY_LLAMA_EAT, Sound.ENTITY_LLAMA_HURT, Sound.ENTITY_LLAMA_SPIT, Sound.ENTITY_LLAMA_STEP, Sound.ENTITY_LLAMA_SWAG -> Material.LLAMA_SPAWN_EGG;
            case Sound.ENTITY_MAGMA_CUBE_DEATH, Sound.ENTITY_MAGMA_CUBE_DEATH_SMALL, Sound.ENTITY_MAGMA_CUBE_HURT, Sound.ENTITY_MAGMA_CUBE_HURT_SMALL, Sound.ENTITY_MAGMA_CUBE_JUMP, Sound.ENTITY_MAGMA_CUBE_SQUISH, Sound.ENTITY_MAGMA_CUBE_SQUISH_SMALL -> Material.MAGMA_CUBE_SPAWN_EGG;
            case Sound.ENTITY_MINECART_INSIDE, Sound.ENTITY_MINECART_INSIDE_UNDERWATER, Sound.ENTITY_MINECART_RIDING -> Material.MINECART;
            case Sound.ENTITY_MOOSHROOM_CONVERT, Sound.ENTITY_MOOSHROOM_EAT, Sound.ENTITY_MOOSHROOM_MILK, Sound.ENTITY_MOOSHROOM_SHEAR, Sound.ENTITY_MOOSHROOM_SUSPICIOUS_MILK -> Material.MOOSHROOM_SPAWN_EGG;
            case Sound.ENTITY_MULE_AMBIENT, Sound.ENTITY_MULE_ANGRY, Sound.ENTITY_MULE_CHEST, Sound.ENTITY_MULE_DEATH, Sound.ENTITY_MULE_EAT, Sound.ENTITY_MULE_HURT -> Material.MULE_SPAWN_EGG;
            case Sound.ENTITY_OCELOT_AMBIENT, Sound.ENTITY_OCELOT_DEATH, Sound.ENTITY_OCELOT_HURT -> Material.OCELOT_SPAWN_EGG;
            case Sound.ENTITY_PAINTING_BREAK, Sound.ENTITY_PAINTING_PLACE -> Material.PAINTING;
            case Sound.ENTITY_PANDA_AGGRESSIVE_AMBIENT, Sound.ENTITY_PANDA_AMBIENT, Sound.ENTITY_PANDA_BITE, Sound.ENTITY_PANDA_CANT_BREED, Sound.ENTITY_PANDA_DEATH, Sound.ENTITY_PANDA_EAT, Sound.ENTITY_PANDA_HURT, Sound.ENTITY_PANDA_PRE_SNEEZE, Sound.ENTITY_PANDA_SNEEZE, Sound.ENTITY_PANDA_STEP, Sound.ENTITY_PANDA_WORRIED_AMBIENT -> Material.PANDA_SPAWN_EGG;
            case Sound.ENTITY_PARROT_AMBIENT, Sound.ENTITY_PARROT_DEATH, Sound.ENTITY_PARROT_EAT, Sound.ENTITY_PARROT_FLY, Sound.ENTITY_PARROT_HURT, Sound.ENTITY_PARROT_IMITATE_BLAZE, Sound.ENTITY_PARROT_IMITATE_CREEPER, Sound.ENTITY_PARROT_IMITATE_DROWNED, Sound.ENTITY_PARROT_IMITATE_ELDER_GUARDIAN, Sound.ENTITY_PARROT_IMITATE_ENDERMITE, Sound.ENTITY_PARROT_IMITATE_ENDER_DRAGON, Sound.ENTITY_PARROT_IMITATE_EVOKER, Sound.ENTITY_PARROT_IMITATE_GHAST, Sound.ENTITY_PARROT_IMITATE_GUARDIAN, Sound.ENTITY_PARROT_IMITATE_HOGLIN, Sound.ENTITY_PARROT_IMITATE_HUSK, Sound.ENTITY_PARROT_IMITATE_ILLUSIONER, Sound.ENTITY_PARROT_IMITATE_MAGMA_CUBE, Sound.ENTITY_PARROT_IMITATE_PHANTOM, Sound.ENTITY_PARROT_IMITATE_PIGLIN, Sound.ENTITY_PARROT_IMITATE_PIGLIN_BRUTE, Sound.ENTITY_PARROT_IMITATE_PILLAGER, Sound.ENTITY_PARROT_IMITATE_RAVAGER, Sound.ENTITY_PARROT_IMITATE_SHULKER, Sound.ENTITY_PARROT_IMITATE_SILVERFISH, Sound.ENTITY_PARROT_IMITATE_SKELETON, Sound.ENTITY_PARROT_IMITATE_SLIME, Sound.ENTITY_PARROT_IMITATE_SPIDER, Sound.ENTITY_PARROT_IMITATE_STRAY, Sound.ENTITY_PARROT_IMITATE_VEX, Sound.ENTITY_PARROT_IMITATE_VINDICATOR, Sound.ENTITY_PARROT_IMITATE_WARDEN, Sound.ENTITY_PARROT_IMITATE_WITCH, Sound.ENTITY_PARROT_IMITATE_WITHER, Sound.ENTITY_PARROT_IMITATE_WITHER_SKELETON, Sound.ENTITY_PARROT_IMITATE_ZOGLIN, Sound.ENTITY_PARROT_IMITATE_ZOMBIE, Sound.ENTITY_PARROT_IMITATE_ZOMBIE_VILLAGER, Sound.ENTITY_PARROT_STEP -> Material.PARROT_SPAWN_EGG;
            case Sound.ENTITY_PHANTOM_AMBIENT, Sound.ENTITY_PHANTOM_BITE, Sound.ENTITY_PHANTOM_DEATH, Sound.ENTITY_PHANTOM_FLAP, Sound.ENTITY_PHANTOM_HURT, Sound.ENTITY_PHANTOM_SWOOP -> Material.PHANTOM_SPAWN_EGG;
            case Sound.ENTITY_PIGLIN_ADMIRING_ITEM, Sound.ENTITY_PIGLIN_AMBIENT, Sound.ENTITY_PIGLIN_ANGRY, Sound.ENTITY_PIGLIN_BRUTE_AMBIENT, Sound.ENTITY_PIGLIN_BRUTE_ANGRY, Sound.ENTITY_PIGLIN_BRUTE_CONVERTED_TO_ZOMBIFIED, Sound.ENTITY_PIGLIN_BRUTE_DEATH, Sound.ENTITY_PIGLIN_BRUTE_HURT, Sound.ENTITY_PIGLIN_BRUTE_STEP, Sound.ENTITY_PIGLIN_CELEBRATE, Sound.ENTITY_PIGLIN_CONVERTED_TO_ZOMBIFIED, Sound.ENTITY_PIGLIN_DEATH, Sound.ENTITY_PIGLIN_HURT, Sound.ENTITY_PIGLIN_JEALOUS, Sound.ENTITY_PIGLIN_RETREAT, Sound.ENTITY_PIGLIN_STEP -> Material.PIGLIN_SPAWN_EGG;
            case Sound.ENTITY_PIG_AMBIENT, Sound.ENTITY_PIG_DEATH, Sound.ENTITY_PIG_HURT, Sound.ENTITY_PIG_SADDLE, Sound.ENTITY_PIG_STEP -> Material.PIG_SPAWN_EGG;
            case Sound.ENTITY_PILLAGER_AMBIENT, Sound.ENTITY_PILLAGER_CELEBRATE, Sound.ENTITY_PILLAGER_DEATH, Sound.ENTITY_PILLAGER_HURT, Sound.EVENT_RAID_HORN -> Material.PILLAGER_SPAWN_EGG;
            case Sound.ENTITY_PLAYER_ATTACK_CRIT, Sound.ENTITY_PLAYER_ATTACK_KNOCKBACK, Sound.ENTITY_PLAYER_ATTACK_NODAMAGE, Sound.ENTITY_PLAYER_ATTACK_STRONG, Sound.ENTITY_PLAYER_ATTACK_SWEEP, Sound.ENTITY_PLAYER_ATTACK_WEAK, Sound.ENTITY_PLAYER_BIG_FALL, Sound.ENTITY_PLAYER_BREATH, Sound.ENTITY_PLAYER_BURP, Sound.ENTITY_PLAYER_DEATH, Sound.ENTITY_PLAYER_HURT, Sound.ENTITY_PLAYER_HURT_DROWN, Sound.ENTITY_PLAYER_HURT_FREEZE, Sound.ENTITY_PLAYER_HURT_ON_FIRE, Sound.ENTITY_PLAYER_HURT_SWEET_BERRY_BUSH, Sound.ENTITY_PLAYER_LEVELUP, Sound.ENTITY_PLAYER_SMALL_FALL, Sound.ENTITY_PLAYER_SPLASH, Sound.ENTITY_PLAYER_SPLASH_HIGH_SPEED, Sound.ENTITY_PLAYER_SWIM -> Material.PLAYER_HEAD;
            case Sound.ENTITY_POLAR_BEAR_AMBIENT, Sound.ENTITY_POLAR_BEAR_AMBIENT_BABY, Sound.ENTITY_POLAR_BEAR_DEATH, Sound.ENTITY_POLAR_BEAR_HURT, Sound.ENTITY_POLAR_BEAR_STEP, Sound.ENTITY_POLAR_BEAR_WARNING -> Material.POLAR_BEAR_SPAWN_EGG;
            case Sound.ENTITY_PUFFER_FISH_AMBIENT, Sound.ENTITY_PUFFER_FISH_BLOW_OUT, Sound.ENTITY_PUFFER_FISH_BLOW_UP, Sound.ENTITY_PUFFER_FISH_DEATH, Sound.ENTITY_PUFFER_FISH_FLOP, Sound.ENTITY_PUFFER_FISH_HURT, Sound.ENTITY_PUFFER_FISH_STING -> Material.PUFFERFISH;
            case Sound.ENTITY_RABBIT_AMBIENT, Sound.ENTITY_RABBIT_ATTACK, Sound.ENTITY_RABBIT_DEATH, Sound.ENTITY_RABBIT_HURT, Sound.ENTITY_RABBIT_JUMP -> Material.RABBIT;
            case Sound.ENTITY_RAVAGER_AMBIENT, Sound.ENTITY_RAVAGER_ATTACK, Sound.ENTITY_RAVAGER_CELEBRATE, Sound.ENTITY_RAVAGER_DEATH, Sound.ENTITY_RAVAGER_HURT, Sound.ENTITY_RAVAGER_ROAR, Sound.ENTITY_RAVAGER_STEP, Sound.ENTITY_RAVAGER_STUNNED -> Material.RAVAGER_SPAWN_EGG;
            case Sound.ENTITY_SALMON_AMBIENT, Sound.ENTITY_SALMON_DEATH, Sound.ENTITY_SALMON_FLOP, Sound.ENTITY_SALMON_HURT -> Material.SALMON;
            case Sound.ENTITY_SHEEP_AMBIENT, Sound.ENTITY_SHEEP_DEATH, Sound.ENTITY_SHEEP_HURT, Sound.ENTITY_SHEEP_SHEAR, Sound.ENTITY_SHEEP_STEP -> Material.SHEEP_SPAWN_EGG;
            case Sound.ENTITY_SHULKER_AMBIENT, Sound.ENTITY_SHULKER_BULLET_HIT, Sound.ENTITY_SHULKER_BULLET_HURT, Sound.ENTITY_SHULKER_CLOSE, Sound.ENTITY_SHULKER_DEATH, Sound.ENTITY_SHULKER_HURT, Sound.ENTITY_SHULKER_HURT_CLOSED, Sound.ENTITY_SHULKER_OPEN, Sound.ENTITY_SHULKER_SHOOT, Sound.ENTITY_SHULKER_TELEPORT -> Material.SHULKER_SPAWN_EGG;
            case Sound.ENTITY_SILVERFISH_AMBIENT, Sound.ENTITY_SILVERFISH_DEATH, Sound.ENTITY_SILVERFISH_HURT, Sound.ENTITY_SILVERFISH_STEP -> Material.SILVERFISH_SPAWN_EGG;
            case Sound.ENTITY_SKELETON_AMBIENT, Sound.ENTITY_SKELETON_CONVERTED_TO_STRAY, Sound.ENTITY_SKELETON_DEATH, Sound.ENTITY_SKELETON_HORSE_AMBIENT, Sound.ENTITY_SKELETON_HORSE_AMBIENT_WATER, Sound.ENTITY_SKELETON_HORSE_DEATH, Sound.ENTITY_SKELETON_HORSE_GALLOP_WATER, Sound.ENTITY_SKELETON_HORSE_HURT, Sound.ENTITY_SKELETON_HORSE_JUMP_WATER, Sound.ENTITY_SKELETON_HORSE_STEP_WATER, Sound.ENTITY_SKELETON_HORSE_SWIM, Sound.ENTITY_SKELETON_HURT, Sound.ENTITY_SKELETON_SHOOT, Sound.ENTITY_SKELETON_STEP -> Material.SKELETON_SPAWN_EGG;
            case Sound.ENTITY_SLIME_ATTACK, Sound.ENTITY_SLIME_DEATH, Sound.ENTITY_SLIME_DEATH_SMALL, Sound.ENTITY_SLIME_HURT, Sound.ENTITY_SLIME_HURT_SMALL, Sound.ENTITY_SLIME_JUMP, Sound.ENTITY_SLIME_JUMP_SMALL, Sound.ENTITY_SLIME_SQUISH, Sound.ENTITY_SLIME_SQUISH_SMALL -> Material.SLIME_SPAWN_EGG;
            case Sound.ENTITY_SNIFFER_DEATH, Sound.ENTITY_SNIFFER_DIGGING, Sound.ENTITY_SNIFFER_DIGGING_STOP, Sound.ENTITY_SNIFFER_DROP_SEED, Sound.ENTITY_SNIFFER_EAT, Sound.ENTITY_SNIFFER_HAPPY, Sound.ENTITY_SNIFFER_HURT, Sound.ENTITY_SNIFFER_IDLE, Sound.ENTITY_SNIFFER_SCENTING, Sound.ENTITY_SNIFFER_SEARCHING, Sound.ENTITY_SNIFFER_SNIFFING, Sound.ENTITY_SNIFFER_STEP -> Material.SNIFFER_SPAWN_EGG;
            case Sound.ENTITY_SNOWBALL_THROW -> Material.SNOWBALL;
            case Sound.ENTITY_SNOW_GOLEM_AMBIENT, Sound.ENTITY_SNOW_GOLEM_DEATH, Sound.ENTITY_SNOW_GOLEM_HURT, Sound.ENTITY_SNOW_GOLEM_SHEAR, Sound.ENTITY_SNOW_GOLEM_SHOOT -> Material.SNOW_GOLEM_SPAWN_EGG;
            case Sound.ENTITY_SPIDER_AMBIENT, Sound.ENTITY_SPIDER_DEATH, Sound.ENTITY_SPIDER_HURT, Sound.ENTITY_SPIDER_STEP -> Material.SPIDER_SPAWN_EGG;
            case Sound.ENTITY_SPLASH_POTION_BREAK, Sound.ENTITY_SPLASH_POTION_THROW -> Material.SPLASH_POTION;
            case Sound.ENTITY_SQUID_AMBIENT, Sound.ENTITY_SQUID_DEATH, Sound.ENTITY_SQUID_HURT, Sound.ENTITY_SQUID_SQUIRT -> Material.SQUID_SPAWN_EGG;
            case Sound.ENTITY_STRAY_AMBIENT, Sound.ENTITY_STRAY_DEATH, Sound.ENTITY_STRAY_HURT, Sound.ENTITY_STRAY_STEP -> Material.STRAY_SPAWN_EGG;
            case Sound.ENTITY_STRIDER_AMBIENT, Sound.ENTITY_STRIDER_DEATH, Sound.ENTITY_STRIDER_EAT, Sound.ENTITY_STRIDER_HAPPY, Sound.ENTITY_STRIDER_HURT, Sound.ENTITY_STRIDER_RETREAT, Sound.ENTITY_STRIDER_SADDLE, Sound.ENTITY_STRIDER_STEP, Sound.ENTITY_STRIDER_STEP_LAVA -> Material.STRIDER_SPAWN_EGG;
            case Sound.ENTITY_TADPOLE_DEATH, Sound.ENTITY_TADPOLE_FLOP, Sound.ENTITY_TADPOLE_GROW_UP, Sound.ENTITY_TADPOLE_HURT -> Material.TADPOLE_SPAWN_EGG;
            case Sound.ENTITY_TNT_PRIMED -> Material.TNT;
            case Sound.ENTITY_TROPICAL_FISH_AMBIENT, Sound.ENTITY_TROPICAL_FISH_DEATH, Sound.ENTITY_TROPICAL_FISH_FLOP, Sound.ENTITY_TROPICAL_FISH_HURT -> Material.TROPICAL_FISH;
            case Sound.ENTITY_TURTLE_AMBIENT_LAND, Sound.ENTITY_TURTLE_DEATH, Sound.ENTITY_TURTLE_DEATH_BABY, Sound.ENTITY_TURTLE_EGG_BREAK, Sound.ENTITY_TURTLE_EGG_CRACK, Sound.ENTITY_TURTLE_EGG_HATCH, Sound.ENTITY_TURTLE_HURT, Sound.ENTITY_TURTLE_HURT_BABY, Sound.ENTITY_TURTLE_LAY_EGG, Sound.ENTITY_TURTLE_SHAMBLE, Sound.ENTITY_TURTLE_SHAMBLE_BABY, Sound.ENTITY_TURTLE_SWIM -> Material.TURTLE_SPAWN_EGG;
            case Sound.ENTITY_VEX_AMBIENT, Sound.ENTITY_VEX_CHARGE, Sound.ENTITY_VEX_DEATH, Sound.ENTITY_VEX_HURT -> Material.VEX_SPAWN_EGG;
            case Sound.ENTITY_VILLAGER_AMBIENT, Sound.ENTITY_VILLAGER_CELEBRATE, Sound.ENTITY_VILLAGER_DEATH, Sound.ENTITY_VILLAGER_HURT, Sound.ENTITY_VILLAGER_NO, Sound.ENTITY_VILLAGER_TRADE, Sound.ENTITY_VILLAGER_WORK_ARMORER, Sound.ENTITY_VILLAGER_WORK_BUTCHER, Sound.ENTITY_VILLAGER_WORK_CARTOGRAPHER, Sound.ENTITY_VILLAGER_WORK_CLERIC, Sound.ENTITY_VILLAGER_WORK_FARMER, Sound.ENTITY_VILLAGER_WORK_FISHERMAN, Sound.ENTITY_VILLAGER_WORK_FLETCHER, Sound.ENTITY_VILLAGER_WORK_LEATHERWORKER, Sound.ENTITY_VILLAGER_WORK_LIBRARIAN, Sound.ENTITY_VILLAGER_WORK_MASON, Sound.ENTITY_VILLAGER_WORK_SHEPHERD, Sound.ENTITY_VILLAGER_WORK_TOOLSMITH, Sound.ENTITY_VILLAGER_WORK_WEAPONSMITH, Sound.ENTITY_VILLAGER_YES -> Material.VILLAGER_SPAWN_EGG;
            case Sound.ENTITY_VINDICATOR_AMBIENT, Sound.ENTITY_VINDICATOR_CELEBRATE, Sound.ENTITY_VINDICATOR_DEATH, Sound.ENTITY_VINDICATOR_HURT -> Material.VINDICATOR_SPAWN_EGG;
            case Sound.ENTITY_WANDERING_TRADER_AMBIENT, Sound.ENTITY_WANDERING_TRADER_DEATH, Sound.ENTITY_WANDERING_TRADER_DISAPPEARED, Sound.ENTITY_WANDERING_TRADER_DRINK_MILK, Sound.ENTITY_WANDERING_TRADER_DRINK_POTION, Sound.ENTITY_WANDERING_TRADER_HURT, Sound.ENTITY_WANDERING_TRADER_NO, Sound.ENTITY_WANDERING_TRADER_REAPPEARED, Sound.ENTITY_WANDERING_TRADER_TRADE, Sound.ENTITY_WANDERING_TRADER_YES -> Material.WANDERING_TRADER_SPAWN_EGG;
            case Sound.ENTITY_WARDEN_AGITATED, Sound.ENTITY_WARDEN_AMBIENT, Sound.ENTITY_WARDEN_ANGRY, Sound.ENTITY_WARDEN_ATTACK_IMPACT, Sound.ENTITY_WARDEN_DEATH, Sound.ENTITY_WARDEN_DIG, Sound.ENTITY_WARDEN_EMERGE, Sound.ENTITY_WARDEN_HEARTBEAT, Sound.ENTITY_WARDEN_HURT, Sound.ENTITY_WARDEN_LISTENING, Sound.ENTITY_WARDEN_LISTENING_ANGRY, Sound.ENTITY_WARDEN_NEARBY_CLOSE, Sound.ENTITY_WARDEN_NEARBY_CLOSER, Sound.ENTITY_WARDEN_NEARBY_CLOSEST, Sound.ENTITY_WARDEN_ROAR, Sound.ENTITY_WARDEN_SNIFF, Sound.ENTITY_WARDEN_SONIC_BOOM, Sound.ENTITY_WARDEN_SONIC_CHARGE, Sound.ENTITY_WARDEN_STEP, Sound.ENTITY_WARDEN_TENDRIL_CLICKS -> Material.WARDEN_SPAWN_EGG;
            case Sound.ENTITY_WITCH_AMBIENT, Sound.ENTITY_WITCH_CELEBRATE, Sound.ENTITY_WITCH_DEATH, Sound.ENTITY_WITCH_DRINK, Sound.ENTITY_WITCH_HURT, Sound.ENTITY_WITCH_THROW -> Material.WITCH_SPAWN_EGG;
            case Sound.ENTITY_WITHER_AMBIENT, Sound.ENTITY_WITHER_BREAK_BLOCK, Sound.ENTITY_WITHER_DEATH, Sound.ENTITY_WITHER_HURT, Sound.ENTITY_WITHER_SHOOT, Sound.ENTITY_WITHER_SKELETON_AMBIENT, Sound.ENTITY_WITHER_SKELETON_DEATH, Sound.ENTITY_WITHER_SKELETON_HURT, Sound.ENTITY_WITHER_SKELETON_STEP, Sound.ENTITY_WITHER_SPAWN -> Material.WITHER_SPAWN_EGG;
            case Sound.ENTITY_WOLF_AMBIENT, Sound.ENTITY_WOLF_DEATH, Sound.ENTITY_WOLF_GROWL, Sound.ENTITY_WOLF_HOWL, Sound.ENTITY_WOLF_HURT, Sound.ENTITY_WOLF_PANT, Sound.ENTITY_WOLF_SHAKE, Sound.ENTITY_WOLF_STEP, Sound.ENTITY_WOLF_WHINE -> Material.WOLF_SPAWN_EGG;
            case Sound.ENTITY_ZOGLIN_AMBIENT, Sound.ENTITY_ZOGLIN_ANGRY, Sound.ENTITY_ZOGLIN_ATTACK, Sound.ENTITY_ZOGLIN_DEATH, Sound.ENTITY_ZOGLIN_HURT, Sound.ENTITY_ZOGLIN_STEP -> Material.ZOGLIN_SPAWN_EGG;
            case Sound.ENTITY_ZOMBIE_AMBIENT, Sound.ENTITY_ZOMBIE_ATTACK_IRON_DOOR, Sound.ENTITY_ZOMBIE_ATTACK_WOODEN_DOOR, Sound.ENTITY_ZOMBIE_BREAK_WOODEN_DOOR, Sound.ENTITY_ZOMBIE_CONVERTED_TO_DROWNED, Sound.ENTITY_ZOMBIE_DEATH, Sound.ENTITY_ZOMBIE_DESTROY_EGG, Sound.ENTITY_ZOMBIE_HORSE_AMBIENT, Sound.ENTITY_ZOMBIE_HORSE_DEATH, Sound.ENTITY_ZOMBIE_HORSE_HURT, Sound.ENTITY_ZOMBIE_HURT, Sound.ENTITY_ZOMBIE_INFECT, Sound.ENTITY_ZOMBIE_STEP, Sound.ENTITY_ZOMBIE_VILLAGER_AMBIENT, Sound.ENTITY_ZOMBIE_VILLAGER_CONVERTED, Sound.ENTITY_ZOMBIE_VILLAGER_CURE, Sound.ENTITY_ZOMBIE_VILLAGER_DEATH, Sound.ENTITY_ZOMBIE_VILLAGER_HURT, Sound.ENTITY_ZOMBIE_VILLAGER_STEP -> Material.ZOMBIE_SPAWN_EGG;
            case Sound.ENTITY_ZOMBIFIED_PIGLIN_AMBIENT, Sound.ENTITY_ZOMBIFIED_PIGLIN_ANGRY, Sound.ENTITY_ZOMBIFIED_PIGLIN_DEATH, Sound.ENTITY_ZOMBIFIED_PIGLIN_HURT -> Material.ZOMBIFIED_PIGLIN_SPAWN_EGG;
            case Sound.ITEM_ARMOR_EQUIP_CHAIN, Sound.ITEM_ARMOR_EQUIP_DIAMOND, Sound.ITEM_ARMOR_EQUIP_ELYTRA, Sound.ITEM_ARMOR_EQUIP_GENERIC, Sound.ITEM_ARMOR_EQUIP_GOLD, Sound.ITEM_ARMOR_EQUIP_IRON, Sound.ITEM_ARMOR_EQUIP_LEATHER, Sound.ITEM_ARMOR_EQUIP_NETHERITE, Sound.ITEM_ARMOR_EQUIP_TURTLE -> Material.DIAMOND_CHESTPLATE;
            case Sound.ITEM_AXE_SCRAPE, Sound.ITEM_AXE_WAX_OFF, Sound.ITEM_AXE_STRIP -> Material.WOODEN_AXE;
            case Sound.ITEM_BONE_MEAL_USE -> Material.BONE_MEAL;
            case Sound.ITEM_BOOK_PAGE_TURN, Sound.ITEM_BOOK_PUT -> Material.BOOK;
            case Sound.ITEM_BOTTLE_EMPTY, Sound.ITEM_BOTTLE_FILL, Sound.ITEM_BOTTLE_FILL_DRAGONBREATH -> Material.GLASS_BOTTLE;
            case Sound.ITEM_BRUSH_BRUSHING_GENERIC, Sound.ITEM_BRUSH_BRUSHING_GRAVEL, Sound.ITEM_BRUSH_BRUSHING_GRAVEL_COMPLETE, Sound.ITEM_BRUSH_BRUSHING_SAND, Sound.ITEM_BRUSH_BRUSHING_SAND_COMPLETE -> Material.BRUSH;
            case Sound.ITEM_BUCKET_EMPTY, Sound.ITEM_BUCKET_EMPTY_AXOLOTL, Sound.ITEM_BUCKET_EMPTY_FISH, Sound.ITEM_BUCKET_EMPTY_LAVA, Sound.ITEM_BUCKET_EMPTY_POWDER_SNOW, Sound.ITEM_BUCKET_EMPTY_TADPOLE, Sound.ITEM_BUCKET_FILL, Sound.ITEM_BUCKET_FILL_AXOLOTL, Sound.ITEM_BUCKET_FILL_FISH, Sound.ITEM_BUCKET_FILL_LAVA, Sound.ITEM_BUCKET_FILL_POWDER_SNOW, Sound.ITEM_BUCKET_FILL_TADPOLE -> Material.BUCKET;
            case Sound.ITEM_BUNDLE_DROP_CONTENTS, Sound.ITEM_BUNDLE_INSERT, Sound.ITEM_BUNDLE_REMOVE_ONE -> Material.BUNDLE;
            case Sound.ITEM_CHORUS_FRUIT_TELEPORT -> Material.CHORUS_FRUIT;
            case Sound.ITEM_CROSSBOW_HIT, Sound.ITEM_CROSSBOW_LOADING_END, Sound.ITEM_CROSSBOW_LOADING_MIDDLE, Sound.ITEM_CROSSBOW_LOADING_START, Sound.ITEM_CROSSBOW_QUICK_CHARGE_1, Sound.ITEM_CROSSBOW_QUICK_CHARGE_2, Sound.ITEM_CROSSBOW_QUICK_CHARGE_3, Sound.ITEM_CROSSBOW_SHOOT -> Material.CROSSBOW;
            case Sound.ITEM_DYE_USE -> Material.WHITE_DYE;
            case Sound.ITEM_ELYTRA_FLYING -> Material.ELYTRA;
            case Sound.ITEM_FIRECHARGE_USE -> Material.FIRE_CHARGE;
            case Sound.ITEM_GLOW_INK_SAC_USE -> Material.GLOW_INK_SAC;
            case Sound.ITEM_GOAT_HORN_PLAY, Sound.ITEM_GOAT_HORN_SOUND_0, Sound.ITEM_GOAT_HORN_SOUND_1, Sound.ITEM_GOAT_HORN_SOUND_2, Sound.ITEM_GOAT_HORN_SOUND_3, Sound.ITEM_GOAT_HORN_SOUND_4, Sound.ITEM_GOAT_HORN_SOUND_5, Sound.ITEM_GOAT_HORN_SOUND_6, Sound.ITEM_GOAT_HORN_SOUND_7 -> Material.GOAT_HORN;
            case Sound.ITEM_HOE_TILL -> Material.WOODEN_HOE;
            case Sound.ITEM_HONEYCOMB_WAX_ON -> Material.HONEYCOMB;
            case Sound.ITEM_HONEY_BOTTLE_DRINK -> Material.HONEY_BOTTLE;
            case Sound.ITEM_INK_SAC_USE -> Material.INK_SAC;
            case Sound.ITEM_SHIELD_BLOCK, Sound.ITEM_SHIELD_BREAK -> Material.SHIELD;
            case Sound.ITEM_SHOVEL_FLATTEN -> Material.WOODEN_SHOVEL;
            case Sound.ITEM_SPYGLASS_STOP_USING, Sound.ITEM_SPYGLASS_USE -> Material.SPYGLASS;
            case Sound.ITEM_TOTEM_USE -> Material.TOTEM_OF_UNDYING;
            case Sound.MUSIC_CREATIVE, Sound.MUSIC_CREDITS, Sound.MUSIC_DISC_11, Sound.MUSIC_DISC_13, Sound.MUSIC_DISC_5, Sound.MUSIC_DISC_BLOCKS, Sound.MUSIC_DISC_CAT, Sound.MUSIC_DISC_CHIRP, Sound.MUSIC_DISC_FAR, Sound.MUSIC_DISC_MALL, Sound.MUSIC_DISC_MELLOHI, Sound.MUSIC_DISC_OTHERSIDE, Sound.MUSIC_DISC_PIGSTEP, Sound.MUSIC_DISC_RELIC, Sound.MUSIC_DISC_STAL, Sound.MUSIC_DISC_STRAD, Sound.MUSIC_DISC_WAIT, Sound.MUSIC_DISC_WARD, Sound.MUSIC_DRAGON, Sound.MUSIC_END, Sound.MUSIC_GAME, Sound.MUSIC_MENU, Sound.MUSIC_NETHER_BASALT_DELTAS, Sound.MUSIC_NETHER_CRIMSON_FOREST, Sound.MUSIC_NETHER_NETHER_WASTES, Sound.MUSIC_NETHER_SOUL_SAND_VALLEY, Sound.MUSIC_NETHER_WARPED_FOREST, Sound.MUSIC_OVERWORLD_BADLANDS, Sound.MUSIC_OVERWORLD_BAMBOO_JUNGLE, Sound.MUSIC_OVERWORLD_CHERRY_GROVE, Sound.MUSIC_OVERWORLD_DEEP_DARK, Sound.MUSIC_OVERWORLD_DESERT, Sound.MUSIC_OVERWORLD_DRIPSTONE_CAVES, Sound.MUSIC_OVERWORLD_FLOWER_FOREST, Sound.MUSIC_OVERWORLD_FOREST, Sound.MUSIC_OVERWORLD_FROZEN_PEAKS, Sound.MUSIC_OVERWORLD_GROVE, Sound.MUSIC_OVERWORLD_JAGGED_PEAKS, Sound.MUSIC_OVERWORLD_JUNGLE, Sound.MUSIC_OVERWORLD_LUSH_CAVES, Sound.MUSIC_OVERWORLD_MEADOW, Sound.MUSIC_OVERWORLD_OLD_GROWTH_TAIGA, Sound.MUSIC_OVERWORLD_SNOWY_SLOPES, Sound.MUSIC_OVERWORLD_SPARSE_JUNGLE, Sound.MUSIC_OVERWORLD_STONY_PEAKS, Sound.MUSIC_OVERWORLD_SWAMP, Sound.MUSIC_UNDER_WATER -> Material.MUSIC_DISC_5;
            case Sound.UI_CARTOGRAPHY_TABLE_TAKE_RESULT, Sound.UI_STONECUTTER_SELECT_RECIPE, Sound.UI_STONECUTTER_TAKE_RESULT -> Material.CARTOGRAPHY_TABLE;
            case Sound.UI_LOOM_SELECT_PATTERN, Sound.UI_LOOM_TAKE_RESULT -> Material.LOOM;
            case Sound.UI_TOAST_CHALLENGE_COMPLETE, Sound.UI_TOAST_IN, Sound.UI_TOAST_OUT -> Material.BREAD;
            case Sound.BLOCK_TUFF_STEP, Sound.BLOCK_TUFF_BREAK, Sound.BLOCK_TUFF_FALL, Sound.BLOCK_TUFF_HIT, Sound.BLOCK_TUFF_PLACE -> Material.TUFF;
            case Sound.BLOCK_TRIPWIRE_DETACH, Sound.BLOCK_TRIPWIRE_ATTACH, Sound.BLOCK_TRIPWIRE_CLICK_OFF, Sound.BLOCK_TRIPWIRE_CLICK_ON -> Material.TRIPWIRE_HOOK;
            case Sound.BLOCK_SWEET_BERRY_BUSH_PLACE, Sound.BLOCK_SWEET_BERRY_BUSH_BREAK, Sound.BLOCK_SWEET_BERRY_BUSH_PICK_BERRIES -> Material.SWEET_BERRIES;
            case Sound.BLOCK_SUSPICIOUS_SAND_STEP, Sound.BLOCK_SUSPICIOUS_SAND_BREAK, Sound.BLOCK_SUSPICIOUS_SAND_FALL, Sound.BLOCK_SUSPICIOUS_SAND_HIT, Sound.BLOCK_SUSPICIOUS_SAND_PLACE -> Material.SUSPICIOUS_SAND;
            case Sound.BLOCK_SUSPICIOUS_GRAVEL_STEP, Sound.BLOCK_SUSPICIOUS_GRAVEL_BREAK, Sound.BLOCK_SUSPICIOUS_GRAVEL_FALL, Sound.BLOCK_SUSPICIOUS_GRAVEL_HIT, Sound.BLOCK_SUSPICIOUS_GRAVEL_PLACE -> Material.SUSPICIOUS_GRAVEL;
            case Sound.BLOCK_STONE_PRESSURE_PLATE_CLICK_ON, Sound.BLOCK_STONE_PRESSURE_PLATE_CLICK_OFF -> Material.STONE_PRESSURE_PLATE;
            case Sound.BLOCK_STONE_BUTTON_CLICK_ON, Sound.BLOCK_STONE_BUTTON_CLICK_OFF -> Material.STONE_BUTTON;
            case Sound.BLOCK_STEM_STEP, Sound.BLOCK_STEM_BREAK, Sound.BLOCK_STEM_FALL, Sound.BLOCK_STEM_HIT, Sound.BLOCK_STEM_PLACE -> Material.MUSHROOM_STEM;
            case Sound.BLOCK_SPORE_BLOSSOM_STEP, Sound.BLOCK_SPORE_BLOSSOM_BREAK, Sound.BLOCK_SPORE_BLOSSOM_FALL, Sound.BLOCK_SPORE_BLOSSOM_HIT, Sound.BLOCK_SPORE_BLOSSOM_PLACE -> Material.SPORE_BLOSSOM;
            case Sound.BLOCK_SOUL_SOIL_STEP, Sound.BLOCK_SOUL_SOIL_BREAK, Sound.BLOCK_SOUL_SOIL_FALL, Sound.BLOCK_SOUL_SOIL_HIT, Sound.BLOCK_SOUL_SOIL_PLACE -> Material.SOUL_SOIL;
            case Sound.BLOCK_SNOW_STEP, Sound.BLOCK_SNOW_FALL, Sound.BLOCK_SNOW_HIT, Sound.BLOCK_SNOW_PLACE -> Material.SNOW;
            case Sound.BLOCK_SNOW_BREAK -> Material.SNOW_BLOCK;
            case Sound.BLOCK_SNIFFER_EGG_PLOP, Sound.BLOCK_SNIFFER_EGG_CRACK, Sound.BLOCK_SNIFFER_EGG_HATCH -> Material.SNIFFER_EGG;
            case Sound.BLOCK_SMOKER_SMOKE -> Material.SMOKER;
            case Sound.BLOCK_SMITHING_TABLE_USE -> Material.SMITHING_TABLE;
            case Sound.BLOCK_SMALL_DRIPLEAF_STEP, Sound.BLOCK_SMALL_DRIPLEAF_BREAK, Sound.BLOCK_SMALL_DRIPLEAF_FALL, Sound.BLOCK_SMALL_DRIPLEAF_HIT, Sound.BLOCK_SMALL_DRIPLEAF_PLACE -> Material.SMALL_DRIPLEAF;
            case Sound.BLOCK_SMALL_AMETHYST_BUD_PLACE, Sound.BLOCK_SMALL_AMETHYST_BUD_BREAK -> Material.SMALL_AMETHYST_BUD;
            case Sound.BLOCK_SLIME_BLOCK_STEP, Sound.BLOCK_SLIME_BLOCK_BREAK, Sound.BLOCK_SLIME_BLOCK_FALL, Sound.BLOCK_SLIME_BLOCK_HIT, Sound.BLOCK_SLIME_BLOCK_PLACE -> Material.SLIME_BLOCK;
            case Sound.BLOCK_SIGN_WAXED_INTERACT_FAIL -> Material.OAK_SIGN;
            case Sound.BLOCK_SHULKER_BOX_OPEN, Sound.BLOCK_SHULKER_BOX_CLOSE -> Material.SHULKER_BOX;
            case Sound.BLOCK_SHROOMLIGHT_STEP, Sound.BLOCK_SHROOMLIGHT_BREAK, Sound.BLOCK_SHROOMLIGHT_FALL, Sound.BLOCK_SHROOMLIGHT_HIT, Sound.BLOCK_SHROOMLIGHT_PLACE -> Material.SHROOMLIGHT;
            case Sound.BLOCK_SCULK_VEIN_STEP, Sound.BLOCK_SCULK_VEIN_BREAK, Sound.BLOCK_SCULK_VEIN_FALL, Sound.BLOCK_SCULK_VEIN_HIT, Sound.BLOCK_SCULK_VEIN_PLACE -> Material.SCULK_VEIN;
            case Sound.BLOCK_SCULK_STEP, Sound.BLOCK_SCULK_BREAK, Sound.BLOCK_SCULK_CHARGE, Sound.BLOCK_SCULK_FALL, Sound.BLOCK_SCULK_HIT, Sound.BLOCK_SCULK_PLACE, Sound.BLOCK_SCULK_SPREAD -> Material.SCULK;
            case Sound.BLOCK_SCULK_SHRIEKER_STEP, Sound.BLOCK_SCULK_SHRIEKER_BREAK, Sound.BLOCK_SCULK_SHRIEKER_FALL, Sound.BLOCK_SCULK_SHRIEKER_HIT, Sound.BLOCK_SCULK_SHRIEKER_PLACE, Sound.BLOCK_SCULK_SHRIEKER_SHRIEK -> Material.SCULK_SHRIEKER;
            case Sound.BLOCK_SCULK_SENSOR_STEP, Sound.BLOCK_SCULK_SENSOR_BREAK, Sound.BLOCK_SCULK_SENSOR_CLICKING, Sound.BLOCK_SCULK_SENSOR_CLICKING_STOP, Sound.BLOCK_SCULK_SENSOR_FALL, Sound.BLOCK_SCULK_SENSOR_HIT, Sound.BLOCK_SCULK_SENSOR_PLACE -> Material.SCULK_SENSOR;
            case Sound.BLOCK_SCULK_CATALYST_STEP, Sound.BLOCK_SCULK_CATALYST_BLOOM, Sound.BLOCK_SCULK_CATALYST_BREAK, Sound.BLOCK_SCULK_CATALYST_FALL, Sound.BLOCK_SCULK_CATALYST_HIT, Sound.BLOCK_SCULK_CATALYST_PLACE -> Material.SCULK_CATALYST;
            case Sound.BLOCK_SCAFFOLDING_STEP, Sound.BLOCK_SCAFFOLDING_BREAK, Sound.BLOCK_SCAFFOLDING_FALL, Sound.BLOCK_SCAFFOLDING_HIT, Sound.BLOCK_SCAFFOLDING_PLACE -> Material.SCAFFOLDING;
            case Sound.BLOCK_SAND_STEP, Sound.BLOCK_SAND_BREAK, Sound.BLOCK_SAND_FALL, Sound.BLOCK_SAND_HIT, Sound.BLOCK_SAND_PLACE -> Material.SAND;
            case Sound.BLOCK_ROOTS_STEP, Sound.BLOCK_ROOTS_BREAK, Sound.BLOCK_ROOTS_FALL, Sound.BLOCK_ROOTS_HIT, Sound.BLOCK_ROOTS_PLACE -> Material.BEETROOT;
            case Sound.BLOCK_ROOTED_DIRT_STEP, Sound.BLOCK_ROOTED_DIRT_BREAK, Sound.BLOCK_ROOTED_DIRT_FALL, Sound.BLOCK_ROOTED_DIRT_HIT, Sound.BLOCK_ROOTED_DIRT_PLACE -> Material.ROOTED_DIRT;
            case Sound.BLOCK_RESPAWN_ANCHOR_SET_SPAWN, Sound.BLOCK_RESPAWN_ANCHOR_AMBIENT, Sound.BLOCK_RESPAWN_ANCHOR_CHARGE, Sound.BLOCK_RESPAWN_ANCHOR_DEPLETE -> Material.RESPAWN_ANCHOR;
            case Sound.BLOCK_REDSTONE_TORCH_BURNOUT -> Material.REDSTONE_TORCH;
            case Sound.BLOCK_PUMPKIN_CARVE -> Material.PUMPKIN;
            case Sound.BLOCK_POWDER_SNOW_STEP, Sound.BLOCK_POWDER_SNOW_BREAK, Sound.BLOCK_POWDER_SNOW_FALL, Sound.BLOCK_POWDER_SNOW_HIT, Sound.BLOCK_POWDER_SNOW_PLACE -> Material.POWDER_SNOW_BUCKET;
            case Sound.BLOCK_POLISHED_DEEPSLATE_STEP, Sound.BLOCK_POLISHED_DEEPSLATE_BREAK, Sound.BLOCK_POLISHED_DEEPSLATE_FALL, Sound.BLOCK_POLISHED_DEEPSLATE_HIT, Sound.BLOCK_POLISHED_DEEPSLATE_PLACE -> Material.POLISHED_DEEPSLATE;
            case Sound.BLOCK_POINTED_DRIPSTONE_STEP, Sound.BLOCK_POINTED_DRIPSTONE_BREAK, Sound.BLOCK_POINTED_DRIPSTONE_DRIP_LAVA, Sound.BLOCK_POINTED_DRIPSTONE_DRIP_LAVA_INTO_CAULDRON, Sound.BLOCK_POINTED_DRIPSTONE_DRIP_WATER, Sound.BLOCK_POINTED_DRIPSTONE_DRIP_WATER_INTO_CAULDRON, Sound.BLOCK_POINTED_DRIPSTONE_FALL, Sound.BLOCK_POINTED_DRIPSTONE_HIT, Sound.BLOCK_POINTED_DRIPSTONE_LAND, Sound.BLOCK_POINTED_DRIPSTONE_PLACE -> Material.POINTED_DRIPSTONE;
            case Sound.BLOCK_PISTON_EXTEND, Sound.BLOCK_PISTON_CONTRACT -> Material.PISTON;
            case Sound.BLOCK_PINK_PETALS_STEP, Sound.BLOCK_PINK_PETALS_BREAK, Sound.BLOCK_PINK_PETALS_FALL, Sound.BLOCK_PINK_PETALS_HIT, Sound.BLOCK_PINK_PETALS_PLACE -> Material.PINK_PETALS;
            case Sound.BLOCK_PACKED_MUD_STEP, Sound.BLOCK_PACKED_MUD_BREAK, Sound.BLOCK_PACKED_MUD_FALL, Sound.BLOCK_PACKED_MUD_HIT, Sound.BLOCK_PACKED_MUD_PLACE -> Material.PACKED_MUD;
            case Sound.BLOCK_NYLIUM_STEP, Sound.BLOCK_NYLIUM_BREAK, Sound.BLOCK_NYLIUM_FALL, Sound.BLOCK_NYLIUM_HIT, Sound.BLOCK_NYLIUM_PLACE -> Material.MYCELIUM;
            case Sound.INTENTIONALLY_EMPTY -> Material.BARRIER;
            default -> Material.NOTE_BLOCK;
        };
    }

    @Generated
    private MaterialUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

