/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.rsceditor.utils;

import com.balugaq.rsceditor.api.objects.types.LinkedMachineRecipe;
import com.balugaq.rsceditor.api.objects.types.MachineRecipe;
import com.balugaq.rsceditor.api.objects.types.Register;
import com.balugaq.rsceditor.api.objects.types.TemplateMachineRecipe;
import com.balugaq.rsceditor.utils.Debug;
import com.balugaq.rsceditor.utils.ReflectionUtil;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Random;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.file.YamlRepresenter;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.DumperOptions;

public class YamlWriter {
    private static final Random random = new Random();
    private String root;
    private File file;
    private YamlConfiguration configuration = new YamlConfiguration();

    public YamlWriter() {
        try {
            ((DumperOptions)ReflectionUtil.getValue(this.configuration, "yamlDumperOptions")).setDefaultFlowStyle(DumperOptions.FlowStyle.FLOW);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            ((YamlRepresenter)ReflectionUtil.getValue(this.configuration, "representer")).setDefaultFlowStyle(DumperOptions.FlowStyle.FLOW);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @CanIgnoreReturnValue
    @NotNull
    public YamlWriter setFile(@NotNull File file) {
        this.file = file;
        this.configuration = YamlConfiguration.loadConfiguration((File)file);
        return this;
    }

    @CanIgnoreReturnValue
    @NotNull
    public YamlWriter setRoot(@NotNull String root) {
        this.root = root;
        return this;
    }

    @CanIgnoreReturnValue
    @NotNull
    public YamlWriter set(String key, @NotNull MachineRecipe recipe) {
        String recipeKey = this.getKey(key) + "." + recipe.getName();
        Object callback = "";
        if (this.configuration.contains(recipeKey)) {
            callback = "_" + Math.abs(random.nextInt(Integer.MAX_VALUE));
            Debug.log("&cDuplicate key: " + recipeKey);
            Debug.log("&c  Callback: " + recipeKey + (String)callback);
        }
        recipeKey = recipeKey + (String)callback;
        this.configuration.set(recipeKey + ".seconds", (Object)recipe.getProcessingTime());
        String inputKey = key + "." + recipe.getName() + (String)callback + ".input";
        for (int i = 0; i < recipe.getInputs().length; ++i) {
            this.set(inputKey + "." + (i + 1), recipe.getInputs()[i], false);
        }
        String outputKey = key + "." + recipe.getName() + (String)callback + ".output";
        for (int i = 0; i < recipe.getOutputs().length; ++i) {
            this.set(outputKey + "." + (i + 1), recipe.getOutputs()[i], false);
        }
        this.configuration.set(recipeKey + ".chooseOne", (Object)recipe.isChooseOne());
        this.configuration.set(recipeKey + ".forDisplay", (Object)recipe.isForDisplay());
        this.configuration.set(recipeKey + ".hide", (Object)recipe.isHide());
        return this;
    }

    @CanIgnoreReturnValue
    @NotNull
    public YamlWriter set(String key, @NotNull TemplateMachineRecipe recipe) {
        String recipeKey = this.getKey(key) + "." + recipe.getId() + "." + recipe.getName();
        Object callback = "";
        if (this.configuration.contains(recipeKey)) {
            callback = "_" + Math.abs(random.nextInt(Integer.MAX_VALUE));
            Debug.log("&cDuplicate key: " + recipeKey);
            Debug.log("&c  Callback: " + recipeKey + (String)callback);
        }
        recipeKey = recipeKey + (String)callback;
        this.configuration.set(recipeKey + ".seconds", (Object)recipe.getProcessingTime());
        String inputKey = key + "." + recipe.getId() + "." + recipe.getName() + (String)callback + ".input";
        for (int i = 0; i < recipe.getInputs().length; ++i) {
            this.set(inputKey + "." + (i + 1), recipe.getInputs()[i], false);
        }
        String outputKey = key + "." + recipe.getId() + "." + recipe.getName() + (String)callback + ".output";
        for (int i = 0; i < recipe.getOutputs().length; ++i) {
            this.set(outputKey + "." + (i + 1), recipe.getOutputs()[i], false);
        }
        this.configuration.set(recipeKey + ".chooseOne", (Object)recipe.isChooseOne());
        this.configuration.set(recipeKey + ".forDisplay", (Object)recipe.isForDisplay());
        this.configuration.set(recipeKey + ".hide", (Object)recipe.isHide());
        return this;
    }

    @CanIgnoreReturnValue
    @NotNull
    public YamlWriter set(String key, @NotNull LinkedMachineRecipe recipe) {
        ItemStack itemStack;
        String recipeKey = this.getKey(key) + "." + recipe.getName();
        Object callback = "";
        if (this.configuration.contains(recipeKey)) {
            callback = "_" + Math.abs(random.nextInt(Integer.MAX_VALUE));
            Debug.log("&cDuplicate key: " + recipeKey);
            Debug.log("&c  Callback: " + recipeKey + (String)callback);
        }
        recipeKey = recipeKey + (String)callback;
        this.configuration.set(recipeKey + ".seconds", (Object)recipe.getProcessingTime());
        String inputKey = key + "." + recipe.getName() + (String)callback + ".input";
        String outputKey = key + "." + recipe.getName() + (String)callback + ".output";
        int i = 1;
        for (Integer slot : recipe.getLinkedInputs().keySet()) {
            itemStack = recipe.getLinkedInputs().get(slot);
            if (itemStack == null || itemStack.getType() == Material.AIR) continue;
            this.set(inputKey + "." + i, itemStack.clone(), false);
            this.configuration.set(this.getKey(inputKey) + "." + i + ".slot", (Object)slot);
            ++i;
        }
        i = 1;
        for (Integer slot : recipe.getLinkedOutputs().keySet()) {
            itemStack = recipe.getLinkedOutputs().get(slot);
            if (itemStack == null || itemStack.getType() == Material.AIR) continue;
            this.set(outputKey + "." + i, itemStack.clone(), false);
            this.configuration.set(this.getKey(outputKey) + "." + i + ".slot", (Object)slot);
            ++i;
        }
        for (int k = 0; k < recipe.getFreeOutputs().length; ++k) {
            ItemStack itemStack2 = recipe.getFreeOutputs()[k];
            if (itemStack2 == null || itemStack2.getType() == Material.AIR) continue;
            this.set(outputKey + "." + (k + 1), itemStack2.clone(), false);
        }
        this.configuration.set(recipeKey + ".chooseOne", (Object)recipe.isChooseOne());
        this.configuration.set(recipeKey + ".forDisplay", (Object)recipe.isForDisplay());
        this.configuration.set(recipeKey + ".hide", (Object)recipe.isHide());
        return this;
    }

    @CanIgnoreReturnValue
    @NotNull
    public YamlWriter set(@NotNull String key, @Nullable Register register) {
        if (register == null) {
            return this;
        }
        String registerKey = this.getKey(key);
        String id_alias = register.getIdAlias();
        if (id_alias != null) {
            this.configuration.set(registerKey + ".id_alias", (Object)id_alias);
        }
        boolean late_init = register.isLateInit();
        this.configuration.set(registerKey + ".lateInit", (Object)late_init);
        boolean warn = register.isWarn();
        this.configuration.set(registerKey + ".warn", (Object)warn);
        boolean unfinished = register.isUnfinished();
        this.configuration.set(registerKey + ".unfinished", (Object)unfinished);
        List<String> conditions = register.getConditions();
        if (conditions != null && !conditions.isEmpty()) {
            this.configuration.set(registerKey + ".conditions", (Object)conditions.toArray(new String[0]));
        }
        return this;
    }

    @CanIgnoreReturnValue
    @NotNull
    public YamlWriter set(String key, @Nullable ItemStack itemStack) {
        return this.set(key, itemStack, true);
    }

    @CanIgnoreReturnValue
    @NotNull
    public YamlWriter set(String key, @Nullable ItemStack itemStack, boolean model) {
        if (itemStack == null) {
            return this;
        }
        if (itemStack.getType() == Material.AIR) {
            this.configuration.set(this.getKey(key + ".material_type"), (Object)"none");
            return this;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)itemStack);
        if (model) {
            List lore;
            if (itemMeta.hasCustomModelData()) {
                int modelData = itemMeta.getCustomModelData();
                this.configuration.set(this.getKey(key + ".modelId"), (Object)modelData);
            }
            if (itemMeta.hasLore() && (lore = itemMeta.getLore()) != null && !lore.isEmpty()) {
                this.configuration.set(this.getKey(key + ".lore"), (Object)lore.toArray(new String[0]));
            }
            if (itemMeta.hasDisplayName()) {
                this.configuration.set(this.getKey(key + ".name"), (Object)itemMeta.getDisplayName());
            }
        }
        if (slimefunItem != null && !slimefunItem.getId().equals("LOGITECH_SAMPLE_HEAD")) {
            this.configuration.set(this.getKey(key + ".material_type"), (Object)"slimefun");
            this.configuration.set(this.getKey(key + ".material"), (Object)slimefunItem.getId());
            this.configuration.set(this.getKey(key + ".amount"), (Object)itemStack.getAmount());
            return this;
        }
        this.configuration.set(this.getKey(key + ".amount"), (Object)itemStack.getAmount());
        if (itemStack.getType() == Material.PLAYER_HEAD || itemStack.getType() == Material.PLAYER_WALL_HEAD) {
            if (itemMeta instanceof SkullMeta) {
                SkullMeta skullMeta = (SkullMeta)itemMeta;
                try {
                    URL url = skullMeta.getOwnerProfile().getTextures().getSkin();
                    String path = url.getPath();
                    String[] parts = path.split("/");
                    String hash = parts[parts.length - 1];
                    this.configuration.set(this.getKey(key + ".material_type"), (Object)"skull_hash");
                    this.configuration.set(this.getKey(key + ".material"), (Object)hash);
                }
                catch (Throwable throwable) {}
            } else {
                this.configuration.set(this.getKey(key + ".material_type"), (Object)"mc");
                this.configuration.set(this.getKey(key + ".material"), (Object)itemStack.getType().name());
            }
        } else {
            this.configuration.set(this.getKey(key + ".material_type"), (Object)"mc");
            this.configuration.set(this.getKey(key + ".material"), (Object)itemStack.getType().name());
        }
        return this;
    }

    @CanIgnoreReturnValue
    @NotNull
    public YamlWriter set(@NotNull String key, Object value) {
        this.configuration.set(this.getKey(key), value);
        return this;
    }

    @NotNull
    public String getKey(@NotNull String key) {
        if (this.root == null) {
            return key;
        }
        return this.root + "." + key;
    }

    @NotNull
    public String toString() {
        return this.configuration.saveToString();
    }

    public void save() {
        try {
            this.configuration.save(this.file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Generated
    public String getRoot() {
        return this.root;
    }

    @Generated
    public File getFile() {
        return this.file;
    }

    @Generated
    public YamlConfiguration getConfiguration() {
        return this.configuration;
    }
}

